#include <stdlib.h>
#include "isectd.h"

/*
   commands take the form:

   CONFIG WORKER service host path args...
 */
char *
isdAddWorker(char *cp, int argc, char **argv)
{
	int i;
	isdWorker *worker;
	Node *node;

	if (argc < 4)
		strcat(cp, "Not enough arguments for CONFIG WORKER\n");
	else {
		node = QueueByteCmp(&isdData.ServiceList, QEQ, offsetof(isdService, name[0]), argv[2], -1, QNULL);
		if (node == QNULL)
			sprintf(strchr(cp, 0), "Couldn't find service '%s' for CONFIG WORKER\n", argv[2]);
		else {
			worker = (isdWorker *) calloc(sizeof *worker, 1);
			worker->socket = worker->restarts = -1;
			worker->up_not_log_in = 0;
			worker->service_id = (worker->service = (isdService *) node)->id;
			worker->id = ++isdData.NextWorkerID;

			strcat(worker->name, argv[2]);
			strcat(worker->host, argv[3]);
			strcat(worker->path, argv[4]);

			for (i = 5; i < argc; i++)
				sprintf(strchr(worker->args, 0), "%s ", argv[i]);
/*
   worker->stopped = argv[2][0] == '*';
 */
			InsertTail(&isdData.LazyWorkers, (Node *) worker);
			sprintf(cp, "WORKER '%s:%s' added.\n", worker->host, worker->path);
			isdLog("worker->id=%d, worker->service_id=%d\n", worker->id, worker->service_id);
		}
	}
	return strchr(cp, 0);
}
