#include "isdio.h"
#include <memory.h>

SOCKET Xport 
isdAttach(const char *hostname, const char *service, char *wid, int priority)
{
	int err = INVALID_SOCKET;
	SOCKET sock;
	isdBadge badge;
	isdHeader header;

#ifdef _Windows
	WSADATA asadata;

	WSAStartup((WORD) 0x20, &asadata);
#endif

	if (hostname == (char *) 0)
		hostname = ISDHOSTNAME;

	if ((sock = isdConnectTo(hostname, wid == NULL ? ISDHOSTNAME:service)) != INVALID_SOCKET) {
		badge.id = htonl(wid == NULL ? 0 : atol(wid));
		badge.priority = htonl(priority);
		badge.hostpid = htonl(getpid());
		badge.blockable = 0;
		strcpy(badge.service, service);
		memset((char *) &header, 0, sizeof header);
		if (isdSend(sock, (char *) &badge, sizeof badge, &header) != -1)
			err = 0;
	}

	if (err != 0)
		isdLogout(sock);

	return err == 0 ? sock : err;
}
