#include "../config.h"
#include <sys/wait.h>
#include <string.h>
#include <stddef.h>
#include "rmt.h"

int
rmtsigchild(void)
{
	int pid;
	Node *node;
	struct ReplyTo *replyto;
	int statusp;

	while ((pid = waitpid(-1, &statusp, WNOHANG)) > 0) {
		isdLog("Pid %d terminated\n", pid);
#if 1 == 2
		if ((node = QueueSearch(&ReplyToQueue, QEQ, offsetof(struct ReplyTo, pid), pid, QNULL)) != QNULL) {
			replyto = (struct ReplyTo *) node;
			replyto->statusp = statusp;
			rmtsendsig(replyto);
			free((char *) RemoveNode((Node *) replyto));
		}
#endif
	}
}
