/*-
 * Copyright (c) 2005 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: ipastat_time.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPASTAT_TIME_H
#define IPASTAT_TIME_H

/*
 * -i ... or -I ...
 */
struct opt_tint {
	STAILQ_ENTRY(opt_tint) link;	/* Link list of all otint. */
	ipa_tm		tm1;		/* From date. */
	ipa_tm		tm2;		/* Till date. */
	char		exact;		/* Set if exact time interval. */
};

/*
 * List of all tint structures.
 */
STAILQ_HEAD(opt_tint_list, opt_tint);

extern struct opt_tint_list opt_tint_list;

extern int	init_time_data(void);

extern void	opt_tint_init(void);
extern int	opt_tint_add(char *, int);
extern void	opt_tint_free(void);

#endif /* !IPASTAT_TIME_H */
