#!/soft/bin/runhugs +l
-- Hey, Emacs, this is -*- haskell -*-
-- Counter example   Erik Meijer (erik@cs.ruu.nl)

\begin{code}
module Main (main) where

import CGI
import Maybe(fromMaybe)

main :: IO ()
main = wrapper (\env -> return (Content{mime = counter env}))

counter :: [(Name,Value)] -> HTML
counter env =
   page "Counter" []
      [ h1 "Click me!"
      , gui counterScript [submit "Count" (show (read n + 1))]
      ] where n = fromMaybe "0" (lookup "Count" env)

-- Edit counterScript to point to the url of the "executable" of this very module.
counterScript :: String
counterScript = "http://www.pms.informatik.uni-muenchen.de/mitarbeiter/panne/cgi-bin/Counter.cgi"
\end{code}
