#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "transcode.h"
#include "interface.h"
#include "tcprobe.h"

extern interface_struct interface;
extern tcprobe_data_struct tcprobe_data;
extern output_config_struct output_config;

int RunTranscode(char *command){
	FILE *transcode;
	char string[256];
	gchar *text;
	int frames1=0,frames2=0;
	GString *new_command;
	
	MakeTranscodeDialog(); /* create new dialog window */

	new_command = g_string_new(command);
	new_command = g_string_append(new_command," --print_status 5 ");
	new_command = g_string_append(new_command,"2>&1");
	
	if(!strcmp("",command)){
		printf("Error!  You must build the command line first.\n");
		return 1;
	}

	
	updateDialog("running: ");
	updateDialog(new_command->str);
	updateDialog("\n\n");

	/* run transcode using command */
	transcode = popen(new_command->str,"r");
	if(transcode == NULL){
		updateDialog("Could not run transcode using:\n");
		updateDialog(new_command->str);
		updateDialog("\n");
		return 1;
	}

	/* change progress bar type if frames have been specified */
	text = gtk_editable_get_chars(GTK_EDITABLE(interface.importFramesEntry),0,-1);
	if(strcmp("",text)){ /* if the user specified certain frames */
		if(sscanf(text,"%d-%d",&frames1,&frames2)){
			gtk_progress_configure(GTK_PROGRESS(interface.progressBar),(gfloat)frames1,(gfloat)frames1,(gfloat)frames2);
		}
	}else{ /* full movie */
		gtk_progress_configure(GTK_PROGRESS(interface.progressBar),0.0,0.0,(float)tcprobe_data.length_frames);
	}

	while((output_config.running) && (fgets(string,sizeof(string),transcode) != NULL)){
		//printf("I got here\n");
		if(sscanf(string,"encoding frames [%d-%d]",&frames1,&frames2)){
			gtk_progress_set_value(GTK_PROGRESS(interface.progressBar),(float)frames2);
			/* force progress bar to update */
			while (gtk_events_pending())
	  			gtk_main_iteration();
		}else{
			if(sscanf(string,"encoding frame [%d]",&frames1)){
				//gtk_progress_set_format_string(GTK_PROGRESS(interface.progressBar),"Mikes test %p");
				gtk_progress_set_value(GTK_PROGRESS(interface.progressBar),(float)frames1);
				/* force progress bar to update */
				while (gtk_events_pending())
	  				gtk_main_iteration();
			}else{
				updateDialog(string);
			}
		}
	}
	pclose(transcode);
	return 0;
}

/* appends new_msg to the text in the dialog label */
void updateDialog(gchar *new_msg){
	gtk_text_insert(GTK_TEXT(interface.transcodeOutputText),NULL,NULL,NULL,new_msg,-1);

}

