#include "optFileWriter.h"


optFileWriter::optFileWriter(char *what_file, nodes *what_nodes) {
  filename = strdup(what_file);
  my_nodes = what_nodes;
}


optFileWriter::~optFileWriter() {
  free(filename);
}


void optFileWriter::write() {
  FILE *outfile = fopen(filename, "w");
  char *header = 
    "<?xml version=\"1.0\" standalone=\"yes\"?>\n<graphopt>\n";
  fwrite(header, strlen(header), 1, outfile);

  write_nodes(outfile);

  fwrite("</graphopt>\n", 13, 1, outfile);
  fclose(outfile);
}


void optFileWriter::write_nodes(FILE *outfile) {
  for (int i = 0; i < my_nodes->number_of_nodes(); i++) {
     char *temp = itoa(i);
     my_nodes->get_node(i)->set_export_id(temp);
     delete temp;
  }

  node *temp_node;
  for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
    temp_node = my_nodes->get_node(temp);
    fprintf(outfile, "  <node>\n");
    fprintf(outfile, "    <id>%s</id>\n", temp_node->get_export_id());
    fprintf(outfile, "    <name>%s</name>\n", temp_node->get_name());
    fprintf(outfile, "    <x_pos>%f</x_pos>\n", temp_node->x_pos);
    fprintf(outfile, "    <y_pos>%f</y_pos>\n", temp_node->y_pos);
    fprintf(outfile, "    <links>\n");

    std::vector<node *> links = temp_node->get_connections();
    for (int i = 0; i < links.size(); i++) {
       fprintf(outfile, "      <link>%s</link>\n", links[i]->get_export_id());
    }
    fprintf(outfile, "    </links>\n");
    fprintf(outfile, "  </node>\n");
  }
}


// Utility methods

char *optFileWriter::itoa(int value) {
  char *string_value = 0;
  if (value > 0)  return digit(value, string_value);
  if (value == 0) {
     char *temp = new char[2];
     temp[0] = '0';
     temp[1] = '\0';
     return temp;
  }

  value = -value;
  string_value = digit(value, string_value);
  char *temp = new char[strlen(string_value) + 2];
  temp[0] = (char) 45;  
  temp[1] = 0;
  return strcat(temp, string_value);
}


char *optFileWriter::digit(int value, char *string_val) {
  if (value == 0) 
    return string_val;

  int digitval;
  int charval;
  switch(value % 10) {
  case 0: charval = 48; digitval = 0; break;
  case 1: charval = 49; digitval = 1; break;
  case 2: charval = 50; digitval = 2; break;
  case 3: charval = 51; digitval = 3; break;
  case 4: charval = 52; digitval = 4; break;
  case 5: charval = 53; digitval = 5; break;
  case 6: charval = 54; digitval = 6; break;
  case 7: charval = 55; digitval = 7; break;
  case 8: charval = 56; digitval = 8; break;
  case 9: charval = 57; digitval = 9; break;
  }

  char *temp;
  if (string_val != 0)
    temp = new char[strlen(string_val) + 2];
  else
    temp = new char[2];
  temp[0] = (char) charval;
  temp[1] = 0;
  if (string_val != 0) {
    strcat(temp, string_val);
    delete string_val;
  }

  value = (value - digitval) / 10;
  return digit(value, temp);
}

char *optFileWriter::kill_quotes(char *line) {
  char *tick = "'";
  char *quote_pos;
  while (strstr(line, "\"") != 0) {
    quote_pos = strstr(line, "\"");
    *quote_pos = *tick;
  }
  return line;
}
