/**
 * optFileReader.h
 *
 * a class to read graphopt files
 */

#ifndef __OPTFILEREADER_H__
#define __OPTFILEREADER_H__
#include "nodes.h"
#include <stdio.h>

static int NODE_TAG      = 0;
static int ID_TAG        = 1;
static int NAME_TAG      = 2;
static int X_POS_TAG     = 3;
static int Y_POS_TAG     = 4;
static int LINKS_TAG     = 5;
static int LINK_TAG      = 6;
static int END_LINKS_TAG = 7;
static int END_NODE_TAG  = 8;

class optFileReader {

 public:

  optFileReader(char *what_file, nodes *what_nodes);   // constructor
  ~optFileReader();                                    // destructor

  int read();  // effects the import; returns 1 on success, 0 on failure


 private:
  char *filename;
  nodes *my_nodes;
  node *current_node;

  // reads a line from infile and returns it.  returns 0 if successful,
  // 1 if the end of the file has been reached.
  char *read_line(FILE *infile); 
  
  char *between_tags(char *line);
  int  tag_name(char *line);

  void process_line(char *line);
  char *chop_cr_lf(char *line);

  int char_tag_to_int(char *tag);
};


#endif




