/**
 * objectInterface.h
 *
 * objectInterface is the class through which the GUI manages everything
 * useful.
 */

#ifndef __OBJECTINTERFACE_H__
#define __OBJECTINTERFACE_H__
#include "nodes.h"
#include "physics.h"
#include <gtk/gtk.h>

class physics;

class objectInterface {

 public:

  // Constructor and destructor
  objectInterface();
  ~objectInterface();

  // File operations
  
  void create_new();                 // creates a new model         
  void open      (char *what_file);  // reads a model from a file   
  int  save      ();                 // saves.  returns 0 on success
  void save_as   (char *what_file);  // saves a model to a file     
  void import    (char *what_file);  // imports a model from a file 
  
  void export_to_visio(char *what_file);  // exports the model into    
  void export_as_ps   (char *what_file);  // a visio-readable,         
  void export_as_gif  (char *what_file);  // postscript, or GIF format 
  
  
  // Model manipulation operations 
  
  // Sets the physics parameters according to user input
  void set_model_parameters(int   new_node_width,
			    int   new_node_height,
			    float new_node_mass,
			    float new_node_charge,
			    int   new_spring_length,
			    float new_spring_constant,
			    float max_sa_movement,
                            bool  new_draw_nodes,
                            bool  new_draw_springs,
                            int   new_layers_to_hide);
  // Gathers nodes at the given layer around their parent nodes at the next
  // layer up
  void gather_nodes_with_layer(int which_layer);
  // Makes sure no two nodes are at the exact same location
  void separate_nodes();
  // Performs a single iteration of movement on the model
  void advance_model();  
  // Draws the model
  void draw_model();         
  
  // Selects a node to move.  Happens when the user clicks on a node
  void select_node_at(float which_x, float which_y);
  // Moves the selected node to the specified position and deselects the node
  void move_selected_node_to(float new_x, float new_y);

  void status(char *message);  // send message to the statusbar
  
 private:
  char *filename;  // The filename of the working model 
  int node_width, node_height;   // The size of a node
  bool draw_nodes, draw_springs;  // should we draw the nodes and springs?
  int layers_to_hide;  // the number of layers to hide (and not compute)
  nodes *my_nodes;      // Our nodes and their connections
  physics *my_physics;  // Our physics module
  node *selected_node;  // The node the user has selected

  GdkPoint *compute_arrowhead_points(GdkPoint *points, 
				     int x1, int y1, int x2, int y2);
  void translate_coordinates(float *x, float *y);  // from the display system 
  // to the one used by our nodes
};


#endif 

