#include "actions.h"
#include "interface.h"
#include "classes/objectInterface.h"
#include <stdio.h>
#include <unistd.h>

GtkWidget *openfile_dialog;
GtkWidget *saveasfile_dialog;
GtkWidget *importfile_dialog;
GtkWidget *exportvisiofile_dialog;
GtkWidget *exportpsfile_dialog;
GtkWidget *exportgiffile_dialog;
GtkWidget *exporttcmfile_dialog;
extern objectInterface *my_objectInterface;
extern GtkWidget *node_width_spinbutton;
extern GtkWidget *node_height_spinbutton;
extern GtkWidget *node_mass_spinbutton;
extern GtkWidget *node_charge_spinbutton;
extern GtkWidget *spring_constant_spinbutton;
extern GtkWidget *spring_length_spinbutton;
extern GtkWidget *max_sa_movement_spinbutton;
extern GtkWidget *draw_nodes_togglebutton;
extern GtkWidget *draw_springs_togglebutton;
extern GtkWidget *hide_layers_spinbutton;


int go_stop_button_state = 0; /* 0 is stopped (button says 'Go'), 1 otherwise */
int move_objects_function;


void do_new() {
   my_objectInterface->create_new();
}

void do_open() {
   openfile_dialog = create_open_fileselection();
   gtk_widget_show(openfile_dialog);
}

void do_save() {
   if (my_objectInterface->save() == 1) {
      do_save_as();
   }
}

void do_save_as() {
   saveasfile_dialog = create_saveas_fileselection();
   gtk_widget_show(saveasfile_dialog);
}

void do_import() {
   importfile_dialog = create_import_fileselection();
   gtk_widget_show(importfile_dialog);
}

void do_export_visio() {
   exportvisiofile_dialog = create_exportvisio_fileselection();
   gtk_widget_show(exportvisiofile_dialog);
}

void do_export_ps() {
   exportpsfile_dialog = create_exportps_fileselection();
   gtk_widget_show(exportpsfile_dialog);
}

void do_export_gif() {
   exportgiffile_dialog= create_exportgif_fileselection();
   gtk_widget_show(exportgiffile_dialog);
}

void do_quit() {
   gtk_main_quit();
}

void move_objects() {
   my_objectInterface->advance_model();
   my_objectInterface->draw_model();
}

void update_model_constants() {
   int node_width = 
      gtk_spin_button_get_value_as_int((GtkSpinButton *)  
                                       node_width_spinbutton); 
   int node_height =
      gtk_spin_button_get_value_as_int((GtkSpinButton *)  
                                       node_height_spinbutton); 
   float node_mass =
      gtk_spin_button_get_value_as_float((GtkSpinButton *)  
                                         node_mass_spinbutton); 
   float node_charge =
      gtk_spin_button_get_value_as_float((GtkSpinButton *)  
                                         node_charge_spinbutton); 
   float spring_length =
      gtk_spin_button_get_value_as_float((GtkSpinButton *)  
                                         spring_length_spinbutton); 
   float spring_constant =
      gtk_spin_button_get_value_as_float((GtkSpinButton *)  
                                         spring_constant_spinbutton); 
   float max_sa_movement =
      gtk_spin_button_get_value_as_float((GtkSpinButton *)  
                                         max_sa_movement_spinbutton); 
   bool draw_nodes = 
      (bool) gtk_toggle_button_get_active((GtkToggleButton *)
                                          draw_nodes_togglebutton);
   bool draw_springs = 
      (bool) gtk_toggle_button_get_active((GtkToggleButton *)
                                          draw_springs_togglebutton);
   int layers_to_hide = 
      gtk_spin_button_get_value_as_int((GtkSpinButton *) 
                                       hide_layers_spinbutton);

   my_objectInterface->
      set_model_parameters(node_width, node_height, 
                           node_mass, node_charge, 
                           (int) spring_length, spring_constant,
                           max_sa_movement, draw_nodes, draw_springs,
                           layers_to_hide);
}

void do_go_stop(GtkButton *button) {
   if (go_stop_button_state == 0) {
      update_model_constants();

      gtk_label_set_text((GtkLabel *) GTK_BIN(button)->child, "Stop");
      go_stop_button_state = 1;
      /* make sure no nodes are on top of each other */
      my_objectInterface->separate_nodes();
      move_objects_function = gtk_idle_add((GtkFunction) move_objects, NULL);
   }
   else {
      gtk_label_set_text((GtkLabel *) GTK_BIN(button)->child, "Go");
      gtk_idle_remove(move_objects_function);
      go_stop_button_state = 0;
   }
}

void do_hide_layers_change() {
   my_objectInterface->gather_nodes_with_layer
      (gtk_spin_button_get_value_as_int
       ((GtkSpinButton *) hide_layers_spinbutton));
   my_objectInterface->separate_nodes();
   update_model_constants();
}

