#!/bin/sh

# build the grams tool
$CC -Wall -Wextra -pedantic -O2 -std=gnu89 grams.c -o grams

# compute idict.h
cat welcome.txt > tmp.txt
cat welcome2.txt >> tmp.txt
cat ../gopherus.txt | dos2unix > gopherus.txt
cat gopherus.txt >> tmp.txt
echo '/* THIS FILE IS AUTOGENERATED BY GENDICT.SH */' > idict.h
./grams tmp.txt 4 | grep -A100 'char gramdict\[\]' >> idict.h

# build idocgen
$CC -Wall -Wextra -pedantic -O2 -std=gnu89 idocgen.c -o idocgen

# compute idoc.h
./idocgen welcome.txt idoc_welcome > idoc.h
./idocgen welcome2.txt idoc_welcome2 >> idoc.h
./idocgen gopherus.txt idoc_manual >> idoc.h

# clean up temporary files
rm grams
rm idocgen
rm tmp.txt
rm gopherus.txt
