// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the Google Gen AI SDK generator DO NOT EDIT.

package genai

import (
	"context"
	"fmt"
	"io"
	"iter"
	"mime"
	"net/http"
	"os"
	"path/filepath"
	"reflect"
	"strconv"
)

func createFileSearchStoreConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"displayName"}, fromDisplayName)
	}

	return toObject, nil
}

func createFileSearchStoreParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = createFileSearchStoreConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func deleteFileSearchStoreConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromForce := getValueByPath(fromObject, []string{"force"})
	if fromForce != nil {
		setValueByPath(parentObject, []string{"_query", "force"}, fromForce)
	}

	return toObject, nil
}

func deleteFileSearchStoreParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = deleteFileSearchStoreConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func getFileSearchStoreParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func importFileConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromCustomMetadata := getValueByPath(fromObject, []string{"customMetadata"})
	if fromCustomMetadata != nil {
		setValueByPath(parentObject, []string{"customMetadata"}, fromCustomMetadata)
	}

	fromChunkingConfig := getValueByPath(fromObject, []string{"chunkingConfig"})
	if fromChunkingConfig != nil {
		setValueByPath(parentObject, []string{"chunkingConfig"}, fromChunkingConfig)
	}

	return toObject, nil
}

func importFileOperationFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	fromDone := getValueByPath(fromObject, []string{"done"})
	if fromDone != nil {
		setValueByPath(toObject, []string{"done"}, fromDone)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	fromResponse := getValueByPath(fromObject, []string{"response"})
	if fromResponse != nil {
		fromResponse, err = importFileResponseFromMldev(fromResponse.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"response"}, fromResponse)
	}

	return toObject, nil
}

func importFileParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFileSearchStoreName := getValueByPath(fromObject, []string{"fileSearchStoreName"})
	if fromFileSearchStoreName != nil {
		setValueByPath(toObject, []string{"_url", "file_search_store_name"}, fromFileSearchStoreName)
	}

	fromFileName := getValueByPath(fromObject, []string{"fileName"})
	if fromFileName != nil {
		setValueByPath(toObject, []string{"fileName"}, fromFileName)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = importFileConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func importFileResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromParent := getValueByPath(fromObject, []string{"parent"})
	if fromParent != nil {
		setValueByPath(toObject, []string{"parent"}, fromParent)
	}

	fromDocumentName := getValueByPath(fromObject, []string{"documentName"})
	if fromDocumentName != nil {
		setValueByPath(toObject, []string{"documentName"}, fromDocumentName)
	}

	return toObject, nil
}

func listFileSearchStoresConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPageSize := getValueByPath(fromObject, []string{"pageSize"})
	if fromPageSize != nil {
		setValueByPath(parentObject, []string{"_query", "pageSize"}, fromPageSize)
	}

	fromPageToken := getValueByPath(fromObject, []string{"pageToken"})
	if fromPageToken != nil {
		setValueByPath(parentObject, []string{"_query", "pageToken"}, fromPageToken)
	}

	return toObject, nil
}

func listFileSearchStoresParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = listFileSearchStoresConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func listFileSearchStoresResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromNextPageToken := getValueByPath(fromObject, []string{"nextPageToken"})
	if fromNextPageToken != nil {
		setValueByPath(toObject, []string{"nextPageToken"}, fromNextPageToken)
	}

	fromFileSearchStores := getValueByPath(fromObject, []string{"fileSearchStores"})
	if fromFileSearchStores != nil {
		setValueByPath(toObject, []string{"fileSearchStores"}, fromFileSearchStores)
	}

	return toObject, nil
}

func uploadToFileSearchStoreConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(parentObject, []string{"mimeType"}, fromMimeType)
	}

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"displayName"}, fromDisplayName)
	}

	fromCustomMetadata := getValueByPath(fromObject, []string{"customMetadata"})
	if fromCustomMetadata != nil {
		setValueByPath(parentObject, []string{"customMetadata"}, fromCustomMetadata)
	}

	fromChunkingConfig := getValueByPath(fromObject, []string{"chunkingConfig"})
	if fromChunkingConfig != nil {
		setValueByPath(parentObject, []string{"chunkingConfig"}, fromChunkingConfig)
	}

	return toObject, nil
}

func uploadToFileSearchStoreParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFileSearchStoreName := getValueByPath(fromObject, []string{"fileSearchStoreName"})
	if fromFileSearchStoreName != nil {
		setValueByPath(toObject, []string{"_url", "file_search_store_name"}, fromFileSearchStoreName)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = uploadToFileSearchStoreConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func uploadToFileSearchStoreResumableResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	return toObject, nil
}

type FileSearchStores struct {
	apiClient *apiClient
	Documents *Documents
}

func (m FileSearchStores) Create(ctx context.Context, config *CreateFileSearchStoreConfig) (*FileSearchStore, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(FileSearchStore)
	var responseMap map[string]any
	var toConverter func(map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return nil, fmt.Errorf("method Create is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = createFileSearchStoreParametersToMldev

	}

	body, err := toConverter(parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("fileSearchStores", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

func (m FileSearchStores) Get(ctx context.Context, name string, config *GetFileSearchStoreConfig) (*FileSearchStore, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"name": name, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(FileSearchStore)
	var responseMap map[string]any
	var toConverter func(map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return nil, fmt.Errorf("method Get is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = getFileSearchStoreParametersToMldev

	}

	body, err := toConverter(parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("{name}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodGet, body, httpOptions)
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

func (m FileSearchStores) Delete(ctx context.Context, name string, config *DeleteFileSearchStoreConfig) error {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"name": name, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var toConverter func(map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return fmt.Errorf("method Delete is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = deleteFileSearchStoreParametersToMldev

	}

	body, err := toConverter(parameterMap, nil)
	if err != nil {
		return err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("{name}", urlParams)
	}
	if err != nil {
		return fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return err
		}
		path += "?" + query
		delete(body, "_query")
	}
	_, err = sendRequest(ctx, m.apiClient, path, http.MethodDelete, body, httpOptions)
	if err != nil {
		return err
	}

	return nil
}

func (m FileSearchStores) list(ctx context.Context, config *ListFileSearchStoresConfig) (*ListFileSearchStoresResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(ListFileSearchStoresResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return nil, fmt.Errorf("method List is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = listFileSearchStoresParametersToMldev
		fromConverter = listFileSearchStoresResponseFromMldev
	}

	body, err := toConverter(parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("fileSearchStores", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodGet, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

func (m FileSearchStores) uploadToFileSearchStore(ctx context.Context, fileSearchStoreName string, config *UploadToFileSearchStoreConfig) (*UploadToFileSearchStoreResumableResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"fileSearchStoreName": fileSearchStoreName, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(UploadToFileSearchStoreResumableResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return nil, fmt.Errorf("method UploadToFileSearchStore is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = uploadToFileSearchStoreParametersToMldev
		fromConverter = uploadToFileSearchStoreResumableResponseFromMldev
	}

	body, err := toConverter(parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("upload/v1beta/{file_search_store_name}:uploadToFileSearchStore", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

func (m FileSearchStores) ImportFile(ctx context.Context, fileSearchStoreName string, fileName string, config *ImportFileConfig) (*ImportFileOperation, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"fileSearchStoreName": fileSearchStoreName, "fileName": fileName, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(ImportFileOperation)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return nil, fmt.Errorf("method ImportFile is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = importFileParametersToMldev
		fromConverter = importFileOperationFromMldev
	}

	body, err := toConverter(parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("{file_search_store_name}:importFile", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// List retrieves a paginated list of file search stores resources.
func (m FileSearchStores) List(ctx context.Context, config *ListFileSearchStoresConfig) (Page[FileSearchStore], error) {
	listFunc := func(ctx context.Context, config map[string]any) ([]*FileSearchStore, string, *HTTPResponse, error) {
		var c ListFileSearchStoresConfig
		if err := mapToStruct(config, &c); err != nil {
			return nil, "", nil, err
		}
		resp, err := m.list(ctx, &c)
		if err != nil {
			return nil, "", nil, err
		}
		return resp.FileSearchStores, resp.NextPageToken, resp.SDKHTTPResponse, nil
	}
	c := make(map[string]any)
	deepMarshal(config, &c)
	return newPage(ctx, "fileSearchStores", c, listFunc)
}

// All retrieves all FileSearchStore stores resources.
//
// This method handles pagination internally, making multiple API calls as needed
// to fetch all entries. It returns an iterator that yields each file search store
// entry one by one. You do not need to manage pagination
// tokens or make multiple calls to retrieve all data.
func (m FileSearchStores) All(ctx context.Context) iter.Seq2[*FileSearchStore, error] {
	listFunc := func(ctx context.Context, config map[string]any) ([]*FileSearchStore, string, *HTTPResponse, error) {
		var c ListFileSearchStoresConfig
		if err := mapToStruct(config, &c); err != nil {
			return nil, "", nil, err
		}
		resp, err := m.list(ctx, &c)
		if err != nil {
			return nil, "", nil, err
		}
		return resp.FileSearchStores, resp.NextPageToken, resp.SDKHTTPResponse, nil
	}
	p, err := newPage(ctx, "fileSearchStores", map[string]any{}, listFunc)
	if err != nil {
		return yieldErrorAndEndIterator[FileSearchStore](err)
	}
	return p.all(ctx)
}

// Upload copies the contents of the given io.Reader to a file search store and return the long running operation.
func (m FileSearchStores) UploadToFileSearchStore(ctx context.Context, r io.Reader, FileSearchStoreName string, config *UploadToFileSearchStoreConfig) (*UploadToFileSearchStoreOperation, error) {
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		return nil, fmt.Errorf("This method is only supported in the Gemini Developer client.")
	}
	if config.MIMEType == "" {
		return nil, fmt.Errorf("MIMEType is required but was not provided. Please set the `MIMEType` in the config")
	}

	httpOptions := HTTPOptions{Headers: http.Header{}}
	if config != nil && config.HTTPOptions != nil {
		deepCopy(*config.HTTPOptions, &httpOptions)
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}

	httpOptions.APIVersion = ""
	httpOptions.Headers.Add("Content-Type", "application/json")
	httpOptions.Headers.Add("X-Goog-Upload-Protocol", "resumable")
	httpOptions.Headers.Add("X-Goog-Upload-Command", "start")
	httpOptions.Headers.Add("X-Goog-Upload-Header-Content-Type", config.MIMEType)

	var clonedConfig UploadToFileSearchStoreConfig
	deepCopy(*config, &clonedConfig)
	clonedConfig.HTTPOptions = &httpOptions
	isTrue := true
	clonedConfig.ShouldReturnHTTPResponse = &isTrue

	resp, err := m.uploadToFileSearchStore(ctx, FileSearchStoreName, &clonedConfig)
	if err != nil {
		return nil, fmt.Errorf("Failed to upload to FileSearchStore store. Ran into an error: %s", err)
	}
	if resp.SDKHTTPResponse == nil || resp.SDKHTTPResponse.Headers == nil {
		return nil, fmt.Errorf("Failed to upload to FileSearchStore store. Upload URL was not returned from the request.")
	}
	uploadURL := resp.SDKHTTPResponse.Headers.Get("X-Goog-Upload-Url")
	if uploadURL == "" {
		return nil, fmt.Errorf("Failed to upload to FileSearchStore store. Upload URL was not returned from the request.")
	}
	return m.apiClient.uploadToFileSearchStore(ctx, r, uploadURL, &httpOptions)
}

// UploadToFileSearchStoreFromPath uploads a file from the specified path to a file search store and return the long running operation.
func (m FileSearchStores) UploadToFileSearchStoreFromPath(ctx context.Context, path string, FileSearchStoreName string, config *UploadToFileSearchStoreConfig) (*UploadToFileSearchStoreOperation, error) {
	fileInfo, err := os.Stat(path)
	if err != nil || fileInfo.IsDir() {
		return nil, fmt.Errorf("%s is not a valid file path.", path)
	}

	osf, err := os.Open(path)
	if err != nil {
		return nil, err
	}
	defer osf.Close()

	if config == nil {
		config = &UploadToFileSearchStoreConfig{}
	}

	var copiedCfg UploadToFileSearchStoreConfig
	deepCopy(*config, &copiedCfg)

	if copiedCfg.MIMEType == "" {
		copiedCfg.MIMEType = mime.TypeByExtension(filepath.Ext(path))
		if copiedCfg.MIMEType == "" {
			return nil, fmt.Errorf("Unknown mime type: Could not determine the mimetype for your file please set the `MIMEType` argument")
		}
	}

	if copiedCfg.HTTPOptions == nil {
		copiedCfg.HTTPOptions = &HTTPOptions{Headers: http.Header{}}
	}
	if copiedCfg.HTTPOptions.Headers == nil {
		copiedCfg.HTTPOptions.Headers = http.Header{}
	}
	copiedCfg.HTTPOptions.Headers.Add("X-Goog-Upload-Header-Content-Length", strconv.FormatInt(fileInfo.Size(), 10))

	fileName := filepath.Base(path)
	copiedCfg.HTTPOptions.Headers.Add("X-Goog-Upload-File-Name", fileName)

	return m.UploadToFileSearchStore(ctx, osf, FileSearchStoreName, &copiedCfg)
}
