// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebaseappcheck provides access to the Firebase App Check API.
//
// For product documentation, see: https://firebase.google.com/docs/app-check
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firebaseappcheck/v1beta"
//	...
//	ctx := context.Background()
//	firebaseappcheckService, err := firebaseappcheck.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	firebaseappcheckService, err := firebaseappcheck.NewService(ctx, option.WithScopes(firebaseappcheck.FirebaseScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firebaseappcheckService, err := firebaseappcheck.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firebaseappcheckService, err := firebaseappcheck.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firebaseappcheck // import "google.golang.org/api/firebaseappcheck/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "firebaseappcheck:v1beta"
const apiName = "firebaseappcheck"
const apiVersion = "v1beta"
const basePath = "https://firebaseappcheck.googleapis.com/"
const basePathTemplate = "https://firebaseappcheck.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firebaseappcheck.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and administer all your Firebase data and settings
	FirebaseScope = "https://www.googleapis.com/auth/firebase"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/firebase",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Jwks = NewJwksService(s)
	s.OauthClients = NewOauthClientsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Jwks *JwksService

	OauthClients *OauthClientsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewJwksService(s *Service) *JwksService {
	rs := &JwksService{s: s}
	return rs
}

type JwksService struct {
	s *Service
}

func NewOauthClientsService(s *Service) *OauthClientsService {
	rs := &OauthClientsService{s: s}
	return rs
}

type OauthClientsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Apps = NewProjectsAppsService(s)
	rs.Services = NewProjectsServicesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Apps *ProjectsAppsService

	Services *ProjectsServicesService
}

func NewProjectsAppsService(s *Service) *ProjectsAppsService {
	rs := &ProjectsAppsService{s: s}
	rs.AppAttestConfig = NewProjectsAppsAppAttestConfigService(s)
	rs.DebugTokens = NewProjectsAppsDebugTokensService(s)
	rs.DeviceCheckConfig = NewProjectsAppsDeviceCheckConfigService(s)
	rs.PlayIntegrityConfig = NewProjectsAppsPlayIntegrityConfigService(s)
	rs.RecaptchaConfig = NewProjectsAppsRecaptchaConfigService(s)
	rs.RecaptchaEnterpriseConfig = NewProjectsAppsRecaptchaEnterpriseConfigService(s)
	rs.RecaptchaV3Config = NewProjectsAppsRecaptchaV3ConfigService(s)
	rs.SafetyNetConfig = NewProjectsAppsSafetyNetConfigService(s)
	return rs
}

type ProjectsAppsService struct {
	s *Service

	AppAttestConfig *ProjectsAppsAppAttestConfigService

	DebugTokens *ProjectsAppsDebugTokensService

	DeviceCheckConfig *ProjectsAppsDeviceCheckConfigService

	PlayIntegrityConfig *ProjectsAppsPlayIntegrityConfigService

	RecaptchaConfig *ProjectsAppsRecaptchaConfigService

	RecaptchaEnterpriseConfig *ProjectsAppsRecaptchaEnterpriseConfigService

	RecaptchaV3Config *ProjectsAppsRecaptchaV3ConfigService

	SafetyNetConfig *ProjectsAppsSafetyNetConfigService
}

func NewProjectsAppsAppAttestConfigService(s *Service) *ProjectsAppsAppAttestConfigService {
	rs := &ProjectsAppsAppAttestConfigService{s: s}
	return rs
}

type ProjectsAppsAppAttestConfigService struct {
	s *Service
}

func NewProjectsAppsDebugTokensService(s *Service) *ProjectsAppsDebugTokensService {
	rs := &ProjectsAppsDebugTokensService{s: s}
	return rs
}

type ProjectsAppsDebugTokensService struct {
	s *Service
}

func NewProjectsAppsDeviceCheckConfigService(s *Service) *ProjectsAppsDeviceCheckConfigService {
	rs := &ProjectsAppsDeviceCheckConfigService{s: s}
	return rs
}

type ProjectsAppsDeviceCheckConfigService struct {
	s *Service
}

func NewProjectsAppsPlayIntegrityConfigService(s *Service) *ProjectsAppsPlayIntegrityConfigService {
	rs := &ProjectsAppsPlayIntegrityConfigService{s: s}
	return rs
}

type ProjectsAppsPlayIntegrityConfigService struct {
	s *Service
}

func NewProjectsAppsRecaptchaConfigService(s *Service) *ProjectsAppsRecaptchaConfigService {
	rs := &ProjectsAppsRecaptchaConfigService{s: s}
	return rs
}

type ProjectsAppsRecaptchaConfigService struct {
	s *Service
}

func NewProjectsAppsRecaptchaEnterpriseConfigService(s *Service) *ProjectsAppsRecaptchaEnterpriseConfigService {
	rs := &ProjectsAppsRecaptchaEnterpriseConfigService{s: s}
	return rs
}

type ProjectsAppsRecaptchaEnterpriseConfigService struct {
	s *Service
}

func NewProjectsAppsRecaptchaV3ConfigService(s *Service) *ProjectsAppsRecaptchaV3ConfigService {
	rs := &ProjectsAppsRecaptchaV3ConfigService{s: s}
	return rs
}

type ProjectsAppsRecaptchaV3ConfigService struct {
	s *Service
}

func NewProjectsAppsSafetyNetConfigService(s *Service) *ProjectsAppsSafetyNetConfigService {
	rs := &ProjectsAppsSafetyNetConfigService{s: s}
	return rs
}

type ProjectsAppsSafetyNetConfigService struct {
	s *Service
}

func NewProjectsServicesService(s *Service) *ProjectsServicesService {
	rs := &ProjectsServicesService{s: s}
	rs.ResourcePolicies = NewProjectsServicesResourcePoliciesService(s)
	return rs
}

type ProjectsServicesService struct {
	s *Service

	ResourcePolicies *ProjectsServicesResourcePoliciesService
}

func NewProjectsServicesResourcePoliciesService(s *Service) *ProjectsServicesResourcePoliciesService {
	rs := &ProjectsServicesResourcePoliciesService{s: s}
	return rs
}

type ProjectsServicesResourcePoliciesService struct {
	s *Service
}

// GoogleFirebaseAppcheckV1betaAppAttestConfig: An app's App Attest
// configuration object. This configuration controls certain properties of the
// `AppCheckToken` returned by ExchangeAppAttestAttestation and
// ExchangeAppAttestAssertion, such as its ttl. Note that the Team ID
// registered with your app is used as part of the validation process. Please
// register it via the Firebase Console or programmatically via the Firebase
// Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.iosApps/patch).
type GoogleFirebaseAppcheckV1betaAppAttestConfig struct {
	// Name: Required. The relative resource name of the App Attest configuration
	// object, in the format: ```
	// projects/{project_number}/apps/{app_id}/appAttestConfig ```
	Name string `json:"name,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// App Attest artifacts will be valid. If unset, a default value of 1 hour is
	// assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaAppAttestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaAppAttestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaAppCheckToken: Encapsulates an *App Check
// token*, which are used to access backend services protected by App Check.
type GoogleFirebaseAppcheckV1betaAppCheckToken struct {
	// AttestationToken: The App Check token. App Check tokens are signed JWTs
	// (https://tools.ietf.org/html/rfc7519) containing claims that identify the
	// attested app and GCP project. This token is used to access Google services
	// protected by App Check. These tokens can also be verified by your own custom
	// backends
	// (https://firebase.google.com/docs/app-check/custom-resource-backend) using
	// the Firebase Admin SDK or third-party libraries.
	AttestationToken string `json:"attestationToken,omitempty"`
	// Token: The App Check token. App Check tokens are signed JWTs
	// (https://tools.ietf.org/html/rfc7519) containing claims that identify the
	// attested app and GCP project. This token is used to access Google services
	// protected by App Check. These tokens can also be verified by your own custom
	// backends
	// (https://firebase.google.com/docs/app-check/custom-resource-backend) using
	// the Firebase Admin SDK or third-party libraries.
	Token string `json:"token,omitempty"`
	// Ttl: The duration from the time this token is minted until its expiration.
	// This field is intended to ease client-side token management, since the
	// client may have clock skew, but is still able to accurately measure a
	// duration.
	Ttl string `json:"ttl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttestationToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttestationToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaAppCheckToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaAppCheckToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaAttestationTokenResponse: Encapsulates an *App
// Check token*, which are used to access Firebase services protected by App
// Check.
type GoogleFirebaseAppcheckV1betaAttestationTokenResponse struct {
	// AttestationToken: An App Check token. App Check tokens are signed JWTs
	// (https://tools.ietf.org/html/rfc7519) containing claims that identify the
	// attested app and Firebase project. This token is used to access Firebase
	// services protected by App Check.
	AttestationToken string `json:"attestationToken,omitempty"`
	// Ttl: The duration from the time this token is minted until its expiration.
	// This field is intended to ease client-side token management, since the
	// client may have clock skew, but is still able to accurately measure a
	// duration.
	Ttl string `json:"ttl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttestationToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttestationToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaAttestationTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaAttestationTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse: Response
// message for the BatchGetAppAttestConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse struct {
	// Configs: AppAttestConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaAppAttestConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse: Response
// message for the BatchGetDeviceCheckConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse struct {
	// Configs: DeviceCheckConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaDeviceCheckConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse: Response
// message for the BatchGetPlayIntegrityConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse struct {
	// Configs: PlayIntegrityConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaPlayIntegrityConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse: Response
// message for the BatchGetRecaptchaConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse struct {
	// Configs: RecaptchaConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaRecaptchaConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse:
// Response message for the BatchGetRecaptchaEnterpriseConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse struct {
	// Configs: RecaptchaEnterpriseConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse: Response
// message for the BatchGetRecaptchaV3Configs method.
type GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse struct {
	// Configs: RecaptchaV3Configs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaRecaptchaV3Config `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse: Response
// message for the BatchGetSafetyNetConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse struct {
	// Configs: SafetyNetConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaSafetyNetConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesRequest: Request
// message for the BatchUpdateResourcePolicies method.
type GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesRequest struct {
	// Requests: Required. The request messages specifying the ResourcePolicy
	// objects to update. A maximum of 100 objects can be updated in a batch.
	Requests []*GoogleFirebaseAppcheckV1betaUpdateResourcePolicyRequest `json:"requests,omitempty"`
	// UpdateMask: Optional. A comma-separated list of names of fields in the
	// ResourcePolicy objects to update. Example: `enforcement_mode`. If this field
	// is present, the `update_mask` field in the UpdateResourcePolicyRequest
	// messages must all match this field, or the entire batch fails and no updates
	// will be committed.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse: Response
// message for the BatchUpdateResourcePolicies method.
type GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse struct {
	// ResourcePolicies: ResourcePolicy objects after the updates have been
	// applied.
	ResourcePolicies []*GoogleFirebaseAppcheckV1betaResourcePolicy `json:"resourcePolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourcePolicies") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest: Request message for
// the BatchUpdateServices method.
type GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest struct {
	// Requests: Required. The request messages specifying the Services to update.
	// A maximum of 100 objects can be updated in a batch.
	Requests []*GoogleFirebaseAppcheckV1betaUpdateServiceRequest `json:"requests,omitempty"`
	// UpdateMask: Optional. A comma-separated list of names of fields in the
	// Services to update. Example: `display_name`. If the `update_mask` field is
	// set in both this request and any of the UpdateServiceRequest messages, they
	// must match or the entire batch fails and no updates will be committed.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse: Response message
// for the BatchUpdateServices method.
type GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse struct {
	// Services: Service objects after the updates have been applied.
	Services []*GoogleFirebaseAppcheckV1betaService `json:"services,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Services") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Services") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaDebugToken: A *debug token* is a secret used
// during the development or integration testing of an app. It essentially
// allows the development or integration testing to bypass app attestation
// while still allowing App Check to enforce protection on supported production
// Firebase services.
type GoogleFirebaseAppcheckV1betaDebugToken struct {
	// DisplayName: Required. A human readable display name used to identify this
	// debug token.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Required. The relative resource name of the debug token, in the
	// format: ```
	// projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```
	Name string `json:"name,omitempty"`
	// Token: Required. Input only. Immutable. The secret token itself. Must be
	// provided during creation, and must be a UUID4, case insensitive. This field
	// is immutable once set, and cannot be provided during an UpdateDebugToken
	// request. You can, however, delete this debug token using DeleteDebugToken to
	// revoke it. For security reasons, this field will never be populated in any
	// response.
	Token string `json:"token,omitempty"`
	// UpdateTime: Output only. Timestamp when this debug token was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaDebugToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaDebugToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaDeviceCheckConfig: An app's DeviceCheck
// configuration object. This configuration is used by ExchangeDeviceCheckToken
// to validate device tokens issued to apps by DeviceCheck. It also controls
// certain properties of the returned `AppCheckToken`, such as its ttl. Note
// that the Team ID registered with your app is used as part of the validation
// process. Please register it via the Firebase Console or programmatically via
// the Firebase Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.iosApps/patch).
type GoogleFirebaseAppcheckV1betaDeviceCheckConfig struct {
	// KeyId: Required. The key identifier of a private key enabled with
	// DeviceCheck, created in your Apple Developer account.
	KeyId string `json:"keyId,omitempty"`
	// Name: Required. The relative resource name of the DeviceCheck configuration
	// object, in the format: ```
	// projects/{project_number}/apps/{app_id}/deviceCheckConfig ```
	Name string `json:"name,omitempty"`
	// PrivateKey: Required. Input only. The contents of the private key (`.p8`)
	// file associated with the key specified by `key_id`. For security reasons,
	// this field will never be populated in any response.
	PrivateKey string `json:"privateKey,omitempty"`
	// PrivateKeySet: Output only. Whether the `private_key` field was previously
	// set. Since we will never return the `private_key` field, this field is the
	// only way to find out whether it was previously set.
	PrivateKeySet bool `json:"privateKeySet,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// DeviceCheck tokens will be valid. If unset, a default value of 1 hour is
	// assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KeyId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaDeviceCheckConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaDeviceCheckConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest: Request
// message for the ExchangeAppAttestAssertion method.
type GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest struct {
	// Artifact: Required. The artifact returned by a previous call to
	// ExchangeAppAttestAttestation.
	Artifact string `json:"artifact,omitempty"`
	// Assertion: Required. The CBOR-encoded assertion returned by the client-side
	// App Attest API.
	Assertion string `json:"assertion,omitempty"`
	// Challenge: Required. A one-time challenge returned by an immediately prior
	// call to GenerateAppAttestChallenge.
	Challenge string `json:"challenge,omitempty"`
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Artifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifact") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest: Request
// message for the ExchangeAppAttestAttestation method.
type GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest struct {
	// AttestationStatement: Required. The App Attest statement returned by the
	// client-side App Attest API. This is a base64url encoded CBOR object in the
	// JSON response.
	AttestationStatement string `json:"attestationStatement,omitempty"`
	// Challenge: Required. A one-time challenge returned by an immediately prior
	// call to GenerateAppAttestChallenge.
	Challenge string `json:"challenge,omitempty"`
	// KeyId: Required. The key ID generated by App Attest for the client app.
	KeyId string `json:"keyId,omitempty"`
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttestationStatement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttestationStatement") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse: Response
// message for the ExchangeAppAttestAttestation method.
type GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse struct {
	// AppCheckToken: Encapsulates an App Check token.
	AppCheckToken *GoogleFirebaseAppcheckV1betaAppCheckToken `json:"appCheckToken,omitempty"`
	// Artifact: An artifact that can be used in future calls to
	// ExchangeAppAttestAssertion.
	Artifact string `json:"artifact,omitempty"`
	// AttestationToken: Encapsulates an App Check token.
	AttestationToken *GoogleFirebaseAppcheckV1betaAttestationTokenResponse `json:"attestationToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppCheckToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppCheckToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest: Request message for
// the ExchangeCustomToken method.
type GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest struct {
	// CustomToken: Required. A custom token signed using your project's Admin SDK
	// service account credentials.
	CustomToken string `json:"customToken,omitempty"`
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest: Request message for
// the ExchangeDebugToken method.
type GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest struct {
	// DebugToken: Required. A debug token secret. This string must match a debug
	// token secret previously created using CreateDebugToken.
	DebugToken string `json:"debugToken,omitempty"`
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DebugToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DebugToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest: Request message
// for the ExchangeDeviceCheckToken method.
type GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest struct {
	// DeviceToken: Required. The `device_token` as returned by Apple's client-side
	// DeviceCheck API
	// (https://developer.apple.com/documentation/devicecheck/dcdevice). This is
	// the base64 encoded `Data` (Swift) or `NSData` (ObjC) object.
	DeviceToken string `json:"deviceToken,omitempty"`
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangePlayIntegrityTokenRequest: Request
// message for the ExchangePlayIntegrityToken method.
type GoogleFirebaseAppcheckV1betaExchangePlayIntegrityTokenRequest struct {
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// PlayIntegrityToken: Required. The integrity verdict response token from Play
	// Integrity
	// (https://developer.android.com/google/play/integrity/verdict#decrypt-verify)
	// issued to your app.
	PlayIntegrityToken string `json:"playIntegrityToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LimitedUse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LimitedUse") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangePlayIntegrityTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangePlayIntegrityTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeRecaptchaEnterpriseTokenRequest: Request
// message for the ExchangeRecaptchaEnterpriseToken method.
type GoogleFirebaseAppcheckV1betaExchangeRecaptchaEnterpriseTokenRequest struct {
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// RecaptchaEnterpriseToken: Required. The reCAPTCHA token as returned by the
	// reCAPTCHA Enterprise JavaScript API
	// (https://cloud.google.com/recaptcha-enterprise/docs/instrument-web-pages).
	RecaptchaEnterpriseToken string `json:"recaptchaEnterpriseToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LimitedUse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LimitedUse") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeRecaptchaEnterpriseTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeRecaptchaEnterpriseTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest: Request message
// for the ExchangeRecaptchaToken method.
type GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest struct {
	// RecaptchaToken: Required. The reCAPTCHA token as returned by the reCAPTCHA
	// v3 JavaScript API (https://developers.google.com/recaptcha/docs/v3).
	RecaptchaToken string `json:"recaptchaToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecaptchaToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecaptchaToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeRecaptchaV3TokenRequest: Request message
// for the ExchangeRecaptchaV3Token method.
type GoogleFirebaseAppcheckV1betaExchangeRecaptchaV3TokenRequest struct {
	// LimitedUse: Specifies whether this attestation is for use in a *limited use*
	// (`true`) or *session based* (`false`) context. To enable this attestation to
	// be used with the *replay protection* feature, set this to `true`. The
	// default value is `false`.
	LimitedUse bool `json:"limitedUse,omitempty"`
	// RecaptchaV3Token: Required. The reCAPTCHA token as returned by the reCAPTCHA
	// v3 JavaScript API (https://developers.google.com/recaptcha/docs/v3).
	RecaptchaV3Token string `json:"recaptchaV3Token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LimitedUse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LimitedUse") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeRecaptchaV3TokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeRecaptchaV3TokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest: Request message
// for the ExchangeSafetyNetToken method.
type GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest struct {
	// SafetyNetToken: Required. The SafetyNet attestation response
	// (https://developer.android.com/training/safetynet/attestation#request-attestation-step)
	// issued to your app.
	SafetyNetToken string `json:"safetyNetToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SafetyNetToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SafetyNetToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest: Request
// message for the GenerateAppAttestChallenge method.
type GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest struct {
}

// GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse: Response
// message for the GenerateAppAttestChallenge method.
type GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse struct {
	// Challenge: A one-time use challenge for the client to pass to the App Attest
	// API.
	Challenge string `json:"challenge,omitempty"`
	// Ttl: The duration from the time this challenge is minted until its
	// expiration. This field is intended to ease client-side token management,
	// since the client may have clock skew, but is still able to accurately
	// measure a duration.
	Ttl string `json:"ttl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Challenge") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Challenge") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeRequest: Request
// message for the GeneratePlayIntegrityChallenge method.
type GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeRequest struct {
}

// GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse: Response
// message for the GeneratePlayIntegrityChallenge method.
type GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse struct {
	// Challenge: A one-time use challenge
	// (https://developer.android.com/google/play/integrity/verdict#protect-against-replay-attacks)
	// for the client to pass to the Play Integrity API.
	Challenge string `json:"challenge,omitempty"`
	// Ttl: The duration from the time this challenge is minted until its
	// expiration. This field is intended to ease client-side token management,
	// since the client may have clock skew, but is still able to accurately
	// measure a duration.
	Ttl string `json:"ttl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Challenge") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Challenge") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaListDebugTokensResponse: Response message for
// the ListDebugTokens method.
type GoogleFirebaseAppcheckV1betaListDebugTokensResponse struct {
	// DebugTokens: The DebugTokens retrieved.
	DebugTokens []*GoogleFirebaseAppcheckV1betaDebugToken `json:"debugTokens,omitempty"`
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty or omitted, then this
	// response is the last page of results. This token can be used in a subsequent
	// call to ListDebugTokens to find the next group of DebugTokens. Page tokens
	// are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DebugTokens") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DebugTokens") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaListDebugTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaListDebugTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse: Response message
// for the ListResourcePolicies method.
type GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse struct {
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty or omitted, then this
	// response is the last page of results. This token can be used in a subsequent
	// call to ListResourcePolicies to find the next group of ResourcePolicy
	// objects. Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ResourcePolicies: The ResourcePolicy objects retrieved.
	ResourcePolicies []*GoogleFirebaseAppcheckV1betaResourcePolicy `json:"resourcePolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaListServicesResponse: Response message for the
// ListServices method.
type GoogleFirebaseAppcheckV1betaListServicesResponse struct {
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty or omitted, then this
	// response is the last page of results. This token can be used in a subsequent
	// call to ListServices to find the next group of Services. Page tokens are
	// short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Services: The Services retrieved.
	Services []*GoogleFirebaseAppcheckV1betaService `json:"services,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaListServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaListServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaPlayIntegrityConfig: An app's Play Integrity
// configuration object. This configuration controls certain properties of the
// `AppCheckToken` returned by ExchangePlayIntegrityToken, such as its ttl.
// Note that your registered SHA-256 certificate fingerprints are used to
// validate tokens issued by the Play Integrity API; please register them via
// the Firebase Console or programmatically via the Firebase Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.androidApps.sha/create).
type GoogleFirebaseAppcheckV1betaPlayIntegrityConfig struct {
	// Name: Required. The relative resource name of the Play Integrity
	// configuration object, in the format: ```
	// projects/{project_number}/apps/{app_id}/playIntegrityConfig ```
	Name string `json:"name,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// Play Integrity tokens will be valid. If unset, a default value of 1 hour is
	// assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaPlayIntegrityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaPlayIntegrityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaPublicJwk: A JWK as specified by section 4 of
// RFC 7517 (https://tools.ietf.org/html/rfc7517#section-4) and section 6.3.1
// of RFC 7518 (https://tools.ietf.org/html/rfc7518#section-6.3.1).
type GoogleFirebaseAppcheckV1betaPublicJwk struct {
	// Alg: See section 4.4 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.4).
	Alg string `json:"alg,omitempty"`
	// E: See section 6.3.1.2 of RFC 7518
	// (https://tools.ietf.org/html/rfc7518#section-6.3.1.2).
	E string `json:"e,omitempty"`
	// Kid: See section 4.5 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.5).
	Kid string `json:"kid,omitempty"`
	// Kty: See section 4.1 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.1).
	Kty string `json:"kty,omitempty"`
	// N: See section 6.3.1.1 of RFC 7518
	// (https://tools.ietf.org/html/rfc7518#section-6.3.1.1).
	N string `json:"n,omitempty"`
	// Use: See section 4.2 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.2).
	Use string `json:"use,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alg") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alg") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaPublicJwk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaPublicJwk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaPublicJwkSet: The currently active set of public
// keys that can be used to verify App Check tokens. This object is a JWK set
// as specified by section 5 of RFC 7517
// (https://tools.ietf.org/html/rfc7517#section-5). For security, the response
// **must not** be cached for longer than six hours.
type GoogleFirebaseAppcheckV1betaPublicJwkSet struct {
	// Keys: The set of public keys. See section 5.1 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-5).
	Keys []*GoogleFirebaseAppcheckV1betaPublicJwk `json:"keys,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Keys") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Keys") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaPublicJwkSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaPublicJwkSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaRecaptchaConfig: An app's reCAPTCHA v3
// configuration object. This configuration is used by ExchangeRecaptchaToken
// to validate reCAPTCHA tokens issued to apps by reCAPTCHA v3. It also
// controls certain properties of the returned `AppCheckToken`, such as its
// ttl.
type GoogleFirebaseAppcheckV1betaRecaptchaConfig struct {
	// Name: Required. The relative resource name of the reCAPTCHA v3 configuration
	// object, in the format: ```
	// projects/{project_number}/apps/{app_id}/recaptchaConfig ```
	Name string `json:"name,omitempty"`
	// SiteSecret: Required. Input only. The site secret used to identify your
	// service for reCAPTCHA v3 verification. For security reasons, this field will
	// never be populated in any response.
	SiteSecret string `json:"siteSecret,omitempty"`
	// SiteSecretSet: Output only. Whether the `site_secret` field was previously
	// set. Since we will never return the `site_secret` field, this field is the
	// only way to find out whether it was previously set.
	SiteSecretSet bool `json:"siteSecretSet,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// reCAPTCHA tokens will be valid. If unset, a default value of 1 day is
	// assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaRecaptchaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaRecaptchaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig: An app's reCAPTCHA
// Enterprise configuration object. This configuration is used by
// ExchangeRecaptchaEnterpriseToken to validate reCAPTCHA tokens issued to apps
// by reCAPTCHA Enterprise. It also controls certain properties of the returned
// `AppCheckToken`, such as its ttl.
type GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig struct {
	// Name: Required. The relative resource name of the reCAPTCHA Enterprise
	// configuration object, in the format: ```
	// projects/{project_number}/apps/{app_id}/recaptchaEnterpriseConfig ```
	Name string `json:"name,omitempty"`
	// SiteKey: The score-based site key created in reCAPTCHA Enterprise
	// (https://cloud.google.com/recaptcha-enterprise/docs/create-key#creating_a_site_key)
	// used to invoke reCAPTCHA and generate the reCAPTCHA tokens
	// (https://cloud.google.com/recaptcha-enterprise/docs/instrument-web-pages)
	// for your application. Important: This is *not* the `site_secret` (as it is
	// in reCAPTCHA v3), but rather your score-based reCAPTCHA Enterprise site key.
	SiteKey string `json:"siteKey,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// reCAPTCHA Enterprise tokens will be valid. If unset, a default value of 1
	// hour is assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaRecaptchaV3Config: An app's reCAPTCHA v3
// configuration object. This configuration is used by ExchangeRecaptchaV3Token
// to validate reCAPTCHA tokens issued to apps by reCAPTCHA v3. It also
// controls certain properties of the returned `AppCheckToken`, such as its
// ttl.
type GoogleFirebaseAppcheckV1betaRecaptchaV3Config struct {
	// Name: Required. The relative resource name of the reCAPTCHA v3 configuration
	// object, in the format: ```
	// projects/{project_number}/apps/{app_id}/recaptchaV3Config ```
	Name string `json:"name,omitempty"`
	// SiteSecret: Required. Input only. The site secret used to identify your
	// service for reCAPTCHA v3 verification. For security reasons, this field will
	// never be populated in any response.
	SiteSecret string `json:"siteSecret,omitempty"`
	// SiteSecretSet: Output only. Whether the `site_secret` field was previously
	// set. Since we will never return the `site_secret` field, this field is the
	// only way to find out whether it was previously set.
	SiteSecretSet bool `json:"siteSecretSet,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// reCAPTCHA tokens will be valid. If unset, a default value of 1 day is
	// assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaRecaptchaV3Config) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaRecaptchaV3Config
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaResourcePolicy: App Check enforcement policy for
// a specific resource of a Google service supported by App Check. Note that
// this policy will override the service-level configuration.
type GoogleFirebaseAppcheckV1betaResourcePolicy struct {
	// EnforcementMode: Required. The App Check enforcement mode for this resource.
	// This will override the EnforcementMode setting on the parent service.
	//
	// Possible values:
	//   "OFF" - Firebase App Check is not enforced for the service, nor are App
	// Check metrics collected. Though the service is not protected by App Check in
	// this mode, other applicable protections, such as user authorization, are
	// still enforced. An unconfigured service is in this mode by default.
	//   "UNENFORCED" - Firebase App Check is not enforced for the service. App
	// Check metrics are collected to help you decide when to turn on enforcement
	// for the service. Though the service is not protected by App Check in this
	// mode, other applicable protections, such as user authorization, are still
	// enforced. Some services require certain conditions to be met before they
	// will work with App Check, such as requiring you to upgrade to a specific
	// service tier. Until those requirements are met for a service, this
	// `UNENFORCED` setting will have no effect and App Check will not work with
	// that service.
	//   "ENFORCED" - Firebase App Check is enforced for the service. The service
	// will reject any request that attempts to access your project's resources if
	// it does not have valid App Check token attached, with some exceptions
	// depending on the service; for example, some services will still allow
	// requests bearing the developer's privileged service account credentials
	// without an App Check token. App Check metrics continue to be collected to
	// help you detect issues with your App Check integration and monitor the
	// composition of your callers. While the service is protected by App Check,
	// other applicable protections, such as user authorization, continue to be
	// enforced at the same time. Use caution when choosing to enforce App Check on
	// a Firebase service. If your users have not updated to an App Check capable
	// version of your app, their apps will no longer be able to use your Firebase
	// services that are enforcing App Check. App Check metrics can help you decide
	// whether to enforce App Check on your Firebase services. If your app has not
	// launched yet, you should enable enforcement immediately, since there are no
	// outdated clients in use. Some services require certain conditions to be met
	// before they will work with App Check, such as requiring you to upgrade to a
	// specific service tier. Until those requirements are met for a service, this
	// `ENFORCED` setting will have no effect and App Check will not work with that
	// service.
	EnforcementMode string `json:"enforcementMode,omitempty"`
	// Etag: This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the client
	// has an up-to-date value before proceeding. This etag is strongly validated
	// as defined by RFC 7232.
	Etag string `json:"etag,omitempty"`
	// Name: Required. Identifier. The relative name of the resource policy object,
	// in the format: ```
	// projects/{project_number}/services/{service_id}/resourcePolicies/{resource_po
	// licy_id} ``` Note that the `service_id` element must be a supported service
	// ID. Currently, the following service IDs are supported: *
	// `oauth2.googleapis.com` (Google Identity for iOS) `resource_policy_id` is a
	// system-generated UID.
	Name string `json:"name,omitempty"`
	// TargetResource: Required. Service specific name of the resource object to
	// which this policy applies, in the format: * **iOS OAuth clients** (Google
	// Identity for iOS):
	// `//oauth2.googleapis.com/projects/{project_number}/oauthClients/{oauth_client
	// _id}` Note that the resource must belong to the service specified in the
	// `name` and be from the same project as this policy, but the resource is
	// allowed to be missing at the time of creation of this policy; in that case,
	// we make a best-effort attempt at respecting this policy, but it may not have
	// any effect until the resource is fully created.
	TargetResource string `json:"targetResource,omitempty"`
	// UpdateTime: Output only. Timestamp when this resource policy configuration
	// object was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EnforcementMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnforcementMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaResourcePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaResourcePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaSafetyNetConfig: An app's SafetyNet
// configuration object. This configuration controls certain properties of the
// `AppCheckToken` returned by ExchangeSafetyNetToken, such as its ttl. Note
// that your registered SHA-256 certificate fingerprints are used to validate
// tokens issued by SafetyNet; please register them via the Firebase Console or
// programmatically via the Firebase Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.androidApps.sha/create).
type GoogleFirebaseAppcheckV1betaSafetyNetConfig struct {
	// Name: Required. The relative resource name of the SafetyNet configuration
	// object, in the format: ```
	// projects/{project_number}/apps/{app_id}/safetyNetConfig ```
	Name string `json:"name,omitempty"`
	// TokenTtl: Specifies the duration for which App Check tokens exchanged from
	// SafetyNet tokens will be valid. If unset, a default value of 1 hour is
	// assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaSafetyNetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaSafetyNetConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaService: The enforcement configuration for a
// Firebase service supported by App Check.
type GoogleFirebaseAppcheckV1betaService struct {
	// EnforcementMode: Required. The App Check enforcement mode for this service.
	//
	// Possible values:
	//   "OFF" - Firebase App Check is not enforced for the service, nor are App
	// Check metrics collected. Though the service is not protected by App Check in
	// this mode, other applicable protections, such as user authorization, are
	// still enforced. An unconfigured service is in this mode by default.
	//   "UNENFORCED" - Firebase App Check is not enforced for the service. App
	// Check metrics are collected to help you decide when to turn on enforcement
	// for the service. Though the service is not protected by App Check in this
	// mode, other applicable protections, such as user authorization, are still
	// enforced. Some services require certain conditions to be met before they
	// will work with App Check, such as requiring you to upgrade to a specific
	// service tier. Until those requirements are met for a service, this
	// `UNENFORCED` setting will have no effect and App Check will not work with
	// that service.
	//   "ENFORCED" - Firebase App Check is enforced for the service. The service
	// will reject any request that attempts to access your project's resources if
	// it does not have valid App Check token attached, with some exceptions
	// depending on the service; for example, some services will still allow
	// requests bearing the developer's privileged service account credentials
	// without an App Check token. App Check metrics continue to be collected to
	// help you detect issues with your App Check integration and monitor the
	// composition of your callers. While the service is protected by App Check,
	// other applicable protections, such as user authorization, continue to be
	// enforced at the same time. Use caution when choosing to enforce App Check on
	// a Firebase service. If your users have not updated to an App Check capable
	// version of your app, their apps will no longer be able to use your Firebase
	// services that are enforcing App Check. App Check metrics can help you decide
	// whether to enforce App Check on your Firebase services. If your app has not
	// launched yet, you should enable enforcement immediately, since there are no
	// outdated clients in use. Some services require certain conditions to be met
	// before they will work with App Check, such as requiring you to upgrade to a
	// specific service tier. Until those requirements are met for a service, this
	// `ENFORCED` setting will have no effect and App Check will not work with that
	// service.
	EnforcementMode string `json:"enforcementMode,omitempty"`
	// Etag: This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the client
	// has an up-to-date value before proceeding. This etag is strongly validated
	// as defined by RFC 7232.
	Etag string `json:"etag,omitempty"`
	// Name: Required. The relative resource name of the service configuration
	// object, in the format: ``` projects/{project_number}/services/{service_id}
	// ``` Note that the `service_id` element must be a supported service ID.
	// Currently, the following service IDs are supported: *
	// `firebasestorage.googleapis.com` (Cloud Storage for Firebase) *
	// `firebasedatabase.googleapis.com` (Firebase Realtime Database) *
	// `firestore.googleapis.com` (Cloud Firestore) *
	// `identitytoolkit.googleapis.com` (Firebase Authentication with Identity
	// Platform) * `oauth2.googleapis.com` (Google Identity for iOS)
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when this service configuration object
	// was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EnforcementMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnforcementMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaUpdateResourcePolicyRequest: Request message for
// the UpdateResourcePolicy method as well as an individual update message for
// the BatchUpdateResourcePolicies method.
type GoogleFirebaseAppcheckV1betaUpdateResourcePolicyRequest struct {
	// ResourcePolicy: Required. The ResourcePolicy to update. The ResourcePolicy's
	// `name` field is used to identify the ResourcePolicy to be updated, in the
	// format: ```
	// projects/{project_number}/services/{service_id}/resourcePolicies/{resource_po
	// licy_id} ``` Note that the `service_id` element must be a supported service
	// ID. Currently, the following service IDs are supported: *
	// `oauth2.googleapis.com` (Google Identity for iOS)
	ResourcePolicy *GoogleFirebaseAppcheckV1betaResourcePolicy `json:"resourcePolicy,omitempty"`
	// UpdateMask: Required. A comma-separated list of names of fields in the
	// ResourcePolicy to update. Example: `enforcement_mode`.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourcePolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourcePolicy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaUpdateResourcePolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaUpdateResourcePolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaUpdateServiceRequest: Request message for the
// UpdateService method as well as an individual update message for the
// BatchUpdateServices method.
type GoogleFirebaseAppcheckV1betaUpdateServiceRequest struct {
	// Service: Required. The Service to update. The Service's `name` field is used
	// to identify the Service to be updated, in the format: ```
	// projects/{project_number}/services/{service_id} ``` Note that the
	// `service_id` element must be a supported service ID. Currently, the
	// following service IDs are supported: * `firebasestorage.googleapis.com`
	// (Cloud Storage for Firebase) * `firebasedatabase.googleapis.com` (Firebase
	// Realtime Database) * `firestore.googleapis.com` (Cloud Firestore) *
	// `identitytoolkit.googleapis.com` (Firebase Authentication with Identity
	// Platform) * `oauth2.googleapis.com` (Google Identity for iOS) For Firebase
	// Authentication to work with App Check, you must first upgrade to Firebase
	// Authentication with Identity Platform
	// (https://firebase.google.com/docs/auth#identity-platform).
	Service *GoogleFirebaseAppcheckV1betaService `json:"service,omitempty"`
	// UpdateMask: Required. A comma-separated list of names of fields in the
	// Service to update. Example: `enforcement_mode`.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaUpdateServiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaUpdateServiceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenRequest: Request message for
// the VerifyAppCheckToken method.
type GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenRequest struct {
	// AppCheckToken: Required. The App Check token to verify. App Check tokens
	// exchanged from the SafetyNet provider are not supported; an HTTP 400 error
	// will be returned.
	AppCheckToken string `json:"appCheckToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppCheckToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppCheckToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse: Response message
// for the VerifyAppCheckToken method.
type GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse struct {
	// AlreadyConsumed: Whether this token was already consumed. If this is the
	// first time this method has seen the given App Check token, this field will
	// be omitted from the response. The given token will then be marked as
	// `already_consumed` (set to `true`) for all future invocations of this method
	// for that token. Note that if the given App Check token is invalid, an HTTP
	// 403 error is returned instead of a response containing this field,
	// regardless whether the token was already consumed.
	AlreadyConsumed bool `json:"alreadyConsumed,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlreadyConsumed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlreadyConsumed") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type JwksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a public JWK set as specified by RFC 7517
// (https://tools.ietf.org/html/rfc7517) that can be used to verify App Check
// tokens. Exactly one of the public keys in the returned set will successfully
// validate any App Check token that is currently valid.
//
//   - name: The relative resource name to the public JWK set. Must always be
//     exactly the string `jwks`.
func (r *JwksService) Get(name string) *JwksGetCall {
	c := &JwksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JwksGetCall) Fields(s ...googleapi.Field) *JwksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *JwksGetCall) IfNoneMatch(entityTag string) *JwksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JwksGetCall) Context(ctx context.Context) *JwksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JwksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JwksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.jwks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.jwks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaPublicJwkSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *JwksGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaPublicJwkSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaPublicJwkSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.jwks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OauthClientsExchangeAppAttestAssertionCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betaexchangeappattestassertionrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// ExchangeAppAttestAssertion: Accepts an App Attest assertion and an artifact
// previously obtained from ExchangeAppAttestAttestation and verifies those
// with Apple. If valid, returns an AppCheckToken.
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *OauthClientsService) ExchangeAppAttestAssertion(appid string, googlefirebaseappcheckv1betaexchangeappattestassertionrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest) *OauthClientsExchangeAppAttestAssertionCall {
	c := &OauthClientsExchangeAppAttestAssertionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeappattestassertionrequest = googlefirebaseappcheckv1betaexchangeappattestassertionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OauthClientsExchangeAppAttestAssertionCall) Fields(s ...googleapi.Field) *OauthClientsExchangeAppAttestAssertionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OauthClientsExchangeAppAttestAssertionCall) Context(ctx context.Context) *OauthClientsExchangeAppAttestAssertionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OauthClientsExchangeAppAttestAssertionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OauthClientsExchangeAppAttestAssertionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangeappattestassertionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeAppAttestAssertion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.exchangeAppAttestAssertion", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.oauthClients.exchangeAppAttestAssertion" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OauthClientsExchangeAppAttestAssertionCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.exchangeAppAttestAssertion", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OauthClientsExchangeAppAttestAttestationCall struct {
	s                                                               *Service
	appid                                                           string
	googlefirebaseappcheckv1betaexchangeappattestattestationrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest
	urlParams_                                                      gensupport.URLParams
	ctx_                                                            context.Context
	header_                                                         http.Header
}

// ExchangeAppAttestAttestation: Accepts an App Attest CBOR attestation and
// verifies it with Apple using your preconfigured team and bundle IDs. If
// valid, returns an attestation artifact that can later be exchanged for an
// AppCheckToken using ExchangeAppAttestAssertion. For convenience and
// performance, this method's response object will also contain an
// AppCheckToken (if the verification is successful).
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *OauthClientsService) ExchangeAppAttestAttestation(appid string, googlefirebaseappcheckv1betaexchangeappattestattestationrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest) *OauthClientsExchangeAppAttestAttestationCall {
	c := &OauthClientsExchangeAppAttestAttestationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeappattestattestationrequest = googlefirebaseappcheckv1betaexchangeappattestattestationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OauthClientsExchangeAppAttestAttestationCall) Fields(s ...googleapi.Field) *OauthClientsExchangeAppAttestAttestationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OauthClientsExchangeAppAttestAttestationCall) Context(ctx context.Context) *OauthClientsExchangeAppAttestAttestationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OauthClientsExchangeAppAttestAttestationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OauthClientsExchangeAppAttestAttestationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangeappattestattestationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeAppAttestAttestation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.exchangeAppAttestAttestation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.oauthClients.exchangeAppAttestAttestation" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OauthClientsExchangeAppAttestAttestationCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.exchangeAppAttestAttestation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OauthClientsExchangeDebugTokenCall struct {
	s                                                     *Service
	appid                                                 string
	googlefirebaseappcheckv1betaexchangedebugtokenrequest *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// ExchangeDebugToken: Validates a debug token secret that you have previously
// created using CreateDebugToken. If valid, returns an AppCheckToken. Note
// that a restrictive quota is enforced on this method to prevent accidental
// exposure of the app to abuse.
//
//   - app: The relative resource name of the app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *OauthClientsService) ExchangeDebugToken(appid string, googlefirebaseappcheckv1betaexchangedebugtokenrequest *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest) *OauthClientsExchangeDebugTokenCall {
	c := &OauthClientsExchangeDebugTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangedebugtokenrequest = googlefirebaseappcheckv1betaexchangedebugtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OauthClientsExchangeDebugTokenCall) Fields(s ...googleapi.Field) *OauthClientsExchangeDebugTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OauthClientsExchangeDebugTokenCall) Context(ctx context.Context) *OauthClientsExchangeDebugTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OauthClientsExchangeDebugTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OauthClientsExchangeDebugTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangedebugtokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeDebugToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.exchangeDebugToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.oauthClients.exchangeDebugToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OauthClientsExchangeDebugTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.exchangeDebugToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OauthClientsGenerateAppAttestChallengeCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betagenerateappattestchallengerequest *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// GenerateAppAttestChallenge: Generates a challenge that protects the
// integrity of an immediately following call to ExchangeAppAttestAttestation
// or ExchangeAppAttestAssertion. A challenge should not be reused for multiple
// calls.
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *OauthClientsService) GenerateAppAttestChallenge(appid string, googlefirebaseappcheckv1betagenerateappattestchallengerequest *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest) *OauthClientsGenerateAppAttestChallengeCall {
	c := &OauthClientsGenerateAppAttestChallengeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betagenerateappattestchallengerequest = googlefirebaseappcheckv1betagenerateappattestchallengerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OauthClientsGenerateAppAttestChallengeCall) Fields(s ...googleapi.Field) *OauthClientsGenerateAppAttestChallengeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OauthClientsGenerateAppAttestChallengeCall) Context(ctx context.Context) *OauthClientsGenerateAppAttestChallengeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OauthClientsGenerateAppAttestChallengeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OauthClientsGenerateAppAttestChallengeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betagenerateappattestchallengerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:generateAppAttestChallenge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.generateAppAttestChallenge", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.oauthClients.generateAppAttestChallenge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OauthClientsGenerateAppAttestChallengeCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.oauthClients.generateAppAttestChallenge", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsVerifyAppCheckTokenCall struct {
	s                                                      *Service
	projectid                                              string
	googlefirebaseappcheckv1betaverifyappchecktokenrequest *GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// VerifyAppCheckToken: Verifies the given App Check token and returns token
// usage signals that callers may act upon. This method currently only supports
// App Check tokens exchanged from the following attestation providers: * Play
// Integrity API * App Attest * DeviceCheck (`DCDevice` tokens) * reCAPTCHA
// Enterprise * reCAPTCHA v3 * Custom providers App Check tokens exchanged from
// debug secrets are also supported. Calling this method on an otherwise valid
// App Check token with an unsupported provider will cause an HTTP 400 error to
// be returned. Returns whether this token was already consumed before this
// call. If this is the first time this method has seen the given App Check
// token, the field `already_consumed` in the response will be absent. The
// given token will then be marked as `already_consumed` (set to `true`) for
// all future invocations of this method for that token. Note that if the given
// App Check token is invalid, an HTTP 403 error is returned instead of a
// response object, regardless whether the token was already consumed.
// Currently, when evaluating whether an App Check token was already consumed,
// only calls to this exact method are counted. Use of the App Check token
// elsewhere will not mark the token as being already consumed. The caller must
// have the `firebaseappcheck.appCheckTokens.verify`
// (https://firebase.google.com/docs/projects/iam/permissions#app-check)
// permission to call this method. This permission is part of the Firebase App
// Check Token Verifier role
// (https://firebase.google.com/docs/projects/iam/roles-predefined-product#app-check).
//
//   - project: The relative resource name of the project for which the token was
//     minted, in the format: ``` projects/{project_number} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsService) VerifyAppCheckToken(projectid string, googlefirebaseappcheckv1betaverifyappchecktokenrequest *GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenRequest) *ProjectsVerifyAppCheckTokenCall {
	c := &ProjectsVerifyAppCheckTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectid = projectid
	c.googlefirebaseappcheckv1betaverifyappchecktokenrequest = googlefirebaseappcheckv1betaverifyappchecktokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsVerifyAppCheckTokenCall) Fields(s ...googleapi.Field) *ProjectsVerifyAppCheckTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsVerifyAppCheckTokenCall) Context(ctx context.Context) *ProjectsVerifyAppCheckTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsVerifyAppCheckTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsVerifyAppCheckTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaverifyappchecktokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+project}:verifyAppCheckToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.projectid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.verifyAppCheckToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.verifyAppCheckToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsVerifyAppCheckTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaVerifyAppCheckTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.verifyAppCheckToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeAppAttestAssertionCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betaexchangeappattestassertionrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// ExchangeAppAttestAssertion: Accepts an App Attest assertion and an artifact
// previously obtained from ExchangeAppAttestAttestation and verifies those
// with Apple. If valid, returns an AppCheckToken.
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *ProjectsAppsService) ExchangeAppAttestAssertion(appid string, googlefirebaseappcheckv1betaexchangeappattestassertionrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest) *ProjectsAppsExchangeAppAttestAssertionCall {
	c := &ProjectsAppsExchangeAppAttestAssertionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeappattestassertionrequest = googlefirebaseappcheckv1betaexchangeappattestassertionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeAppAttestAssertionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Context(ctx context.Context) *ProjectsAppsExchangeAppAttestAssertionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeAppAttestAssertionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangeappattestassertionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeAppAttestAssertion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeAppAttestAssertion", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeAppAttestAssertion" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeAppAttestAssertion", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeAppAttestAttestationCall struct {
	s                                                               *Service
	appid                                                           string
	googlefirebaseappcheckv1betaexchangeappattestattestationrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest
	urlParams_                                                      gensupport.URLParams
	ctx_                                                            context.Context
	header_                                                         http.Header
}

// ExchangeAppAttestAttestation: Accepts an App Attest CBOR attestation and
// verifies it with Apple using your preconfigured team and bundle IDs. If
// valid, returns an attestation artifact that can later be exchanged for an
// AppCheckToken using ExchangeAppAttestAssertion. For convenience and
// performance, this method's response object will also contain an
// AppCheckToken (if the verification is successful).
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *ProjectsAppsService) ExchangeAppAttestAttestation(appid string, googlefirebaseappcheckv1betaexchangeappattestattestationrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest) *ProjectsAppsExchangeAppAttestAttestationCall {
	c := &ProjectsAppsExchangeAppAttestAttestationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeappattestattestationrequest = googlefirebaseappcheckv1betaexchangeappattestattestationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeAppAttestAttestationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Context(ctx context.Context) *ProjectsAppsExchangeAppAttestAttestationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeAppAttestAttestationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangeappattestattestationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeAppAttestAttestation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeAppAttestAttestation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeAppAttestAttestation" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeAppAttestAttestation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeCustomTokenCall struct {
	s                                                      *Service
	appid                                                  string
	googlefirebaseappcheckv1betaexchangecustomtokenrequest *GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// ExchangeCustomToken: Validates a custom token signed using your project's
// Admin SDK service account credentials. If valid, returns an AppCheckToken.
//
//   - app: The relative resource name of the app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeCustomToken(appid string, googlefirebaseappcheckv1betaexchangecustomtokenrequest *GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest) *ProjectsAppsExchangeCustomTokenCall {
	c := &ProjectsAppsExchangeCustomTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangecustomtokenrequest = googlefirebaseappcheckv1betaexchangecustomtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeCustomTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeCustomTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeCustomTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeCustomTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeCustomTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeCustomTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangecustomtokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeCustomToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeCustomToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeCustomToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeCustomTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeCustomToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeDebugTokenCall struct {
	s                                                     *Service
	appid                                                 string
	googlefirebaseappcheckv1betaexchangedebugtokenrequest *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// ExchangeDebugToken: Validates a debug token secret that you have previously
// created using CreateDebugToken. If valid, returns an AppCheckToken. Note
// that a restrictive quota is enforced on this method to prevent accidental
// exposure of the app to abuse.
//
//   - app: The relative resource name of the app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *ProjectsAppsService) ExchangeDebugToken(appid string, googlefirebaseappcheckv1betaexchangedebugtokenrequest *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest) *ProjectsAppsExchangeDebugTokenCall {
	c := &ProjectsAppsExchangeDebugTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangedebugtokenrequest = googlefirebaseappcheckv1betaexchangedebugtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeDebugTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeDebugTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeDebugTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeDebugTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeDebugTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeDebugTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangedebugtokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeDebugToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeDebugToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeDebugToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeDebugTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeDebugToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeDeviceCheckTokenCall struct {
	s                                                           *Service
	appid                                                       string
	googlefirebaseappcheckv1betaexchangedevicechecktokenrequest *GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// ExchangeDeviceCheckToken: Accepts a `device_token`
// (https://developer.apple.com/documentation/devicecheck/dcdevice) issued by
// DeviceCheck, and attempts to validate it with Apple. If valid, returns an
// AppCheckToken.
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeDeviceCheckToken(appid string, googlefirebaseappcheckv1betaexchangedevicechecktokenrequest *GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest) *ProjectsAppsExchangeDeviceCheckTokenCall {
	c := &ProjectsAppsExchangeDeviceCheckTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangedevicechecktokenrequest = googlefirebaseappcheckv1betaexchangedevicechecktokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeDeviceCheckTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeDeviceCheckTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeDeviceCheckTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangedevicechecktokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeDeviceCheckToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeDeviceCheckToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeDeviceCheckToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeDeviceCheckToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangePlayIntegrityTokenCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betaexchangeplayintegritytokenrequest *GoogleFirebaseAppcheckV1betaExchangePlayIntegrityTokenRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// ExchangePlayIntegrityToken: Validates an integrity verdict response token
// from Play Integrity
// (https://developer.android.com/google/play/integrity/verdict#decrypt-verify).
// If valid, returns an AppCheckToken.
//
//   - app: The relative resource name of the Android app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangePlayIntegrityToken(appid string, googlefirebaseappcheckv1betaexchangeplayintegritytokenrequest *GoogleFirebaseAppcheckV1betaExchangePlayIntegrityTokenRequest) *ProjectsAppsExchangePlayIntegrityTokenCall {
	c := &ProjectsAppsExchangePlayIntegrityTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeplayintegritytokenrequest = googlefirebaseappcheckv1betaexchangeplayintegritytokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangePlayIntegrityTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangePlayIntegrityTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangePlayIntegrityTokenCall) Context(ctx context.Context) *ProjectsAppsExchangePlayIntegrityTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangePlayIntegrityTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangePlayIntegrityTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangeplayintegritytokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangePlayIntegrityToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangePlayIntegrityToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangePlayIntegrityToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangePlayIntegrityTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangePlayIntegrityToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeRecaptchaEnterpriseTokenCall struct {
	s                                                                   *Service
	appid                                                               string
	googlefirebaseappcheckv1betaexchangerecaptchaenterprisetokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaEnterpriseTokenRequest
	urlParams_                                                          gensupport.URLParams
	ctx_                                                                context.Context
	header_                                                             http.Header
}

// ExchangeRecaptchaEnterpriseToken: Validates a reCAPTCHA Enterprise response
// token
// (https://cloud.google.com/recaptcha-enterprise/docs/create-assessment#retrieve_token).
// If valid, returns an App Check token AppCheckToken.
//
//   - app: The relative resource name of the web app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeRecaptchaEnterpriseToken(appid string, googlefirebaseappcheckv1betaexchangerecaptchaenterprisetokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaEnterpriseTokenRequest) *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall {
	c := &ProjectsAppsExchangeRecaptchaEnterpriseTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangerecaptchaenterprisetokenrequest = googlefirebaseappcheckv1betaexchangerecaptchaenterprisetokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangerecaptchaenterprisetokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeRecaptchaEnterpriseToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeRecaptchaEnterpriseToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeRecaptchaEnterpriseToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeRecaptchaEnterpriseTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeRecaptchaEnterpriseToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeRecaptchaTokenCall struct {
	s                                                         *Service
	appid                                                     string
	googlefirebaseappcheckv1betaexchangerecaptchatokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// ExchangeRecaptchaToken: Validates a reCAPTCHA v3 response token
// (https://developers.google.com/recaptcha/docs/v3). If valid, returns an
// AppCheckToken.
//
//   - app: The relative resource name of the web app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeRecaptchaToken(appid string, googlefirebaseappcheckv1betaexchangerecaptchatokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest) *ProjectsAppsExchangeRecaptchaTokenCall {
	c := &ProjectsAppsExchangeRecaptchaTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangerecaptchatokenrequest = googlefirebaseappcheckv1betaexchangerecaptchatokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeRecaptchaTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeRecaptchaTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeRecaptchaTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangerecaptchatokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeRecaptchaToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeRecaptchaToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeRecaptchaToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeRecaptchaToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeRecaptchaV3TokenCall struct {
	s                                                           *Service
	appid                                                       string
	googlefirebaseappcheckv1betaexchangerecaptchav3tokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaV3TokenRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// ExchangeRecaptchaV3Token: Validates a reCAPTCHA v3 response token
// (https://developers.google.com/recaptcha/docs/v3). If valid, returns an
// AppCheckToken.
//
//   - app: The relative resource name of the web app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeRecaptchaV3Token(appid string, googlefirebaseappcheckv1betaexchangerecaptchav3tokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaV3TokenRequest) *ProjectsAppsExchangeRecaptchaV3TokenCall {
	c := &ProjectsAppsExchangeRecaptchaV3TokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangerecaptchav3tokenrequest = googlefirebaseappcheckv1betaexchangerecaptchav3tokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeRecaptchaV3TokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeRecaptchaV3TokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeRecaptchaV3TokenCall) Context(ctx context.Context) *ProjectsAppsExchangeRecaptchaV3TokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeRecaptchaV3TokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeRecaptchaV3TokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangerecaptchav3tokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeRecaptchaV3Token")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeRecaptchaV3Token", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeRecaptchaV3Token" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeRecaptchaV3TokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeRecaptchaV3Token", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsExchangeSafetyNetTokenCall struct {
	s                                                         *Service
	appid                                                     string
	googlefirebaseappcheckv1betaexchangesafetynettokenrequest *GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// ExchangeSafetyNetToken: Validates a SafetyNet token
// (https://developer.android.com/training/safetynet/attestation#request-attestation-step).
// If valid, returns an AppCheckToken.
//
//   - app: The relative resource name of the Android app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeSafetyNetToken(appid string, googlefirebaseappcheckv1betaexchangesafetynettokenrequest *GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest) *ProjectsAppsExchangeSafetyNetTokenCall {
	c := &ProjectsAppsExchangeSafetyNetTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangesafetynettokenrequest = googlefirebaseappcheckv1betaexchangesafetynettokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeSafetyNetTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeSafetyNetTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeSafetyNetTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaexchangesafetynettokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeSafetyNetToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeSafetyNetToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeSafetyNetToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppCheckToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppCheckToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppCheckToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.exchangeSafetyNetToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsGenerateAppAttestChallengeCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betagenerateappattestchallengerequest *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// GenerateAppAttestChallenge: Generates a challenge that protects the
// integrity of an immediately following call to ExchangeAppAttestAttestation
// or ExchangeAppAttestAssertion. A challenge should not be reused for multiple
// calls.
//
//   - app: The relative resource name of the iOS app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard. Alternatively, if
//     this method is being called for an OAuth client protected by App Check,
//     this field can also be in the format: ``` oauthClients/{oauth_client_id}
//     ``` You can view the OAuth client ID for your OAuth clients in the Google
//     Cloud console. Note that only iOS OAuth clients are supported at this
//     time, and they must be linked to corresponding iOS Firebase apps. Please
//     see the documentation
//     (https://developers.google.com/identity/sign-in/ios/appcheck/get-started#project-setup)
//     for more information.
func (r *ProjectsAppsService) GenerateAppAttestChallenge(appid string, googlefirebaseappcheckv1betagenerateappattestchallengerequest *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest) *ProjectsAppsGenerateAppAttestChallengeCall {
	c := &ProjectsAppsGenerateAppAttestChallengeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betagenerateappattestchallengerequest = googlefirebaseappcheckv1betagenerateappattestchallengerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Fields(s ...googleapi.Field) *ProjectsAppsGenerateAppAttestChallengeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Context(ctx context.Context) *ProjectsAppsGenerateAppAttestChallengeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsGenerateAppAttestChallengeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betagenerateappattestchallengerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:generateAppAttestChallenge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.generateAppAttestChallenge", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.generateAppAttestChallenge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.generateAppAttestChallenge", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsGeneratePlayIntegrityChallengeCall struct {
	s                                                                 *Service
	appid                                                             string
	googlefirebaseappcheckv1betagenerateplayintegritychallengerequest *GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// GeneratePlayIntegrityChallenge: Generates a challenge that protects the
// integrity of an immediately following integrity verdict request to the Play
// Integrity API. The next call to ExchangePlayIntegrityToken using the
// resulting integrity token will verify the presence and validity of the
// challenge. A challenge should not be reused for multiple calls.
//
//   - app: The relative resource name of the app, in the format: ```
//     projects/{project_number}/apps/{app_id} ``` If necessary, the
//     `project_number` element can be replaced with the project ID of the
//     Firebase project. Learn more about using project identifiers in Google's
//     AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) GeneratePlayIntegrityChallenge(appid string, googlefirebaseappcheckv1betagenerateplayintegritychallengerequest *GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeRequest) *ProjectsAppsGeneratePlayIntegrityChallengeCall {
	c := &ProjectsAppsGeneratePlayIntegrityChallengeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betagenerateplayintegritychallengerequest = googlefirebaseappcheckv1betagenerateplayintegritychallengerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsGeneratePlayIntegrityChallengeCall) Fields(s ...googleapi.Field) *ProjectsAppsGeneratePlayIntegrityChallengeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsGeneratePlayIntegrityChallengeCall) Context(ctx context.Context) *ProjectsAppsGeneratePlayIntegrityChallengeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsGeneratePlayIntegrityChallengeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsGeneratePlayIntegrityChallengeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betagenerateplayintegritychallengerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:generatePlayIntegrityChallenge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.generatePlayIntegrityChallenge", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.generatePlayIntegrityChallenge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse.ServerRes
// ponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsGeneratePlayIntegrityChallengeCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaGeneratePlayIntegrityChallengeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.generatePlayIntegrityChallenge", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsAppAttestConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the AppAttestConfigs for the specified list of
// apps.
//
//   - parent: The parent project name shared by all AppAttestConfigs being
//     retrieved, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being retrieved must match
//     this field, or the entire batch fails.
func (r *ProjectsAppsAppAttestConfigService) BatchGet(parent string) *ProjectsAppsAppAttestConfigBatchGetCall {
	c := &ProjectsAppsAppAttestConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the AppAttestConfigs to retrieve, in the format ```
// projects/{project_number}/apps/{app_id}/appAttestConfig ``` A maximum of 100
// objects can be retrieved in a batch.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Names(names ...string) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsAppAttestConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/appAttestConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.appAttestConfig.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.appAttestConfig.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.appAttestConfig.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsAppAttestConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the AppAttestConfig for the specified app.
//
//   - name: The relative resource name of the AppAttestConfig, in the format:
//     ``` projects/{project_number}/apps/{app_id}/appAttestConfig ```.
func (r *ProjectsAppsAppAttestConfigService) Get(name string) *ProjectsAppsAppAttestConfigGetCall {
	c := &ProjectsAppsAppAttestConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsAppAttestConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsAppAttestConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsAppAttestConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsAppAttestConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsAppAttestConfigGetCall) Context(ctx context.Context) *ProjectsAppsAppAttestConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsAppAttestConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsAppAttestConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.appAttestConfig.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.appAttestConfig.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppAttestConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsAppAttestConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppAttestConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppAttestConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.appAttestConfig.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsAppAttestConfigPatchCall struct {
	s                                           *Service
	name                                        string
	googlefirebaseappcheckv1betaappattestconfig *GoogleFirebaseAppcheckV1betaAppAttestConfig
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates the AppAttestConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to exchange
// AppAttest tokens for App Check tokens.
//
//   - name: The relative resource name of the App Attest configuration object,
//     in the format: ``` projects/{project_number}/apps/{app_id}/appAttestConfig
//     ```.
func (r *ProjectsAppsAppAttestConfigService) Patch(name string, googlefirebaseappcheckv1betaappattestconfig *GoogleFirebaseAppcheckV1betaAppAttestConfig) *ProjectsAppsAppAttestConfigPatchCall {
	c := &ProjectsAppsAppAttestConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betaappattestconfig = googlefirebaseappcheckv1betaappattestconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the AppAttestConfig to update.
// Example: `token_ttl`.
func (c *ProjectsAppsAppAttestConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsAppAttestConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsAppAttestConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsAppAttestConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsAppAttestConfigPatchCall) Context(ctx context.Context) *ProjectsAppsAppAttestConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsAppAttestConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsAppAttestConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaappattestconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.appAttestConfig.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.appAttestConfig.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaAppAttestConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsAppAttestConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppAttestConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaAppAttestConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.appAttestConfig.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDebugTokensCreateCall struct {
	s                                      *Service
	parent                                 string
	googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a new DebugToken for the specified app. For security
// reasons, after the creation operation completes, the `token` field cannot be
// updated or retrieved, but you can revoke the debug token using
// DeleteDebugToken. Each app can have a maximum of 20 debug tokens.
//
//   - parent: The relative resource name of the parent app in which the
//     specified DebugToken will be created, in the format: ```
//     projects/{project_number}/apps/{app_id} ```.
func (r *ProjectsAppsDebugTokensService) Create(parent string, googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken) *ProjectsAppsDebugTokensCreateCall {
	c := &ProjectsAppsDebugTokensCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappcheckv1betadebugtoken = googlefirebaseappcheckv1betadebugtoken
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDebugTokensCreateCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDebugTokensCreateCall) Context(ctx context.Context) *ProjectsAppsDebugTokensCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDebugTokensCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betadebugtoken)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/debugTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaDebugToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensCreateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDebugToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaDebugToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDebugTokensDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified DebugToken. A deleted debug token cannot be
// used to exchange for an App Check token. Use this method when you suspect
// the secret `token` has been compromised or when you no longer need the debug
// token.
//
//   - name: The relative resource name of the DebugToken to delete, in the
//     format: ```
//     projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```.
func (r *ProjectsAppsDebugTokensService) Delete(name string) *ProjectsAppsDebugTokensDeleteCall {
	c := &ProjectsAppsDebugTokensDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDebugTokensDeleteCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDebugTokensDeleteCall) Context(ctx context.Context) *ProjectsAppsDebugTokensDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDebugTokensDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsDebugTokensDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDebugTokensGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified DebugToken. For security reasons, the `token` field
// is never populated in the response.
//
//   - name: The relative resource name of the debug token, in the format: ```
//     projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```.
func (r *ProjectsAppsDebugTokensService) Get(name string) *ProjectsAppsDebugTokensGetCall {
	c := &ProjectsAppsDebugTokensGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDebugTokensGetCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsDebugTokensGetCall) IfNoneMatch(entityTag string) *ProjectsAppsDebugTokensGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDebugTokensGetCall) Context(ctx context.Context) *ProjectsAppsDebugTokensGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDebugTokensGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaDebugToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDebugToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaDebugToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDebugTokensListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all DebugTokens for the specified app. For security reasons, the
// `token` field is never populated in the response.
//
//   - parent: The relative resource name of the parent app for which to list
//     each associated DebugToken, in the format: ```
//     projects/{project_number}/apps/{app_id} ```.
func (r *ProjectsAppsDebugTokensService) List(parent string) *ProjectsAppsDebugTokensListCall {
	c := &ProjectsAppsDebugTokensListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// DebugTokens to return in the response. Note that an app can have at most 20
// debug tokens. The server may return fewer than this at its own discretion.
// If no value is specified (or too large a value is specified), the server
// will impose its own limit.
func (c *ProjectsAppsDebugTokensListCall) PageSize(pageSize int64) *ProjectsAppsDebugTokensListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to ListDebugTokens indicating where in the set of DebugTokens
// to resume listing. Provide this to retrieve the subsequent page. When
// paginating, all other parameters provided to ListDebugTokens must match the
// call that provided the page token; if they do not match, the result is
// undefined.
func (c *ProjectsAppsDebugTokensListCall) PageToken(pageToken string) *ProjectsAppsDebugTokensListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDebugTokensListCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsDebugTokensListCall) IfNoneMatch(entityTag string) *ProjectsAppsDebugTokensListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDebugTokensListCall) Context(ctx context.Context) *ProjectsAppsDebugTokensListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDebugTokensListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/debugTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaListDebugTokensResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaListDebugTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaListDebugTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAppsDebugTokensListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppcheckV1betaListDebugTokensResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAppsDebugTokensPatchCall struct {
	s                                      *Service
	name                                   string
	googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Updates the specified DebugToken. For security reasons, the `token`
// field cannot be updated, nor will it be populated in the response, but you
// can revoke the debug token using DeleteDebugToken.
//
//   - name: The relative resource name of the debug token, in the format: ```
//     projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```.
func (r *ProjectsAppsDebugTokensService) Patch(name string, googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken) *ProjectsAppsDebugTokensPatchCall {
	c := &ProjectsAppsDebugTokensPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betadebugtoken = googlefirebaseappcheckv1betadebugtoken
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the DebugToken to update.
// Example: `display_name`.
func (c *ProjectsAppsDebugTokensPatchCall) UpdateMask(updateMask string) *ProjectsAppsDebugTokensPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDebugTokensPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDebugTokensPatchCall) Context(ctx context.Context) *ProjectsAppsDebugTokensPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDebugTokensPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betadebugtoken)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaDebugToken.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDebugToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaDebugToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.debugTokens.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDeviceCheckConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the DeviceCheckConfigs for the specified list of
// apps. For security reasons, the `private_key` field is never populated in
// the response.
//
//   - parent: The parent project name shared by all DeviceCheckConfigs being
//     retrieved, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being retrieved must match
//     this field, or the entire batch fails.
func (r *ProjectsAppsDeviceCheckConfigService) BatchGet(parent string) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c := &ProjectsAppsDeviceCheckConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the DeviceCheckConfigs to retrieve, in the format ```
// projects/{project_number}/apps/{app_id}/deviceCheckConfig ``` A maximum of
// 100 objects can be retrieved in a batch.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Names(names ...string) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/deviceCheckConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.deviceCheckConfig.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.deviceCheckConfig.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.deviceCheckConfig.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDeviceCheckConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the DeviceCheckConfig for the specified app. For security reasons,
// the `private_key` field is never populated in the response.
//
//   - name: The relative resource name of the DeviceCheckConfig, in the format:
//     ``` projects/{project_number}/apps/{app_id}/deviceCheckConfig ```.
func (r *ProjectsAppsDeviceCheckConfigService) Get(name string) *ProjectsAppsDeviceCheckConfigGetCall {
	c := &ProjectsAppsDeviceCheckConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsDeviceCheckConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsDeviceCheckConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsDeviceCheckConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Context(ctx context.Context) *ProjectsAppsDeviceCheckConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDeviceCheckConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.deviceCheckConfig.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.deviceCheckConfig.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaDeviceCheckConfig.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDeviceCheckConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaDeviceCheckConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.deviceCheckConfig.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsDeviceCheckConfigPatchCall struct {
	s                                             *Service
	name                                          string
	googlefirebaseappcheckv1betadevicecheckconfig *GoogleFirebaseAppcheckV1betaDeviceCheckConfig
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates the DeviceCheckConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to exchange
// DeviceCheck tokens for App Check tokens. For security reasons, the
// `private_key` field is never populated in the response.
//
//   - name: The relative resource name of the DeviceCheck configuration object,
//     in the format: ```
//     projects/{project_number}/apps/{app_id}/deviceCheckConfig ```.
func (r *ProjectsAppsDeviceCheckConfigService) Patch(name string, googlefirebaseappcheckv1betadevicecheckconfig *GoogleFirebaseAppcheckV1betaDeviceCheckConfig) *ProjectsAppsDeviceCheckConfigPatchCall {
	c := &ProjectsAppsDeviceCheckConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betadevicecheckconfig = googlefirebaseappcheckv1betadevicecheckconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the DeviceCheckConfig to update.
// Example: `key_id,private_key`.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsDeviceCheckConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsDeviceCheckConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Context(ctx context.Context) *ProjectsAppsDeviceCheckConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDeviceCheckConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betadevicecheckconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.deviceCheckConfig.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.deviceCheckConfig.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaDeviceCheckConfig.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDeviceCheckConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaDeviceCheckConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.deviceCheckConfig.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsPlayIntegrityConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the PlayIntegrityConfigs for the specified list of
// apps.
//
//   - parent: The parent project name shared by all PlayIntegrityConfigs being
//     retrieved, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being retrieved must match
//     this field, or the entire batch fails.
func (r *ProjectsAppsPlayIntegrityConfigService) BatchGet(parent string) *ProjectsAppsPlayIntegrityConfigBatchGetCall {
	c := &ProjectsAppsPlayIntegrityConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the PlayIntegrityConfigs to retrieve, in the format ```
// projects/{project_number}/apps/{app_id}/playIntegrityConfig ``` A maximum of
// 100 objects can be retrieved in a batch.
func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) Names(names ...string) *ProjectsAppsPlayIntegrityConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsPlayIntegrityConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsPlayIntegrityConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsPlayIntegrityConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/playIntegrityConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.playIntegrityConfig.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.playIntegrityConfig.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsPlayIntegrityConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetPlayIntegrityConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.playIntegrityConfig.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsPlayIntegrityConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the PlayIntegrityConfig for the specified app.
//
//   - name: The relative resource name of the PlayIntegrityConfig, in the
//     format: ``` projects/{project_number}/apps/{app_id}/playIntegrityConfig
//     ```.
func (r *ProjectsAppsPlayIntegrityConfigService) Get(name string) *ProjectsAppsPlayIntegrityConfigGetCall {
	c := &ProjectsAppsPlayIntegrityConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsPlayIntegrityConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsPlayIntegrityConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsPlayIntegrityConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsPlayIntegrityConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsPlayIntegrityConfigGetCall) Context(ctx context.Context) *ProjectsAppsPlayIntegrityConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsPlayIntegrityConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsPlayIntegrityConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.playIntegrityConfig.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.playIntegrityConfig.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaPlayIntegrityConfig.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsPlayIntegrityConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaPlayIntegrityConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaPlayIntegrityConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.playIntegrityConfig.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsPlayIntegrityConfigPatchCall struct {
	s                                               *Service
	name                                            string
	googlefirebaseappcheckv1betaplayintegrityconfig *GoogleFirebaseAppcheckV1betaPlayIntegrityConfig
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Patch: Updates the PlayIntegrityConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to exchange
// Play Integrity tokens for App Check tokens.
//
//   - name: The relative resource name of the Play Integrity configuration
//     object, in the format: ```
//     projects/{project_number}/apps/{app_id}/playIntegrityConfig ```.
func (r *ProjectsAppsPlayIntegrityConfigService) Patch(name string, googlefirebaseappcheckv1betaplayintegrityconfig *GoogleFirebaseAppcheckV1betaPlayIntegrityConfig) *ProjectsAppsPlayIntegrityConfigPatchCall {
	c := &ProjectsAppsPlayIntegrityConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betaplayintegrityconfig = googlefirebaseappcheckv1betaplayintegrityconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the PlayIntegrityConfig to
// update. Example: `token_ttl`.
func (c *ProjectsAppsPlayIntegrityConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsPlayIntegrityConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsPlayIntegrityConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsPlayIntegrityConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsPlayIntegrityConfigPatchCall) Context(ctx context.Context) *ProjectsAppsPlayIntegrityConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsPlayIntegrityConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsPlayIntegrityConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaplayintegrityconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.playIntegrityConfig.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.playIntegrityConfig.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaPlayIntegrityConfig.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsPlayIntegrityConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaPlayIntegrityConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaPlayIntegrityConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.playIntegrityConfig.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the RecaptchaConfigs for the specified list of
// apps. For security reasons, the `site_secret` field is never populated in
// the response.
//
//   - parent: The parent project name shared by all RecaptchaConfigs being
//     retrieved, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being retrieved must match
//     this field, or the entire batch fails.
func (r *ProjectsAppsRecaptchaConfigService) BatchGet(parent string) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c := &ProjectsAppsRecaptchaConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the RecaptchaConfigs to retrieve, in the format: ```
// projects/{project_number}/apps/{app_id}/recaptchaConfig ``` A maximum of 100
// objects can be retrieved in a batch.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Names(names ...string) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/recaptchaConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaConfig.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaConfig.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaConfig.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the RecaptchaConfig for the specified app. For security reasons,
// the `site_secret` field is never populated in the response.
//
//   - name: The relative resource name of the RecaptchaConfig, in the format:
//     ``` projects/{project_number}/apps/{app_id}/recaptchaConfig ```.
func (r *ProjectsAppsRecaptchaConfigService) Get(name string) *ProjectsAppsRecaptchaConfigGetCall {
	c := &ProjectsAppsRecaptchaConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsRecaptchaConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaConfigGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaConfig.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaConfig.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaConfig.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaConfigPatchCall struct {
	s                                           *Service
	name                                        string
	googlefirebaseappcheckv1betarecaptchaconfig *GoogleFirebaseAppcheckV1betaRecaptchaConfig
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates the RecaptchaConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to exchange
// reCAPTCHA tokens for App Check tokens. For security reasons, the
// `site_secret` field is never populated in the response.
//
//   - name: The relative resource name of the reCAPTCHA v3 configuration object,
//     in the format: ``` projects/{project_number}/apps/{app_id}/recaptchaConfig
//     ```.
func (r *ProjectsAppsRecaptchaConfigService) Patch(name string, googlefirebaseappcheckv1betarecaptchaconfig *GoogleFirebaseAppcheckV1betaRecaptchaConfig) *ProjectsAppsRecaptchaConfigPatchCall {
	c := &ProjectsAppsRecaptchaConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betarecaptchaconfig = googlefirebaseappcheckv1betarecaptchaconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the RecaptchaConfig to update.
// Example: `site_secret`.
func (c *ProjectsAppsRecaptchaConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsRecaptchaConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Context(ctx context.Context) *ProjectsAppsRecaptchaConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betarecaptchaconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaConfig.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaConfig.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaConfig.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the RecaptchaEnterpriseConfigs for the specified
// list of apps.
//
//   - parent: The parent project name shared by all RecaptchaEnterpriseConfigs
//     being retrieved, in the format ``` projects/{project_number} ``` The
//     parent collection in the `name` field of any resource being retrieved must
//     match this field, or the entire batch fails.
func (r *ProjectsAppsRecaptchaEnterpriseConfigService) BatchGet(parent string) *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall {
	c := &ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the RecaptchaEnterpriseConfigs to retrieve, in the format: ```
// projects/{project_number}/apps/{app_id}/recaptchaEnterpriseConfig ``` A
// maximum of 100 objects can be retrieved in a batch.
func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) Names(names ...string) *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/recaptchaEnterpriseConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse.Serve
// rResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaEnterpriseConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetRecaptchaEnterpriseConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaEnterpriseConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the RecaptchaEnterpriseConfig for the specified app.
//
//   - name: The relative resource name of the RecaptchaEnterpriseConfig, in the
//     format: ```
//     projects/{project_number}/apps/{app_id}/recaptchaEnterpriseConfig ```.
func (r *ProjectsAppsRecaptchaEnterpriseConfigService) Get(name string) *ProjectsAppsRecaptchaEnterpriseConfigGetCall {
	c := &ProjectsAppsRecaptchaEnterpriseConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaEnterpriseConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaEnterpriseConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsRecaptchaEnterpriseConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaEnterpriseConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaEnterpriseConfigGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaEnterpriseConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaEnterpriseConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaEnterpriseConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaEnterpriseConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaEnterpriseConfigPatchCall struct {
	s                                                     *Service
	name                                                  string
	googlefirebaseappcheckv1betarecaptchaenterpriseconfig *GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Patch: Updates the RecaptchaEnterpriseConfig for the specified app. While
// this configuration is incomplete or invalid, the app will be unable to
// exchange reCAPTCHA Enterprise tokens for App Check tokens.
//
//   - name: The relative resource name of the reCAPTCHA Enterprise configuration
//     object, in the format: ```
//     projects/{project_number}/apps/{app_id}/recaptchaEnterpriseConfig ```.
func (r *ProjectsAppsRecaptchaEnterpriseConfigService) Patch(name string, googlefirebaseappcheckv1betarecaptchaenterpriseconfig *GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig) *ProjectsAppsRecaptchaEnterpriseConfigPatchCall {
	c := &ProjectsAppsRecaptchaEnterpriseConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betarecaptchaenterpriseconfig = googlefirebaseappcheckv1betarecaptchaenterpriseconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the RecaptchaEnterpriseConfig to
// update. Example: `site_key`.
func (c *ProjectsAppsRecaptchaEnterpriseConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsRecaptchaEnterpriseConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaEnterpriseConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaEnterpriseConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaEnterpriseConfigPatchCall) Context(ctx context.Context) *ProjectsAppsRecaptchaEnterpriseConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaEnterpriseConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaEnterpriseConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betarecaptchaenterpriseconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaEnterpriseConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaEnterpriseConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaEnterpriseConfig.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaV3ConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the RecaptchaV3Configs for the specified list of
// apps. For security reasons, the `site_secret` field is never populated in
// the response.
//
//   - parent: The parent project name shared by all RecaptchaV3Configs being
//     retrieved, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being retrieved must match
//     this field, or the entire batch fails.
func (r *ProjectsAppsRecaptchaV3ConfigService) BatchGet(parent string) *ProjectsAppsRecaptchaV3ConfigBatchGetCall {
	c := &ProjectsAppsRecaptchaV3ConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the RecaptchaV3Configs to retrieve, in the format: ```
// projects/{project_number}/apps/{app_id}/recaptchaV3Config ``` A maximum of
// 100 objects can be retrieved in a batch.
func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) Names(names ...string) *ProjectsAppsRecaptchaV3ConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaV3ConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaV3ConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaV3ConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/recaptchaV3Config:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaV3Config.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaV3Config.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaV3ConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetRecaptchaV3ConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaV3Config.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaV3ConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the RecaptchaV3Config for the specified app. For security reasons,
// the `site_secret` field is never populated in the response.
//
//   - name: The relative resource name of the RecaptchaV3Config, in the format:
//     ``` projects/{project_number}/apps/{app_id}/recaptchaV3Config ```.
func (r *ProjectsAppsRecaptchaV3ConfigService) Get(name string) *ProjectsAppsRecaptchaV3ConfigGetCall {
	c := &ProjectsAppsRecaptchaV3ConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaV3ConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaV3ConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsRecaptchaV3ConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaV3ConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaV3ConfigGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaV3ConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaV3ConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaV3ConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaV3Config.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaV3Config.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaV3Config.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaV3ConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaV3Config, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaV3Config{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaV3Config.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsRecaptchaV3ConfigPatchCall struct {
	s                                             *Service
	name                                          string
	googlefirebaseappcheckv1betarecaptchav3config *GoogleFirebaseAppcheckV1betaRecaptchaV3Config
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates the RecaptchaV3Config for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to exchange
// reCAPTCHA V3 tokens for App Check tokens. For security reasons, the
// `site_secret` field is never populated in the response.
//
//   - name: The relative resource name of the reCAPTCHA v3 configuration object,
//     in the format: ```
//     projects/{project_number}/apps/{app_id}/recaptchaV3Config ```.
func (r *ProjectsAppsRecaptchaV3ConfigService) Patch(name string, googlefirebaseappcheckv1betarecaptchav3config *GoogleFirebaseAppcheckV1betaRecaptchaV3Config) *ProjectsAppsRecaptchaV3ConfigPatchCall {
	c := &ProjectsAppsRecaptchaV3ConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betarecaptchav3config = googlefirebaseappcheckv1betarecaptchav3config
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the RecaptchaV3Config to update.
// Example: `site_secret`.
func (c *ProjectsAppsRecaptchaV3ConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsRecaptchaV3ConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsRecaptchaV3ConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaV3ConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsRecaptchaV3ConfigPatchCall) Context(ctx context.Context) *ProjectsAppsRecaptchaV3ConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsRecaptchaV3ConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaV3ConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betarecaptchav3config)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaV3Config.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaV3Config.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaV3Config.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsRecaptchaV3ConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaV3Config, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaV3Config{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.recaptchaV3Config.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsSafetyNetConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Atomically gets the SafetyNetConfigs for the specified list of
// apps.
//
//   - parent: The parent project name shared by all SafetyNetConfigs being
//     retrieved, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being retrieved must match
//     this field, or the entire batch fails.
func (r *ProjectsAppsSafetyNetConfigService) BatchGet(parent string) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c := &ProjectsAppsSafetyNetConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative resource
// names of the SafetyNetConfigs to retrieve, in the format ```
// projects/{project_number}/apps/{app_id}/safetyNetConfig ``` A maximum of 100
// objects can be retrieved in a batch.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Names(names ...string) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsSafetyNetConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/safetyNetConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.safetyNetConfig.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.safetyNetConfig.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.safetyNetConfig.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsSafetyNetConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the SafetyNetConfig for the specified app.
//
//   - name: The relative resource name of the SafetyNetConfig, in the format:
//     ``` projects/{project_number}/apps/{app_id}/safetyNetConfig ```.
func (r *ProjectsAppsSafetyNetConfigService) Get(name string) *ProjectsAppsSafetyNetConfigGetCall {
	c := &ProjectsAppsSafetyNetConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsSafetyNetConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsSafetyNetConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsSafetyNetConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsSafetyNetConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsSafetyNetConfigGetCall) Context(ctx context.Context) *ProjectsAppsSafetyNetConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsSafetyNetConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsSafetyNetConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.safetyNetConfig.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.safetyNetConfig.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaSafetyNetConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsSafetyNetConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaSafetyNetConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaSafetyNetConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.safetyNetConfig.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsSafetyNetConfigPatchCall struct {
	s                                           *Service
	name                                        string
	googlefirebaseappcheckv1betasafetynetconfig *GoogleFirebaseAppcheckV1betaSafetyNetConfig
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates the SafetyNetConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to exchange
// SafetyNet tokens for App Check tokens.
//
//   - name: The relative resource name of the SafetyNet configuration object, in
//     the format: ``` projects/{project_number}/apps/{app_id}/safetyNetConfig
//     ```.
func (r *ProjectsAppsSafetyNetConfigService) Patch(name string, googlefirebaseappcheckv1betasafetynetconfig *GoogleFirebaseAppcheckV1betaSafetyNetConfig) *ProjectsAppsSafetyNetConfigPatchCall {
	c := &ProjectsAppsSafetyNetConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betasafetynetconfig = googlefirebaseappcheckv1betasafetynetconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the SafetyNetConfig to update.
// Example: `token_ttl`.
func (c *ProjectsAppsSafetyNetConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsSafetyNetConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsSafetyNetConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Context(ctx context.Context) *ProjectsAppsSafetyNetConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsSafetyNetConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betasafetynetconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.safetyNetConfig.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.safetyNetConfig.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaSafetyNetConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaSafetyNetConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaSafetyNetConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.apps.safetyNetConfig.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesBatchUpdateCall struct {
	s                                                      *Service
	parent                                                 string
	googlefirebaseappcheckv1betabatchupdateservicesrequest *GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchUpdate: Atomically updates the specified Service configurations.
//
//   - parent: The parent project name shared by all Service configurations being
//     updated, in the format ``` projects/{project_number} ``` The parent
//     collection in the `name` field of any resource being updated must match
//     this field, or the entire batch fails.
func (r *ProjectsServicesService) BatchUpdate(parent string, googlefirebaseappcheckv1betabatchupdateservicesrequest *GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest) *ProjectsServicesBatchUpdateCall {
	c := &ProjectsServicesBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappcheckv1betabatchupdateservicesrequest = googlefirebaseappcheckv1betabatchupdateservicesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesBatchUpdateCall) Fields(s ...googleapi.Field) *ProjectsServicesBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesBatchUpdateCall) Context(ctx context.Context) *ProjectsServicesBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betabatchupdateservicesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/services:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.batchUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.batchUpdate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the Service configuration for the specified service name.
//
//   - name: The relative resource name of the Service to retrieve, in the
//     format: ``` projects/{project_number}/services/{service_id} ``` Note that
//     the `service_id` element must be a supported service ID. Currently, the
//     following service IDs are supported: * `firebasestorage.googleapis.com`
//     (Cloud Storage for Firebase) * `firebasedatabase.googleapis.com` (Firebase
//     Realtime Database) * `firestore.googleapis.com` (Cloud Firestore) *
//     `identitytoolkit.googleapis.com` (Firebase Authentication with Identity
//     Platform) * `oauth2.googleapis.com` (Google Identity for iOS).
func (r *ProjectsServicesService) Get(name string) *ProjectsServicesGetCall {
	c := &ProjectsServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesGetCall) Fields(s ...googleapi.Field) *ProjectsServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsServicesGetCall) IfNoneMatch(entityTag string) *ProjectsServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesGetCall) Context(ctx context.Context) *ProjectsServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaService.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaService, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaService{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Service configurations for the specified project. Only
// Services which were explicitly configured using UpdateService or
// BatchUpdateServices will be returned.
//
//   - parent: The relative resource name of the parent project for which to list
//     each associated Service, in the format: ``` projects/{project_number} ```.
func (r *ProjectsServicesService) List(parent string) *ProjectsServicesListCall {
	c := &ProjectsServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// Services to return in the response. Only explicitly configured services are
// returned. The server may return fewer than this at its own discretion. If no
// value is specified (or too large a value is specified), the server will
// impose its own limit.
func (c *ProjectsServicesListCall) PageSize(pageSize int64) *ProjectsServicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to ListServices indicating where in the set of Services to
// resume listing. Provide this to retrieve the subsequent page. When
// paginating, all other parameters provided to ListServices must match the
// call that provided the page token; if they do not match, the result is
// undefined.
func (c *ProjectsServicesListCall) PageToken(pageToken string) *ProjectsServicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesListCall) Fields(s ...googleapi.Field) *ProjectsServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsServicesListCall) IfNoneMatch(entityTag string) *ProjectsServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesListCall) Context(ctx context.Context) *ProjectsServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaListServicesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaListServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaListServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsServicesListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppcheckV1betaListServicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsServicesPatchCall struct {
	s                                   *Service
	name                                string
	googlefirebaseappcheckv1betaservice *GoogleFirebaseAppcheckV1betaService
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates the specified Service configuration.
//
//   - name: The relative resource name of the service configuration object, in
//     the format: ``` projects/{project_number}/services/{service_id} ``` Note
//     that the `service_id` element must be a supported service ID. Currently,
//     the following service IDs are supported: *
//     `firebasestorage.googleapis.com` (Cloud Storage for Firebase) *
//     `firebasedatabase.googleapis.com` (Firebase Realtime Database) *
//     `firestore.googleapis.com` (Cloud Firestore) *
//     `identitytoolkit.googleapis.com` (Firebase Authentication with Identity
//     Platform) * `oauth2.googleapis.com` (Google Identity for iOS).
func (r *ProjectsServicesService) Patch(name string, googlefirebaseappcheckv1betaservice *GoogleFirebaseAppcheckV1betaService) *ProjectsServicesPatchCall {
	c := &ProjectsServicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betaservice = googlefirebaseappcheckv1betaservice
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the Service to update. Example:
// `enforcement_mode`.
func (c *ProjectsServicesPatchCall) UpdateMask(updateMask string) *ProjectsServicesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesPatchCall) Fields(s ...googleapi.Field) *ProjectsServicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesPatchCall) Context(ctx context.Context) *ProjectsServicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaservice)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaService.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaService, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaService{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesResourcePoliciesBatchUpdateCall struct {
	s                                                              *Service
	parent                                                         string
	googlefirebaseappcheckv1betabatchupdateresourcepoliciesrequest *GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// BatchUpdate: Atomically updates the specified ResourcePolicy configurations.
//
//   - parent: The parent service name, in the format ```
//     projects/{project_number}/services/{service_id} ``` The parent collection
//     in the `name` field of any resource being updated must match this field,
//     or the entire batch fails.
func (r *ProjectsServicesResourcePoliciesService) BatchUpdate(parent string, googlefirebaseappcheckv1betabatchupdateresourcepoliciesrequest *GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesRequest) *ProjectsServicesResourcePoliciesBatchUpdateCall {
	c := &ProjectsServicesResourcePoliciesBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappcheckv1betabatchupdateresourcepoliciesrequest = googlefirebaseappcheckv1betabatchupdateresourcepoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesResourcePoliciesBatchUpdateCall) Fields(s ...googleapi.Field) *ProjectsServicesResourcePoliciesBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesResourcePoliciesBatchUpdateCall) Context(ctx context.Context) *ProjectsServicesResourcePoliciesBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesResourcePoliciesBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesResourcePoliciesBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betabatchupdateresourcepoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/resourcePolicies:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.batchUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.resourcePolicies.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsServicesResourcePoliciesBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchUpdateResourcePoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.batchUpdate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesResourcePoliciesCreateCall struct {
	s                                          *Service
	parent                                     string
	googlefirebaseappcheckv1betaresourcepolicy *GoogleFirebaseAppcheckV1betaResourcePolicy
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates the specified ResourcePolicy configuration.
//
//   - parent: The relative resource name of the parent Service in which the
//     specified ResourcePolicy will be created, in the format: ```
//     projects/{project_number}/services/{service_id} ``` Note that the
//     `service_id` element must be a supported service ID. Currently, the
//     following service IDs are supported: * `oauth2.googleapis.com` (Google
//     Identity for iOS).
func (r *ProjectsServicesResourcePoliciesService) Create(parent string, googlefirebaseappcheckv1betaresourcepolicy *GoogleFirebaseAppcheckV1betaResourcePolicy) *ProjectsServicesResourcePoliciesCreateCall {
	c := &ProjectsServicesResourcePoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappcheckv1betaresourcepolicy = googlefirebaseappcheckv1betaresourcepolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesResourcePoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsServicesResourcePoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesResourcePoliciesCreateCall) Context(ctx context.Context) *ProjectsServicesResourcePoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesResourcePoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesResourcePoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaresourcepolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/resourcePolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.resourcePolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaResourcePolicy.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesResourcePoliciesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaResourcePolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaResourcePolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesResourcePoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified ResourcePolicy configuration.
//
//   - name: The relative resource name of the ResourcePolicy to delete, in the
//     format: ```
//     projects/{project_number}/services/{service_id}/resourcePolicies/{resource_
//     policy_id} ```.
func (r *ProjectsServicesResourcePoliciesService) Delete(name string) *ProjectsServicesResourcePoliciesDeleteCall {
	c := &ProjectsServicesResourcePoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The checksum to be validated
// against the current ResourcePolicy, to ensure the client has an up-to-date
// value before proceeding. This checksum is computed by the server based on
// the values of fields in the ResourcePolicy object, and can be obtained from
// the ResourcePolicy object received from the last CreateResourcePolicy,
// GetResourcePolicy, ListResourcePolicies, UpdateResourcePolicy, or
// BatchUpdateResourcePolicies call. This etag is strongly validated as defined
// by RFC 7232.
func (c *ProjectsServicesResourcePoliciesDeleteCall) Etag(etag string) *ProjectsServicesResourcePoliciesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesResourcePoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsServicesResourcePoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesResourcePoliciesDeleteCall) Context(ctx context.Context) *ProjectsServicesResourcePoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesResourcePoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesResourcePoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.resourcePolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsServicesResourcePoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesResourcePoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested ResourcePolicy configuration.
//
//   - name: The relative resource name of the ResourcePolicy to retrieve, in the
//     format: ```
//     projects/{project_number}/services/{service_id}/resourcePolicies/{resource_
//     policy_id} ``` Note that the `service_id` element must be a supported
//     service ID. Currently, the following service IDs are supported: *
//     `oauth2.googleapis.com` (Google Identity for iOS).
func (r *ProjectsServicesResourcePoliciesService) Get(name string) *ProjectsServicesResourcePoliciesGetCall {
	c := &ProjectsServicesResourcePoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesResourcePoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsServicesResourcePoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsServicesResourcePoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsServicesResourcePoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesResourcePoliciesGetCall) Context(ctx context.Context) *ProjectsServicesResourcePoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesResourcePoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesResourcePoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.resourcePolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaResourcePolicy.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesResourcePoliciesGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaResourcePolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaResourcePolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsServicesResourcePoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all ResourcePolicy configurations for the specified project and
// service.
//
//   - parent: The relative resource name of the parent Service for which to list
//     each associated ResourcePolicy, in the format: ```
//     projects/{project_number}/services/{service_id} ``` Note that the
//     `service_id` element must be a supported service ID. Currently, the
//     following service IDs are supported: * `oauth2.googleapis.com` (Google
//     Identity for iOS).
func (r *ProjectsServicesResourcePoliciesService) List(parent string) *ProjectsServicesResourcePoliciesListCall {
	c := &ProjectsServicesResourcePoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filters the results by the
// specified rule. For the exact syntax of this field, please consult the
// AIP-160 (https://google.aip.dev/160) standard. Currently, since the only
// fields in the ResourcePolicy resource are the scalar fields
// `enforcement_mode` and `target_resource`, this method does not support the
// traversal operator (`.`) or the has operator (`:`). Here are some examples
// of valid filters: * `enforcement_mode = ENFORCED` * `target_resource =
// "//oauth2.googleapis.com/projects/12345/oauthClients/" * `enforcement_mode
// = ENFORCED AND target_resource =
// "//oauth2.googleapis.com/projects/12345/oauthClients/"
func (c *ProjectsServicesResourcePoliciesListCall) Filter(filter string) *ProjectsServicesResourcePoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// ResourcePolicy objects to return in the response. The server may return
// fewer than this at its own discretion. If no value is specified (or too
// large a value is specified), the server will impose its own limit.
func (c *ProjectsServicesResourcePoliciesListCall) PageSize(pageSize int64) *ProjectsServicesResourcePoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to ListResourcePolicies indicating where in the set of
// ResourcePolicy objects to resume listing. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// ListResourcePolicies must match the call that provided the page token; if
// they do not match, the result is undefined.
func (c *ProjectsServicesResourcePoliciesListCall) PageToken(pageToken string) *ProjectsServicesResourcePoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesResourcePoliciesListCall) Fields(s ...googleapi.Field) *ProjectsServicesResourcePoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsServicesResourcePoliciesListCall) IfNoneMatch(entityTag string) *ProjectsServicesResourcePoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesResourcePoliciesListCall) Context(ctx context.Context) *ProjectsServicesResourcePoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesResourcePoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesResourcePoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/resourcePolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.resourcePolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsServicesResourcePoliciesListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsServicesResourcePoliciesListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppcheckV1betaListResourcePoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsServicesResourcePoliciesPatchCall struct {
	s                                          *Service
	name                                       string
	googlefirebaseappcheckv1betaresourcepolicy *GoogleFirebaseAppcheckV1betaResourcePolicy
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Patch: Updates the specified ResourcePolicy configuration.
//
//   - name: Identifier. The relative name of the resource policy object, in the
//     format: ```
//     projects/{project_number}/services/{service_id}/resourcePolicies/{resource_
//     policy_id} ``` Note that the `service_id` element must be a supported
//     service ID. Currently, the following service IDs are supported: *
//     `oauth2.googleapis.com` (Google Identity for iOS) `resource_policy_id` is
//     a system-generated UID.
func (r *ProjectsServicesResourcePoliciesService) Patch(name string, googlefirebaseappcheckv1betaresourcepolicy *GoogleFirebaseAppcheckV1betaResourcePolicy) *ProjectsServicesResourcePoliciesPatchCall {
	c := &ProjectsServicesResourcePoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betaresourcepolicy = googlefirebaseappcheckv1betaresourcepolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the ResourcePolicy to update.
// Example: `enforcement_mode`.
func (c *ProjectsServicesResourcePoliciesPatchCall) UpdateMask(updateMask string) *ProjectsServicesResourcePoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsServicesResourcePoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsServicesResourcePoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsServicesResourcePoliciesPatchCall) Context(ctx context.Context) *ProjectsServicesResourcePoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsServicesResourcePoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesResourcePoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappcheckv1betaresourcepolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.resourcePolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppcheckV1betaResourcePolicy.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsServicesResourcePoliciesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaResourcePolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppcheckV1betaResourcePolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappcheck.projects.services.resourcePolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
