// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// MagneticFlux represents a magnetic flux in Weber.
type MagneticFlux float64

const Weber MagneticFlux = 1

// Unit converts the MagneticFlux to a *Unit
func (m MagneticFlux) Unit() *Unit {
	return New(float64(m), Dimensions{
		CurrentDim: -1,
		LengthDim:  2,
		MassDim:    1,
		TimeDim:    -2,
	})
}

// MagneticFlux allows MagneticFlux to implement a MagneticFluxer interface
func (m MagneticFlux) MagneticFlux() MagneticFlux {
	return m
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (m *MagneticFlux) From(u Uniter) error {
	if !DimensionsMatch(u, Weber) {
		*m = MagneticFlux(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*m = MagneticFlux(u.Unit().Value())
	return nil
}

func (m MagneticFlux) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", m, float64(m))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " Wb"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(m))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(m))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(m))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(m))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g Wb)", c, m, float64(m))
	}
}
