// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListVulnerabilityImpactedHostsRequest wrapper for the ListVulnerabilityImpactedHosts operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListVulnerabilityImpactedHosts.go.html to see an example of how to use ListVulnerabilityImpactedHostsRequest.
type ListVulnerabilityImpactedHostsRequest struct {

	// unique vulnerability identifier
	VulnerabilityId *string `mandatory:"true" contributesTo:"path" name:"vulnerabilityId"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListVulnerabilityImpactedHostsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is Ascending. If no value is specified instanceId is default.
	SortBy ListVulnerabilityImpactedHostsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListVulnerabilityImpactedHostsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListVulnerabilityImpactedHostsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListVulnerabilityImpactedHostsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListVulnerabilityImpactedHostsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListVulnerabilityImpactedHostsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListVulnerabilityImpactedHostsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListVulnerabilityImpactedHostsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityImpactedHostsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListVulnerabilityImpactedHostsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListVulnerabilityImpactedHostsResponse wrapper for the ListVulnerabilityImpactedHosts operation
type ListVulnerabilityImpactedHostsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of VulnerabilityImpactedHostSummaryCollection instances
	VulnerabilityImpactedHostSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListVulnerabilityImpactedHostsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListVulnerabilityImpactedHostsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListVulnerabilityImpactedHostsSortOrderEnum Enum with underlying type: string
type ListVulnerabilityImpactedHostsSortOrderEnum string

// Set of constants representing the allowable values for ListVulnerabilityImpactedHostsSortOrderEnum
const (
	ListVulnerabilityImpactedHostsSortOrderAsc  ListVulnerabilityImpactedHostsSortOrderEnum = "ASC"
	ListVulnerabilityImpactedHostsSortOrderDesc ListVulnerabilityImpactedHostsSortOrderEnum = "DESC"
)

var mappingListVulnerabilityImpactedHostsSortOrderEnum = map[string]ListVulnerabilityImpactedHostsSortOrderEnum{
	"ASC":  ListVulnerabilityImpactedHostsSortOrderAsc,
	"DESC": ListVulnerabilityImpactedHostsSortOrderDesc,
}

var mappingListVulnerabilityImpactedHostsSortOrderEnumLowerCase = map[string]ListVulnerabilityImpactedHostsSortOrderEnum{
	"asc":  ListVulnerabilityImpactedHostsSortOrderAsc,
	"desc": ListVulnerabilityImpactedHostsSortOrderDesc,
}

// GetListVulnerabilityImpactedHostsSortOrderEnumValues Enumerates the set of values for ListVulnerabilityImpactedHostsSortOrderEnum
func GetListVulnerabilityImpactedHostsSortOrderEnumValues() []ListVulnerabilityImpactedHostsSortOrderEnum {
	values := make([]ListVulnerabilityImpactedHostsSortOrderEnum, 0)
	for _, v := range mappingListVulnerabilityImpactedHostsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityImpactedHostsSortOrderEnumStringValues Enumerates the set of values in String for ListVulnerabilityImpactedHostsSortOrderEnum
func GetListVulnerabilityImpactedHostsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListVulnerabilityImpactedHostsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityImpactedHostsSortOrderEnum(val string) (ListVulnerabilityImpactedHostsSortOrderEnum, bool) {
	enum, ok := mappingListVulnerabilityImpactedHostsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityImpactedHostsSortByEnum Enum with underlying type: string
type ListVulnerabilityImpactedHostsSortByEnum string

// Set of constants representing the allowable values for ListVulnerabilityImpactedHostsSortByEnum
const (
	ListVulnerabilityImpactedHostsSortByInstanceid ListVulnerabilityImpactedHostsSortByEnum = "instanceId"
)

var mappingListVulnerabilityImpactedHostsSortByEnum = map[string]ListVulnerabilityImpactedHostsSortByEnum{
	"instanceId": ListVulnerabilityImpactedHostsSortByInstanceid,
}

var mappingListVulnerabilityImpactedHostsSortByEnumLowerCase = map[string]ListVulnerabilityImpactedHostsSortByEnum{
	"instanceid": ListVulnerabilityImpactedHostsSortByInstanceid,
}

// GetListVulnerabilityImpactedHostsSortByEnumValues Enumerates the set of values for ListVulnerabilityImpactedHostsSortByEnum
func GetListVulnerabilityImpactedHostsSortByEnumValues() []ListVulnerabilityImpactedHostsSortByEnum {
	values := make([]ListVulnerabilityImpactedHostsSortByEnum, 0)
	for _, v := range mappingListVulnerabilityImpactedHostsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityImpactedHostsSortByEnumStringValues Enumerates the set of values in String for ListVulnerabilityImpactedHostsSortByEnum
func GetListVulnerabilityImpactedHostsSortByEnumStringValues() []string {
	return []string{
		"instanceId",
	}
}

// GetMappingListVulnerabilityImpactedHostsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityImpactedHostsSortByEnum(val string) (ListVulnerabilityImpactedHostsSortByEnum, bool) {
	enum, ok := mappingListVulnerabilityImpactedHostsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
