// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// ScanResultVulnerabilityStateEnum Enum with underlying type: string
type ScanResultVulnerabilityStateEnum string

// Set of constants representing the allowable values for ScanResultVulnerabilityStateEnum
const (
	ScanResultVulnerabilityStateOpen          ScanResultVulnerabilityStateEnum = "OPEN"
	ScanResultVulnerabilityStateFixed         ScanResultVulnerabilityStateEnum = "FIXED"
	ScanResultVulnerabilityStateNotApplicable ScanResultVulnerabilityStateEnum = "NOT_APPLICABLE"
)

var mappingScanResultVulnerabilityStateEnum = map[string]ScanResultVulnerabilityStateEnum{
	"OPEN":           ScanResultVulnerabilityStateOpen,
	"FIXED":          ScanResultVulnerabilityStateFixed,
	"NOT_APPLICABLE": ScanResultVulnerabilityStateNotApplicable,
}

var mappingScanResultVulnerabilityStateEnumLowerCase = map[string]ScanResultVulnerabilityStateEnum{
	"open":           ScanResultVulnerabilityStateOpen,
	"fixed":          ScanResultVulnerabilityStateFixed,
	"not_applicable": ScanResultVulnerabilityStateNotApplicable,
}

// GetScanResultVulnerabilityStateEnumValues Enumerates the set of values for ScanResultVulnerabilityStateEnum
func GetScanResultVulnerabilityStateEnumValues() []ScanResultVulnerabilityStateEnum {
	values := make([]ScanResultVulnerabilityStateEnum, 0)
	for _, v := range mappingScanResultVulnerabilityStateEnum {
		values = append(values, v)
	}
	return values
}

// GetScanResultVulnerabilityStateEnumStringValues Enumerates the set of values in String for ScanResultVulnerabilityStateEnum
func GetScanResultVulnerabilityStateEnumStringValues() []string {
	return []string{
		"OPEN",
		"FIXED",
		"NOT_APPLICABLE",
	}
}

// GetMappingScanResultVulnerabilityStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingScanResultVulnerabilityStateEnum(val string) (ScanResultVulnerabilityStateEnum, bool) {
	enum, ok := mappingScanResultVulnerabilityStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
