// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostEndpointProtectionScanResultsRequest wrapper for the ListHostEndpointProtectionScanResults operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostEndpointProtectionScanResults.go.html to see an example of how to use ListHostEndpointProtectionScanResultsRequest.
type ListHostEndpointProtectionScanResultsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The ID of a compute instance
	InstanceId *string `mandatory:"false" contributesTo:"query" name:"instanceId"`

	// Parameter to filter by highestProblemSeverity for scan results
	HighestProblemSeverity ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum `mandatory:"false" contributesTo:"query" name:"highestProblemSeverity" omitEmpty:"true"`

	// Date and time on or after which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedGreaterThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedGreaterThanOrEqualTo"`

	// Date and time on or before which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedLessThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedLessThanOrEqualTo"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostEndpointProtectionScanResultsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.
	SortBy ListHostEndpointProtectionScanResultsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A flag to return only the latest scan result of an instance.
	IsLatestOnly *bool `mandatory:"false" contributesTo:"query" name:"isLatestOnly"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostEndpointProtectionScanResultsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostEndpointProtectionScanResultsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostEndpointProtectionScanResultsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostEndpointProtectionScanResultsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostEndpointProtectionScanResultsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnum(string(request.HighestProblemSeverity)); !ok && request.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", request.HighestProblemSeverity, strings.Join(GetListHostEndpointProtectionScanResultsHighestProblemSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostEndpointProtectionScanResultsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostEndpointProtectionScanResultsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostEndpointProtectionScanResultsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostEndpointProtectionScanResultsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostEndpointProtectionScanResultsResponse wrapper for the ListHostEndpointProtectionScanResults operation
type ListHostEndpointProtectionScanResultsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostEndpointProtectionScanResultSummaryCollection instances
	HostEndpointProtectionScanResultSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostEndpointProtectionScanResultsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostEndpointProtectionScanResultsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum Enum with underlying type: string
type ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum string

// Set of constants representing the allowable values for ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum
const (
	ListHostEndpointProtectionScanResultsHighestProblemSeverityNone     ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum = "NONE"
	ListHostEndpointProtectionScanResultsHighestProblemSeverityLow      ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum = "LOW"
	ListHostEndpointProtectionScanResultsHighestProblemSeverityMedium   ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum = "MEDIUM"
	ListHostEndpointProtectionScanResultsHighestProblemSeverityHigh     ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum = "HIGH"
	ListHostEndpointProtectionScanResultsHighestProblemSeverityCritical ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum = "CRITICAL"
)

var mappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnum = map[string]ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum{
	"NONE":     ListHostEndpointProtectionScanResultsHighestProblemSeverityNone,
	"LOW":      ListHostEndpointProtectionScanResultsHighestProblemSeverityLow,
	"MEDIUM":   ListHostEndpointProtectionScanResultsHighestProblemSeverityMedium,
	"HIGH":     ListHostEndpointProtectionScanResultsHighestProblemSeverityHigh,
	"CRITICAL": ListHostEndpointProtectionScanResultsHighestProblemSeverityCritical,
}

var mappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnumLowerCase = map[string]ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum{
	"none":     ListHostEndpointProtectionScanResultsHighestProblemSeverityNone,
	"low":      ListHostEndpointProtectionScanResultsHighestProblemSeverityLow,
	"medium":   ListHostEndpointProtectionScanResultsHighestProblemSeverityMedium,
	"high":     ListHostEndpointProtectionScanResultsHighestProblemSeverityHigh,
	"critical": ListHostEndpointProtectionScanResultsHighestProblemSeverityCritical,
}

// GetListHostEndpointProtectionScanResultsHighestProblemSeverityEnumValues Enumerates the set of values for ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum
func GetListHostEndpointProtectionScanResultsHighestProblemSeverityEnumValues() []ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum {
	values := make([]ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum, 0)
	for _, v := range mappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostEndpointProtectionScanResultsHighestProblemSeverityEnumStringValues Enumerates the set of values in String for ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum
func GetListHostEndpointProtectionScanResultsHighestProblemSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnum(val string) (ListHostEndpointProtectionScanResultsHighestProblemSeverityEnum, bool) {
	enum, ok := mappingListHostEndpointProtectionScanResultsHighestProblemSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostEndpointProtectionScanResultsSortOrderEnum Enum with underlying type: string
type ListHostEndpointProtectionScanResultsSortOrderEnum string

// Set of constants representing the allowable values for ListHostEndpointProtectionScanResultsSortOrderEnum
const (
	ListHostEndpointProtectionScanResultsSortOrderAsc  ListHostEndpointProtectionScanResultsSortOrderEnum = "ASC"
	ListHostEndpointProtectionScanResultsSortOrderDesc ListHostEndpointProtectionScanResultsSortOrderEnum = "DESC"
)

var mappingListHostEndpointProtectionScanResultsSortOrderEnum = map[string]ListHostEndpointProtectionScanResultsSortOrderEnum{
	"ASC":  ListHostEndpointProtectionScanResultsSortOrderAsc,
	"DESC": ListHostEndpointProtectionScanResultsSortOrderDesc,
}

var mappingListHostEndpointProtectionScanResultsSortOrderEnumLowerCase = map[string]ListHostEndpointProtectionScanResultsSortOrderEnum{
	"asc":  ListHostEndpointProtectionScanResultsSortOrderAsc,
	"desc": ListHostEndpointProtectionScanResultsSortOrderDesc,
}

// GetListHostEndpointProtectionScanResultsSortOrderEnumValues Enumerates the set of values for ListHostEndpointProtectionScanResultsSortOrderEnum
func GetListHostEndpointProtectionScanResultsSortOrderEnumValues() []ListHostEndpointProtectionScanResultsSortOrderEnum {
	values := make([]ListHostEndpointProtectionScanResultsSortOrderEnum, 0)
	for _, v := range mappingListHostEndpointProtectionScanResultsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostEndpointProtectionScanResultsSortOrderEnumStringValues Enumerates the set of values in String for ListHostEndpointProtectionScanResultsSortOrderEnum
func GetListHostEndpointProtectionScanResultsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostEndpointProtectionScanResultsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostEndpointProtectionScanResultsSortOrderEnum(val string) (ListHostEndpointProtectionScanResultsSortOrderEnum, bool) {
	enum, ok := mappingListHostEndpointProtectionScanResultsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostEndpointProtectionScanResultsSortByEnum Enum with underlying type: string
type ListHostEndpointProtectionScanResultsSortByEnum string

// Set of constants representing the allowable values for ListHostEndpointProtectionScanResultsSortByEnum
const (
	ListHostEndpointProtectionScanResultsSortByTimestarted     ListHostEndpointProtectionScanResultsSortByEnum = "timeStarted"
	ListHostEndpointProtectionScanResultsSortByTimefinished    ListHostEndpointProtectionScanResultsSortByEnum = "timeFinished"
	ListHostEndpointProtectionScanResultsSortByProblemseverity ListHostEndpointProtectionScanResultsSortByEnum = "problemSeverity"
)

var mappingListHostEndpointProtectionScanResultsSortByEnum = map[string]ListHostEndpointProtectionScanResultsSortByEnum{
	"timeStarted":     ListHostEndpointProtectionScanResultsSortByTimestarted,
	"timeFinished":    ListHostEndpointProtectionScanResultsSortByTimefinished,
	"problemSeverity": ListHostEndpointProtectionScanResultsSortByProblemseverity,
}

var mappingListHostEndpointProtectionScanResultsSortByEnumLowerCase = map[string]ListHostEndpointProtectionScanResultsSortByEnum{
	"timestarted":     ListHostEndpointProtectionScanResultsSortByTimestarted,
	"timefinished":    ListHostEndpointProtectionScanResultsSortByTimefinished,
	"problemseverity": ListHostEndpointProtectionScanResultsSortByProblemseverity,
}

// GetListHostEndpointProtectionScanResultsSortByEnumValues Enumerates the set of values for ListHostEndpointProtectionScanResultsSortByEnum
func GetListHostEndpointProtectionScanResultsSortByEnumValues() []ListHostEndpointProtectionScanResultsSortByEnum {
	values := make([]ListHostEndpointProtectionScanResultsSortByEnum, 0)
	for _, v := range mappingListHostEndpointProtectionScanResultsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostEndpointProtectionScanResultsSortByEnumStringValues Enumerates the set of values in String for ListHostEndpointProtectionScanResultsSortByEnum
func GetListHostEndpointProtectionScanResultsSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"problemSeverity",
	}
}

// GetMappingListHostEndpointProtectionScanResultsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostEndpointProtectionScanResultsSortByEnum(val string) (ListHostEndpointProtectionScanResultsSortByEnum, bool) {
	enum, ok := mappingListHostEndpointProtectionScanResultsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
