// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Dblm API
//
// A description of the Dblm API
//

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityResourceSummary The assessed Resources.
type VulnerabilityResourceSummary struct {

	// The resource ID for this resource.
	Id *string `mandatory:"true" json:"id"`

	// The name of the resource.
	Name *string `mandatory:"true" json:"name"`

	// A string representing the version of the resource.
	Version *string `mandatory:"true" json:"version"`

	// A string representing the release of the resource.
	Release *string `mandatory:"true" json:"release"`

	// A string representing the platform of the resource.
	Platform *string `mandatory:"true" json:"platform"`

	// Time when the latest configuration collection happened.
	TimeConfigCollected *common.SDKTime `mandatory:"true" json:"timeConfigCollected"`

	// Time when the latest scan happened for the resource.
	TimeScanEnded *common.SDKTime `mandatory:"true" json:"timeScanEnded"`

	// Identifier for the resource is subscribed to.
	ImageId *string `mandatory:"true" json:"imageId"`

	// Image the resource is subscribed to.
	SubscribedImage *string `mandatory:"true" json:"subscribedImage"`

	// Metric errors.
	MetricErrors []MetricError `mandatory:"true" json:"metricErrors"`

	// PDBs for a CDB.
	ChildPdbs []ChildPdb `mandatory:"true" json:"childPdbs"`

	// Summary of the resources that are registered and may or may not have vulnerabilities.
	VulnerabilitiesSummary *interface{} `mandatory:"true" json:"vulnerabilitiesSummary"`

	// Summary of the patch recommendations for databases.
	PatchRecommendationsSummary *interface{} `mandatory:"true" json:"patchRecommendationsSummary"`

	// List of the patch recommendations for databases
	PatchRecommendationsDetails []PatchRecommendationsDetailsSummary `mandatory:"true" json:"patchRecommendationsDetails"`
}

func (m VulnerabilityResourceSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityResourceSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
