// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/read"
	"github.com/mrusme/journalist/ent/user"
)

// Read is the model entity for the Read schema.
type Read struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// ItemID holds the value of the "item_id" field.
	ItemID uuid.UUID `json:"item_id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the ReadQuery when eager-loading is set.
	Edges        ReadEdges `json:"edges"`
	selectValues sql.SelectValues
}

// ReadEdges holds the relations/edges for other nodes in the graph.
type ReadEdges struct {
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// Item holds the value of the item edge.
	Item *Item `json:"item,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e ReadEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// ItemOrErr returns the Item value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e ReadEdges) ItemOrErr() (*Item, error) {
	if e.Item != nil {
		return e.Item, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: item.Label}
	}
	return nil, &NotLoadedError{edge: "item"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Read) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case read.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case read.FieldID, read.FieldUserID, read.FieldItemID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Read fields.
func (r *Read) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case read.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				r.ID = *value
			}
		case read.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				r.UserID = *value
			}
		case read.FieldItemID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field item_id", values[i])
			} else if value != nil {
				r.ItemID = *value
			}
		case read.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				r.CreatedAt = value.Time
			}
		default:
			r.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Read.
// This includes values selected through modifiers, order, etc.
func (r *Read) Value(name string) (ent.Value, error) {
	return r.selectValues.Get(name)
}

// QueryUser queries the "user" edge of the Read entity.
func (r *Read) QueryUser() *UserQuery {
	return NewReadClient(r.config).QueryUser(r)
}

// QueryItem queries the "item" edge of the Read entity.
func (r *Read) QueryItem() *ItemQuery {
	return NewReadClient(r.config).QueryItem(r)
}

// Update returns a builder for updating this Read.
// Note that you need to call Read.Unwrap() before calling this method if this Read
// was returned from a transaction, and the transaction was committed or rolled back.
func (r *Read) Update() *ReadUpdateOne {
	return NewReadClient(r.config).UpdateOne(r)
}

// Unwrap unwraps the Read entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (r *Read) Unwrap() *Read {
	_tx, ok := r.config.driver.(*txDriver)
	if !ok {
		panic("ent: Read is not a transactional entity")
	}
	r.config.driver = _tx.drv
	return r
}

// String implements the fmt.Stringer.
func (r *Read) String() string {
	var builder strings.Builder
	builder.WriteString("Read(")
	builder.WriteString(fmt.Sprintf("id=%v, ", r.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", r.UserID))
	builder.WriteString(", ")
	builder.WriteString("item_id=")
	builder.WriteString(fmt.Sprintf("%v", r.ItemID))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(r.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Reads is a parsable slice of Read.
type Reads []*Read
