// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/feed"
)

// Feed is the model entity for the Feed schema.
type Feed struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// URL holds the value of the "url" field.
	URL string `json:"url,omitempty"`
	// Username holds the value of the "username" field.
	Username string `json:"-"`
	// Password holds the value of the "password" field.
	Password string `json:"-"`
	// FeedTitle holds the value of the "feed_title" field.
	FeedTitle string `json:"feed_title,omitempty"`
	// FeedDescription holds the value of the "feed_description" field.
	FeedDescription string `json:"feed_description,omitempty"`
	// FeedLink holds the value of the "feed_link" field.
	FeedLink string `json:"feed_link,omitempty"`
	// FeedFeedLink holds the value of the "feed_feed_link" field.
	FeedFeedLink string `json:"feed_feed_link,omitempty"`
	// FeedUpdated holds the value of the "feed_updated" field.
	FeedUpdated time.Time `json:"feed_updated,omitempty"`
	// FeedPublished holds the value of the "feed_published" field.
	FeedPublished time.Time `json:"feed_published,omitempty"`
	// FeedAuthorName holds the value of the "feed_author_name" field.
	FeedAuthorName string `json:"feed_author_name,omitempty"`
	// FeedAuthorEmail holds the value of the "feed_author_email" field.
	FeedAuthorEmail string `json:"feed_author_email,omitempty"`
	// FeedLanguage holds the value of the "feed_language" field.
	FeedLanguage string `json:"feed_language,omitempty"`
	// FeedImageTitle holds the value of the "feed_image_title" field.
	FeedImageTitle string `json:"feed_image_title,omitempty"`
	// FeedImageURL holds the value of the "feed_image_url" field.
	FeedImageURL string `json:"feed_image_url,omitempty"`
	// FeedCopyright holds the value of the "feed_copyright" field.
	FeedCopyright string `json:"feed_copyright,omitempty"`
	// FeedGenerator holds the value of the "feed_generator" field.
	FeedGenerator string `json:"feed_generator,omitempty"`
	// FeedCategories holds the value of the "feed_categories" field.
	FeedCategories string `json:"feed_categories,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// DeletedAt holds the value of the "deleted_at" field.
	DeletedAt *time.Time `json:"deleted_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the FeedQuery when eager-loading is set.
	Edges        FeedEdges `json:"edges"`
	selectValues sql.SelectValues
}

// FeedEdges holds the relations/edges for other nodes in the graph.
type FeedEdges struct {
	// Items holds the value of the items edge.
	Items []*Item `json:"items,omitempty"`
	// SubscribedUsers holds the value of the subscribed_users edge.
	SubscribedUsers []*User `json:"subscribed_users,omitempty"`
	// Subscriptions holds the value of the subscriptions edge.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [3]bool
}

// ItemsOrErr returns the Items value or an error if the edge
// was not loaded in eager-loading.
func (e FeedEdges) ItemsOrErr() ([]*Item, error) {
	if e.loadedTypes[0] {
		return e.Items, nil
	}
	return nil, &NotLoadedError{edge: "items"}
}

// SubscribedUsersOrErr returns the SubscribedUsers value or an error if the edge
// was not loaded in eager-loading.
func (e FeedEdges) SubscribedUsersOrErr() ([]*User, error) {
	if e.loadedTypes[1] {
		return e.SubscribedUsers, nil
	}
	return nil, &NotLoadedError{edge: "subscribed_users"}
}

// SubscriptionsOrErr returns the Subscriptions value or an error if the edge
// was not loaded in eager-loading.
func (e FeedEdges) SubscriptionsOrErr() ([]*Subscription, error) {
	if e.loadedTypes[2] {
		return e.Subscriptions, nil
	}
	return nil, &NotLoadedError{edge: "subscriptions"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Feed) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case feed.FieldURL, feed.FieldUsername, feed.FieldPassword, feed.FieldFeedTitle, feed.FieldFeedDescription, feed.FieldFeedLink, feed.FieldFeedFeedLink, feed.FieldFeedAuthorName, feed.FieldFeedAuthorEmail, feed.FieldFeedLanguage, feed.FieldFeedImageTitle, feed.FieldFeedImageURL, feed.FieldFeedCopyright, feed.FieldFeedGenerator, feed.FieldFeedCategories:
			values[i] = new(sql.NullString)
		case feed.FieldFeedUpdated, feed.FieldFeedPublished, feed.FieldCreatedAt, feed.FieldUpdatedAt, feed.FieldDeletedAt:
			values[i] = new(sql.NullTime)
		case feed.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Feed fields.
func (f *Feed) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case feed.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				f.ID = *value
			}
		case feed.FieldURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field url", values[i])
			} else if value.Valid {
				f.URL = value.String
			}
		case feed.FieldUsername:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field username", values[i])
			} else if value.Valid {
				f.Username = value.String
			}
		case feed.FieldPassword:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field password", values[i])
			} else if value.Valid {
				f.Password = value.String
			}
		case feed.FieldFeedTitle:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_title", values[i])
			} else if value.Valid {
				f.FeedTitle = value.String
			}
		case feed.FieldFeedDescription:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_description", values[i])
			} else if value.Valid {
				f.FeedDescription = value.String
			}
		case feed.FieldFeedLink:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_link", values[i])
			} else if value.Valid {
				f.FeedLink = value.String
			}
		case feed.FieldFeedFeedLink:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_feed_link", values[i])
			} else if value.Valid {
				f.FeedFeedLink = value.String
			}
		case feed.FieldFeedUpdated:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field feed_updated", values[i])
			} else if value.Valid {
				f.FeedUpdated = value.Time
			}
		case feed.FieldFeedPublished:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field feed_published", values[i])
			} else if value.Valid {
				f.FeedPublished = value.Time
			}
		case feed.FieldFeedAuthorName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_author_name", values[i])
			} else if value.Valid {
				f.FeedAuthorName = value.String
			}
		case feed.FieldFeedAuthorEmail:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_author_email", values[i])
			} else if value.Valid {
				f.FeedAuthorEmail = value.String
			}
		case feed.FieldFeedLanguage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_language", values[i])
			} else if value.Valid {
				f.FeedLanguage = value.String
			}
		case feed.FieldFeedImageTitle:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_image_title", values[i])
			} else if value.Valid {
				f.FeedImageTitle = value.String
			}
		case feed.FieldFeedImageURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_image_url", values[i])
			} else if value.Valid {
				f.FeedImageURL = value.String
			}
		case feed.FieldFeedCopyright:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_copyright", values[i])
			} else if value.Valid {
				f.FeedCopyright = value.String
			}
		case feed.FieldFeedGenerator:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_generator", values[i])
			} else if value.Valid {
				f.FeedGenerator = value.String
			}
		case feed.FieldFeedCategories:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field feed_categories", values[i])
			} else if value.Valid {
				f.FeedCategories = value.String
			}
		case feed.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				f.CreatedAt = value.Time
			}
		case feed.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				f.UpdatedAt = value.Time
			}
		case feed.FieldDeletedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field deleted_at", values[i])
			} else if value.Valid {
				f.DeletedAt = new(time.Time)
				*f.DeletedAt = value.Time
			}
		default:
			f.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Feed.
// This includes values selected through modifiers, order, etc.
func (f *Feed) Value(name string) (ent.Value, error) {
	return f.selectValues.Get(name)
}

// QueryItems queries the "items" edge of the Feed entity.
func (f *Feed) QueryItems() *ItemQuery {
	return NewFeedClient(f.config).QueryItems(f)
}

// QuerySubscribedUsers queries the "subscribed_users" edge of the Feed entity.
func (f *Feed) QuerySubscribedUsers() *UserQuery {
	return NewFeedClient(f.config).QuerySubscribedUsers(f)
}

// QuerySubscriptions queries the "subscriptions" edge of the Feed entity.
func (f *Feed) QuerySubscriptions() *SubscriptionQuery {
	return NewFeedClient(f.config).QuerySubscriptions(f)
}

// Update returns a builder for updating this Feed.
// Note that you need to call Feed.Unwrap() before calling this method if this Feed
// was returned from a transaction, and the transaction was committed or rolled back.
func (f *Feed) Update() *FeedUpdateOne {
	return NewFeedClient(f.config).UpdateOne(f)
}

// Unwrap unwraps the Feed entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (f *Feed) Unwrap() *Feed {
	_tx, ok := f.config.driver.(*txDriver)
	if !ok {
		panic("ent: Feed is not a transactional entity")
	}
	f.config.driver = _tx.drv
	return f
}

// String implements the fmt.Stringer.
func (f *Feed) String() string {
	var builder strings.Builder
	builder.WriteString("Feed(")
	builder.WriteString(fmt.Sprintf("id=%v, ", f.ID))
	builder.WriteString("url=")
	builder.WriteString(f.URL)
	builder.WriteString(", ")
	builder.WriteString("username=<sensitive>")
	builder.WriteString(", ")
	builder.WriteString("password=<sensitive>")
	builder.WriteString(", ")
	builder.WriteString("feed_title=")
	builder.WriteString(f.FeedTitle)
	builder.WriteString(", ")
	builder.WriteString("feed_description=")
	builder.WriteString(f.FeedDescription)
	builder.WriteString(", ")
	builder.WriteString("feed_link=")
	builder.WriteString(f.FeedLink)
	builder.WriteString(", ")
	builder.WriteString("feed_feed_link=")
	builder.WriteString(f.FeedFeedLink)
	builder.WriteString(", ")
	builder.WriteString("feed_updated=")
	builder.WriteString(f.FeedUpdated.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("feed_published=")
	builder.WriteString(f.FeedPublished.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("feed_author_name=")
	builder.WriteString(f.FeedAuthorName)
	builder.WriteString(", ")
	builder.WriteString("feed_author_email=")
	builder.WriteString(f.FeedAuthorEmail)
	builder.WriteString(", ")
	builder.WriteString("feed_language=")
	builder.WriteString(f.FeedLanguage)
	builder.WriteString(", ")
	builder.WriteString("feed_image_title=")
	builder.WriteString(f.FeedImageTitle)
	builder.WriteString(", ")
	builder.WriteString("feed_image_url=")
	builder.WriteString(f.FeedImageURL)
	builder.WriteString(", ")
	builder.WriteString("feed_copyright=")
	builder.WriteString(f.FeedCopyright)
	builder.WriteString(", ")
	builder.WriteString("feed_generator=")
	builder.WriteString(f.FeedGenerator)
	builder.WriteString(", ")
	builder.WriteString("feed_categories=")
	builder.WriteString(f.FeedCategories)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(f.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(f.UpdatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	if v := f.DeletedAt; v != nil {
		builder.WriteString("deleted_at=")
		builder.WriteString(v.Format(time.ANSIC))
	}
	builder.WriteByte(')')
	return builder.String()
}

// Feeds is a parsable slice of Feed.
type Feeds []*Feed
