// Code generated by command: avogen -output zinstructions_test.go buildtest. DO NOT EDIT.

//go:build !integration

package build

import (
	"math"
	"testing"

	"github.com/mmcloughlin/avo/operand"
	"github.com/mmcloughlin/avo/reg"
)

var (
	op1     operand.Op = operand.Imm(1)
	op3     operand.Op = operand.Imm(3)
	opimm2u operand.Op = operand.Imm(3)
	opimm8  operand.Op = operand.Imm(math.MaxInt8)
	opimm16 operand.Op = operand.Imm(math.MaxInt16)
	opimm32 operand.Op = operand.Imm(math.MaxInt32)
	opimm64 operand.Op = operand.Imm(math.MaxInt64)
	opal    operand.Op = reg.AL
	opcl    operand.Op = reg.CL
	opax    operand.Op = reg.AX
	opeax   operand.Op = reg.EAX
	oprax   operand.Op = reg.RAX
	opr8    operand.Op = reg.CH
	opr16   operand.Op = reg.R9W
	opr32   operand.Op = reg.R10L
	opr64   operand.Op = reg.R11
	opxmm0  operand.Op = reg.X0
	opxmm   operand.Op = reg.X7
	opymm   operand.Op = reg.Y15
	opzmm   operand.Op = reg.Z31
	opk     operand.Op = reg.K7
	opm     operand.Op = operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}
	opm8    operand.Op = operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}
	opm16   operand.Op = operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}
	opm32   operand.Op = operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}
	opm64   operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opm128  operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opm256  operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opm512  operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opvm32x operand.Op = operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}
	opvm64x operand.Op = operand.Mem{Base: reg.R13, Index: reg.X8, Scale: 1}
	opvm32y operand.Op = operand.Mem{Base: reg.R13, Index: reg.Y4, Scale: 1}
	opvm64y operand.Op = operand.Mem{Base: reg.R13, Index: reg.Y8, Scale: 1}
	opvm32z operand.Op = operand.Mem{Base: reg.R13, Index: reg.Z4, Scale: 1}
	opvm64z operand.Op = operand.Mem{Base: reg.R13, Index: reg.Z8, Scale: 1}
	oprel8  operand.Op = operand.Rel(math.MaxInt8)
	oprel32 operand.Op = operand.LabelRef("lbl")
)

func TestContextInstructions(t *testing.T) {
	ctx := NewContext()
	ctx.Function("Instructions")
	ctx.ADCB(opimm8, opal)
	ctx.ADCL(opimm32, opeax)
	ctx.ADCQ(opimm32, opm64)
	ctx.ADCW(opimm16, opax)
	ctx.ADCXL(opm32, opr32)
	ctx.ADCXQ(opm64, opr64)
	ctx.ADDB(opimm8, opal)
	ctx.ADDL(opimm32, opeax)
	ctx.ADDPD(opm128, opxmm)
	ctx.ADDPS(opm128, opxmm)
	ctx.ADDQ(opimm32, opm64)
	ctx.ADDSD(opm64, opxmm)
	ctx.ADDSS(opm32, opxmm)
	ctx.ADDSUBPD(opm128, opxmm)
	ctx.ADDSUBPS(opm128, opxmm)
	ctx.ADDW(opimm16, opax)
	ctx.ADOXL(opm32, opr32)
	ctx.ADOXQ(opm64, opr64)
	ctx.AESDEC(opm128, opxmm)
	ctx.AESDECLAST(opm128, opxmm)
	ctx.AESENC(opm128, opxmm)
	ctx.AESENCLAST(opm128, opxmm)
	ctx.AESIMC(opm128, opxmm)
	ctx.AESKEYGENASSIST(opimm8, opm128, opxmm)
	ctx.ANDB(opimm8, opal)
	ctx.ANDL(opimm32, opeax)
	ctx.ANDNL(opm32, opr32, opr32)
	ctx.ANDNPD(opm128, opxmm)
	ctx.ANDNPS(opm128, opxmm)
	ctx.ANDNQ(opm64, opr64, opr64)
	ctx.ANDPD(opm128, opxmm)
	ctx.ANDPS(opm128, opxmm)
	ctx.ANDQ(opimm32, opm64)
	ctx.ANDW(opimm16, opax)
	ctx.BEXTRL(opr32, opm32, opr32)
	ctx.BEXTRQ(opr64, opm64, opr64)
	ctx.BLENDPD(opimm8, opm128, opxmm)
	ctx.BLENDPS(opimm8, opm128, opxmm)
	ctx.BLENDVPD(opxmm0, opm128, opxmm)
	ctx.BLENDVPS(opxmm0, opm128, opxmm)
	ctx.BLSIL(opm32, opr32)
	ctx.BLSIQ(opm64, opr64)
	ctx.BLSMSKL(opm32, opr32)
	ctx.BLSMSKQ(opm64, opr64)
	ctx.BLSRL(opm32, opr32)
	ctx.BLSRQ(opm64, opr64)
	ctx.BSFL(opm32, opr32)
	ctx.BSFQ(opm64, opr64)
	ctx.BSFW(opm16, opr16)
	ctx.BSRL(opm32, opr32)
	ctx.BSRQ(opm64, opr64)
	ctx.BSRW(opm16, opr16)
	ctx.BSWAPL(opr32)
	ctx.BSWAPQ(opr64)
	ctx.BTCL(opimm8, opm32)
	ctx.BTCQ(opimm8, opm64)
	ctx.BTCW(opimm8, opm16)
	ctx.BTL(opimm8, opm32)
	ctx.BTQ(opimm8, opm64)
	ctx.BTRL(opimm8, opm32)
	ctx.BTRQ(opimm8, opm64)
	ctx.BTRW(opimm8, opm16)
	ctx.BTSL(opimm8, opm32)
	ctx.BTSQ(opimm8, opm64)
	ctx.BTSW(opimm8, opm16)
	ctx.BTW(opimm8, opm16)
	ctx.BZHIL(opr32, opm32, opr32)
	ctx.BZHIQ(opr64, opm64, opr64)
	ctx.CALL(oprel32)
	ctx.CBW()
	ctx.CDQ()
	ctx.CDQE()
	ctx.CLC()
	ctx.CLD()
	ctx.CLFLUSH(opm8)
	ctx.CLFLUSHOPT(opm8)
	ctx.CMC()
	ctx.CMOVLCC(opm32, opr32)
	ctx.CMOVLCS(opm32, opr32)
	ctx.CMOVLEQ(opm32, opr32)
	ctx.CMOVLGE(opm32, opr32)
	ctx.CMOVLGT(opm32, opr32)
	ctx.CMOVLHI(opm32, opr32)
	ctx.CMOVLLE(opm32, opr32)
	ctx.CMOVLLS(opm32, opr32)
	ctx.CMOVLLT(opm32, opr32)
	ctx.CMOVLMI(opm32, opr32)
	ctx.CMOVLNE(opm32, opr32)
	ctx.CMOVLOC(opm32, opr32)
	ctx.CMOVLOS(opm32, opr32)
	ctx.CMOVLPC(opm32, opr32)
	ctx.CMOVLPL(opm32, opr32)
	ctx.CMOVLPS(opm32, opr32)
	ctx.CMOVQCC(opm64, opr64)
	ctx.CMOVQCS(opm64, opr64)
	ctx.CMOVQEQ(opm64, opr64)
	ctx.CMOVQGE(opm64, opr64)
	ctx.CMOVQGT(opm64, opr64)
	ctx.CMOVQHI(opm64, opr64)
	ctx.CMOVQLE(opm64, opr64)
	ctx.CMOVQLS(opm64, opr64)
	ctx.CMOVQLT(opm64, opr64)
	ctx.CMOVQMI(opm64, opr64)
	ctx.CMOVQNE(opm64, opr64)
	ctx.CMOVQOC(opm64, opr64)
	ctx.CMOVQOS(opm64, opr64)
	ctx.CMOVQPC(opm64, opr64)
	ctx.CMOVQPL(opm64, opr64)
	ctx.CMOVQPS(opm64, opr64)
	ctx.CMOVWCC(opm16, opr16)
	ctx.CMOVWCS(opm16, opr16)
	ctx.CMOVWEQ(opm16, opr16)
	ctx.CMOVWGE(opm16, opr16)
	ctx.CMOVWGT(opm16, opr16)
	ctx.CMOVWHI(opm16, opr16)
	ctx.CMOVWLE(opm16, opr16)
	ctx.CMOVWLS(opm16, opr16)
	ctx.CMOVWLT(opm16, opr16)
	ctx.CMOVWMI(opm16, opr16)
	ctx.CMOVWNE(opm16, opr16)
	ctx.CMOVWOC(opm16, opr16)
	ctx.CMOVWOS(opm16, opr16)
	ctx.CMOVWPC(opm16, opr16)
	ctx.CMOVWPL(opm16, opr16)
	ctx.CMOVWPS(opm16, opr16)
	ctx.CMPB(opal, opimm8)
	ctx.CMPL(opeax, opimm32)
	ctx.CMPPD(opm128, opxmm, opimm8)
	ctx.CMPPS(opm128, opxmm, opimm8)
	ctx.CMPQ(opm64, opimm32)
	ctx.CMPSD(opm64, opxmm, opimm8)
	ctx.CMPSS(opm32, opxmm, opimm8)
	ctx.CMPW(opax, opimm16)
	ctx.CMPXCHG16B(opm128)
	ctx.CMPXCHG8B(opm64)
	ctx.CMPXCHGB(opr8, opm8)
	ctx.CMPXCHGL(opr32, opm32)
	ctx.CMPXCHGQ(opr64, opm64)
	ctx.CMPXCHGW(opr16, opm16)
	ctx.COMISD(opm64, opxmm)
	ctx.COMISS(opm32, opxmm)
	ctx.CPUID()
	ctx.CQO()
	ctx.CRC32B(opm8, opr32)
	ctx.CRC32L(opm32, opr32)
	ctx.CRC32Q(opm64, opr64)
	ctx.CRC32W(opm16, opr32)
	ctx.CVTPD2PL(opm128, opxmm)
	ctx.CVTPD2PS(opm128, opxmm)
	ctx.CVTPL2PD(opm64, opxmm)
	ctx.CVTPL2PS(opm128, opxmm)
	ctx.CVTPS2PD(opm64, opxmm)
	ctx.CVTPS2PL(opm128, opxmm)
	ctx.CVTSD2SL(opm64, opr32)
	ctx.CVTSD2SS(opm64, opxmm)
	ctx.CVTSL2SD(opm32, opxmm)
	ctx.CVTSL2SS(opm32, opxmm)
	ctx.CVTSQ2SD(opm64, opxmm)
	ctx.CVTSQ2SS(opm64, opxmm)
	ctx.CVTSS2SD(opm32, opxmm)
	ctx.CVTSS2SL(opm32, opr32)
	ctx.CVTTPD2PL(opm128, opxmm)
	ctx.CVTTPS2PL(opm128, opxmm)
	ctx.CVTTSD2SL(opm64, opr32)
	ctx.CVTTSD2SQ(opm64, opr64)
	ctx.CVTTSS2SL(opm32, opr32)
	ctx.CWD()
	ctx.CWDE()
	ctx.DECB(opm8)
	ctx.DECL(opm32)
	ctx.DECQ(opm64)
	ctx.DECW(opm16)
	ctx.DIVB(opm8)
	ctx.DIVL(opm32)
	ctx.DIVPD(opm128, opxmm)
	ctx.DIVPS(opm128, opxmm)
	ctx.DIVQ(opm64)
	ctx.DIVSD(opm64, opxmm)
	ctx.DIVSS(opm32, opxmm)
	ctx.DIVW(opm16)
	ctx.DPPD(opimm8, opm128, opxmm)
	ctx.DPPS(opimm8, opm128, opxmm)
	ctx.EXTRACTPS(opimm2u, opxmm, opm32)
	ctx.HADDPD(opm128, opxmm)
	ctx.HADDPS(opm128, opxmm)
	ctx.HSUBPD(opm128, opxmm)
	ctx.HSUBPS(opm128, opxmm)
	ctx.IDIVB(opm8)
	ctx.IDIVL(opm32)
	ctx.IDIVQ(opm64)
	ctx.IDIVW(opm16)
	ctx.IMUL3L(opimm32, opm32, opr32)
	ctx.IMUL3Q(opimm32, opm64, opr64)
	ctx.IMUL3W(opimm16, opm16, opr16)
	ctx.IMULB(opm8)
	ctx.IMULL(opm32, opr32)
	ctx.IMULQ(opm64, opr64)
	ctx.IMULW(opm16, opr16)
	ctx.INCB(opm8)
	ctx.INCL(opm32)
	ctx.INCQ(opm64)
	ctx.INCW(opm16)
	ctx.INSERTPS(opimm8, opm32, opxmm)
	ctx.INT(op3)
	ctx.JA(oprel32)
	ctx.JAE(oprel32)
	ctx.JB(oprel32)
	ctx.JBE(oprel32)
	ctx.JC(oprel32)
	ctx.JCC(oprel32)
	ctx.JCS(oprel32)
	ctx.JCXZL(oprel8)
	ctx.JCXZQ(oprel8)
	ctx.JE(oprel32)
	ctx.JEQ(oprel32)
	ctx.JG(oprel32)
	ctx.JGE(oprel32)
	ctx.JGT(oprel32)
	ctx.JHI(oprel32)
	ctx.JHS(oprel32)
	ctx.JL(oprel32)
	ctx.JLE(oprel32)
	ctx.JLO(oprel32)
	ctx.JLS(oprel32)
	ctx.JLT(oprel32)
	ctx.JMI(oprel32)
	ctx.JMP(oprel32)
	ctx.JNA(oprel32)
	ctx.JNAE(oprel32)
	ctx.JNB(oprel32)
	ctx.JNBE(oprel32)
	ctx.JNC(oprel32)
	ctx.JNE(oprel32)
	ctx.JNG(oprel32)
	ctx.JNGE(oprel32)
	ctx.JNL(oprel32)
	ctx.JNLE(oprel32)
	ctx.JNO(oprel32)
	ctx.JNP(oprel32)
	ctx.JNS(oprel32)
	ctx.JNZ(oprel32)
	ctx.JO(oprel32)
	ctx.JOC(oprel32)
	ctx.JOS(oprel32)
	ctx.JP(oprel32)
	ctx.JPC(oprel32)
	ctx.JPE(oprel32)
	ctx.JPL(oprel32)
	ctx.JPO(oprel32)
	ctx.JPS(oprel32)
	ctx.JS(oprel32)
	ctx.JZ(oprel32)
	ctx.KADDB(opk, opk, opk)
	ctx.KADDD(opk, opk, opk)
	ctx.KADDQ(opk, opk, opk)
	ctx.KADDW(opk, opk, opk)
	ctx.KANDB(opk, opk, opk)
	ctx.KANDD(opk, opk, opk)
	ctx.KANDNB(opk, opk, opk)
	ctx.KANDND(opk, opk, opk)
	ctx.KANDNQ(opk, opk, opk)
	ctx.KANDNW(opk, opk, opk)
	ctx.KANDQ(opk, opk, opk)
	ctx.KANDW(opk, opk, opk)
	ctx.KMOVB(opk, opk)
	ctx.KMOVD(opk, opk)
	ctx.KMOVQ(opk, opk)
	ctx.KMOVW(opk, opk)
	ctx.KNOTB(opk, opk)
	ctx.KNOTD(opk, opk)
	ctx.KNOTQ(opk, opk)
	ctx.KNOTW(opk, opk)
	ctx.KORB(opk, opk, opk)
	ctx.KORD(opk, opk, opk)
	ctx.KORQ(opk, opk, opk)
	ctx.KORTESTB(opk, opk)
	ctx.KORTESTD(opk, opk)
	ctx.KORTESTQ(opk, opk)
	ctx.KORTESTW(opk, opk)
	ctx.KORW(opk, opk, opk)
	ctx.KSHIFTLB(opimm8, opk, opk)
	ctx.KSHIFTLD(opimm8, opk, opk)
	ctx.KSHIFTLQ(opimm8, opk, opk)
	ctx.KSHIFTLW(opimm8, opk, opk)
	ctx.KSHIFTRB(opimm8, opk, opk)
	ctx.KSHIFTRD(opimm8, opk, opk)
	ctx.KSHIFTRQ(opimm8, opk, opk)
	ctx.KSHIFTRW(opimm8, opk, opk)
	ctx.KTESTB(opk, opk)
	ctx.KTESTD(opk, opk)
	ctx.KTESTQ(opk, opk)
	ctx.KTESTW(opk, opk)
	ctx.KUNPCKBW(opk, opk, opk)
	ctx.KUNPCKDQ(opk, opk, opk)
	ctx.KUNPCKWD(opk, opk, opk)
	ctx.KXNORB(opk, opk, opk)
	ctx.KXNORD(opk, opk, opk)
	ctx.KXNORQ(opk, opk, opk)
	ctx.KXNORW(opk, opk, opk)
	ctx.KXORB(opk, opk, opk)
	ctx.KXORD(opk, opk, opk)
	ctx.KXORQ(opk, opk, opk)
	ctx.KXORW(opk, opk, opk)
	ctx.LDDQU(opm128, opxmm)
	ctx.LDMXCSR(opm32)
	ctx.LEAL(opm, opr32)
	ctx.LEAQ(opm, opr64)
	ctx.LEAW(opm, opr16)
	ctx.LFENCE()
	ctx.LZCNTL(opm32, opr32)
	ctx.LZCNTQ(opm64, opr64)
	ctx.LZCNTW(opm16, opr16)
	ctx.MASKMOVDQU(opxmm, opxmm)
	ctx.MASKMOVOU(opxmm, opxmm)
	ctx.MAXPD(opm128, opxmm)
	ctx.MAXPS(opm128, opxmm)
	ctx.MAXSD(opm64, opxmm)
	ctx.MAXSS(opm32, opxmm)
	ctx.MFENCE()
	ctx.MINPD(opm128, opxmm)
	ctx.MINPS(opm128, opxmm)
	ctx.MINSD(opm64, opxmm)
	ctx.MINSS(opm32, opxmm)
	ctx.MONITOR()
	ctx.MOVAPD(opm128, opxmm)
	ctx.MOVAPS(opm128, opxmm)
	ctx.MOVB(opimm8, opm8)
	ctx.MOVBELL(opm32, opr32)
	ctx.MOVBEQQ(opm64, opr64)
	ctx.MOVBEWW(opm16, opr16)
	ctx.MOVBLSX(opm8, opr32)
	ctx.MOVBLZX(opm8, opr32)
	ctx.MOVBQSX(opm8, opr64)
	ctx.MOVBQZX(opm8, opr64)
	ctx.MOVBWSX(opm8, opr16)
	ctx.MOVBWZX(opm8, opr16)
	ctx.MOVD(opm32, opxmm)
	ctx.MOVDDUP(opm64, opxmm)
	ctx.MOVDQ2Q(opm32, opxmm)
	ctx.MOVHLPS(opxmm, opxmm)
	ctx.MOVHPD(opm64, opxmm)
	ctx.MOVHPS(opm64, opxmm)
	ctx.MOVL(opimm32, opm32)
	ctx.MOVLHPS(opxmm, opxmm)
	ctx.MOVLPD(opm64, opxmm)
	ctx.MOVLPS(opm64, opxmm)
	ctx.MOVLQSX(opm32, opr64)
	ctx.MOVLQZX(opm32, opr64)
	ctx.MOVMSKPD(opxmm, opr32)
	ctx.MOVMSKPS(opxmm, opr32)
	ctx.MOVNTDQ(opxmm, opm128)
	ctx.MOVNTDQA(opm128, opxmm)
	ctx.MOVNTIL(opr32, opm32)
	ctx.MOVNTIQ(opr64, opm64)
	ctx.MOVNTO(opxmm, opm128)
	ctx.MOVNTPD(opxmm, opm128)
	ctx.MOVNTPS(opxmm, opm128)
	ctx.MOVO(opm128, opxmm)
	ctx.MOVOA(opm128, opxmm)
	ctx.MOVOU(opm128, opxmm)
	ctx.MOVQ(opm32, opxmm)
	ctx.MOVSD(opm64, opxmm)
	ctx.MOVSHDUP(opm128, opxmm)
	ctx.MOVSLDUP(opm128, opxmm)
	ctx.MOVSS(opm32, opxmm)
	ctx.MOVUPD(opm128, opxmm)
	ctx.MOVUPS(opm128, opxmm)
	ctx.MOVW(opimm16, opm16)
	ctx.MOVWLSX(opm16, opr32)
	ctx.MOVWLZX(opm16, opr32)
	ctx.MOVWQSX(opm16, opr64)
	ctx.MOVWQZX(opm16, opr64)
	ctx.MPSADBW(opimm8, opm128, opxmm)
	ctx.MULB(opm8)
	ctx.MULL(opm32)
	ctx.MULPD(opm128, opxmm)
	ctx.MULPS(opm128, opxmm)
	ctx.MULQ(opm64)
	ctx.MULSD(opm64, opxmm)
	ctx.MULSS(opm32, opxmm)
	ctx.MULW(opm16)
	ctx.MULXL(opm32, opr32, opr32)
	ctx.MULXQ(opm64, opr64, opr64)
	ctx.MWAIT()
	ctx.NEGB(opm8)
	ctx.NEGL(opm32)
	ctx.NEGQ(opm64)
	ctx.NEGW(opm16)
	ctx.NOP()
	ctx.NOTB(opm8)
	ctx.NOTL(opm32)
	ctx.NOTQ(opm64)
	ctx.NOTW(opm16)
	ctx.ORB(opimm8, opal)
	ctx.ORL(opimm32, opeax)
	ctx.ORPD(opm128, opxmm)
	ctx.ORPS(opm128, opxmm)
	ctx.ORQ(opimm32, opm64)
	ctx.ORW(opimm16, opax)
	ctx.PABSB(opm128, opxmm)
	ctx.PABSD(opm128, opxmm)
	ctx.PABSW(opm128, opxmm)
	ctx.PACKSSLW(opm128, opxmm)
	ctx.PACKSSWB(opm128, opxmm)
	ctx.PACKUSDW(opm128, opxmm)
	ctx.PACKUSWB(opm128, opxmm)
	ctx.PADDB(opm128, opxmm)
	ctx.PADDD(opm128, opxmm)
	ctx.PADDL(opm128, opxmm)
	ctx.PADDQ(opm128, opxmm)
	ctx.PADDSB(opm128, opxmm)
	ctx.PADDSW(opm128, opxmm)
	ctx.PADDUSB(opm128, opxmm)
	ctx.PADDUSW(opm128, opxmm)
	ctx.PADDW(opm128, opxmm)
	ctx.PALIGNR(opimm8, opm128, opxmm)
	ctx.PAND(opm128, opxmm)
	ctx.PANDN(opm128, opxmm)
	ctx.PAUSE()
	ctx.PAVGB(opm128, opxmm)
	ctx.PAVGW(opm128, opxmm)
	ctx.PBLENDVB(opxmm0, opm128, opxmm)
	ctx.PBLENDW(opimm8, opm128, opxmm)
	ctx.PCLMULQDQ(opimm8, opm128, opxmm)
	ctx.PCMPEQB(opm128, opxmm)
	ctx.PCMPEQL(opm128, opxmm)
	ctx.PCMPEQQ(opm128, opxmm)
	ctx.PCMPEQW(opm128, opxmm)
	ctx.PCMPESTRI(opimm8, opm128, opxmm)
	ctx.PCMPESTRM(opimm8, opm128, opxmm)
	ctx.PCMPGTB(opm128, opxmm)
	ctx.PCMPGTL(opm128, opxmm)
	ctx.PCMPGTQ(opm128, opxmm)
	ctx.PCMPGTW(opm128, opxmm)
	ctx.PCMPISTRI(opimm8, opm128, opxmm)
	ctx.PCMPISTRM(opimm8, opm128, opxmm)
	ctx.PDEPL(opm32, opr32, opr32)
	ctx.PDEPQ(opm64, opr64, opr64)
	ctx.PEXTL(opm32, opr32, opr32)
	ctx.PEXTQ(opm64, opr64, opr64)
	ctx.PEXTRB(opimm8, opxmm, opm8)
	ctx.PEXTRD(opimm8, opxmm, opm32)
	ctx.PEXTRQ(opimm8, opxmm, opm64)
	ctx.PEXTRW(opimm8, opxmm, opm16)
	ctx.PHADDD(opm128, opxmm)
	ctx.PHADDSW(opm128, opxmm)
	ctx.PHADDW(opm128, opxmm)
	ctx.PHMINPOSUW(opm128, opxmm)
	ctx.PHSUBD(opm128, opxmm)
	ctx.PHSUBSW(opm128, opxmm)
	ctx.PHSUBW(opm128, opxmm)
	ctx.PINSRB(opimm8, opm8, opxmm)
	ctx.PINSRD(opimm8, opm32, opxmm)
	ctx.PINSRQ(opimm8, opm64, opxmm)
	ctx.PINSRW(opimm8, opm16, opxmm)
	ctx.PMADDUBSW(opm128, opxmm)
	ctx.PMADDWL(opm128, opxmm)
	ctx.PMAXSB(opm128, opxmm)
	ctx.PMAXSD(opm128, opxmm)
	ctx.PMAXSW(opm128, opxmm)
	ctx.PMAXUB(opm128, opxmm)
	ctx.PMAXUD(opm128, opxmm)
	ctx.PMAXUW(opm128, opxmm)
	ctx.PMINSB(opm128, opxmm)
	ctx.PMINSD(opm128, opxmm)
	ctx.PMINSW(opm128, opxmm)
	ctx.PMINUB(opm128, opxmm)
	ctx.PMINUD(opm128, opxmm)
	ctx.PMINUW(opm128, opxmm)
	ctx.PMOVMSKB(opxmm, opr32)
	ctx.PMOVSXBD(opm32, opxmm)
	ctx.PMOVSXBQ(opm16, opxmm)
	ctx.PMOVSXBW(opm64, opxmm)
	ctx.PMOVSXDQ(opm64, opxmm)
	ctx.PMOVSXWD(opm64, opxmm)
	ctx.PMOVSXWQ(opm32, opxmm)
	ctx.PMOVZXBD(opm32, opxmm)
	ctx.PMOVZXBQ(opm16, opxmm)
	ctx.PMOVZXBW(opm64, opxmm)
	ctx.PMOVZXDQ(opm64, opxmm)
	ctx.PMOVZXWD(opm64, opxmm)
	ctx.PMOVZXWQ(opm32, opxmm)
	ctx.PMULDQ(opm128, opxmm)
	ctx.PMULHRSW(opm128, opxmm)
	ctx.PMULHUW(opm128, opxmm)
	ctx.PMULHW(opm128, opxmm)
	ctx.PMULLD(opm128, opxmm)
	ctx.PMULLW(opm128, opxmm)
	ctx.PMULULQ(opm128, opxmm)
	ctx.POPCNTL(opm32, opr32)
	ctx.POPCNTQ(opm64, opr64)
	ctx.POPCNTW(opm16, opr16)
	ctx.POPQ(opm64)
	ctx.POPW(opm16)
	ctx.POR(opm128, opxmm)
	ctx.PREFETCHNTA(opm8)
	ctx.PREFETCHT0(opm8)
	ctx.PREFETCHT1(opm8)
	ctx.PREFETCHT2(opm8)
	ctx.PSADBW(opm128, opxmm)
	ctx.PSHUFB(opm128, opxmm)
	ctx.PSHUFD(opimm8, opm128, opxmm)
	ctx.PSHUFHW(opimm8, opm128, opxmm)
	ctx.PSHUFL(opimm8, opm128, opxmm)
	ctx.PSHUFLW(opimm8, opm128, opxmm)
	ctx.PSIGNB(opm128, opxmm)
	ctx.PSIGND(opm128, opxmm)
	ctx.PSIGNW(opm128, opxmm)
	ctx.PSLLDQ(opimm8, opxmm)
	ctx.PSLLL(opimm8, opxmm)
	ctx.PSLLO(opimm8, opxmm)
	ctx.PSLLQ(opimm8, opxmm)
	ctx.PSLLW(opimm8, opxmm)
	ctx.PSRAL(opimm8, opxmm)
	ctx.PSRAW(opimm8, opxmm)
	ctx.PSRLDQ(opimm8, opxmm)
	ctx.PSRLL(opimm8, opxmm)
	ctx.PSRLO(opimm8, opxmm)
	ctx.PSRLQ(opimm8, opxmm)
	ctx.PSRLW(opimm8, opxmm)
	ctx.PSUBB(opm128, opxmm)
	ctx.PSUBL(opm128, opxmm)
	ctx.PSUBQ(opm128, opxmm)
	ctx.PSUBSB(opm128, opxmm)
	ctx.PSUBSW(opm128, opxmm)
	ctx.PSUBUSB(opm128, opxmm)
	ctx.PSUBUSW(opm128, opxmm)
	ctx.PSUBW(opm128, opxmm)
	ctx.PTEST(opm128, opxmm)
	ctx.PUNPCKHBW(opm128, opxmm)
	ctx.PUNPCKHLQ(opm128, opxmm)
	ctx.PUNPCKHQDQ(opm128, opxmm)
	ctx.PUNPCKHWL(opm128, opxmm)
	ctx.PUNPCKLBW(opm128, opxmm)
	ctx.PUNPCKLLQ(opm128, opxmm)
	ctx.PUNPCKLQDQ(opm128, opxmm)
	ctx.PUNPCKLWL(opm128, opxmm)
	ctx.PUSHQ(opimm32)
	ctx.PUSHW(opm16)
	ctx.PXOR(opm128, opxmm)
	ctx.RCLB(op1, opm8)
	ctx.RCLL(op1, opm32)
	ctx.RCLQ(op1, opm64)
	ctx.RCLW(op1, opm16)
	ctx.RCPPS(opm128, opxmm)
	ctx.RCPSS(opm32, opxmm)
	ctx.RCRB(op1, opm8)
	ctx.RCRL(op1, opm32)
	ctx.RCRQ(op1, opm64)
	ctx.RCRW(op1, opm16)
	ctx.RDRANDL(opr16)
	ctx.RDSEEDL(opr16)
	ctx.RDTSC()
	ctx.RDTSCP()
	ctx.RET()
	ctx.RETFL(opimm16)
	ctx.RETFQ(opimm16)
	ctx.RETFW(opimm16)
	ctx.ROLB(op1, opm8)
	ctx.ROLL(op1, opm32)
	ctx.ROLQ(op1, opm64)
	ctx.ROLW(op1, opm16)
	ctx.RORB(op1, opm8)
	ctx.RORL(op1, opm32)
	ctx.RORQ(op1, opm64)
	ctx.RORW(op1, opm16)
	ctx.RORXL(opimm8, opm32, opr32)
	ctx.RORXQ(opimm8, opm64, opr64)
	ctx.ROUNDPD(opimm8, opm128, opxmm)
	ctx.ROUNDPS(opimm8, opm128, opxmm)
	ctx.ROUNDSD(opimm8, opm64, opxmm)
	ctx.ROUNDSS(opimm8, opm32, opxmm)
	ctx.RSQRTPS(opm128, opxmm)
	ctx.RSQRTSS(opm32, opxmm)
	ctx.SALB(op1, opm8)
	ctx.SALL(op1, opm32)
	ctx.SALQ(op1, opm64)
	ctx.SALW(op1, opm16)
	ctx.SARB(op1, opm8)
	ctx.SARL(op1, opm32)
	ctx.SARQ(op1, opm64)
	ctx.SARW(op1, opm16)
	ctx.SARXL(opr32, opm32, opr32)
	ctx.SARXQ(opr64, opm64, opr64)
	ctx.SBBB(opimm8, opal)
	ctx.SBBL(opimm32, opeax)
	ctx.SBBQ(opimm32, opm64)
	ctx.SBBW(opimm16, opax)
	ctx.SETCC(opm8)
	ctx.SETCS(opm8)
	ctx.SETEQ(opm8)
	ctx.SETGE(opm8)
	ctx.SETGT(opm8)
	ctx.SETHI(opm8)
	ctx.SETLE(opm8)
	ctx.SETLS(opm8)
	ctx.SETLT(opm8)
	ctx.SETMI(opm8)
	ctx.SETNE(opm8)
	ctx.SETOC(opm8)
	ctx.SETOS(opm8)
	ctx.SETPC(opm8)
	ctx.SETPL(opm8)
	ctx.SETPS(opm8)
	ctx.SFENCE()
	ctx.SHA1MSG1(opm128, opxmm)
	ctx.SHA1MSG2(opm128, opxmm)
	ctx.SHA1NEXTE(opm128, opxmm)
	ctx.SHA1RNDS4(opimm2u, opm128, opxmm)
	ctx.SHA256MSG1(opm128, opxmm)
	ctx.SHA256MSG2(opm128, opxmm)
	ctx.SHA256RNDS2(opxmm0, opm128, opxmm)
	ctx.SHLB(op1, opm8)
	ctx.SHLL(op1, opm32)
	ctx.SHLQ(op1, opm64)
	ctx.SHLW(op1, opm16)
	ctx.SHLXL(opr32, opm32, opr32)
	ctx.SHLXQ(opr64, opm64, opr64)
	ctx.SHRB(op1, opm8)
	ctx.SHRL(op1, opm32)
	ctx.SHRQ(op1, opm64)
	ctx.SHRW(op1, opm16)
	ctx.SHRXL(opr32, opm32, opr32)
	ctx.SHRXQ(opr64, opm64, opr64)
	ctx.SHUFPD(opimm8, opm128, opxmm)
	ctx.SHUFPS(opimm8, opm128, opxmm)
	ctx.SQRTPD(opm128, opxmm)
	ctx.SQRTPS(opm128, opxmm)
	ctx.SQRTSD(opm64, opxmm)
	ctx.SQRTSS(opm32, opxmm)
	ctx.STC()
	ctx.STD()
	ctx.STMXCSR(opm32)
	ctx.SUBB(opimm8, opal)
	ctx.SUBL(opimm32, opeax)
	ctx.SUBPD(opm128, opxmm)
	ctx.SUBPS(opm128, opxmm)
	ctx.SUBQ(opimm32, opm64)
	ctx.SUBSD(opm64, opxmm)
	ctx.SUBSS(opm32, opxmm)
	ctx.SUBW(opimm16, opax)
	ctx.SYSCALL()
	ctx.TESTB(opimm8, opal)
	ctx.TESTL(opimm32, opeax)
	ctx.TESTQ(opimm32, opm64)
	ctx.TESTW(opimm16, opax)
	ctx.TZCNTL(opm32, opr32)
	ctx.TZCNTQ(opm64, opr64)
	ctx.TZCNTW(opm16, opr16)
	ctx.UCOMISD(opm64, opxmm)
	ctx.UCOMISS(opm32, opxmm)
	ctx.UD2()
	ctx.UNPCKHPD(opm128, opxmm)
	ctx.UNPCKHPS(opm128, opxmm)
	ctx.UNPCKLPD(opm128, opxmm)
	ctx.UNPCKLPS(opm128, opxmm)
	ctx.VADDPD(opm128, opxmm, opxmm)
	ctx.VADDPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VADDPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VADDPD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VADDPS(opm128, opxmm, opxmm)
	ctx.VADDPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VADDPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VADDPS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VADDPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VADDSD(opm64, opxmm, opxmm)
	ctx.VADDSD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VADDSS(opm32, opxmm, opxmm)
	ctx.VADDSS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VADDSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VADDSUBPD(opm128, opxmm, opxmm)
	ctx.VADDSUBPS(opm128, opxmm, opxmm)
	ctx.VAESDEC(opm128, opxmm, opxmm)
	ctx.VAESDECLAST(opm128, opxmm, opxmm)
	ctx.VAESENC(opm128, opxmm, opxmm)
	ctx.VAESENCLAST(opm128, opxmm, opxmm)
	ctx.VAESIMC(opm128, opxmm)
	ctx.VAESKEYGENASSIST(opimm8, opm128, opxmm)
	ctx.VALIGND(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VALIGND_BCST(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VALIGND_BCST_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VALIGND_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VALIGNQ(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VALIGNQ_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VALIGNQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VALIGNQ_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VANDNPD(opm128, opxmm, opxmm)
	ctx.VANDNPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VANDNPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VANDNPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VANDNPS(opm128, opxmm, opxmm)
	ctx.VANDNPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VANDNPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VANDNPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VANDPD(opm128, opxmm, opxmm)
	ctx.VANDPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VANDPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VANDPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VANDPS(opm128, opxmm, opxmm)
	ctx.VANDPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VANDPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VANDPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VBLENDMPD(opm128, opxmm, opk, opxmm)
	ctx.VBLENDMPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VBLENDMPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VBLENDMPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VBLENDMPS(opm128, opxmm, opk, opxmm)
	ctx.VBLENDMPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VBLENDMPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VBLENDMPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VBLENDPD(opimm8, opm128, opxmm, opxmm)
	ctx.VBLENDPS(opimm8, opm128, opxmm, opxmm)
	ctx.VBLENDVPD(opxmm, opm128, opxmm, opxmm)
	ctx.VBLENDVPS(opxmm, opm128, opxmm, opxmm)
	ctx.VBROADCASTF128(opm128, opymm)
	ctx.VBROADCASTF32X2(opm64, opk, opymm)
	ctx.VBROADCASTF32X2_Z(opm64, opk, opymm)
	ctx.VBROADCASTF32X4(opm128, opk, opymm)
	ctx.VBROADCASTF32X4_Z(opm128, opk, opymm)
	ctx.VBROADCASTF32X8(opm256, opk, opzmm)
	ctx.VBROADCASTF32X8_Z(opm256, opk, opzmm)
	ctx.VBROADCASTF64X2(opm128, opk, opymm)
	ctx.VBROADCASTF64X2_Z(opm128, opk, opymm)
	ctx.VBROADCASTF64X4(opm256, opk, opzmm)
	ctx.VBROADCASTF64X4_Z(opm256, opk, opzmm)
	ctx.VBROADCASTI128(opm128, opymm)
	ctx.VBROADCASTI32X2(opm64, opk, opxmm)
	ctx.VBROADCASTI32X2_Z(opm64, opk, opxmm)
	ctx.VBROADCASTI32X4(opm128, opk, opymm)
	ctx.VBROADCASTI32X4_Z(opm128, opk, opymm)
	ctx.VBROADCASTI32X8(opm256, opk, opzmm)
	ctx.VBROADCASTI32X8_Z(opm256, opk, opzmm)
	ctx.VBROADCASTI64X2(opm128, opk, opymm)
	ctx.VBROADCASTI64X2_Z(opm128, opk, opymm)
	ctx.VBROADCASTI64X4(opm256, opk, opzmm)
	ctx.VBROADCASTI64X4_Z(opm256, opk, opzmm)
	ctx.VBROADCASTSD(opxmm, opymm)
	ctx.VBROADCASTSD_Z(opm64, opk, opymm)
	ctx.VBROADCASTSS(opxmm, opxmm)
	ctx.VBROADCASTSS_Z(opm32, opk, opymm)
	ctx.VCMPPD(opimm8, opm128, opxmm, opxmm)
	ctx.VCMPPD_BCST(opimm8, opm64, opxmm, opk, opk)
	ctx.VCMPPD_SAE(opimm8, opzmm, opzmm, opk, opk)
	ctx.VCMPPS(opimm8, opm128, opxmm, opxmm)
	ctx.VCMPPS_BCST(opimm8, opm32, opxmm, opk, opk)
	ctx.VCMPPS_SAE(opimm8, opzmm, opzmm, opk, opk)
	ctx.VCMPSD(opimm8, opm64, opxmm, opxmm)
	ctx.VCMPSD_SAE(opimm8, opxmm, opxmm, opk, opk)
	ctx.VCMPSS(opimm8, opm32, opxmm, opxmm)
	ctx.VCMPSS_SAE(opimm8, opxmm, opxmm, opk, opk)
	ctx.VCOMISD(opm64, opxmm)
	ctx.VCOMISD_SAE(opxmm, opxmm)
	ctx.VCOMISS(opm32, opxmm)
	ctx.VCOMISS_SAE(opxmm, opxmm)
	ctx.VCOMPRESSPD(opxmm, opk, opm128)
	ctx.VCOMPRESSPD_Z(opxmm, opk, opm128)
	ctx.VCOMPRESSPS(opxmm, opk, opm128)
	ctx.VCOMPRESSPS_Z(opxmm, opk, opm128)
	ctx.VCVTDQ2PD(opm128, opymm)
	ctx.VCVTDQ2PD_BCST(opm32, opk, opxmm)
	ctx.VCVTDQ2PD_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTDQ2PD_Z(opm128, opk, opymm)
	ctx.VCVTDQ2PS(opm128, opxmm)
	ctx.VCVTDQ2PS_BCST(opm32, opk, opxmm)
	ctx.VCVTDQ2PS_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTDQ2PS_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTDQ2PS_Z(opm128, opk, opxmm)
	ctx.VCVTPD2DQ(opm512, opk, opymm)
	ctx.VCVTPD2DQX(opm128, opxmm)
	ctx.VCVTPD2DQX_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2DQX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2DQX_Z(opm128, opk, opxmm)
	ctx.VCVTPD2DQY(opm256, opxmm)
	ctx.VCVTPD2DQY_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2DQY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2DQY_Z(opm256, opk, opxmm)
	ctx.VCVTPD2DQ_BCST(opm64, opk, opymm)
	ctx.VCVTPD2DQ_BCST_Z(opm64, opk, opymm)
	ctx.VCVTPD2DQ_RD_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RD_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RN_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RN_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RU_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RU_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RZ_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_RZ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2DQ_Z(opm512, opk, opymm)
	ctx.VCVTPD2PS(opm512, opk, opymm)
	ctx.VCVTPD2PSX(opm128, opxmm)
	ctx.VCVTPD2PSX_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2PSX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2PSX_Z(opm128, opk, opxmm)
	ctx.VCVTPD2PSY(opm256, opxmm)
	ctx.VCVTPD2PSY_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2PSY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2PSY_Z(opm256, opk, opxmm)
	ctx.VCVTPD2PS_BCST(opm64, opk, opymm)
	ctx.VCVTPD2PS_BCST_Z(opm64, opk, opymm)
	ctx.VCVTPD2PS_RD_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RD_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RN_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RN_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RU_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RU_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RZ_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2PS_RZ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2PS_Z(opm512, opk, opymm)
	ctx.VCVTPD2QQ(opm128, opk, opxmm)
	ctx.VCVTPD2QQ_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2QQ_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2QQ_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2QQ_Z(opm128, opk, opxmm)
	ctx.VCVTPD2UDQ(opm512, opk, opymm)
	ctx.VCVTPD2UDQX(opm128, opk, opxmm)
	ctx.VCVTPD2UDQX_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2UDQX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2UDQX_Z(opm128, opk, opxmm)
	ctx.VCVTPD2UDQY(opm256, opk, opxmm)
	ctx.VCVTPD2UDQY_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2UDQY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2UDQY_Z(opm256, opk, opxmm)
	ctx.VCVTPD2UDQ_BCST(opm64, opk, opymm)
	ctx.VCVTPD2UDQ_BCST_Z(opm64, opk, opymm)
	ctx.VCVTPD2UDQ_RD_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RD_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RN_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RN_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RU_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RU_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RZ_SAE(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_RZ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTPD2UDQ_Z(opm512, opk, opymm)
	ctx.VCVTPD2UQQ(opm128, opk, opxmm)
	ctx.VCVTPD2UQQ_BCST(opm64, opk, opxmm)
	ctx.VCVTPD2UQQ_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTPD2UQQ_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPD2UQQ_Z(opm128, opk, opxmm)
	ctx.VCVTPH2PS(opm128, opymm)
	ctx.VCVTPH2PS_SAE(opymm, opk, opzmm)
	ctx.VCVTPH2PS_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPH2PS_Z(opm128, opk, opymm)
	ctx.VCVTPS2DQ(opm128, opxmm)
	ctx.VCVTPS2DQ_BCST(opm32, opk, opxmm)
	ctx.VCVTPS2DQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTPS2DQ_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2DQ_Z(opm128, opk, opxmm)
	ctx.VCVTPS2PD(opm128, opymm)
	ctx.VCVTPS2PD_BCST(opm32, opk, opxmm)
	ctx.VCVTPS2PD_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTPS2PD_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2PD_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2PD_Z(opm64, opk, opxmm)
	ctx.VCVTPS2PH(opimm8, opxmm, opm64)
	ctx.VCVTPS2PH_SAE(opimm8, opzmm, opk, opymm)
	ctx.VCVTPS2PH_SAE_Z(opimm8, opzmm, opk, opymm)
	ctx.VCVTPS2PH_Z(opimm8, opxmm, opk, opm64)
	ctx.VCVTPS2QQ(opm128, opk, opymm)
	ctx.VCVTPS2QQ_BCST(opm32, opk, opxmm)
	ctx.VCVTPS2QQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTPS2QQ_RD_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RD_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RN_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RN_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RU_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RU_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RZ_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_RZ_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2QQ_Z(opm128, opk, opymm)
	ctx.VCVTPS2UDQ(opm128, opk, opxmm)
	ctx.VCVTPS2UDQ_BCST(opm32, opk, opxmm)
	ctx.VCVTPS2UDQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTPS2UDQ_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTPS2UDQ_Z(opm128, opk, opxmm)
	ctx.VCVTPS2UQQ(opm128, opk, opymm)
	ctx.VCVTPS2UQQ_BCST(opm32, opk, opxmm)
	ctx.VCVTPS2UQQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTPS2UQQ_RD_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RD_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RN_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RN_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RU_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RU_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RZ_SAE(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_RZ_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTPS2UQQ_Z(opm128, opk, opymm)
	ctx.VCVTQQ2PD(opm128, opk, opxmm)
	ctx.VCVTQQ2PD_BCST(opm64, opk, opxmm)
	ctx.VCVTQQ2PD_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTQQ2PD_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTQQ2PD_Z(opm128, opk, opxmm)
	ctx.VCVTQQ2PS(opm512, opk, opymm)
	ctx.VCVTQQ2PSX(opm128, opk, opxmm)
	ctx.VCVTQQ2PSX_BCST(opm64, opk, opxmm)
	ctx.VCVTQQ2PSX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTQQ2PSX_Z(opm128, opk, opxmm)
	ctx.VCVTQQ2PSY(opm256, opk, opxmm)
	ctx.VCVTQQ2PSY_BCST(opm64, opk, opxmm)
	ctx.VCVTQQ2PSY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTQQ2PSY_Z(opm256, opk, opxmm)
	ctx.VCVTQQ2PS_BCST(opm64, opk, opymm)
	ctx.VCVTQQ2PS_BCST_Z(opm64, opk, opymm)
	ctx.VCVTQQ2PS_RD_SAE(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RD_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RN_SAE(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RN_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RU_SAE(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RU_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RZ_SAE(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_RZ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTQQ2PS_Z(opm512, opk, opymm)
	ctx.VCVTSD2SI(opm64, opr32)
	ctx.VCVTSD2SIQ(opm64, opr64)
	ctx.VCVTSD2SIQ_RD_SAE(opxmm, opr64)
	ctx.VCVTSD2SIQ_RN_SAE(opxmm, opr64)
	ctx.VCVTSD2SIQ_RU_SAE(opxmm, opr64)
	ctx.VCVTSD2SIQ_RZ_SAE(opxmm, opr64)
	ctx.VCVTSD2SI_RD_SAE(opxmm, opr32)
	ctx.VCVTSD2SI_RN_SAE(opxmm, opr32)
	ctx.VCVTSD2SI_RU_SAE(opxmm, opr32)
	ctx.VCVTSD2SI_RZ_SAE(opxmm, opr32)
	ctx.VCVTSD2SS(opm64, opxmm, opxmm)
	ctx.VCVTSD2SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSD2SS_Z(opm64, opxmm, opk, opxmm)
	ctx.VCVTSD2USIL(opm64, opr32)
	ctx.VCVTSD2USIL_RD_SAE(opxmm, opr32)
	ctx.VCVTSD2USIL_RN_SAE(opxmm, opr32)
	ctx.VCVTSD2USIL_RU_SAE(opxmm, opr32)
	ctx.VCVTSD2USIL_RZ_SAE(opxmm, opr32)
	ctx.VCVTSD2USIQ(opm64, opr64)
	ctx.VCVTSD2USIQ_RD_SAE(opxmm, opr64)
	ctx.VCVTSD2USIQ_RN_SAE(opxmm, opr64)
	ctx.VCVTSD2USIQ_RU_SAE(opxmm, opr64)
	ctx.VCVTSD2USIQ_RZ_SAE(opxmm, opr64)
	ctx.VCVTSI2SDL(opm32, opxmm, opxmm)
	ctx.VCVTSI2SDQ(opm64, opxmm, opxmm)
	ctx.VCVTSI2SDQ_RD_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SDQ_RN_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SDQ_RU_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SDQ_RZ_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SSL(opm32, opxmm, opxmm)
	ctx.VCVTSI2SSL_RD_SAE(opr32, opxmm, opxmm)
	ctx.VCVTSI2SSL_RN_SAE(opr32, opxmm, opxmm)
	ctx.VCVTSI2SSL_RU_SAE(opr32, opxmm, opxmm)
	ctx.VCVTSI2SSL_RZ_SAE(opr32, opxmm, opxmm)
	ctx.VCVTSI2SSQ(opm64, opxmm, opxmm)
	ctx.VCVTSI2SSQ_RD_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SSQ_RN_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SSQ_RU_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSI2SSQ_RZ_SAE(opr64, opxmm, opxmm)
	ctx.VCVTSS2SD(opm32, opxmm, opxmm)
	ctx.VCVTSS2SD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSS2SD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VCVTSS2SD_Z(opm32, opxmm, opk, opxmm)
	ctx.VCVTSS2SI(opm32, opr32)
	ctx.VCVTSS2SIQ(opm32, opr64)
	ctx.VCVTSS2SIQ_RD_SAE(opxmm, opr64)
	ctx.VCVTSS2SIQ_RN_SAE(opxmm, opr64)
	ctx.VCVTSS2SIQ_RU_SAE(opxmm, opr64)
	ctx.VCVTSS2SIQ_RZ_SAE(opxmm, opr64)
	ctx.VCVTSS2SI_RD_SAE(opxmm, opr32)
	ctx.VCVTSS2SI_RN_SAE(opxmm, opr32)
	ctx.VCVTSS2SI_RU_SAE(opxmm, opr32)
	ctx.VCVTSS2SI_RZ_SAE(opxmm, opr32)
	ctx.VCVTSS2USIL(opm32, opr32)
	ctx.VCVTSS2USIL_RD_SAE(opxmm, opr32)
	ctx.VCVTSS2USIL_RN_SAE(opxmm, opr32)
	ctx.VCVTSS2USIL_RU_SAE(opxmm, opr32)
	ctx.VCVTSS2USIL_RZ_SAE(opxmm, opr32)
	ctx.VCVTSS2USIQ(opm32, opr64)
	ctx.VCVTSS2USIQ_RD_SAE(opxmm, opr64)
	ctx.VCVTSS2USIQ_RN_SAE(opxmm, opr64)
	ctx.VCVTSS2USIQ_RU_SAE(opxmm, opr64)
	ctx.VCVTSS2USIQ_RZ_SAE(opxmm, opr64)
	ctx.VCVTTPD2DQ(opm512, opk, opymm)
	ctx.VCVTTPD2DQX(opm128, opxmm)
	ctx.VCVTTPD2DQX_BCST(opm64, opk, opxmm)
	ctx.VCVTTPD2DQX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTTPD2DQX_Z(opm128, opk, opxmm)
	ctx.VCVTTPD2DQY(opm256, opxmm)
	ctx.VCVTTPD2DQY_BCST(opm64, opk, opxmm)
	ctx.VCVTTPD2DQY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTTPD2DQY_Z(opm256, opk, opxmm)
	ctx.VCVTTPD2DQ_BCST(opm64, opk, opymm)
	ctx.VCVTTPD2DQ_BCST_Z(opm64, opk, opymm)
	ctx.VCVTTPD2DQ_SAE(opzmm, opk, opymm)
	ctx.VCVTTPD2DQ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTTPD2DQ_Z(opm512, opk, opymm)
	ctx.VCVTTPD2QQ(opm128, opk, opxmm)
	ctx.VCVTTPD2QQ_BCST(opm64, opk, opxmm)
	ctx.VCVTTPD2QQ_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTTPD2QQ_SAE(opzmm, opk, opzmm)
	ctx.VCVTTPD2QQ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTTPD2QQ_Z(opm128, opk, opxmm)
	ctx.VCVTTPD2UDQ(opm512, opk, opymm)
	ctx.VCVTTPD2UDQX(opm128, opk, opxmm)
	ctx.VCVTTPD2UDQX_BCST(opm64, opk, opxmm)
	ctx.VCVTTPD2UDQX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTTPD2UDQX_Z(opm128, opk, opxmm)
	ctx.VCVTTPD2UDQY(opm256, opk, opxmm)
	ctx.VCVTTPD2UDQY_BCST(opm64, opk, opxmm)
	ctx.VCVTTPD2UDQY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTTPD2UDQY_Z(opm256, opk, opxmm)
	ctx.VCVTTPD2UDQ_BCST(opm64, opk, opymm)
	ctx.VCVTTPD2UDQ_BCST_Z(opm64, opk, opymm)
	ctx.VCVTTPD2UDQ_SAE(opzmm, opk, opymm)
	ctx.VCVTTPD2UDQ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTTPD2UDQ_Z(opm512, opk, opymm)
	ctx.VCVTTPD2UQQ(opm128, opk, opxmm)
	ctx.VCVTTPD2UQQ_BCST(opm64, opk, opxmm)
	ctx.VCVTTPD2UQQ_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTTPD2UQQ_SAE(opzmm, opk, opzmm)
	ctx.VCVTTPD2UQQ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTTPD2UQQ_Z(opm128, opk, opxmm)
	ctx.VCVTTPS2DQ(opm128, opxmm)
	ctx.VCVTTPS2DQ_BCST(opm32, opk, opxmm)
	ctx.VCVTTPS2DQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTTPS2DQ_SAE(opzmm, opk, opzmm)
	ctx.VCVTTPS2DQ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTTPS2DQ_Z(opm128, opk, opxmm)
	ctx.VCVTTPS2QQ(opm128, opk, opymm)
	ctx.VCVTTPS2QQ_BCST(opm32, opk, opxmm)
	ctx.VCVTTPS2QQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTTPS2QQ_SAE(opymm, opk, opzmm)
	ctx.VCVTTPS2QQ_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTTPS2QQ_Z(opm128, opk, opymm)
	ctx.VCVTTPS2UDQ(opm128, opk, opxmm)
	ctx.VCVTTPS2UDQ_BCST(opm32, opk, opxmm)
	ctx.VCVTTPS2UDQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTTPS2UDQ_SAE(opzmm, opk, opzmm)
	ctx.VCVTTPS2UDQ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTTPS2UDQ_Z(opm128, opk, opxmm)
	ctx.VCVTTPS2UQQ(opm128, opk, opymm)
	ctx.VCVTTPS2UQQ_BCST(opm32, opk, opxmm)
	ctx.VCVTTPS2UQQ_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTTPS2UQQ_SAE(opymm, opk, opzmm)
	ctx.VCVTTPS2UQQ_SAE_Z(opymm, opk, opzmm)
	ctx.VCVTTPS2UQQ_Z(opm128, opk, opymm)
	ctx.VCVTTSD2SI(opm64, opr32)
	ctx.VCVTTSD2SIQ(opm64, opr64)
	ctx.VCVTTSD2SIQ_SAE(opxmm, opr64)
	ctx.VCVTTSD2SI_SAE(opxmm, opr32)
	ctx.VCVTTSD2USIL(opm64, opr32)
	ctx.VCVTTSD2USIL_SAE(opxmm, opr32)
	ctx.VCVTTSD2USIQ(opm64, opr64)
	ctx.VCVTTSD2USIQ_SAE(opxmm, opr64)
	ctx.VCVTTSS2SI(opm32, opr32)
	ctx.VCVTTSS2SIQ(opm32, opr64)
	ctx.VCVTTSS2SIQ_SAE(opxmm, opr64)
	ctx.VCVTTSS2SI_SAE(opxmm, opr32)
	ctx.VCVTTSS2USIL(opm32, opr32)
	ctx.VCVTTSS2USIL_SAE(opxmm, opr32)
	ctx.VCVTTSS2USIQ(opm32, opr64)
	ctx.VCVTTSS2USIQ_SAE(opxmm, opr64)
	ctx.VCVTUDQ2PD(opm128, opk, opymm)
	ctx.VCVTUDQ2PD_BCST(opm32, opk, opxmm)
	ctx.VCVTUDQ2PD_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTUDQ2PD_Z(opm128, opk, opymm)
	ctx.VCVTUDQ2PS(opm128, opk, opxmm)
	ctx.VCVTUDQ2PS_BCST(opm32, opk, opxmm)
	ctx.VCVTUDQ2PS_BCST_Z(opm32, opk, opxmm)
	ctx.VCVTUDQ2PS_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUDQ2PS_Z(opm128, opk, opxmm)
	ctx.VCVTUQQ2PD(opm128, opk, opxmm)
	ctx.VCVTUQQ2PD_BCST(opm64, opk, opxmm)
	ctx.VCVTUQQ2PD_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTUQQ2PD_RD_SAE(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RN_SAE(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RU_SAE(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RZ_SAE(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VCVTUQQ2PD_Z(opm128, opk, opxmm)
	ctx.VCVTUQQ2PS(opm512, opk, opymm)
	ctx.VCVTUQQ2PSX(opm128, opk, opxmm)
	ctx.VCVTUQQ2PSX_BCST(opm64, opk, opxmm)
	ctx.VCVTUQQ2PSX_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTUQQ2PSX_Z(opm128, opk, opxmm)
	ctx.VCVTUQQ2PSY(opm256, opk, opxmm)
	ctx.VCVTUQQ2PSY_BCST(opm64, opk, opxmm)
	ctx.VCVTUQQ2PSY_BCST_Z(opm64, opk, opxmm)
	ctx.VCVTUQQ2PSY_Z(opm256, opk, opxmm)
	ctx.VCVTUQQ2PS_BCST(opm64, opk, opymm)
	ctx.VCVTUQQ2PS_BCST_Z(opm64, opk, opymm)
	ctx.VCVTUQQ2PS_RD_SAE(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RD_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RN_SAE(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RN_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RU_SAE(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RU_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RZ_SAE(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_RZ_SAE_Z(opzmm, opk, opymm)
	ctx.VCVTUQQ2PS_Z(opm512, opk, opymm)
	ctx.VCVTUSI2SDL(opm32, opxmm, opxmm)
	ctx.VCVTUSI2SDQ(opm64, opxmm, opxmm)
	ctx.VCVTUSI2SDQ_RD_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SDQ_RN_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SDQ_RU_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SDQ_RZ_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SSL(opm32, opxmm, opxmm)
	ctx.VCVTUSI2SSL_RD_SAE(opr32, opxmm, opxmm)
	ctx.VCVTUSI2SSL_RN_SAE(opr32, opxmm, opxmm)
	ctx.VCVTUSI2SSL_RU_SAE(opr32, opxmm, opxmm)
	ctx.VCVTUSI2SSL_RZ_SAE(opr32, opxmm, opxmm)
	ctx.VCVTUSI2SSQ(opm64, opxmm, opxmm)
	ctx.VCVTUSI2SSQ_RD_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SSQ_RN_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SSQ_RU_SAE(opr64, opxmm, opxmm)
	ctx.VCVTUSI2SSQ_RZ_SAE(opr64, opxmm, opxmm)
	ctx.VDBPSADBW(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VDBPSADBW_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VDIVPD(opm128, opxmm, opxmm)
	ctx.VDIVPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VDIVPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VDIVPD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VDIVPS(opm128, opxmm, opxmm)
	ctx.VDIVPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VDIVPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VDIVPS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VDIVPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VDIVSD(opm64, opxmm, opxmm)
	ctx.VDIVSD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VDIVSS(opm32, opxmm, opxmm)
	ctx.VDIVSS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VDIVSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VDPPD(opimm8, opm128, opxmm, opxmm)
	ctx.VDPPS(opimm8, opm128, opxmm, opxmm)
	ctx.VEXP2PD(opm512, opk, opzmm)
	ctx.VEXP2PD_BCST(opm64, opk, opzmm)
	ctx.VEXP2PD_BCST_Z(opm64, opk, opzmm)
	ctx.VEXP2PD_SAE(opzmm, opk, opzmm)
	ctx.VEXP2PD_SAE_Z(opzmm, opk, opzmm)
	ctx.VEXP2PD_Z(opm512, opk, opzmm)
	ctx.VEXP2PS(opm512, opk, opzmm)
	ctx.VEXP2PS_BCST(opm32, opk, opzmm)
	ctx.VEXP2PS_BCST_Z(opm32, opk, opzmm)
	ctx.VEXP2PS_SAE(opzmm, opk, opzmm)
	ctx.VEXP2PS_SAE_Z(opzmm, opk, opzmm)
	ctx.VEXP2PS_Z(opm512, opk, opzmm)
	ctx.VEXPANDPD(opm256, opk, opymm)
	ctx.VEXPANDPD_Z(opm256, opk, opymm)
	ctx.VEXPANDPS(opm128, opk, opxmm)
	ctx.VEXPANDPS_Z(opm128, opk, opxmm)
	ctx.VEXTRACTF128(opimm8, opymm, opm128)
	ctx.VEXTRACTF32X4(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTF32X4_Z(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTF32X8(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTF32X8_Z(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTF64X2(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTF64X2_Z(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTF64X4(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTF64X4_Z(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTI128(opimm8, opymm, opm128)
	ctx.VEXTRACTI32X4(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTI32X4_Z(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTI32X8(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTI32X8_Z(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTI64X2(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTI64X2_Z(opimm8, opymm, opk, opm128)
	ctx.VEXTRACTI64X4(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTI64X4_Z(opimm8, opzmm, opk, opm256)
	ctx.VEXTRACTPS(opimm8, opxmm, opm32)
	ctx.VFIXUPIMMPD(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VFIXUPIMMPD_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VFIXUPIMMPD_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VFIXUPIMMPD_SAE(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VFIXUPIMMPD_SAE_Z(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VFIXUPIMMPD_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VFIXUPIMMPS(opimm8, opm256, opymm, opk, opymm)
	ctx.VFIXUPIMMPS_BCST(opimm8, opm32, opymm, opk, opymm)
	ctx.VFIXUPIMMPS_BCST_Z(opimm8, opm32, opymm, opk, opymm)
	ctx.VFIXUPIMMPS_SAE(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VFIXUPIMMPS_SAE_Z(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VFIXUPIMMPS_Z(opimm8, opm256, opymm, opk, opymm)
	ctx.VFIXUPIMMSD(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSD_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSD_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSD_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSS(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSS_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSS_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VFIXUPIMMSS_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VFMADD132PD(opm128, opxmm, opxmm)
	ctx.VFMADD132PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMADD132PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADD132PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADD132PS(opm128, opxmm, opxmm)
	ctx.VFMADD132PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMADD132PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADD132PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD132PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADD132SD(opm64, opxmm, opxmm)
	ctx.VFMADD132SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADD132SS(opm32, opxmm, opxmm)
	ctx.VFMADD132SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD132SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADD213PD(opm128, opxmm, opxmm)
	ctx.VFMADD213PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMADD213PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADD213PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADD213PS(opm128, opxmm, opxmm)
	ctx.VFMADD213PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMADD213PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADD213PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD213PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADD213SD(opm64, opxmm, opxmm)
	ctx.VFMADD213SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADD213SS(opm32, opxmm, opxmm)
	ctx.VFMADD213SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD213SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADD231PD(opm128, opxmm, opxmm)
	ctx.VFMADD231PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMADD231PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADD231PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADD231PS(opm128, opxmm, opxmm)
	ctx.VFMADD231PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMADD231PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADD231PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADD231PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADD231SD(opm64, opxmm, opxmm)
	ctx.VFMADD231SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADD231SS(opm32, opxmm, opxmm)
	ctx.VFMADD231SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMADD231SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB132PD(opm128, opxmm, opxmm)
	ctx.VFMADDSUB132PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMADDSUB132PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADDSUB132PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADDSUB132PS(opm128, opxmm, opxmm)
	ctx.VFMADDSUB132PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB132PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB132PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB132PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADDSUB213PD(opm128, opxmm, opxmm)
	ctx.VFMADDSUB213PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMADDSUB213PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADDSUB213PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADDSUB213PS(opm128, opxmm, opxmm)
	ctx.VFMADDSUB213PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB213PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB213PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB213PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADDSUB231PD(opm128, opxmm, opxmm)
	ctx.VFMADDSUB231PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMADDSUB231PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMADDSUB231PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMADDSUB231PS(opm128, opxmm, opxmm)
	ctx.VFMADDSUB231PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB231PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMADDSUB231PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMADDSUB231PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB132PD(opm128, opxmm, opxmm)
	ctx.VFMSUB132PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB132PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB132PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB132PS(opm128, opxmm, opxmm)
	ctx.VFMSUB132PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB132PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB132PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB132PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB132SD(opm64, opxmm, opxmm)
	ctx.VFMSUB132SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB132SS(opm32, opxmm, opxmm)
	ctx.VFMSUB132SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB132SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB213PD(opm128, opxmm, opxmm)
	ctx.VFMSUB213PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB213PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB213PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB213PS(opm128, opxmm, opxmm)
	ctx.VFMSUB213PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB213PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB213PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB213PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB213SD(opm64, opxmm, opxmm)
	ctx.VFMSUB213SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB213SS(opm32, opxmm, opxmm)
	ctx.VFMSUB213SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB213SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB231PD(opm128, opxmm, opxmm)
	ctx.VFMSUB231PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB231PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB231PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB231PS(opm128, opxmm, opxmm)
	ctx.VFMSUB231PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB231PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUB231PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUB231PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUB231SD(opm64, opxmm, opxmm)
	ctx.VFMSUB231SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUB231SS(opm32, opxmm, opxmm)
	ctx.VFMSUB231SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFMSUB231SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD132PD(opm128, opxmm, opxmm)
	ctx.VFMSUBADD132PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMSUBADD132PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUBADD132PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUBADD132PS(opm128, opxmm, opxmm)
	ctx.VFMSUBADD132PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD132PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD132PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD132PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUBADD213PD(opm128, opxmm, opxmm)
	ctx.VFMSUBADD213PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMSUBADD213PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUBADD213PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUBADD213PS(opm128, opxmm, opxmm)
	ctx.VFMSUBADD213PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD213PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD213PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD213PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUBADD231PD(opm128, opxmm, opxmm)
	ctx.VFMSUBADD231PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFMSUBADD231PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFMSUBADD231PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFMSUBADD231PS(opm128, opxmm, opxmm)
	ctx.VFMSUBADD231PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD231PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFMSUBADD231PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFMSUBADD231PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD132PD(opm128, opxmm, opxmm)
	ctx.VFNMADD132PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD132PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD132PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD132PS(opm128, opxmm, opxmm)
	ctx.VFNMADD132PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD132PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD132PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD132PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD132SD(opm64, opxmm, opxmm)
	ctx.VFNMADD132SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD132SS(opm32, opxmm, opxmm)
	ctx.VFNMADD132SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD132SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD213PD(opm128, opxmm, opxmm)
	ctx.VFNMADD213PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD213PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD213PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD213PS(opm128, opxmm, opxmm)
	ctx.VFNMADD213PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD213PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD213PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD213PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD213SD(opm64, opxmm, opxmm)
	ctx.VFNMADD213SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD213SS(opm32, opxmm, opxmm)
	ctx.VFNMADD213SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD213SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD231PD(opm128, opxmm, opxmm)
	ctx.VFNMADD231PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD231PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD231PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD231PS(opm128, opxmm, opxmm)
	ctx.VFNMADD231PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD231PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMADD231PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMADD231PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMADD231SD(opm64, opxmm, opxmm)
	ctx.VFNMADD231SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMADD231SS(opm32, opxmm, opxmm)
	ctx.VFNMADD231SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMADD231SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB132PD(opm128, opxmm, opxmm)
	ctx.VFNMSUB132PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB132PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB132PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMSUB132PS(opm128, opxmm, opxmm)
	ctx.VFNMSUB132PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB132PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB132PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB132PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD(opm64, opxmm, opxmm)
	ctx.VFNMSUB132SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS(opm32, opxmm, opxmm)
	ctx.VFNMSUB132SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB132SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB213PD(opm128, opxmm, opxmm)
	ctx.VFNMSUB213PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB213PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB213PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMSUB213PS(opm128, opxmm, opxmm)
	ctx.VFNMSUB213PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB213PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB213PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB213PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD(opm64, opxmm, opxmm)
	ctx.VFNMSUB213SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS(opm32, opxmm, opxmm)
	ctx.VFNMSUB213SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB213SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB231PD(opm128, opxmm, opxmm)
	ctx.VFNMSUB231PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB231PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB231PD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMSUB231PS(opm128, opxmm, opxmm)
	ctx.VFNMSUB231PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB231PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VFNMSUB231PS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VFNMSUB231PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD(opm64, opxmm, opxmm)
	ctx.VFNMSUB231SD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS(opm32, opxmm, opxmm)
	ctx.VFNMSUB231SS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VFNMSUB231SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VFPCLASSPDX(opimm8, opm128, opk, opk)
	ctx.VFPCLASSPDX_BCST(opimm8, opm64, opk, opk)
	ctx.VFPCLASSPDY(opimm8, opm256, opk, opk)
	ctx.VFPCLASSPDY_BCST(opimm8, opm64, opk, opk)
	ctx.VFPCLASSPDZ(opimm8, opm512, opk, opk)
	ctx.VFPCLASSPDZ_BCST(opimm8, opm64, opk, opk)
	ctx.VFPCLASSPSX(opimm8, opm128, opk, opk)
	ctx.VFPCLASSPSX_BCST(opimm8, opm32, opk, opk)
	ctx.VFPCLASSPSY(opimm8, opm256, opk, opk)
	ctx.VFPCLASSPSY_BCST(opimm8, opm32, opk, opk)
	ctx.VFPCLASSPSZ(opimm8, opm512, opk, opk)
	ctx.VFPCLASSPSZ_BCST(opimm8, opm32, opk, opk)
	ctx.VFPCLASSSD(opimm8, opm64, opk, opk)
	ctx.VFPCLASSSS(opimm8, opm32, opk, opk)
	ctx.VGATHERDPD(opxmm, opvm32x, opxmm)
	ctx.VGATHERDPS(opxmm, opvm32x, opxmm)
	ctx.VGATHERQPD(opxmm, opvm64x, opxmm)
	ctx.VGATHERQPS(opxmm, opvm64x, opxmm)
	ctx.VGETEXPPD(opm128, opk, opxmm)
	ctx.VGETEXPPD_BCST(opm64, opk, opxmm)
	ctx.VGETEXPPD_BCST_Z(opm64, opk, opxmm)
	ctx.VGETEXPPD_SAE(opzmm, opk, opzmm)
	ctx.VGETEXPPD_SAE_Z(opzmm, opk, opzmm)
	ctx.VGETEXPPD_Z(opm128, opk, opxmm)
	ctx.VGETEXPPS(opm128, opk, opxmm)
	ctx.VGETEXPPS_BCST(opm32, opk, opxmm)
	ctx.VGETEXPPS_BCST_Z(opm32, opk, opxmm)
	ctx.VGETEXPPS_SAE(opzmm, opk, opzmm)
	ctx.VGETEXPPS_SAE_Z(opzmm, opk, opzmm)
	ctx.VGETEXPPS_Z(opm128, opk, opxmm)
	ctx.VGETEXPSD(opm64, opxmm, opk, opxmm)
	ctx.VGETEXPSD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VGETEXPSD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VGETEXPSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VGETEXPSS(opm32, opxmm, opk, opxmm)
	ctx.VGETEXPSS_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VGETEXPSS_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VGETEXPSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VGETMANTPD(opimm8, opm128, opk, opxmm)
	ctx.VGETMANTPD_BCST(opimm8, opm64, opk, opxmm)
	ctx.VGETMANTPD_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VGETMANTPD_SAE(opimm8, opzmm, opk, opzmm)
	ctx.VGETMANTPD_SAE_Z(opimm8, opzmm, opk, opzmm)
	ctx.VGETMANTPD_Z(opimm8, opm128, opk, opxmm)
	ctx.VGETMANTPS(opimm8, opm128, opk, opxmm)
	ctx.VGETMANTPS_BCST(opimm8, opm32, opk, opxmm)
	ctx.VGETMANTPS_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VGETMANTPS_SAE(opimm8, opzmm, opk, opzmm)
	ctx.VGETMANTPS_SAE_Z(opimm8, opzmm, opk, opzmm)
	ctx.VGETMANTPS_Z(opimm8, opm128, opk, opxmm)
	ctx.VGETMANTSD(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VGETMANTSD_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VGETMANTSD_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VGETMANTSD_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VGETMANTSS(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VGETMANTSS_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VGETMANTSS_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VGETMANTSS_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VGF2P8AFFINEINVQB(opimm8, opm128, opxmm, opxmm)
	ctx.VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opzmm, opk, opzmm)
	ctx.VGF2P8AFFINEINVQB_BCST_Z(opimm8, opm64, opzmm, opk, opzmm)
	ctx.VGF2P8AFFINEINVQB_Z(opimm8, opm512, opzmm, opk, opzmm)
	ctx.VGF2P8AFFINEQB(opimm8, opm128, opxmm, opxmm)
	ctx.VGF2P8AFFINEQB_BCST(opimm8, opm64, opzmm, opk, opzmm)
	ctx.VGF2P8AFFINEQB_BCST_Z(opimm8, opm64, opzmm, opk, opzmm)
	ctx.VGF2P8AFFINEQB_Z(opimm8, opm512, opzmm, opk, opzmm)
	ctx.VGF2P8MULB(opm128, opxmm, opxmm)
	ctx.VGF2P8MULB_Z(opm512, opzmm, opk, opzmm)
	ctx.VHADDPD(opm128, opxmm, opxmm)
	ctx.VHADDPS(opm128, opxmm, opxmm)
	ctx.VHSUBPD(opm128, opxmm, opxmm)
	ctx.VHSUBPS(opm128, opxmm, opxmm)
	ctx.VINSERTF128(opimm8, opm128, opymm, opymm)
	ctx.VINSERTF32X4(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTF32X4_Z(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTF32X8(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTF32X8_Z(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTF64X2(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTF64X2_Z(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTF64X4(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTF64X4_Z(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTI128(opimm8, opm128, opymm, opymm)
	ctx.VINSERTI32X4(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTI32X4_Z(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTI32X8(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTI32X8_Z(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTI64X2(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTI64X2_Z(opimm8, opm128, opymm, opk, opymm)
	ctx.VINSERTI64X4(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTI64X4_Z(opimm8, opm256, opzmm, opk, opzmm)
	ctx.VINSERTPS(opimm8, opm32, opxmm, opxmm)
	ctx.VLDDQU(opm128, opxmm)
	ctx.VLDMXCSR(opm32)
	ctx.VMASKMOVDQU(opxmm, opxmm)
	ctx.VMASKMOVPD(opm128, opxmm, opxmm)
	ctx.VMASKMOVPS(opm128, opxmm, opxmm)
	ctx.VMAXPD(opm128, opxmm, opxmm)
	ctx.VMAXPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VMAXPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VMAXPD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMAXPD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMAXPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VMAXPS(opm128, opxmm, opxmm)
	ctx.VMAXPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VMAXPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VMAXPS_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMAXPS_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMAXPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VMAXSD(opm64, opxmm, opxmm)
	ctx.VMAXSD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMAXSD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMAXSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VMAXSS(opm32, opxmm, opxmm)
	ctx.VMAXSS_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMAXSS_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMAXSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VMINPD(opm128, opxmm, opxmm)
	ctx.VMINPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VMINPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VMINPD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMINPD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMINPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VMINPS(opm128, opxmm, opxmm)
	ctx.VMINPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VMINPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VMINPS_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMINPS_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMINPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VMINSD(opm64, opxmm, opxmm)
	ctx.VMINSD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMINSD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMINSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VMINSS(opm32, opxmm, opxmm)
	ctx.VMINSS_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMINSS_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMINSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VMOVAPD(opm128, opxmm)
	ctx.VMOVAPD_Z(opm128, opk, opxmm)
	ctx.VMOVAPS(opm128, opxmm)
	ctx.VMOVAPS_Z(opm128, opk, opxmm)
	ctx.VMOVD(opm32, opxmm)
	ctx.VMOVDDUP(opm256, opymm)
	ctx.VMOVDDUP_Z(opm256, opk, opymm)
	ctx.VMOVDQA(opm128, opxmm)
	ctx.VMOVDQA32(opm128, opk, opxmm)
	ctx.VMOVDQA32_Z(opm128, opk, opxmm)
	ctx.VMOVDQA64(opm128, opk, opxmm)
	ctx.VMOVDQA64_Z(opm128, opk, opxmm)
	ctx.VMOVDQU(opm128, opxmm)
	ctx.VMOVDQU16(opm128, opk, opxmm)
	ctx.VMOVDQU16_Z(opm128, opk, opxmm)
	ctx.VMOVDQU32(opm128, opk, opxmm)
	ctx.VMOVDQU32_Z(opm128, opk, opxmm)
	ctx.VMOVDQU64(opm128, opk, opxmm)
	ctx.VMOVDQU64_Z(opm128, opk, opxmm)
	ctx.VMOVDQU8(opm128, opk, opxmm)
	ctx.VMOVDQU8_Z(opm128, opk, opxmm)
	ctx.VMOVHLPS(opxmm, opxmm, opxmm)
	ctx.VMOVHPD(opm64, opxmm, opxmm)
	ctx.VMOVHPS(opm64, opxmm, opxmm)
	ctx.VMOVLHPS(opxmm, opxmm, opxmm)
	ctx.VMOVLPD(opm64, opxmm, opxmm)
	ctx.VMOVLPS(opm64, opxmm, opxmm)
	ctx.VMOVMSKPD(opxmm, opr32)
	ctx.VMOVMSKPS(opxmm, opr32)
	ctx.VMOVNTDQ(opxmm, opm128)
	ctx.VMOVNTDQA(opm256, opymm)
	ctx.VMOVNTPD(opxmm, opm128)
	ctx.VMOVNTPS(opxmm, opm128)
	ctx.VMOVQ(opm64, opxmm)
	ctx.VMOVSD(opm64, opxmm)
	ctx.VMOVSD_Z(opm64, opk, opxmm)
	ctx.VMOVSHDUP(opm128, opxmm)
	ctx.VMOVSHDUP_Z(opm128, opk, opxmm)
	ctx.VMOVSLDUP(opm128, opxmm)
	ctx.VMOVSLDUP_Z(opm128, opk, opxmm)
	ctx.VMOVSS(opm32, opxmm)
	ctx.VMOVSS_Z(opm32, opk, opxmm)
	ctx.VMOVUPD(opm128, opxmm)
	ctx.VMOVUPD_Z(opm128, opk, opxmm)
	ctx.VMOVUPS(opm128, opxmm)
	ctx.VMOVUPS_Z(opm128, opk, opxmm)
	ctx.VMPSADBW(opimm8, opm256, opymm, opymm)
	ctx.VMULPD(opm128, opxmm, opxmm)
	ctx.VMULPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VMULPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VMULPD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VMULPS(opm128, opxmm, opxmm)
	ctx.VMULPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VMULPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VMULPS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VMULPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VMULSD(opm64, opxmm, opxmm)
	ctx.VMULSD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VMULSS(opm32, opxmm, opxmm)
	ctx.VMULSS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VMULSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VORPD(opm128, opxmm, opxmm)
	ctx.VORPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VORPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VORPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VORPS(opm128, opxmm, opxmm)
	ctx.VORPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VORPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VORPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VPABSB(opm256, opymm)
	ctx.VPABSB_Z(opm128, opk, opxmm)
	ctx.VPABSD(opm256, opymm)
	ctx.VPABSD_BCST(opm32, opk, opxmm)
	ctx.VPABSD_BCST_Z(opm32, opk, opxmm)
	ctx.VPABSD_Z(opm128, opk, opxmm)
	ctx.VPABSQ(opm128, opk, opxmm)
	ctx.VPABSQ_BCST(opm64, opk, opxmm)
	ctx.VPABSQ_BCST_Z(opm64, opk, opxmm)
	ctx.VPABSQ_Z(opm128, opk, opxmm)
	ctx.VPABSW(opm256, opymm)
	ctx.VPABSW_Z(opm128, opk, opxmm)
	ctx.VPACKSSDW(opm256, opymm, opymm)
	ctx.VPACKSSDW_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPACKSSDW_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPACKSSDW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPACKSSWB(opm256, opymm, opymm)
	ctx.VPACKSSWB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPACKUSDW(opm256, opymm, opymm)
	ctx.VPACKUSDW_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPACKUSDW_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPACKUSDW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPACKUSWB(opm256, opymm, opymm)
	ctx.VPACKUSWB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDB(opm256, opymm, opymm)
	ctx.VPADDB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDD(opm256, opymm, opymm)
	ctx.VPADDD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPADDD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPADDD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDQ(opm256, opymm, opymm)
	ctx.VPADDQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPADDQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPADDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDSB(opm256, opymm, opymm)
	ctx.VPADDSB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDSW(opm256, opymm, opymm)
	ctx.VPADDSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDUSB(opm256, opymm, opymm)
	ctx.VPADDUSB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDUSW(opm256, opymm, opymm)
	ctx.VPADDUSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPADDW(opm256, opymm, opymm)
	ctx.VPADDW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPALIGNR(opimm8, opm256, opymm, opymm)
	ctx.VPALIGNR_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPAND(opm256, opymm, opymm)
	ctx.VPANDD(opm128, opxmm, opk, opxmm)
	ctx.VPANDD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPANDD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPANDD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPANDN(opm256, opymm, opymm)
	ctx.VPANDND(opm128, opxmm, opk, opxmm)
	ctx.VPANDND_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPANDND_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPANDND_Z(opm128, opxmm, opk, opxmm)
	ctx.VPANDNQ(opm128, opxmm, opk, opxmm)
	ctx.VPANDNQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPANDNQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPANDNQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPANDQ(opm128, opxmm, opk, opxmm)
	ctx.VPANDQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPANDQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPANDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPAVGB(opm256, opymm, opymm)
	ctx.VPAVGB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPAVGW(opm256, opymm, opymm)
	ctx.VPAVGW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDD(opimm8, opm128, opxmm, opxmm)
	ctx.VPBLENDMB(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMD(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPBLENDMD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPBLENDMD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMQ(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPBLENDMQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPBLENDMQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMW(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDMW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPBLENDVB(opymm, opm256, opymm, opymm)
	ctx.VPBLENDW(opimm8, opm256, opymm, opymm)
	ctx.VPBROADCASTB(opm8, opxmm)
	ctx.VPBROADCASTB_Z(opm8, opk, opxmm)
	ctx.VPBROADCASTD(opm32, opxmm)
	ctx.VPBROADCASTD_Z(opm32, opk, opxmm)
	ctx.VPBROADCASTMB2Q(opk, opxmm)
	ctx.VPBROADCASTMW2D(opk, opxmm)
	ctx.VPBROADCASTQ(opm64, opxmm)
	ctx.VPBROADCASTQ_Z(opm64, opk, opxmm)
	ctx.VPBROADCASTW(opm16, opxmm)
	ctx.VPBROADCASTW_Z(opm16, opk, opxmm)
	ctx.VPCLMULQDQ(opimm8, opm128, opxmm, opxmm)
	ctx.VPCMPB(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPD(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPD_BCST(opimm8, opm32, opxmm, opk, opk)
	ctx.VPCMPEQB(opm256, opymm, opymm)
	ctx.VPCMPEQD(opm256, opymm, opymm)
	ctx.VPCMPEQD_BCST(opm32, opxmm, opk, opk)
	ctx.VPCMPEQQ(opm256, opymm, opymm)
	ctx.VPCMPEQQ_BCST(opm64, opxmm, opk, opk)
	ctx.VPCMPEQW(opm256, opymm, opymm)
	ctx.VPCMPESTRI(opimm8, opm128, opxmm)
	ctx.VPCMPESTRM(opimm8, opm128, opxmm)
	ctx.VPCMPGTB(opm256, opymm, opymm)
	ctx.VPCMPGTD(opm256, opymm, opymm)
	ctx.VPCMPGTD_BCST(opm32, opxmm, opk, opk)
	ctx.VPCMPGTQ(opm256, opymm, opymm)
	ctx.VPCMPGTQ_BCST(opm64, opxmm, opk, opk)
	ctx.VPCMPGTW(opm256, opymm, opymm)
	ctx.VPCMPISTRI(opimm8, opm128, opxmm)
	ctx.VPCMPISTRM(opimm8, opm128, opxmm)
	ctx.VPCMPQ(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPQ_BCST(opimm8, opm64, opxmm, opk, opk)
	ctx.VPCMPUB(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPUD(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPUD_BCST(opimm8, opm32, opxmm, opk, opk)
	ctx.VPCMPUQ(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPUQ_BCST(opimm8, opm64, opxmm, opk, opk)
	ctx.VPCMPUW(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCMPW(opimm8, opm128, opxmm, opk, opk)
	ctx.VPCOMPRESSB(opxmm, opk, opm128)
	ctx.VPCOMPRESSB_Z(opxmm, opk, opxmm)
	ctx.VPCOMPRESSD(opxmm, opk, opm128)
	ctx.VPCOMPRESSD_Z(opxmm, opk, opm128)
	ctx.VPCOMPRESSQ(opxmm, opk, opm128)
	ctx.VPCOMPRESSQ_Z(opxmm, opk, opm128)
	ctx.VPCOMPRESSW(opxmm, opk, opm128)
	ctx.VPCOMPRESSW_Z(opxmm, opk, opxmm)
	ctx.VPCONFLICTD(opm128, opk, opxmm)
	ctx.VPCONFLICTD_BCST(opm32, opk, opxmm)
	ctx.VPCONFLICTD_BCST_Z(opm32, opk, opxmm)
	ctx.VPCONFLICTD_Z(opm128, opk, opxmm)
	ctx.VPCONFLICTQ(opm128, opk, opxmm)
	ctx.VPCONFLICTQ_BCST(opm64, opk, opxmm)
	ctx.VPCONFLICTQ_BCST_Z(opm64, opk, opxmm)
	ctx.VPCONFLICTQ_Z(opm128, opk, opxmm)
	ctx.VPDPBUSD(opm128, opxmm, opk, opxmm)
	ctx.VPDPBUSDS(opm128, opxmm, opk, opxmm)
	ctx.VPDPBUSDS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPDPBUSDS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPDPBUSDS_Z(opm128, opxmm, opk, opxmm)
	ctx.VPDPBUSD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPDPBUSD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPDPBUSD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPDPWSSD(opm128, opxmm, opk, opxmm)
	ctx.VPDPWSSDS(opm128, opxmm, opk, opxmm)
	ctx.VPDPWSSDS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPDPWSSDS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPDPWSSDS_Z(opm128, opxmm, opk, opxmm)
	ctx.VPDPWSSD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPDPWSSD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPDPWSSD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERM2F128(opimm8, opm256, opymm, opymm)
	ctx.VPERM2I128(opimm8, opm256, opymm, opymm)
	ctx.VPERMB(opm128, opxmm, opk, opxmm)
	ctx.VPERMB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMD(opm256, opymm, opymm)
	ctx.VPERMD_BCST(opm32, opymm, opk, opymm)
	ctx.VPERMD_BCST_Z(opm32, opymm, opk, opymm)
	ctx.VPERMD_Z(opm256, opymm, opk, opymm)
	ctx.VPERMI2B(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2B_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2D(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2D_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPERMI2D_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPERMI2D_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2PD(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPERMI2PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPERMI2PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2PS(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPERMI2PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPERMI2PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2Q(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2Q_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPERMI2Q_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPERMI2Q_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2W(opm128, opxmm, opk, opxmm)
	ctx.VPERMI2W_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMILPD(opimm8, opm128, opxmm)
	ctx.VPERMILPD_BCST(opimm8, opm64, opk, opxmm)
	ctx.VPERMILPD_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VPERMILPD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPERMILPS(opimm8, opm128, opxmm)
	ctx.VPERMILPS_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPERMILPS_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPERMILPS_Z(opimm8, opm128, opk, opxmm)
	ctx.VPERMPD(opimm8, opm256, opymm)
	ctx.VPERMPD_BCST(opimm8, opm64, opk, opymm)
	ctx.VPERMPD_BCST_Z(opimm8, opm64, opk, opymm)
	ctx.VPERMPD_Z(opimm8, opm256, opk, opymm)
	ctx.VPERMPS(opm256, opymm, opymm)
	ctx.VPERMPS_BCST(opm32, opymm, opk, opymm)
	ctx.VPERMPS_BCST_Z(opm32, opymm, opk, opymm)
	ctx.VPERMPS_Z(opm256, opymm, opk, opymm)
	ctx.VPERMQ(opimm8, opm256, opymm)
	ctx.VPERMQ_BCST(opimm8, opm64, opk, opymm)
	ctx.VPERMQ_BCST_Z(opimm8, opm64, opk, opymm)
	ctx.VPERMQ_Z(opimm8, opm256, opk, opymm)
	ctx.VPERMT2B(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2B_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2D(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2D_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPERMT2D_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPERMT2D_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2PD(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2PD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPERMT2PD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPERMT2PD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2PS(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2PS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPERMT2PS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPERMT2PS_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2Q(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2Q_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPERMT2Q_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPERMT2Q_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2W(opm128, opxmm, opk, opxmm)
	ctx.VPERMT2W_Z(opm128, opxmm, opk, opxmm)
	ctx.VPERMW(opm128, opxmm, opk, opxmm)
	ctx.VPERMW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPEXPANDB(opm128, opk, opxmm)
	ctx.VPEXPANDB_Z(opm128, opk, opxmm)
	ctx.VPEXPANDD(opm128, opk, opxmm)
	ctx.VPEXPANDD_Z(opm128, opk, opxmm)
	ctx.VPEXPANDQ(opm128, opk, opxmm)
	ctx.VPEXPANDQ_Z(opm128, opk, opxmm)
	ctx.VPEXPANDW(opm128, opk, opxmm)
	ctx.VPEXPANDW_Z(opm128, opk, opxmm)
	ctx.VPEXTRB(opimm8, opxmm, opm8)
	ctx.VPEXTRD(opimm8, opxmm, opm32)
	ctx.VPEXTRQ(opimm8, opxmm, opm64)
	ctx.VPEXTRW(opimm8, opxmm, opm16)
	ctx.VPGATHERDD(opxmm, opvm32x, opxmm)
	ctx.VPGATHERDQ(opxmm, opvm32x, opxmm)
	ctx.VPGATHERQD(opxmm, opvm64x, opxmm)
	ctx.VPGATHERQQ(opxmm, opvm64x, opxmm)
	ctx.VPHADDD(opm256, opymm, opymm)
	ctx.VPHADDSW(opm256, opymm, opymm)
	ctx.VPHADDW(opm256, opymm, opymm)
	ctx.VPHMINPOSUW(opm128, opxmm)
	ctx.VPHSUBD(opm256, opymm, opymm)
	ctx.VPHSUBSW(opm256, opymm, opymm)
	ctx.VPHSUBW(opm256, opymm, opymm)
	ctx.VPINSRB(opimm8, opm8, opxmm, opxmm)
	ctx.VPINSRD(opimm8, opm32, opxmm, opxmm)
	ctx.VPINSRQ(opimm8, opm64, opxmm, opxmm)
	ctx.VPINSRW(opimm8, opm16, opxmm, opxmm)
	ctx.VPLZCNTD(opm128, opk, opxmm)
	ctx.VPLZCNTD_BCST(opm32, opk, opxmm)
	ctx.VPLZCNTD_BCST_Z(opm32, opk, opxmm)
	ctx.VPLZCNTD_Z(opm128, opk, opxmm)
	ctx.VPLZCNTQ(opm128, opk, opxmm)
	ctx.VPLZCNTQ_BCST(opm64, opk, opxmm)
	ctx.VPLZCNTQ_BCST_Z(opm64, opk, opxmm)
	ctx.VPLZCNTQ_Z(opm128, opk, opxmm)
	ctx.VPMADD52HUQ(opm128, opxmm, opk, opxmm)
	ctx.VPMADD52HUQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMADD52HUQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMADD52HUQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMADD52LUQ(opm128, opxmm, opk, opxmm)
	ctx.VPMADD52LUQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMADD52LUQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMADD52LUQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMADDUBSW(opm256, opymm, opymm)
	ctx.VPMADDUBSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMADDWD(opm256, opymm, opymm)
	ctx.VPMADDWD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMASKMOVD(opm128, opxmm, opxmm)
	ctx.VPMASKMOVQ(opm128, opxmm, opxmm)
	ctx.VPMAXSB(opm256, opymm, opymm)
	ctx.VPMAXSB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXSD(opm256, opymm, opymm)
	ctx.VPMAXSD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPMAXSD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPMAXSD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXSQ(opm128, opxmm, opk, opxmm)
	ctx.VPMAXSQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMAXSQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMAXSQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXSW(opm256, opymm, opymm)
	ctx.VPMAXSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXUB(opm256, opymm, opymm)
	ctx.VPMAXUB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXUD(opm256, opymm, opymm)
	ctx.VPMAXUD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPMAXUD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPMAXUD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXUQ(opm128, opxmm, opk, opxmm)
	ctx.VPMAXUQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMAXUQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMAXUQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMAXUW(opm256, opymm, opymm)
	ctx.VPMAXUW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINSB(opm256, opymm, opymm)
	ctx.VPMINSB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINSD(opm256, opymm, opymm)
	ctx.VPMINSD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPMINSD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPMINSD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINSQ(opm128, opxmm, opk, opxmm)
	ctx.VPMINSQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMINSQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMINSQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINSW(opm256, opymm, opymm)
	ctx.VPMINSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINUB(opm256, opymm, opymm)
	ctx.VPMINUB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINUD(opm256, opymm, opymm)
	ctx.VPMINUD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPMINUD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPMINUD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINUQ(opm128, opxmm, opk, opxmm)
	ctx.VPMINUQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMINUQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMINUQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMINUW(opm256, opymm, opymm)
	ctx.VPMINUW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMOVB2M(opxmm, opk)
	ctx.VPMOVD2M(opxmm, opk)
	ctx.VPMOVDB(opxmm, opk, opm32)
	ctx.VPMOVDB_Z(opxmm, opk, opm32)
	ctx.VPMOVDW(opxmm, opk, opm64)
	ctx.VPMOVDW_Z(opxmm, opk, opm64)
	ctx.VPMOVM2B(opk, opxmm)
	ctx.VPMOVM2D(opk, opxmm)
	ctx.VPMOVM2Q(opk, opxmm)
	ctx.VPMOVM2W(opk, opxmm)
	ctx.VPMOVMSKB(opymm, opr32)
	ctx.VPMOVQ2M(opxmm, opk)
	ctx.VPMOVQB(opxmm, opk, opm16)
	ctx.VPMOVQB_Z(opxmm, opk, opm16)
	ctx.VPMOVQD(opxmm, opk, opm64)
	ctx.VPMOVQD_Z(opxmm, opk, opm64)
	ctx.VPMOVQW(opxmm, opk, opm32)
	ctx.VPMOVQW_Z(opxmm, opk, opm32)
	ctx.VPMOVSDB(opxmm, opk, opm32)
	ctx.VPMOVSDB_Z(opxmm, opk, opm32)
	ctx.VPMOVSDW(opxmm, opk, opm64)
	ctx.VPMOVSDW_Z(opxmm, opk, opm64)
	ctx.VPMOVSQB(opxmm, opk, opm16)
	ctx.VPMOVSQB_Z(opxmm, opk, opm16)
	ctx.VPMOVSQD(opxmm, opk, opm64)
	ctx.VPMOVSQD_Z(opxmm, opk, opm64)
	ctx.VPMOVSQW(opxmm, opk, opm32)
	ctx.VPMOVSQW_Z(opxmm, opk, opm32)
	ctx.VPMOVSWB(opxmm, opk, opm64)
	ctx.VPMOVSWB_Z(opxmm, opk, opm64)
	ctx.VPMOVSXBD(opm64, opymm)
	ctx.VPMOVSXBD_Z(opm32, opk, opxmm)
	ctx.VPMOVSXBQ(opm32, opymm)
	ctx.VPMOVSXBQ_Z(opm16, opk, opxmm)
	ctx.VPMOVSXBW(opm128, opymm)
	ctx.VPMOVSXBW_Z(opm128, opk, opymm)
	ctx.VPMOVSXDQ(opm128, opymm)
	ctx.VPMOVSXDQ_Z(opm128, opk, opymm)
	ctx.VPMOVSXWD(opm128, opymm)
	ctx.VPMOVSXWD_Z(opm128, opk, opymm)
	ctx.VPMOVSXWQ(opm64, opymm)
	ctx.VPMOVSXWQ_Z(opm32, opk, opxmm)
	ctx.VPMOVUSDB(opxmm, opk, opm32)
	ctx.VPMOVUSDB_Z(opxmm, opk, opm32)
	ctx.VPMOVUSDW(opxmm, opk, opm64)
	ctx.VPMOVUSDW_Z(opxmm, opk, opm64)
	ctx.VPMOVUSQB(opxmm, opk, opm16)
	ctx.VPMOVUSQB_Z(opxmm, opk, opm16)
	ctx.VPMOVUSQD(opxmm, opk, opm64)
	ctx.VPMOVUSQD_Z(opxmm, opk, opm64)
	ctx.VPMOVUSQW(opxmm, opk, opm32)
	ctx.VPMOVUSQW_Z(opxmm, opk, opm32)
	ctx.VPMOVUSWB(opxmm, opk, opm64)
	ctx.VPMOVUSWB_Z(opxmm, opk, opm64)
	ctx.VPMOVW2M(opxmm, opk)
	ctx.VPMOVWB(opxmm, opk, opm64)
	ctx.VPMOVWB_Z(opxmm, opk, opm64)
	ctx.VPMOVZXBD(opm64, opymm)
	ctx.VPMOVZXBD_Z(opm32, opk, opxmm)
	ctx.VPMOVZXBQ(opm32, opymm)
	ctx.VPMOVZXBQ_Z(opm16, opk, opxmm)
	ctx.VPMOVZXBW(opm128, opymm)
	ctx.VPMOVZXBW_Z(opm128, opk, opymm)
	ctx.VPMOVZXDQ(opm128, opymm)
	ctx.VPMOVZXDQ_Z(opm128, opk, opymm)
	ctx.VPMOVZXWD(opm128, opymm)
	ctx.VPMOVZXWD_Z(opm128, opk, opymm)
	ctx.VPMOVZXWQ(opm64, opymm)
	ctx.VPMOVZXWQ_Z(opm32, opk, opxmm)
	ctx.VPMULDQ(opm256, opymm, opymm)
	ctx.VPMULDQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMULDQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMULDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULHRSW(opm256, opymm, opymm)
	ctx.VPMULHRSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULHUW(opm256, opymm, opymm)
	ctx.VPMULHUW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULHW(opm256, opymm, opymm)
	ctx.VPMULHW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULLD(opm256, opymm, opymm)
	ctx.VPMULLD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPMULLD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPMULLD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULLQ(opm128, opxmm, opk, opxmm)
	ctx.VPMULLQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMULLQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMULLQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULLW(opm256, opymm, opymm)
	ctx.VPMULLW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULTISHIFTQB(opm128, opxmm, opk, opxmm)
	ctx.VPMULTISHIFTQB_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMULTISHIFTQB_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMULTISHIFTQB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPMULUDQ(opm256, opymm, opymm)
	ctx.VPMULUDQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPMULUDQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPMULUDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPOPCNTB(opm128, opk, opxmm)
	ctx.VPOPCNTB_Z(opm128, opk, opxmm)
	ctx.VPOPCNTD(opm128, opk, opxmm)
	ctx.VPOPCNTD_BCST(opm32, opk, opxmm)
	ctx.VPOPCNTD_BCST_Z(opm32, opk, opxmm)
	ctx.VPOPCNTD_Z(opm128, opk, opxmm)
	ctx.VPOPCNTQ(opm128, opk, opxmm)
	ctx.VPOPCNTQ_BCST(opm64, opk, opxmm)
	ctx.VPOPCNTQ_BCST_Z(opm64, opk, opxmm)
	ctx.VPOPCNTQ_Z(opm128, opk, opxmm)
	ctx.VPOPCNTW(opm128, opk, opxmm)
	ctx.VPOPCNTW_Z(opm128, opk, opxmm)
	ctx.VPOR(opm256, opymm, opymm)
	ctx.VPORD(opm128, opxmm, opk, opxmm)
	ctx.VPORD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPORD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPORD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPORQ(opm128, opxmm, opk, opxmm)
	ctx.VPORQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPORQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPORQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPROLD(opimm8, opm128, opk, opxmm)
	ctx.VPROLD_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPROLD_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPROLD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPROLQ(opimm8, opm128, opk, opxmm)
	ctx.VPROLQ_BCST(opimm8, opm64, opk, opxmm)
	ctx.VPROLQ_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VPROLQ_Z(opimm8, opm128, opk, opxmm)
	ctx.VPROLVD(opm128, opxmm, opk, opxmm)
	ctx.VPROLVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPROLVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPROLVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPROLVQ(opm128, opxmm, opk, opxmm)
	ctx.VPROLVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPROLVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPROLVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPRORD(opimm8, opm128, opk, opxmm)
	ctx.VPRORD_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPRORD_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPRORD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPRORQ(opimm8, opm128, opk, opxmm)
	ctx.VPRORQ_BCST(opimm8, opm64, opk, opxmm)
	ctx.VPRORQ_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VPRORQ_Z(opimm8, opm128, opk, opxmm)
	ctx.VPRORVD(opm128, opxmm, opk, opxmm)
	ctx.VPRORVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPRORVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPRORVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPRORVQ(opm128, opxmm, opk, opxmm)
	ctx.VPRORVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPRORVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPRORVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSADBW(opm256, opymm, opymm)
	ctx.VPSCATTERDD(opxmm, opk, opvm32x)
	ctx.VPSCATTERDQ(opxmm, opk, opvm32x)
	ctx.VPSCATTERQD(opxmm, opk, opvm64x)
	ctx.VPSCATTERQQ(opxmm, opk, opvm64x)
	ctx.VPSHLDD(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHLDD_BCST(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VPSHLDD_BCST_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VPSHLDD_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHLDQ(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHLDQ_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VPSHLDQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VPSHLDQ_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHLDVD(opm128, opxmm, opk, opxmm)
	ctx.VPSHLDVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPSHLDVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPSHLDVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHLDVQ(opm128, opxmm, opk, opxmm)
	ctx.VPSHLDVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPSHLDVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPSHLDVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHLDVW(opm128, opxmm, opk, opxmm)
	ctx.VPSHLDVW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHLDW(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHLDW_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHRDD(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHRDD_BCST(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VPSHRDD_BCST_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VPSHRDD_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHRDQ(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHRDQ_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VPSHRDQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VPSHRDQ_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHRDVD(opm128, opxmm, opk, opxmm)
	ctx.VPSHRDVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPSHRDVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPSHRDVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHRDVQ(opm128, opxmm, opk, opxmm)
	ctx.VPSHRDVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPSHRDVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPSHRDVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHRDVW(opm128, opxmm, opk, opxmm)
	ctx.VPSHRDVW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHRDW(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHRDW_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPSHUFB(opm256, opymm, opymm)
	ctx.VPSHUFBITQMB(opm128, opxmm, opk, opk)
	ctx.VPSHUFB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSHUFD(opimm8, opm256, opymm)
	ctx.VPSHUFD_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPSHUFD_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPSHUFD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSHUFHW(opimm8, opm256, opymm)
	ctx.VPSHUFHW_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSHUFLW(opimm8, opm256, opymm)
	ctx.VPSHUFLW_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSIGNB(opm256, opymm, opymm)
	ctx.VPSIGND(opm256, opymm, opymm)
	ctx.VPSIGNW(opm256, opymm, opymm)
	ctx.VPSLLD(opimm8, opymm, opymm)
	ctx.VPSLLDQ(opimm8, opymm, opymm)
	ctx.VPSLLD_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPSLLD_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPSLLD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSLLQ(opimm8, opymm, opymm)
	ctx.VPSLLQ_BCST(opimm8, opm64, opk, opxmm)
	ctx.VPSLLQ_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VPSLLQ_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSLLVD(opm128, opxmm, opxmm)
	ctx.VPSLLVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPSLLVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPSLLVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSLLVQ(opm128, opxmm, opxmm)
	ctx.VPSLLVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPSLLVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPSLLVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSLLVW(opm128, opxmm, opk, opxmm)
	ctx.VPSLLVW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSLLW(opimm8, opymm, opymm)
	ctx.VPSLLW_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSRAD(opimm8, opymm, opymm)
	ctx.VPSRAD_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPSRAD_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPSRAD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSRAQ(opimm8, opm128, opk, opxmm)
	ctx.VPSRAQ_BCST(opimm8, opm64, opk, opxmm)
	ctx.VPSRAQ_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VPSRAQ_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSRAVD(opm128, opxmm, opxmm)
	ctx.VPSRAVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPSRAVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPSRAVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSRAVQ(opm128, opxmm, opk, opxmm)
	ctx.VPSRAVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPSRAVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPSRAVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSRAVW(opm128, opxmm, opk, opxmm)
	ctx.VPSRAVW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSRAW(opimm8, opymm, opymm)
	ctx.VPSRAW_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSRLD(opimm8, opymm, opymm)
	ctx.VPSRLDQ(opimm8, opymm, opymm)
	ctx.VPSRLD_BCST(opimm8, opm32, opk, opxmm)
	ctx.VPSRLD_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VPSRLD_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSRLQ(opimm8, opymm, opymm)
	ctx.VPSRLQ_BCST(opimm8, opm64, opk, opxmm)
	ctx.VPSRLQ_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VPSRLQ_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSRLVD(opm128, opxmm, opxmm)
	ctx.VPSRLVD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPSRLVD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPSRLVD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSRLVQ(opm128, opxmm, opxmm)
	ctx.VPSRLVQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPSRLVQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPSRLVQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSRLVW(opm128, opxmm, opk, opxmm)
	ctx.VPSRLVW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSRLW(opimm8, opymm, opymm)
	ctx.VPSRLW_Z(opimm8, opm128, opk, opxmm)
	ctx.VPSUBB(opm256, opymm, opymm)
	ctx.VPSUBB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBD(opm256, opymm, opymm)
	ctx.VPSUBD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPSUBD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPSUBD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBQ(opm256, opymm, opymm)
	ctx.VPSUBQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPSUBQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPSUBQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBSB(opm256, opymm, opymm)
	ctx.VPSUBSB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBSW(opm256, opymm, opymm)
	ctx.VPSUBSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBUSB(opm256, opymm, opymm)
	ctx.VPSUBUSB_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBUSW(opm256, opymm, opymm)
	ctx.VPSUBUSW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPSUBW(opm256, opymm, opymm)
	ctx.VPSUBW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPTERNLOGD(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPTERNLOGD_BCST(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VPTERNLOGD_BCST_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VPTERNLOGD_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPTERNLOGQ(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPTERNLOGQ_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VPTERNLOGQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VPTERNLOGQ_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VPTEST(opm128, opxmm)
	ctx.VPTESTMB(opm128, opxmm, opk, opk)
	ctx.VPTESTMD(opm128, opxmm, opk, opk)
	ctx.VPTESTMD_BCST(opm32, opxmm, opk, opk)
	ctx.VPTESTMQ(opm128, opxmm, opk, opk)
	ctx.VPTESTMQ_BCST(opm64, opxmm, opk, opk)
	ctx.VPTESTMW(opm128, opxmm, opk, opk)
	ctx.VPTESTNMB(opm512, opzmm, opk, opk)
	ctx.VPTESTNMD(opm128, opxmm, opk, opk)
	ctx.VPTESTNMD_BCST(opm32, opxmm, opk, opk)
	ctx.VPTESTNMQ(opm128, opxmm, opk, opk)
	ctx.VPTESTNMQ_BCST(opm64, opxmm, opk, opk)
	ctx.VPTESTNMW(opm512, opzmm, opk, opk)
	ctx.VPUNPCKHBW(opm256, opymm, opymm)
	ctx.VPUNPCKHBW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKHDQ(opm256, opymm, opymm)
	ctx.VPUNPCKHDQ_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPUNPCKHDQ_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPUNPCKHDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKHQDQ(opm256, opymm, opymm)
	ctx.VPUNPCKHQDQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPUNPCKHQDQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPUNPCKHQDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKHWD(opm256, opymm, opymm)
	ctx.VPUNPCKHWD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKLBW(opm256, opymm, opymm)
	ctx.VPUNPCKLBW_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKLDQ(opm256, opymm, opymm)
	ctx.VPUNPCKLDQ_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPUNPCKLDQ_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPUNPCKLDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKLQDQ(opm256, opymm, opymm)
	ctx.VPUNPCKLQDQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPUNPCKLQDQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPUNPCKLQDQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VPUNPCKLWD(opm256, opymm, opymm)
	ctx.VPUNPCKLWD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPXOR(opm256, opymm, opymm)
	ctx.VPXORD(opm128, opxmm, opk, opxmm)
	ctx.VPXORD_BCST(opm32, opxmm, opk, opxmm)
	ctx.VPXORD_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VPXORD_Z(opm128, opxmm, opk, opxmm)
	ctx.VPXORQ(opm128, opxmm, opk, opxmm)
	ctx.VPXORQ_BCST(opm64, opxmm, opk, opxmm)
	ctx.VPXORQ_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VPXORQ_Z(opm128, opxmm, opk, opxmm)
	ctx.VRANGEPD(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VRANGEPD_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VRANGEPD_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VRANGEPD_SAE(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VRANGEPD_SAE_Z(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VRANGEPD_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VRANGEPS(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VRANGEPS_BCST(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VRANGEPS_BCST_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VRANGEPS_SAE(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VRANGEPS_SAE_Z(opimm8, opzmm, opzmm, opk, opzmm)
	ctx.VRANGEPS_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VRANGESD(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VRANGESD_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRANGESD_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRANGESD_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VRANGESS(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VRANGESS_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRANGESS_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRANGESS_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VRCP14PD(opm128, opk, opxmm)
	ctx.VRCP14PD_BCST(opm64, opk, opxmm)
	ctx.VRCP14PD_BCST_Z(opm64, opk, opxmm)
	ctx.VRCP14PD_Z(opm128, opk, opxmm)
	ctx.VRCP14PS(opm128, opk, opxmm)
	ctx.VRCP14PS_BCST(opm32, opk, opxmm)
	ctx.VRCP14PS_BCST_Z(opm32, opk, opxmm)
	ctx.VRCP14PS_Z(opm128, opk, opxmm)
	ctx.VRCP14SD(opm64, opxmm, opk, opxmm)
	ctx.VRCP14SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VRCP14SS(opm32, opxmm, opk, opxmm)
	ctx.VRCP14SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VRCP28PD(opm512, opk, opzmm)
	ctx.VRCP28PD_BCST(opm64, opk, opzmm)
	ctx.VRCP28PD_BCST_Z(opm64, opk, opzmm)
	ctx.VRCP28PD_SAE(opzmm, opk, opzmm)
	ctx.VRCP28PD_SAE_Z(opzmm, opk, opzmm)
	ctx.VRCP28PD_Z(opm512, opk, opzmm)
	ctx.VRCP28PS(opm512, opk, opzmm)
	ctx.VRCP28PS_BCST(opm32, opk, opzmm)
	ctx.VRCP28PS_BCST_Z(opm32, opk, opzmm)
	ctx.VRCP28PS_SAE(opzmm, opk, opzmm)
	ctx.VRCP28PS_SAE_Z(opzmm, opk, opzmm)
	ctx.VRCP28PS_Z(opm512, opk, opzmm)
	ctx.VRCP28SD(opm64, opxmm, opk, opxmm)
	ctx.VRCP28SD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VRCP28SD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VRCP28SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VRCP28SS(opm32, opxmm, opk, opxmm)
	ctx.VRCP28SS_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VRCP28SS_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VRCP28SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VRCPPS(opm128, opxmm)
	ctx.VRCPSS(opm32, opxmm, opxmm)
	ctx.VREDUCEPD(opimm8, opm128, opk, opxmm)
	ctx.VREDUCEPD_BCST(opimm8, opm64, opk, opxmm)
	ctx.VREDUCEPD_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VREDUCEPD_Z(opimm8, opm128, opk, opxmm)
	ctx.VREDUCEPS(opimm8, opm128, opk, opxmm)
	ctx.VREDUCEPS_BCST(opimm8, opm32, opk, opxmm)
	ctx.VREDUCEPS_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VREDUCEPS_Z(opimm8, opm128, opk, opxmm)
	ctx.VREDUCESD(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VREDUCESD_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VREDUCESS(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VREDUCESS_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VRNDSCALEPD(opimm8, opm128, opk, opxmm)
	ctx.VRNDSCALEPD_BCST(opimm8, opm64, opk, opxmm)
	ctx.VRNDSCALEPD_BCST_Z(opimm8, opm64, opk, opxmm)
	ctx.VRNDSCALEPD_SAE(opimm8, opzmm, opk, opzmm)
	ctx.VRNDSCALEPD_SAE_Z(opimm8, opzmm, opk, opzmm)
	ctx.VRNDSCALEPD_Z(opimm8, opm128, opk, opxmm)
	ctx.VRNDSCALEPS(opimm8, opm128, opk, opxmm)
	ctx.VRNDSCALEPS_BCST(opimm8, opm32, opk, opxmm)
	ctx.VRNDSCALEPS_BCST_Z(opimm8, opm32, opk, opxmm)
	ctx.VRNDSCALEPS_SAE(opimm8, opzmm, opk, opzmm)
	ctx.VRNDSCALEPS_SAE_Z(opimm8, opzmm, opk, opzmm)
	ctx.VRNDSCALEPS_Z(opimm8, opm128, opk, opxmm)
	ctx.VRNDSCALESD(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VRNDSCALESD_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRNDSCALESD_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRNDSCALESD_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VRNDSCALESS(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VRNDSCALESS_SAE(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRNDSCALESS_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm)
	ctx.VRNDSCALESS_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VROUNDPD(opimm8, opm128, opxmm)
	ctx.VROUNDPS(opimm8, opm128, opxmm)
	ctx.VROUNDSD(opimm8, opm64, opxmm, opxmm)
	ctx.VROUNDSS(opimm8, opm32, opxmm, opxmm)
	ctx.VRSQRT14PD(opm128, opk, opxmm)
	ctx.VRSQRT14PD_BCST(opm64, opk, opxmm)
	ctx.VRSQRT14PD_BCST_Z(opm64, opk, opxmm)
	ctx.VRSQRT14PD_Z(opm128, opk, opxmm)
	ctx.VRSQRT14PS(opm128, opk, opxmm)
	ctx.VRSQRT14PS_BCST(opm32, opk, opxmm)
	ctx.VRSQRT14PS_BCST_Z(opm32, opk, opxmm)
	ctx.VRSQRT14PS_Z(opm128, opk, opxmm)
	ctx.VRSQRT14SD(opm64, opxmm, opk, opxmm)
	ctx.VRSQRT14SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VRSQRT14SS(opm32, opxmm, opk, opxmm)
	ctx.VRSQRT14SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VRSQRT28PD(opm512, opk, opzmm)
	ctx.VRSQRT28PD_BCST(opm64, opk, opzmm)
	ctx.VRSQRT28PD_BCST_Z(opm64, opk, opzmm)
	ctx.VRSQRT28PD_SAE(opzmm, opk, opzmm)
	ctx.VRSQRT28PD_SAE_Z(opzmm, opk, opzmm)
	ctx.VRSQRT28PD_Z(opm512, opk, opzmm)
	ctx.VRSQRT28PS(opm512, opk, opzmm)
	ctx.VRSQRT28PS_BCST(opm32, opk, opzmm)
	ctx.VRSQRT28PS_BCST_Z(opm32, opk, opzmm)
	ctx.VRSQRT28PS_SAE(opzmm, opk, opzmm)
	ctx.VRSQRT28PS_SAE_Z(opzmm, opk, opzmm)
	ctx.VRSQRT28PS_Z(opm512, opk, opzmm)
	ctx.VRSQRT28SD(opm64, opxmm, opk, opxmm)
	ctx.VRSQRT28SD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VRSQRT28SD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VRSQRT28SD_Z(opm64, opxmm, opk, opxmm)
	ctx.VRSQRT28SS(opm32, opxmm, opk, opxmm)
	ctx.VRSQRT28SS_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VRSQRT28SS_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VRSQRT28SS_Z(opm32, opxmm, opk, opxmm)
	ctx.VRSQRTPS(opm128, opxmm)
	ctx.VRSQRTSS(opm32, opxmm, opxmm)
	ctx.VSCALEFPD(opm128, opxmm, opk, opxmm)
	ctx.VSCALEFPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VSCALEFPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VSCALEFPD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VSCALEFPS(opm128, opxmm, opk, opxmm)
	ctx.VSCALEFPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VSCALEFPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VSCALEFPS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSCALEFPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VSCALEFSD(opm64, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VSCALEFSS(opm32, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSCALEFSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VSCATTERDPD(opxmm, opk, opvm32x)
	ctx.VSCATTERDPS(opxmm, opk, opvm32x)
	ctx.VSCATTERQPD(opxmm, opk, opvm64x)
	ctx.VSCATTERQPS(opxmm, opk, opvm64x)
	ctx.VSHUFF32X4(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFF32X4_BCST(opimm8, opm32, opymm, opk, opymm)
	ctx.VSHUFF32X4_BCST_Z(opimm8, opm32, opymm, opk, opymm)
	ctx.VSHUFF32X4_Z(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFF64X2(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFF64X2_BCST(opimm8, opm64, opymm, opk, opymm)
	ctx.VSHUFF64X2_BCST_Z(opimm8, opm64, opymm, opk, opymm)
	ctx.VSHUFF64X2_Z(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFI32X4(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFI32X4_BCST(opimm8, opm32, opymm, opk, opymm)
	ctx.VSHUFI32X4_BCST_Z(opimm8, opm32, opymm, opk, opymm)
	ctx.VSHUFI32X4_Z(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFI64X2(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFI64X2_BCST(opimm8, opm64, opymm, opk, opymm)
	ctx.VSHUFI64X2_BCST_Z(opimm8, opm64, opymm, opk, opymm)
	ctx.VSHUFI64X2_Z(opimm8, opm256, opymm, opk, opymm)
	ctx.VSHUFPD(opimm8, opm128, opxmm, opxmm)
	ctx.VSHUFPD_BCST(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VSHUFPD_BCST_Z(opimm8, opm64, opxmm, opk, opxmm)
	ctx.VSHUFPD_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VSHUFPS(opimm8, opm128, opxmm, opxmm)
	ctx.VSHUFPS_BCST(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VSHUFPS_BCST_Z(opimm8, opm32, opxmm, opk, opxmm)
	ctx.VSHUFPS_Z(opimm8, opm128, opxmm, opk, opxmm)
	ctx.VSQRTPD(opm128, opxmm)
	ctx.VSQRTPD_BCST(opm32, opk, opxmm)
	ctx.VSQRTPD_BCST_Z(opm32, opk, opxmm)
	ctx.VSQRTPD_RD_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPD_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPD_RN_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPD_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPD_RU_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPD_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPD_RZ_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPD_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPD_Z(opm128, opk, opxmm)
	ctx.VSQRTPS(opm128, opxmm)
	ctx.VSQRTPS_BCST(opm32, opk, opxmm)
	ctx.VSQRTPS_BCST_Z(opm32, opk, opxmm)
	ctx.VSQRTPS_RD_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPS_RD_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPS_RN_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPS_RN_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPS_RU_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPS_RU_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPS_RZ_SAE(opzmm, opk, opzmm)
	ctx.VSQRTPS_RZ_SAE_Z(opzmm, opk, opzmm)
	ctx.VSQRTPS_Z(opm128, opk, opxmm)
	ctx.VSQRTSD(opm64, opxmm, opxmm)
	ctx.VSQRTSD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VSQRTSS(opm32, opxmm, opxmm)
	ctx.VSQRTSS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSQRTSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VSTMXCSR(opm32)
	ctx.VSUBPD(opm128, opxmm, opxmm)
	ctx.VSUBPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VSUBPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VSUBPD_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VSUBPS(opm128, opxmm, opxmm)
	ctx.VSUBPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VSUBPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VSUBPS_RD_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RN_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RU_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RZ_SAE(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm)
	ctx.VSUBPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VSUBSD(opm64, opxmm, opxmm)
	ctx.VSUBSD_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSD_Z(opm64, opxmm, opk, opxmm)
	ctx.VSUBSS(opm32, opxmm, opxmm)
	ctx.VSUBSS_RD_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RN_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RU_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RZ_SAE(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm)
	ctx.VSUBSS_Z(opm32, opxmm, opk, opxmm)
	ctx.VTESTPD(opm128, opxmm)
	ctx.VTESTPS(opm128, opxmm)
	ctx.VUCOMISD(opm64, opxmm)
	ctx.VUCOMISD_SAE(opxmm, opxmm)
	ctx.VUCOMISS(opm32, opxmm)
	ctx.VUCOMISS_SAE(opxmm, opxmm)
	ctx.VUNPCKHPD(opm128, opxmm, opxmm)
	ctx.VUNPCKHPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VUNPCKHPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VUNPCKHPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VUNPCKHPS(opm128, opxmm, opxmm)
	ctx.VUNPCKHPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VUNPCKHPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VUNPCKHPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VUNPCKLPD(opm128, opxmm, opxmm)
	ctx.VUNPCKLPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VUNPCKLPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VUNPCKLPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VUNPCKLPS(opm128, opxmm, opxmm)
	ctx.VUNPCKLPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VUNPCKLPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VUNPCKLPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VXORPD(opm128, opxmm, opxmm)
	ctx.VXORPD_BCST(opm64, opxmm, opk, opxmm)
	ctx.VXORPD_BCST_Z(opm64, opxmm, opk, opxmm)
	ctx.VXORPD_Z(opm128, opxmm, opk, opxmm)
	ctx.VXORPS(opm128, opxmm, opxmm)
	ctx.VXORPS_BCST(opm32, opxmm, opk, opxmm)
	ctx.VXORPS_BCST_Z(opm32, opxmm, opk, opxmm)
	ctx.VXORPS_Z(opm128, opxmm, opk, opxmm)
	ctx.VZEROALL()
	ctx.VZEROUPPER()
	ctx.XADDB(opr8, opm8)
	ctx.XADDL(opr32, opm32)
	ctx.XADDQ(opr64, opm64)
	ctx.XADDW(opr16, opm16)
	ctx.XCHGB(opm8, opr8)
	ctx.XCHGL(opeax, opr32)
	ctx.XCHGQ(opm64, opr64)
	ctx.XCHGW(opax, opr16)
	ctx.XGETBV()
	ctx.XLAT()
	ctx.XORB(opimm8, opal)
	ctx.XORL(opimm32, opeax)
	ctx.XORPD(opm128, opxmm)
	ctx.XORPS(opm128, opxmm)
	ctx.XORQ(opimm32, opm64)
	ctx.XORW(opimm16, opax)
	if _, err := ctx.Result(); err != nil {
		t.Fatal(err)
	}
}
