// Code generated by NodeGenerator. DO NOT EDIT.

// Package node is a generated by the generator.
package node

import (
	"sync/atomic"
	"unsafe"
)

// BERW is a cache entry that provide the following features:
//
// 1. Base
//
// 2. Expiration
//
// 3. Refresh
//
// 4. Weight
type BERW[K comparable, V any] struct {
	key           K
	value         V
	prev          *BERW[K, V]
	next          *BERW[K, V]
	prevExp       *BERW[K, V]
	nextExp       *BERW[K, V]
	expiresAt     atomic.Int64
	refreshableAt atomic.Int64
	weight        uint32
	state         atomic.Uint32
	queueType     uint8
}

// NewBERW creates a new BERW.
func NewBERW[K comparable, V any](key K, value V, expiresAt, refreshableAt int64, weight uint32) Node[K, V] {
	n := &BERW[K, V]{
		key:    key,
		value:  value,
		weight: weight,
	}
	n.expiresAt.Store(expiresAt)
	n.refreshableAt.Store(refreshableAt)
	n.state.Store(aliveState)

	return n
}

// CastPointerToBERW casts a pointer to BERW.
func CastPointerToBERW[K comparable, V any](ptr unsafe.Pointer) Node[K, V] {
	return (*BERW[K, V])(ptr)
}

func (n *BERW[K, V]) Key() K {
	return n.key
}

func (n *BERW[K, V]) Value() V {
	return n.value
}

func (n *BERW[K, V]) AsPointer() unsafe.Pointer {
	return unsafe.Pointer(n)
}

func (n *BERW[K, V]) Prev() Node[K, V] {
	return n.prev
}

func (n *BERW[K, V]) SetPrev(v Node[K, V]) {
	if v == nil {
		n.prev = nil
		return
	}
	n.prev = (*BERW[K, V])(v.AsPointer())
}

func (n *BERW[K, V]) Next() Node[K, V] {
	return n.next
}

func (n *BERW[K, V]) SetNext(v Node[K, V]) {
	if v == nil {
		n.next = nil
		return
	}
	n.next = (*BERW[K, V])(v.AsPointer())
}

func (n *BERW[K, V]) PrevExp() Node[K, V] {
	return n.prevExp
}

func (n *BERW[K, V]) SetPrevExp(v Node[K, V]) {
	if v == nil {
		n.prevExp = nil
		return
	}
	n.prevExp = (*BERW[K, V])(v.AsPointer())
}

func (n *BERW[K, V]) NextExp() Node[K, V] {
	return n.nextExp
}

func (n *BERW[K, V]) SetNextExp(v Node[K, V]) {
	if v == nil {
		n.nextExp = nil
		return
	}
	n.nextExp = (*BERW[K, V])(v.AsPointer())
}

func (n *BERW[K, V]) HasExpired(now int64) bool {
	return n.ExpiresAt() <= now
}

func (n *BERW[K, V]) ExpiresAt() int64 {
	return n.expiresAt.Load()
}

func (n *BERW[K, V]) CASExpiresAt(old, new int64) bool {
	return n.expiresAt.CompareAndSwap(old, new)
}

func (n *BERW[K, V]) SetExpiresAt(new int64) {
	n.expiresAt.Store(new)
}

func (n *BERW[K, V]) RefreshableAt() int64 {
	return n.refreshableAt.Load()
}

func (n *BERW[K, V]) CASRefreshableAt(old, new int64) bool {
	return n.refreshableAt.CompareAndSwap(old, new)
}

func (n *BERW[K, V]) SetRefreshableAt(new int64) {
	n.refreshableAt.Store(new)
}

func (n *BERW[K, V]) IsFresh(now int64) bool {
	return n.IsAlive() && n.RefreshableAt() > now
}

func (n *BERW[K, V]) Weight() uint32 {
	return n.weight
}

func (n *BERW[K, V]) IsAlive() bool {
	return n.state.Load() == aliveState
}

func (n *BERW[K, V]) IsRetired() bool {
	return n.state.Load() == retiredState
}

func (n *BERW[K, V]) Retire() {
	n.state.Store(retiredState)
}

func (n *BERW[K, V]) IsDead() bool {
	return n.state.Load() == deadState
}

func (n *BERW[K, V]) Die() {
	n.state.Store(deadState)
}

func (n *BERW[K, V]) GetQueueType() uint8 {
	return n.queueType
}

func (n *BERW[K, V]) SetQueueType(queueType uint8) {
	n.queueType = queueType
}

func (n *BERW[K, V]) InWindow() bool {
	return n.GetQueueType() == InWindowQueue
}

func (n *BERW[K, V]) MakeWindow() {
	n.SetQueueType(InWindowQueue)
}

func (n *BERW[K, V]) InMainProbation() bool {
	return n.GetQueueType() == InMainProbationQueue
}

func (n *BERW[K, V]) MakeMainProbation() {
	n.SetQueueType(InMainProbationQueue)
}

func (n *BERW[K, V]) InMainProtected() bool {
	return n.GetQueueType() == InMainProtectedQueue
}

func (n *BERW[K, V]) MakeMainProtected() {
	n.SetQueueType(InMainProtectedQueue)
}
