// Code generated by tools/cmd/genjwa/main.go. DO NOT EDIT.

package jwa

import (
	"fmt"
	"sort"
	"sync"
)

// CompressionAlgorithm represents the compression algorithms as described in https://tools.ietf.org/html/rfc7518#section-7.3
type CompressionAlgorithm string

// Supported values for CompressionAlgorithm
const (
	Deflate    CompressionAlgorithm = "DEF" // DEFLATE (RFC 1951)
	NoCompress CompressionAlgorithm = ""    // No compression
)

var muCompressionAlgorithms sync.RWMutex
var allCompressionAlgorithms map[CompressionAlgorithm]struct{}
var listCompressionAlgorithm []CompressionAlgorithm

func init() {
	muCompressionAlgorithms.Lock()
	defer muCompressionAlgorithms.Unlock()
	allCompressionAlgorithms = make(map[CompressionAlgorithm]struct{})
	allCompressionAlgorithms[Deflate] = struct{}{}
	allCompressionAlgorithms[NoCompress] = struct{}{}
	rebuildCompressionAlgorithm()
}

// RegisterCompressionAlgorithm registers a new CompressionAlgorithm so that the jwx can properly handle the new value.
// Duplicates will silently be ignored
func RegisterCompressionAlgorithm(v CompressionAlgorithm) {
	muCompressionAlgorithms.Lock()
	defer muCompressionAlgorithms.Unlock()
	if _, ok := allCompressionAlgorithms[v]; !ok {
		allCompressionAlgorithms[v] = struct{}{}
		rebuildCompressionAlgorithm()
	}
}

// UnregisterCompressionAlgorithm unregisters a CompressionAlgorithm from its known database.
// Non-existentn entries will silently be ignored
func UnregisterCompressionAlgorithm(v CompressionAlgorithm) {
	muCompressionAlgorithms.Lock()
	defer muCompressionAlgorithms.Unlock()
	if _, ok := allCompressionAlgorithms[v]; ok {
		delete(allCompressionAlgorithms, v)
		rebuildCompressionAlgorithm()
	}
}

func rebuildCompressionAlgorithm() {
	listCompressionAlgorithm = make([]CompressionAlgorithm, 0, len(allCompressionAlgorithms))
	for v := range allCompressionAlgorithms {
		listCompressionAlgorithm = append(listCompressionAlgorithm, v)
	}
	sort.Slice(listCompressionAlgorithm, func(i, j int) bool {
		return string(listCompressionAlgorithm[i]) < string(listCompressionAlgorithm[j])
	})
}

// CompressionAlgorithms returns a list of all available values for CompressionAlgorithm
func CompressionAlgorithms() []CompressionAlgorithm {
	muCompressionAlgorithms.RLock()
	defer muCompressionAlgorithms.RUnlock()
	return listCompressionAlgorithm
}

// Accept is used when conversion from values given by
// outside sources (such as JSON payloads) is required
func (v *CompressionAlgorithm) Accept(value interface{}) error {
	var tmp CompressionAlgorithm
	if x, ok := value.(CompressionAlgorithm); ok {
		tmp = x
	} else {
		var s string
		switch x := value.(type) {
		case fmt.Stringer:
			s = x.String()
		case string:
			s = x
		default:
			return fmt.Errorf(`invalid type for jwa.CompressionAlgorithm: %T`, value)
		}
		tmp = CompressionAlgorithm(s)
	}
	if _, ok := allCompressionAlgorithms[tmp]; !ok {
		return fmt.Errorf(`invalid jwa.CompressionAlgorithm value`)
	}

	*v = tmp
	return nil
}

// String returns the string representation of a CompressionAlgorithm
func (v CompressionAlgorithm) String() string {
	return string(v)
}
