// DO NOT EDIT: This file is autogenerated via the builtin command.

package pandas

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   40,
				},
				File:   "capitalize_strings_toUpper_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_toUpper = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})))\n\ntest _string_toUpper = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 77,
						Line:   37,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "t_string_toUpper = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "t_string_toUpper",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_toUpper",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   37,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   37,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   37,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   37,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   37,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "({r with _value: strings.toUpper(v: r._value), _time: r._time})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   37,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "{r with _value: strings.toUpper(v: r._value), _time: r._time}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   37,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "_value: strings.toUpper(v: r._value)",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   37,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   37,
																		},
																		File:   "capitalize_strings_toUpper_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   37,
																			},
																			File:   "capitalize_strings_toUpper_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   37,
																			},
																			File:   "capitalize_strings_toUpper_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   37,
																				},
																				File:   "capitalize_strings_toUpper_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 48,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   37,
																				},
																				File:   "capitalize_strings_toUpper_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 50,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   37,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "strings.toUpper(v: r._value)",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   37,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "strings.toUpper",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "capitalize_strings_toUpper_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   37,
																		},
																		File:   "capitalize_strings_toUpper_test.flux",
																		Source: "toUpper",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "toUpper",
															},
														},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   37,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "_time: r._time",
															Start: ast.Position{
																Column: 59,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   37,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 59,
																	Line:   37,
																},
															},
														},
														Name: "_time",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   37,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "r._time",
																Start: ast.Position{
																	Column: 66,
																	Line:   37,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   37,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 66,
																		Line:   37,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 73,
																		Line:   37,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 68,
																		Line:   37,
																	},
																},
															},
															Name: "_time",
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   37,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.toUpper(v: r._value), _time: r._time}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   40,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "_string_toUpper = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "_string_toUpper",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_toUpper",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   40,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   40,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   40,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   40,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "fn: t_string_toUpper",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   40,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "t_string_toUpper",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_toUpper",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   40,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "test _string_toUpper = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "capitalize_strings_toUpper_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   40,
				},
				File:   "cat_strings_joinStr_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_joinStr = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})))\n\ntest _string_joinStr = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 80,
						Line:   37,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "t_string_joinStr = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "t_string_joinStr",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_joinStr",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 80,
							Line:   37,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 80,
								Line:   37,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   37,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   37,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   37,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   37,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "{r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   37,
															},
															File:   "cat_strings_joinStr_test.flux",
															Source: "_value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "cat_strings_joinStr_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   37,
																	},
																	File:   "cat_strings_joinStr_test.flux",
																	Source: "arr: [r._value, \"PLUS\"], v: \"\"",
																	Start: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   37,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "arr: [r._value, \"PLUS\"]",
																		Start: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																			File:   "cat_strings_joinStr_test.flux",
																			Source: "arr",
																			Start: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																		},
																	},
																	Name: "arr",
																},
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   37,
																			},
																			File:   "cat_strings_joinStr_test.flux",
																			Source: "[r._value, \"PLUS\"]",
																			Start: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   37,
																				},
																				File:   "cat_strings_joinStr_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 51,
																					Line:   37,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 52,
																						Line:   37,
																					},
																					File:   "cat_strings_joinStr_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 51,
																						Line:   37,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 59,
																						Line:   37,
																					},
																					File:   "cat_strings_joinStr_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 53,
																						Line:   37,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	}, &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 67,
																					Line:   37,
																				},
																				File:   "cat_strings_joinStr_test.flux",
																				Source: "\"PLUS\"",
																				Start: ast.Position{
																					Column: 61,
																					Line:   37,
																				},
																			},
																		},
																		Value: "PLUS",
																	}},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   37,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "v: \"\"",
																		Start: ast.Position{
																			Column: 70,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 71,
																				Line:   37,
																			},
																			File:   "cat_strings_joinStr_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   37,
																			},
																			File:   "cat_strings_joinStr_test.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 73,
																				Line:   37,
																			},
																		},
																	},
																	Value: "",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   37,
																},
																File:   "cat_strings_joinStr_test.flux",
																Source: "strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   37,
																	},
																	File:   "cat_strings_joinStr_test.flux",
																	Source: "strings.joinStr",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   37,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "joinStr",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "joinStr",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "cat_strings_joinStr_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   37,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   40,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "_string_joinStr = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "_string_joinStr",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_joinStr",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   40,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   40,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   40,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   40,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "fn: t_string_joinStr",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   40,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "t_string_joinStr",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_joinStr",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   40,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "test _string_joinStr = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "cat_strings_joinStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 103,
					Line:   40,
				},
				File:   "center_strings_joinStr_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_center = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})))\n\ntest _string_center = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 98,
						Line:   37,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "t_string_center = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   33,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "t_string_center",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_center",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 98,
							Line:   37,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})))",
						Start: ast.Position{
							Column: 19,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   37,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   37,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   37,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   37,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   37,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "{r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   37,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "_value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\")",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   37,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "arr: [\" \", r._value, \" \"], v: \"\"",
																	Start: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   37,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "arr: [\" \", r._value, \" \"]",
																		Start: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "arr",
																			Start: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																		},
																	},
																	Name: "arr",
																},
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "[\" \", r._value, \" \"]",
																			Start: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   37,
																				},
																				File:   "center_strings_joinStr_test.flux",
																				Source: "\" \"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   37,
																				},
																			},
																		},
																		Value: " ",
																	}, &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   37,
																				},
																				File:   "center_strings_joinStr_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 56,
																					Line:   37,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   37,
																					},
																					File:   "center_strings_joinStr_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   37,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   37,
																					},
																					File:   "center_strings_joinStr_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 58,
																						Line:   37,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	}, &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 69,
																					Line:   37,
																				},
																				File:   "center_strings_joinStr_test.flux",
																				Source: "\" \"",
																				Start: ast.Position{
																					Column: 66,
																					Line:   37,
																				},
																			},
																		},
																		Value: " ",
																	}},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   37,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "v: \"\"",
																		Start: ast.Position{
																			Column: 72,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   37,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 72,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   37,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 75,
																				Line:   37,
																			},
																		},
																	},
																	Value: "",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   37,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\")",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   37,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "strings.joinStr",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   37,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "joinStr",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "joinStr",
															},
														},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 94,
																Line:   37,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "_time: r._time",
															Start: ast.Position{
																Column: 80,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   37,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 80,
																	Line:   37,
																},
															},
														},
														Name: "_time",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 94,
																	Line:   37,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "r._time",
																Start: ast.Position{
																	Column: 87,
																	Line:   37,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 88,
																		Line:   37,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 87,
																		Line:   37,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 94,
																		Line:   37,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 89,
																		Line:   37,
																	},
																},
															},
															Name: "_time",
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 97,
										Line:   37,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   33,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 103,
							Line:   40,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "_string_center = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   39,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "_string_center",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_center",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 103,
								Line:   40,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
							Start: ast.Position{
								Column: 23,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   40,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 102,
										Line:   40,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   40,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "fn: t_string_center",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 101,
												Line:   40,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "t_string_center",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_center",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 103,
						Line:   40,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "test _string_center = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "center_strings_joinStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   48,
				},
				File:   "contains_filter_by_regex_match_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n\"\n\nre = regexp.compile(v: \".*0\")\n\nt_filter_by_regex = (table=<-) =>\ntable\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => (regexp.matchRegexpString(r: re, v: r.name)))\n\ntest _filter_by_regex = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   25,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   25,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   38,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   38,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   40,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "re = regexp.compile(v: \".*0\")",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   40,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   40,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "v: \".*0\"",
							Start: ast.Position{
								Column: 21,
								Line:   40,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   40,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "v: \".*0\"",
								Start: ast.Position{
									Column: 21,
									Line:   40,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   40,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   40,
									},
								},
							},
							Name: "v",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   40,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "\".*0\"",
									Start: ast.Position{
										Column: 24,
										Line:   40,
									},
								},
							},
							Value: ".*0",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   40,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "regexp.compile(v: \".*0\")",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   40,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   40,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   40,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   40,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   40,
								},
							},
						},
						Name: "compile",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   45,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "t_filter_by_regex = (table=<-) =>\ntable\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => (regexp.matchRegexpString(r: re, v: r.name)))",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   42,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "t_filter_by_regex",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "t_filter_by_regex",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   45,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "(table=<-) =>\ntable\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => (regexp.matchRegexpString(r: re, v: r.name)))",
						Start: ast.Position{
							Column: 21,
							Line:   42,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   43,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 1,
										Line:   43,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   44,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "table\n  |> range(start: 2018-05-20T19:53:26Z)",
								Start: ast.Position{
									Column: 1,
									Line:   43,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   44,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "start: 2018-05-20T19:53:26Z",
										Start: ast.Position{
											Column: 12,
											Line:   44,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "start: 2018-05-20T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   44,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   44,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 12,
													Line:   44,
												},
											},
										},
										Name: "start",
									},
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   44,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "2018-05-20T19:53:26Z",
												Start: ast.Position{
													Column: 19,
													Line:   44,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-20T19:53:26Z"),
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   44,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "range(start: 2018-05-20T19:53:26Z)",
									Start: ast.Position{
										Column: 6,
										Line:   44,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   44,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 6,
											Line:   44,
										},
									},
								},
								Name: "range",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   45,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "table\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => (regexp.matchRegexpString(r: re, v: r.name)))",
							Start: ast.Position{
								Column: 1,
								Line:   43,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   45,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "fn: (r) => (regexp.matchRegexpString(r: re, v: r.name))",
									Start: ast.Position{
										Column: 13,
										Line:   45,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   45,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "fn: (r) => (regexp.matchRegexpString(r: re, v: r.name))",
										Start: ast.Position{
											Column: 13,
											Line:   45,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   45,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 13,
												Line:   45,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   45,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "(r) => (regexp.matchRegexpString(r: re, v: r.name))",
											Start: ast.Position{
												Column: 17,
												Line:   45,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   45,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "(regexp.matchRegexpString(r: re, v: r.name))",
												Start: ast.Position{
													Column: 24,
													Line:   45,
												},
											},
										},
										Expression: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   45,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "r: re, v: r.name",
														Start: ast.Position{
															Column: 50,
															Line:   45,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   45,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "r: re",
															Start: ast.Position{
																Column: 50,
																Line:   45,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   45,
																},
																File:   "contains_filter_by_regex_match_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 50,
																	Line:   45,
																},
															},
														},
														Name: "r",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   45,
																},
																File:   "contains_filter_by_regex_match_test.flux",
																Source: "re",
																Start: ast.Position{
																	Column: 53,
																	Line:   45,
																},
															},
														},
														Name: "re",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   45,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "v: r.name",
															Start: ast.Position{
																Column: 57,
																Line:   45,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   45,
																},
																File:   "contains_filter_by_regex_match_test.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 57,
																	Line:   45,
																},
															},
														},
														Name: "v",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   45,
																},
																File:   "contains_filter_by_regex_match_test.flux",
																Source: "r.name",
																Start: ast.Position{
																	Column: 60,
																	Line:   45,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   45,
																	},
																	File:   "contains_filter_by_regex_match_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 60,
																		Line:   45,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   45,
																	},
																	File:   "contains_filter_by_regex_match_test.flux",
																	Source: "name",
																	Start: ast.Position{
																		Column: 62,
																		Line:   45,
																	},
																},
															},
															Name: "name",
														},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   45,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "regexp.matchRegexpString(r: re, v: r.name)",
													Start: ast.Position{
														Column: 25,
														Line:   45,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   45,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "regexp.matchRegexpString",
														Start: ast.Position{
															Column: 25,
															Line:   45,
														},
													},
												},
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   45,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "regexp",
															Start: ast.Position{
																Column: 25,
																Line:   45,
															},
														},
													},
													Name: "regexp",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   45,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "matchRegexpString",
															Start: ast.Position{
																Column: 32,
																Line:   45,
															},
														},
													},
													Name: "matchRegexpString",
												},
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   45,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 18,
													Line:   45,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   45,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 18,
														Line:   45,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   45,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "filter(fn: (r) => (regexp.matchRegexpString(r: re, v: r.name)))",
								Start: ast.Position{
									Column: 6,
									Line:   45,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   45,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 6,
										Line:   45,
									},
								},
							},
							Name: "filter",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   42,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   42,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   42,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   42,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   48,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "_filter_by_regex = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
						Start: ast.Position{
							Column: 6,
							Line:   47,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   47,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "_filter_by_regex",
							Start: ast.Position{
								Column: 6,
								Line:   47,
							},
						},
					},
					Name: "_filter_by_regex",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   48,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
							Start: ast.Position{
								Column: 25,
								Line:   47,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   48,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
								Start: ast.Position{
									Column: 2,
									Line:   48,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   48,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex}",
									Start: ast.Position{
										Column: 3,
										Line:   48,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   48,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   48,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   48,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   48,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   48,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   48,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   48,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   48,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   48,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   48,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   48,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   48,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   48,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   48,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   48,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   48,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   48,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   48,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   48,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   48,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   48,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   48,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   48,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   48,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   48,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   48,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   48,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   48,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   48,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   48,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   48,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   48,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   48,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   48,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   48,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   48,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "fn: t_filter_by_regex",
										Start: ast.Position{
											Column: 82,
											Line:   48,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   48,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   48,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   48,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "t_filter_by_regex",
											Start: ast.Position{
												Column: 86,
												Line:   48,
											},
										},
									},
									Name: "t_filter_by_regex",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   48,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "test _filter_by_regex = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   4,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   4,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "contains_filter_by_regex_match_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 110,
					Line:   42,
				},
				File:   "count_string_countStr_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n\"\n\nt_string_count = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))\n\t)\n\ntest _string_count = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   7,
						},
						File:   "count_string_countStr_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "count_string_countStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   7,
							},
							File:   "count_string_countStr_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   7,
								},
								File:   "count_string_countStr_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   7,
									},
									File:   "count_string_countStr_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   7,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   7,
					},
					File:   "count_string_countStr_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "count_string_countStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "count_string_countStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "count_string_countStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "count_string_countStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   39,
					},
					File:   "count_string_countStr_test.flux",
					Source: "t_string_count = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))\n\t)",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   35,
						},
						File:   "count_string_countStr_test.flux",
						Source: "t_string_count",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "t_string_count",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   39,
						},
						File:   "count_string_countStr_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))\n\t)",
						Start: ast.Position{
							Column: 18,
							Line:   35,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   39,
							},
							File:   "count_string_countStr_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))\n\t)",
							Start: ast.Position{
								Column: 2,
								Line:   36,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   36,
										},
										File:   "count_string_countStr_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   36,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   37,
									},
									File:   "count_string_countStr_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   36,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   37,
											},
											File:   "count_string_countStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   37,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   37,
												},
												File:   "count_string_countStr_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   37,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   37,
													},
													File:   "count_string_countStr_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   37,
													},
													File:   "count_string_countStr_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   37,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   37,
										},
										File:   "count_string_countStr_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   37,
											},
											File:   "count_string_countStr_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   37,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   38,
								},
								File:   "count_string_countStr_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))",
								Start: ast.Position{
									Column: 3,
									Line:   36,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   38,
										},
										File:   "count_string_countStr_test.flux",
										Source: "fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")})",
										Start: ast.Position{
											Column: 10,
											Line:   38,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")})",
											Start: ast.Position{
												Column: 10,
												Line:   38,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   38,
												},
												File:   "count_string_countStr_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   38,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 81,
													Line:   38,
												},
												File:   "count_string_countStr_test.flux",
												Source: "(r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")})",
												Start: ast.Position{
													Column: 14,
													Line:   38,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 81,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "({r with count: strings.countStr(v: r._value, substr: \"n\")})",
													Start: ast.Position{
														Column: 21,
														Line:   38,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   38,
														},
														File:   "count_string_countStr_test.flux",
														Source: "{r with count: strings.countStr(v: r._value, substr: \"n\")}",
														Start: ast.Position{
															Column: 22,
															Line:   38,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 79,
																Line:   38,
															},
															File:   "count_string_countStr_test.flux",
															Source: "count: strings.countStr(v: r._value, substr: \"n\")",
															Start: ast.Position{
																Column: 30,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   38,
																},
																File:   "count_string_countStr_test.flux",
																Source: "count",
																Start: ast.Position{
																	Column: 30,
																	Line:   38,
																},
															},
														},
														Name: "count",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 78,
																		Line:   38,
																	},
																	File:   "count_string_countStr_test.flux",
																	Source: "v: r._value, substr: \"n\"",
																	Start: ast.Position{
																		Column: 54,
																		Line:   38,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   38,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 54,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   38,
																			},
																			File:   "count_string_countStr_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 54,
																				Line:   38,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   38,
																			},
																			File:   "count_string_countStr_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 57,
																				Line:   38,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   38,
																				},
																				File:   "count_string_countStr_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 57,
																					Line:   38,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   38,
																				},
																				File:   "count_string_countStr_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 59,
																					Line:   38,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   38,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "substr: \"n\"",
																		Start: ast.Position{
																			Column: 67,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   38,
																			},
																			File:   "count_string_countStr_test.flux",
																			Source: "substr",
																			Start: ast.Position{
																				Column: 67,
																				Line:   38,
																			},
																		},
																	},
																	Name: "substr",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   38,
																			},
																			File:   "count_string_countStr_test.flux",
																			Source: "\"n\"",
																			Start: ast.Position{
																				Column: 75,
																				Line:   38,
																			},
																		},
																	},
																	Value: "n",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   38,
																},
																File:   "count_string_countStr_test.flux",
																Source: "strings.countStr(v: r._value, substr: \"n\")",
																Start: ast.Position{
																	Column: 37,
																	Line:   38,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   38,
																	},
																	File:   "count_string_countStr_test.flux",
																	Source: "strings.countStr",
																	Start: ast.Position{
																		Column: 37,
																		Line:   38,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   38,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 37,
																			Line:   38,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   38,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "countStr",
																		Start: ast.Position{
																			Column: 45,
																			Line:   38,
																		},
																	},
																},
																Name: "countStr",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   38,
															},
															File:   "count_string_countStr_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   38,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   38,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   38,
														},
														File:   "count_string_countStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   38,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   38,
									},
									File:   "count_string_countStr_test.flux",
									Source: "map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))",
									Start: ast.Position{
										Column: 6,
										Line:   38,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   38,
										},
										File:   "count_string_countStr_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   38,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   35,
							},
							File:   "count_string_countStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   35,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   35,
								},
								File:   "count_string_countStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   35,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   35,
							},
							File:   "count_string_countStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   35,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   42,
						},
						File:   "count_string_countStr_test.flux",
						Source: "_string_count = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
						Start: ast.Position{
							Column: 6,
							Line:   41,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   41,
							},
							File:   "count_string_countStr_test.flux",
							Source: "_string_count",
							Start: ast.Position{
								Column: 6,
								Line:   41,
							},
						},
					},
					Name: "_string_count",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   42,
							},
							File:   "count_string_countStr_test.flux",
							Source: "() =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
							Start: ast.Position{
								Column: 22,
								Line:   41,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   42,
								},
								File:   "count_string_countStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
								Start: ast.Position{
									Column: 10,
									Line:   42,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   42,
									},
									File:   "count_string_countStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count}",
									Start: ast.Position{
										Column: 11,
										Line:   42,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   42,
										},
										File:   "count_string_countStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 12,
											Line:   42,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   42,
											},
											File:   "count_string_countStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 12,
												Line:   42,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   42,
												},
												File:   "count_string_countStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 39,
													Line:   42,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   42,
													},
													File:   "count_string_countStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 39,
														Line:   42,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   42,
														},
														File:   "count_string_countStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 39,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   42,
														},
														File:   "count_string_countStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 44,
															Line:   42,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   42,
											},
											File:   "count_string_countStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 19,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   42,
												},
												File:   "count_string_countStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 19,
													Line:   42,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   42,
													},
													File:   "count_string_countStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 19,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   42,
													},
													File:   "count_string_countStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 27,
														Line:   42,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   42,
										},
										File:   "count_string_countStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 53,
											Line:   42,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   42,
											},
											File:   "count_string_countStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 53,
												Line:   42,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   42,
												},
												File:   "count_string_countStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 75,
													Line:   42,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   42,
													},
													File:   "count_string_countStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 75,
														Line:   42,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   42,
														},
														File:   "count_string_countStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 75,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   42,
														},
														File:   "count_string_countStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 80,
															Line:   42,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   42,
											},
											File:   "count_string_countStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 59,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   42,
												},
												File:   "count_string_countStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 59,
													Line:   42,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   42,
													},
													File:   "count_string_countStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 59,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   42,
													},
													File:   "count_string_countStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 67,
														Line:   42,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   42,
										},
										File:   "count_string_countStr_test.flux",
										Source: "fn: t_string_count",
										Start: ast.Position{
											Column: 90,
											Line:   42,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   42,
											},
											File:   "count_string_countStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 90,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   42,
											},
											File:   "count_string_countStr_test.flux",
											Source: "t_string_count",
											Start: ast.Position{
												Column: 94,
												Line:   42,
											},
										},
									},
									Name: "t_string_count",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   42,
					},
					File:   "count_string_countStr_test.flux",
					Source: "test _string_count = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "count_string_countStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "count_string_countStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   5,
					},
					File:   "count_string_countStr_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   5,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "count_string_countStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "count_string_countStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "count_string_countStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 121,
					Line:   41,
				},
				File:   "endswith_strings_regexp_hasSuffix_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nre = regexp.compile(v: \" \")\n\nt_string_regexp_hasSuffix = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))))\n\ntest _string_regexp_hasSuffix = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   7,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   7,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   7,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   7,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   7,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   7,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   30,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   30,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   32,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "re = regexp.compile(v: \" \")",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   32,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   32,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "v: \" \"",
							Start: ast.Position{
								Column: 21,
								Line:   32,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   32,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "v: \" \"",
								Start: ast.Position{
									Column: 21,
									Line:   32,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   32,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   32,
									},
								},
							},
							Name: "v",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   32,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "\" \"",
									Start: ast.Position{
										Column: 24,
										Line:   32,
									},
								},
							},
							Value: " ",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   32,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "regexp.compile(v: \" \")",
						Start: ast.Position{
							Column: 6,
							Line:   32,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   32,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   32,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   32,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   32,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   32,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   32,
								},
							},
						},
						Name: "compile",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   38,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "t_string_regexp_hasSuffix = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   34,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "t_string_regexp_hasSuffix",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_string_regexp_hasSuffix",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   38,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))))",
						Start: ast.Position{
							Column: 29,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   38,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   38,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   38,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))",
										Start: ast.Position{
											Column: 13,
											Line:   37,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   38,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))",
											Start: ast.Position{
												Column: 13,
												Line:   37,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   37,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 13,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   38,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "(r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))",
												Start: ast.Position{
													Column: 17,
													Line:   37,
												},
											},
										},
										Body: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   38,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))",
														Start: ast.Position{
															Column: 49,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   37,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "r: re",
															Start: ast.Position{
																Column: 49,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   37,
																},
																File:   "endswith_strings_regexp_hasSuffix_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 49,
																	Line:   37,
																},
															},
														},
														Name: "r",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   37,
																},
																File:   "endswith_strings_regexp_hasSuffix_test.flux",
																Source: "re",
																Start: ast.Position{
																	Column: 52,
																	Line:   37,
																},
															},
														},
														Name: "re",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 107,
																Line:   38,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))",
															Start: ast.Position{
																Column: 56,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   37,
																},
																File:   "endswith_strings_regexp_hasSuffix_test.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 56,
																	Line:   37,
																},
															},
														},
														Name: "v",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 106,
																		Line:   38,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)",
																	Start: ast.Position{
																		Column: 21,
																		Line:   38,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   38,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 21,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 22,
																				Line:   38,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 21,
																				Line:   38,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 32,
																				Line:   38,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 24,
																				Line:   38,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 25,
																					Line:   38,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 24,
																					Line:   38,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 32,
																					Line:   38,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 26,
																					Line:   38,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   38,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "start: strings.strlen(v: r._value) - 1",
																		Start: ast.Position{
																			Column: 34,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   38,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "start",
																			Start: ast.Position{
																				Column: 34,
																				Line:   38,
																			},
																		},
																	},
																	Name: "start",
																},
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 72,
																				Line:   38,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "strings.strlen(v: r._value) - 1",
																			Start: ast.Position{
																				Column: 41,
																				Line:   38,
																			},
																		},
																	},
																	Left: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 67,
																						Line:   38,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "v: r._value",
																					Start: ast.Position{
																						Column: 56,
																						Line:   38,
																					},
																				},
																			},
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 67,
																							Line:   38,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "v: r._value",
																						Start: ast.Position{
																							Column: 56,
																							Line:   38,
																						},
																					},
																				},
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 57,
																								Line:   38,
																							},
																							File:   "endswith_strings_regexp_hasSuffix_test.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 56,
																								Line:   38,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 67,
																								Line:   38,
																							},
																							File:   "endswith_strings_regexp_hasSuffix_test.flux",
																							Source: "r._value",
																							Start: ast.Position{
																								Column: 59,
																								Line:   38,
																							},
																						},
																					},
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 60,
																									Line:   38,
																								},
																								File:   "endswith_strings_regexp_hasSuffix_test.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 59,
																									Line:   38,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 67,
																									Line:   38,
																								},
																								File:   "endswith_strings_regexp_hasSuffix_test.flux",
																								Source: "_value",
																								Start: ast.Position{
																									Column: 61,
																									Line:   38,
																								},
																							},
																						},
																						Name: "_value",
																					},
																				},
																			}},
																			With: nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   38,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "strings.strlen(v: r._value)",
																				Start: ast.Position{
																					Column: 41,
																					Line:   38,
																				},
																			},
																		},
																		Callee: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 55,
																						Line:   38,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "strings.strlen",
																					Start: ast.Position{
																						Column: 41,
																						Line:   38,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 48,
																							Line:   38,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "strings",
																						Start: ast.Position{
																							Column: 41,
																							Line:   38,
																						},
																					},
																				},
																				Name: "strings",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 55,
																							Line:   38,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "strlen",
																						Start: ast.Position{
																							Column: 49,
																							Line:   38,
																						},
																					},
																				},
																				Name: "strlen",
																			},
																		},
																	},
																	Operator: 6,
																	Right: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 72,
																					Line:   38,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "1",
																				Start: ast.Position{
																					Column: 71,
																					Line:   38,
																				},
																			},
																		},
																		Value: int64(1),
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 106,
																			Line:   38,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "end: strings.strlen(v: r._value)",
																		Start: ast.Position{
																			Column: 74,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   38,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "end",
																			Start: ast.Position{
																				Column: 74,
																				Line:   38,
																			},
																		},
																	},
																	Name: "end",
																},
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 105,
																					Line:   38,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 94,
																					Line:   38,
																				},
																			},
																		},
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 105,
																						Line:   38,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "v: r._value",
																					Start: ast.Position{
																						Column: 94,
																						Line:   38,
																					},
																				},
																			},
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 95,
																							Line:   38,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 94,
																							Line:   38,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 105,
																							Line:   38,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 97,
																							Line:   38,
																						},
																					},
																				},
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 98,
																								Line:   38,
																							},
																							File:   "endswith_strings_regexp_hasSuffix_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 97,
																								Line:   38,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 105,
																								Line:   38,
																							},
																							File:   "endswith_strings_regexp_hasSuffix_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 99,
																								Line:   38,
																							},
																						},
																					},
																					Name: "_value",
																				},
																			},
																		}},
																		With: nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 106,
																				Line:   38,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "strings.strlen(v: r._value)",
																			Start: ast.Position{
																				Column: 79,
																				Line:   38,
																			},
																		},
																	},
																	Callee: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 93,
																					Line:   38,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "strings.strlen",
																				Start: ast.Position{
																					Column: 79,
																					Line:   38,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 86,
																						Line:   38,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "strings",
																					Start: ast.Position{
																						Column: 79,
																						Line:   38,
																					},
																				},
																			},
																			Name: "strings",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 93,
																						Line:   38,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "strlen",
																					Start: ast.Position{
																						Column: 87,
																						Line:   38,
																					},
																				},
																			},
																			Name: "strlen",
																		},
																	},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 107,
																	Line:   38,
																},
																File:   "endswith_strings_regexp_hasSuffix_test.flux",
																Source: "strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))",
																Start: ast.Position{
																	Column: 3,
																	Line:   38,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 20,
																		Line:   38,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "strings.substring",
																	Start: ast.Position{
																		Column: 3,
																		Line:   38,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 10,
																			Line:   38,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 3,
																			Line:   38,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 20,
																			Line:   38,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "substring",
																		Start: ast.Position{
																			Column: 11,
																			Line:   38,
																		},
																	},
																},
																Name: "substring",
															},
														},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   38,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)))",
													Start: ast.Position{
														Column: 24,
														Line:   37,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   37,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "regexp.matchRegexpString",
														Start: ast.Position{
															Column: 24,
															Line:   37,
														},
													},
												},
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   37,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "regexp",
															Start: ast.Position{
																Column: 24,
																Line:   37,
															},
														},
													},
													Name: "regexp",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   37,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "matchRegexpString",
															Start: ast.Position{
																Column: 31,
																Line:   37,
															},
														},
													},
													Name: "matchRegexpString",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   37,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 18,
														Line:   37,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   37,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 18,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   38,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "filter(fn: (r) => regexp.matchRegexpString(r: re, v:\n\t\tstrings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   37,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "filter",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   34,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 30,
								Line:   34,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   34,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 30,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   34,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 36,
								Line:   34,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 121,
							Line:   41,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "_string_regexp_hasSuffix = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   40,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "_string_regexp_hasSuffix",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_string_regexp_hasSuffix",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 121,
								Line:   41,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "() =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
							Start: ast.Position{
								Column: 33,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   41,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
								Start: ast.Position{
									Column: 10,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 120,
										Line:   41,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix}",
									Start: ast.Position{
										Column: 11,
										Line:   41,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   41,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 39,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 39,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 39,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 44,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 19,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 19,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 27,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   41,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 53,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 53,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 75,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 75,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 75,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 80,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 59,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 59,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 67,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 119,
											Line:   41,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "fn: t_string_regexp_hasSuffix",
										Start: ast.Position{
											Column: 90,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 90,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 119,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "t_string_regexp_hasSuffix",
											Start: ast.Position{
												Column: 94,
												Line:   41,
											},
										},
									},
									Name: "t_string_regexp_hasSuffix",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 121,
						Line:   41,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "test _string_regexp_hasSuffix = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   5,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   5,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "endswith_strings_regexp_hasSuffix_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   44,
				},
				File:   "extract_regexp_findStringIndex_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n\"\n\nre = regexp.compile(v: \"[[:alpha:]]{1}\")\n\nt_string_extract = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))\n\t)\n\ntest _string_extract = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   7,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   7,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   7,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   7,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   7,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   7,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   35,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "re = regexp.compile(v: \"[[:alpha:]]{1}\")",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   35,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   35,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "v: \"[[:alpha:]]{1}\"",
							Start: ast.Position{
								Column: 21,
								Line:   35,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   35,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "v: \"[[:alpha:]]{1}\"",
								Start: ast.Position{
									Column: 21,
									Line:   35,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   35,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   35,
									},
								},
							},
							Name: "v",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "\"[[:alpha:]]{1}\"",
									Start: ast.Position{
										Column: 24,
										Line:   35,
									},
								},
							},
							Value: "[[:alpha:]]{1}",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   35,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "regexp.compile(v: \"[[:alpha:]]{1}\")",
						Start: ast.Position{
							Column: 6,
							Line:   35,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   35,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   35,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   35,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   35,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   35,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   35,
								},
							},
						},
						Name: "compile",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   41,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "t_string_extract = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))\n\t)",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   37,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "t_string_extract",
						Start: ast.Position{
							Column: 1,
							Line:   37,
						},
					},
				},
				Name: "t_string_extract",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   41,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))\n\t)",
						Start: ast.Position{
							Column: 20,
							Line:   37,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   41,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))\n\t)",
							Start: ast.Position{
								Column: 2,
								Line:   38,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   38,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   38,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   39,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   38,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   39,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   39,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   39,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   39,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   39,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   39,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   39,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   39,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   40,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))",
								Start: ast.Position{
									Column: 3,
									Line:   38,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 87,
											Line:   40,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
										Start: ast.Position{
											Column: 10,
											Line:   40,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   40,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
											Start: ast.Position{
												Column: 10,
												Line:   40,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   40,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   40,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   40,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "(r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
												Start: ast.Position{
													Column: 14,
													Line:   40,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   40,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
													Start: ast.Position{
														Column: 21,
														Line:   40,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 86,
															Line:   40,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "{r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}",
														Start: ast.Position{
															Column: 22,
															Line:   40,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   40,
															},
															File:   "extract_regexp_findStringIndex_test.flux",
															Source: "extract0: regexp.findStringIndex(r: re, v: r._value)[0]",
															Start: ast.Position{
																Column: 30,
																Line:   40,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   40,
																},
																File:   "extract_regexp_findStringIndex_test.flux",
																Source: "extract0",
																Start: ast.Position{
																	Column: 30,
																	Line:   40,
																},
															},
														},
														Name: "extract0",
													},
													Value: &ast.IndexExpression{
														Array: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   40,
																		},
																		File:   "extract_regexp_findStringIndex_test.flux",
																		Source: "r: re, v: r._value",
																		Start: ast.Position{
																			Column: 63,
																			Line:   40,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   40,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "r: re",
																			Start: ast.Position{
																				Column: 63,
																				Line:   40,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   40,
																				},
																				File:   "extract_regexp_findStringIndex_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 63,
																					Line:   40,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Value: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   40,
																				},
																				File:   "extract_regexp_findStringIndex_test.flux",
																				Source: "re",
																				Start: ast.Position{
																					Column: 66,
																					Line:   40,
																				},
																			},
																		},
																		Name: "re",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 81,
																				Line:   40,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 70,
																				Line:   40,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 71,
																					Line:   40,
																				},
																				File:   "extract_regexp_findStringIndex_test.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 70,
																					Line:   40,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 81,
																					Line:   40,
																				},
																				File:   "extract_regexp_findStringIndex_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 73,
																					Line:   40,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 74,
																						Line:   40,
																					},
																					File:   "extract_regexp_findStringIndex_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 73,
																						Line:   40,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 81,
																						Line:   40,
																					},
																					File:   "extract_regexp_findStringIndex_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 75,
																						Line:   40,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 82,
																		Line:   40,
																	},
																	File:   "extract_regexp_findStringIndex_test.flux",
																	Source: "regexp.findStringIndex(r: re, v: r._value)",
																	Start: ast.Position{
																		Column: 40,
																		Line:   40,
																	},
																},
															},
															Callee: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   40,
																		},
																		File:   "extract_regexp_findStringIndex_test.flux",
																		Source: "regexp.findStringIndex",
																		Start: ast.Position{
																			Column: 40,
																			Line:   40,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   40,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "regexp",
																			Start: ast.Position{
																				Column: 40,
																				Line:   40,
																			},
																		},
																	},
																	Name: "regexp",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   40,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "findStringIndex",
																			Start: ast.Position{
																				Column: 47,
																				Line:   40,
																			},
																		},
																	},
																	Name: "findStringIndex",
																},
															},
														},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   40,
																},
																File:   "extract_regexp_findStringIndex_test.flux",
																Source: "regexp.findStringIndex(r: re, v: r._value)[0]",
																Start: ast.Position{
																	Column: 40,
																	Line:   40,
																},
															},
														},
														Index: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 84,
																		Line:   40,
																	},
																	File:   "extract_regexp_findStringIndex_test.flux",
																	Source: "0",
																	Start: ast.Position{
																		Column: 83,
																		Line:   40,
																	},
																},
															},
															Value: int64(0),
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   40,
															},
															File:   "extract_regexp_findStringIndex_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   40,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   40,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   40,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   40,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   40,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))",
									Start: ast.Position{
										Column: 6,
										Line:   40,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   40,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   40,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   37,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   37,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   37,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   37,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   37,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   37,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   44,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "_string_extract = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
						Start: ast.Position{
							Column: 6,
							Line:   43,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   43,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "_string_extract",
							Start: ast.Position{
								Column: 6,
								Line:   43,
							},
						},
					},
					Name: "_string_extract",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   44,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "() =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
							Start: ast.Position{
								Column: 24,
								Line:   43,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   44,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
								Start: ast.Position{
									Column: 10,
									Line:   44,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   44,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract}",
									Start: ast.Position{
										Column: 11,
										Line:   44,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   44,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 12,
											Line:   44,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   44,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 12,
												Line:   44,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   44,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 39,
													Line:   44,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   44,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 39,
														Line:   44,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   44,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 39,
															Line:   44,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   44,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 44,
															Line:   44,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   44,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 19,
												Line:   44,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   44,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 19,
													Line:   44,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   44,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 19,
														Line:   44,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   44,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 27,
														Line:   44,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   44,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 53,
											Line:   44,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   44,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 53,
												Line:   44,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   44,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 75,
													Line:   44,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   44,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 75,
														Line:   44,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   44,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 75,
															Line:   44,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   44,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 80,
															Line:   44,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   44,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 59,
												Line:   44,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   44,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 59,
													Line:   44,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   44,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 59,
														Line:   44,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   44,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 67,
														Line:   44,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   44,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "fn: t_string_extract",
										Start: ast.Position{
											Column: 90,
											Line:   44,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   44,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 90,
												Line:   44,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   44,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "t_string_extract",
											Start: ast.Position{
												Column: 94,
												Line:   44,
											},
										},
									},
									Name: "t_string_extract",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   44,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "test _string_extract = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   5,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   5,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "extract_regexp_findStringIndex_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   44,
				},
				File:   "extract_regexp_findString_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n\"\n\nre = regexp.compile(v: \"[[:alpha:]]{1}\")\n\nt_string_extract = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))\n\t)\n\ntest _string_extract = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   7,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   7,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   7,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   7,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   7,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   7,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   35,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "re = regexp.compile(v: \"[[:alpha:]]{1}\")",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   35,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   35,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "v: \"[[:alpha:]]{1}\"",
							Start: ast.Position{
								Column: 21,
								Line:   35,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   35,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "v: \"[[:alpha:]]{1}\"",
								Start: ast.Position{
									Column: 21,
									Line:   35,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   35,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   35,
									},
								},
							},
							Name: "v",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "\"[[:alpha:]]{1}\"",
									Start: ast.Position{
										Column: 24,
										Line:   35,
									},
								},
							},
							Value: "[[:alpha:]]{1}",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   35,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "regexp.compile(v: \"[[:alpha:]]{1}\")",
						Start: ast.Position{
							Column: 6,
							Line:   35,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   35,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   35,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   35,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   35,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   35,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   35,
								},
							},
						},
						Name: "compile",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   41,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "t_string_extract = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))\n\t)",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   37,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "t_string_extract",
						Start: ast.Position{
							Column: 1,
							Line:   37,
						},
					},
				},
				Name: "t_string_extract",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   41,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))\n\t)",
						Start: ast.Position{
							Column: 20,
							Line:   37,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   41,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))\n\t)",
							Start: ast.Position{
								Column: 2,
								Line:   38,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   38,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   38,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   39,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   38,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   39,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   39,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   39,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   39,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   39,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   39,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   39,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   39,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   40,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))",
								Start: ast.Position{
									Column: 3,
									Line:   38,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   40,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)})",
										Start: ast.Position{
											Column: 10,
											Line:   40,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   40,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)})",
											Start: ast.Position{
												Column: 10,
												Line:   40,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   40,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   40,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   40,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "(r) => ({r with extract: regexp.findString(r: re, v: r._value)})",
												Start: ast.Position{
													Column: 14,
													Line:   40,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   40,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "({r with extract: regexp.findString(r: re, v: r._value)})",
													Start: ast.Position{
														Column: 21,
														Line:   40,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   40,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "{r with extract: regexp.findString(r: re, v: r._value)}",
														Start: ast.Position{
															Column: 22,
															Line:   40,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   40,
															},
															File:   "extract_regexp_findString_test.flux",
															Source: "extract: regexp.findString(r: re, v: r._value)",
															Start: ast.Position{
																Column: 30,
																Line:   40,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   40,
																},
																File:   "extract_regexp_findString_test.flux",
																Source: "extract",
																Start: ast.Position{
																	Column: 30,
																	Line:   40,
																},
															},
														},
														Name: "extract",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   40,
																	},
																	File:   "extract_regexp_findString_test.flux",
																	Source: "r: re, v: r._value",
																	Start: ast.Position{
																		Column: 57,
																		Line:   40,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   40,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "r: re",
																		Start: ast.Position{
																			Column: 57,
																			Line:   40,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   40,
																			},
																			File:   "extract_regexp_findString_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 57,
																				Line:   40,
																			},
																		},
																	},
																	Name: "r",
																},
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   40,
																			},
																			File:   "extract_regexp_findString_test.flux",
																			Source: "re",
																			Start: ast.Position{
																				Column: 60,
																				Line:   40,
																			},
																		},
																	},
																	Name: "re",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   40,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 64,
																			Line:   40,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   40,
																			},
																			File:   "extract_regexp_findString_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 64,
																				Line:   40,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   40,
																			},
																			File:   "extract_regexp_findString_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 67,
																				Line:   40,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   40,
																				},
																				File:   "extract_regexp_findString_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 67,
																					Line:   40,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 75,
																					Line:   40,
																				},
																				File:   "extract_regexp_findString_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 69,
																					Line:   40,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   40,
																},
																File:   "extract_regexp_findString_test.flux",
																Source: "regexp.findString(r: re, v: r._value)",
																Start: ast.Position{
																	Column: 39,
																	Line:   40,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   40,
																	},
																	File:   "extract_regexp_findString_test.flux",
																	Source: "regexp.findString",
																	Start: ast.Position{
																		Column: 39,
																		Line:   40,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   40,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "regexp",
																		Start: ast.Position{
																			Column: 39,
																			Line:   40,
																		},
																	},
																},
																Name: "regexp",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   40,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "findString",
																		Start: ast.Position{
																			Column: 46,
																			Line:   40,
																		},
																	},
																},
																Name: "findString",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   40,
															},
															File:   "extract_regexp_findString_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   40,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   40,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   40,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   40,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   40,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))",
									Start: ast.Position{
										Column: 6,
										Line:   40,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   40,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   40,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   37,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   37,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   37,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   37,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   37,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   37,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   44,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "_string_extract = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
						Start: ast.Position{
							Column: 6,
							Line:   43,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   43,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "_string_extract",
							Start: ast.Position{
								Column: 6,
								Line:   43,
							},
						},
					},
					Name: "_string_extract",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   44,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "() =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
							Start: ast.Position{
								Column: 24,
								Line:   43,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   44,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
								Start: ast.Position{
									Column: 10,
									Line:   44,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   44,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract}",
									Start: ast.Position{
										Column: 11,
										Line:   44,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   44,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 12,
											Line:   44,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   44,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 12,
												Line:   44,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   44,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 39,
													Line:   44,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   44,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 39,
														Line:   44,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   44,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 39,
															Line:   44,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   44,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 44,
															Line:   44,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   44,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 19,
												Line:   44,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   44,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 19,
													Line:   44,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   44,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 19,
														Line:   44,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   44,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 27,
														Line:   44,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   44,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 53,
											Line:   44,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   44,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 53,
												Line:   44,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   44,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 75,
													Line:   44,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   44,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 75,
														Line:   44,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   44,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 75,
															Line:   44,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   44,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 80,
															Line:   44,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   44,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 59,
												Line:   44,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   44,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 59,
													Line:   44,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   44,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 59,
														Line:   44,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   44,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 67,
														Line:   44,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   44,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "fn: t_string_extract",
										Start: ast.Position{
											Column: 90,
											Line:   44,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   44,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 90,
												Line:   44,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   44,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "t_string_extract",
											Start: ast.Position{
												Column: 94,
												Line:   44,
											},
										},
									},
									Name: "t_string_extract",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   44,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "test _string_extract = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   5,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   5,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "extract_regexp_findString_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 103,
					Line:   41,
				},
				File:   "get_strings_substring_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_subset = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})))\n\ntest _string_subset = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "get_strings_substring_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "get_strings_substring_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "get_strings_substring_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "get_strings_substring_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "get_strings_substring_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "get_strings_substring_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "get_strings_substring_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "get_strings_substring_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "get_strings_substring_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "get_strings_substring_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   38,
					},
					File:   "get_strings_substring_test.flux",
					Source: "t_string_subset = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   34,
						},
						File:   "get_strings_substring_test.flux",
						Source: "t_string_subset",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_string_subset",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   38,
						},
						File:   "get_strings_substring_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})))",
						Start: ast.Position{
							Column: 19,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   38,
							},
							File:   "get_strings_substring_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "get_strings_substring_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "get_strings_substring_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "get_strings_substring_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "get_strings_substring_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "get_strings_substring_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "get_strings_substring_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "get_strings_substring_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "get_strings_substring_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   38,
								},
								File:   "get_strings_substring_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   38,
										},
										File:   "get_strings_substring_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   38,
											},
											File:   "get_strings_substring_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "get_strings_substring_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   38,
												},
												File:   "get_strings_substring_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   38,
													},
													File:   "get_strings_substring_test.flux",
													Source: "({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
													Start: ast.Position{
														Column: 12,
														Line:   38,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   38,
														},
														File:   "get_strings_substring_test.flux",
														Source: "{r with _value: strings.substring(v: r._value, start: 0, end: 1)}",
														Start: ast.Position{
															Column: 13,
															Line:   38,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   38,
															},
															File:   "get_strings_substring_test.flux",
															Source: "_value: strings.substring(v: r._value, start: 0, end: 1)",
															Start: ast.Position{
																Column: 21,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   38,
																},
																File:   "get_strings_substring_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   38,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   38,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "v: r._value, start: 0, end: 1",
																	Start: ast.Position{
																		Column: 47,
																		Line:   38,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   38,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 47,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   38,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 47,
																				Line:   38,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   38,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 50,
																				Line:   38,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   38,
																				},
																				File:   "get_strings_substring_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 50,
																					Line:   38,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   38,
																				},
																				File:   "get_strings_substring_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 52,
																					Line:   38,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   38,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "start: 0",
																		Start: ast.Position{
																			Column: 60,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   38,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "start",
																			Start: ast.Position{
																				Column: 60,
																				Line:   38,
																			},
																		},
																	},
																	Name: "start",
																},
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   38,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "0",
																			Start: ast.Position{
																				Column: 67,
																				Line:   38,
																			},
																		},
																	},
																	Value: int64(0),
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   38,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "end: 1",
																		Start: ast.Position{
																			Column: 70,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   38,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "end",
																			Start: ast.Position{
																				Column: 70,
																				Line:   38,
																			},
																		},
																	},
																	Name: "end",
																},
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 76,
																				Line:   38,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "1",
																			Start: ast.Position{
																				Column: 75,
																				Line:   38,
																			},
																		},
																	},
																	Value: int64(1),
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   38,
																},
																File:   "get_strings_substring_test.flux",
																Source: "strings.substring(v: r._value, start: 0, end: 1)",
																Start: ast.Position{
																	Column: 29,
																	Line:   38,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   38,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "strings.substring",
																	Start: ast.Position{
																		Column: 29,
																		Line:   38,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   38,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   38,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   38,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "substring",
																		Start: ast.Position{
																			Column: 37,
																			Line:   38,
																		},
																	},
																},
																Name: "substring",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   38,
															},
															File:   "get_strings_substring_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   38,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "get_strings_substring_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   38,
									},
									File:   "get_strings_substring_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "get_strings_substring_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   34,
							},
							File:   "get_strings_substring_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   34,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   34,
								},
								File:   "get_strings_substring_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   34,
							},
							File:   "get_strings_substring_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   34,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 103,
							Line:   41,
						},
						File:   "get_strings_substring_test.flux",
						Source: "_string_subset = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   40,
							},
							File:   "get_strings_substring_test.flux",
							Source: "_string_subset",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_string_subset",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 103,
								Line:   41,
							},
							File:   "get_strings_substring_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
							Start: ast.Position{
								Column: 23,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   41,
								},
								File:   "get_strings_substring_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
								Start: ast.Position{
									Column: 2,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 102,
										Line:   41,
									},
									File:   "get_strings_substring_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset}",
									Start: ast.Position{
										Column: 3,
										Line:   41,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   41,
										},
										File:   "get_strings_substring_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   41,
											},
											File:   "get_strings_substring_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   41,
												},
												File:   "get_strings_substring_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   41,
													},
													File:   "get_strings_substring_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   41,
														},
														File:   "get_strings_substring_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "get_strings_substring_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   41,
											},
											File:   "get_strings_substring_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   41,
												},
												File:   "get_strings_substring_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   41,
													},
													File:   "get_strings_substring_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   41,
													},
													File:   "get_strings_substring_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   41,
										},
										File:   "get_strings_substring_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   41,
											},
											File:   "get_strings_substring_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   41,
												},
												File:   "get_strings_substring_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   41,
													},
													File:   "get_strings_substring_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   41,
														},
														File:   "get_strings_substring_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   41,
														},
														File:   "get_strings_substring_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   41,
											},
											File:   "get_strings_substring_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   41,
												},
												File:   "get_strings_substring_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   41,
													},
													File:   "get_strings_substring_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   41,
													},
													File:   "get_strings_substring_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   41,
										},
										File:   "get_strings_substring_test.flux",
										Source: "fn: t_string_subset",
										Start: ast.Position{
											Column: 82,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   41,
											},
											File:   "get_strings_substring_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 101,
												Line:   41,
											},
											File:   "get_strings_substring_test.flux",
											Source: "t_string_subset",
											Start: ast.Position{
												Column: 86,
												Line:   41,
											},
										},
									},
									Name: "t_string_subset",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 103,
						Line:   41,
					},
					File:   "get_strings_substring_test.flux",
					Source: "test _string_subset = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "get_strings_substring_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "get_strings_substring_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "get_strings_substring_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "get_strings_substring_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "get_strings_substring_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 102,
					Line:   40,
				},
				File:   "ljust_string_joinStr_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_ljust = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})))\n\ntest _string_ljust = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 77,
						Line:   37,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "t_string_ljust = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   33,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "t_string_ljust",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_ljust",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   37,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})))",
						Start: ast.Position{
							Column: 18,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   37,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   37,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   37,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   37,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   37,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "{r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   37,
															},
															File:   "ljust_string_joinStr_test.flux",
															Source: "_value: strings.joinStr(arr: [\" \", r._value], v: \"\")",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "ljust_string_joinStr_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   37,
																	},
																	File:   "ljust_string_joinStr_test.flux",
																	Source: "arr: [\" \", r._value], v: \"\"",
																	Start: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   37,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "arr: [\" \", r._value]",
																		Start: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																			File:   "ljust_string_joinStr_test.flux",
																			Source: "arr",
																			Start: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																		},
																	},
																	Name: "arr",
																},
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   37,
																			},
																			File:   "ljust_string_joinStr_test.flux",
																			Source: "[\" \", r._value]",
																			Start: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   37,
																				},
																				File:   "ljust_string_joinStr_test.flux",
																				Source: "\" \"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   37,
																				},
																			},
																		},
																		Value: " ",
																	}, &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   37,
																				},
																				File:   "ljust_string_joinStr_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 56,
																					Line:   37,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   37,
																					},
																					File:   "ljust_string_joinStr_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   37,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   37,
																					},
																					File:   "ljust_string_joinStr_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 58,
																						Line:   37,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	}},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   37,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "v: \"\"",
																		Start: ast.Position{
																			Column: 67,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   37,
																			},
																			File:   "ljust_string_joinStr_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 67,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 72,
																				Line:   37,
																			},
																			File:   "ljust_string_joinStr_test.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																		},
																	},
																	Value: "",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   37,
																},
																File:   "ljust_string_joinStr_test.flux",
																Source: "strings.joinStr(arr: [\" \", r._value], v: \"\")",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   37,
																	},
																	File:   "ljust_string_joinStr_test.flux",
																	Source: "strings.joinStr",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   37,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "joinStr",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "joinStr",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "ljust_string_joinStr_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   37,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   33,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   33,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   33,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 102,
							Line:   40,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "_string_ljust = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   39,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "_string_ljust",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_ljust",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   40,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
							Start: ast.Position{
								Column: 22,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   40,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   40,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   40,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "fn: t_string_ljust",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   40,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "t_string_ljust",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_ljust",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 102,
						Line:   40,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "test _string_ljust = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "ljust_string_joinStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   40,
				},
				File:   "lower_strings_toLower_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_toLower = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})))\n\ntest _string_toLower = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 61,
						Line:   37,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "t_string_toLower = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "t_string_toLower",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_toLower",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   37,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   37,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   37,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   37,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   37,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "({r with _value: strings.toLower(v: r._value)})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   37,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "{r with _value: strings.toLower(v: r._value)}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   37,
															},
															File:   "lower_strings_toLower_test.flux",
															Source: "_value: strings.toLower(v: r._value)",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "lower_strings_toLower_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   37,
																	},
																	File:   "lower_strings_toLower_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   37,
																		},
																		File:   "lower_strings_toLower_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   37,
																			},
																			File:   "lower_strings_toLower_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   37,
																			},
																			File:   "lower_strings_toLower_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   37,
																				},
																				File:   "lower_strings_toLower_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 48,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   37,
																				},
																				File:   "lower_strings_toLower_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 50,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   37,
																},
																File:   "lower_strings_toLower_test.flux",
																Source: "strings.toLower(v: r._value)",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   37,
																	},
																	File:   "lower_strings_toLower_test.flux",
																	Source: "strings.toLower",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "lower_strings_toLower_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   37,
																		},
																		File:   "lower_strings_toLower_test.flux",
																		Source: "toLower",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "toLower",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "lower_strings_toLower_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   37,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.toLower(v: r._value)}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   40,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "_string_toLower = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "_string_toLower",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_toLower",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   40,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   40,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   40,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   40,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "fn: t_string_toLower",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   40,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "t_string_toLower",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_toLower",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   40,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "test _string_toLower = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "lower_strings_toLower_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   40,
				},
				File:   "lstrip_string_trimLeft_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_trimLeft = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})))\n\ntest _string_trimLeft = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 75,
						Line:   37,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "t_string_trimLeft = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   33,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "t_string_trimLeft",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_trimLeft",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 75,
							Line:   37,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})))",
						Start: ast.Position{
							Column: 21,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   37,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   37,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   37,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   37,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   37,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "{r with _value: strings.trimLeft(v: r._value, cutset: \" \")}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 71,
																Line:   37,
															},
															File:   "lstrip_string_trimLeft_test.flux",
															Source: "_value: strings.trimLeft(v: r._value, cutset: \" \")",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "lstrip_string_trimLeft_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 70,
																		Line:   37,
																	},
																	File:   "lstrip_string_trimLeft_test.flux",
																	Source: "v: r._value, cutset: \" \"",
																	Start: ast.Position{
																		Column: 46,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   37,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 46,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 47,
																				Line:   37,
																			},
																			File:   "lstrip_string_trimLeft_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 46,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   37,
																			},
																			File:   "lstrip_string_trimLeft_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 49,
																				Line:   37,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   37,
																				},
																				File:   "lstrip_string_trimLeft_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 49,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 57,
																					Line:   37,
																				},
																				File:   "lstrip_string_trimLeft_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 51,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   37,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "cutset: \" \"",
																		Start: ast.Position{
																			Column: 59,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   37,
																			},
																			File:   "lstrip_string_trimLeft_test.flux",
																			Source: "cutset",
																			Start: ast.Position{
																				Column: 59,
																				Line:   37,
																			},
																		},
																	},
																	Name: "cutset",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																			File:   "lstrip_string_trimLeft_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 67,
																				Line:   37,
																			},
																		},
																	},
																	Value: " ",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 71,
																	Line:   37,
																},
																File:   "lstrip_string_trimLeft_test.flux",
																Source: "strings.trimLeft(v: r._value, cutset: \" \")",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																	File:   "lstrip_string_trimLeft_test.flux",
																	Source: "strings.trimLeft",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "trimLeft",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "trimLeft",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "lstrip_string_trimLeft_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   37,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   33,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   40,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "_string_trimLeft = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   39,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "_string_trimLeft",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_trimLeft",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   40,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
							Start: ast.Position{
								Column: 25,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   40,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   40,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   40,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "fn: t_string_trimLeft",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   40,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "t_string_trimLeft",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_trimLeft",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   40,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "test _string_trimLeft = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "lstrip_string_trimLeft_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 106,
					Line:   41,
				},
				File:   "partition_strings_splitN_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_partition = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})))\n\ntest _string_partition = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 77,
						Line:   38,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "t_string_partition = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   34,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "t_string_partition",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_string_partition",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   38,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})))",
						Start: ast.Position{
							Column: 22,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   38,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   38,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   38,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   38,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   38,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   38,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
													Start: ast.Position{
														Column: 12,
														Line:   38,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   38,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "{r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}",
														Start: ast.Position{
															Column: 13,
															Line:   38,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   38,
															},
															File:   "partition_strings_splitN_test.flux",
															Source: "_value: strings.splitN(v: r._value, t: \" \", i: 2)[0]",
															Start: ast.Position{
																Column: 21,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   38,
																},
																File:   "partition_strings_splitN_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   38,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.IndexExpression{
														Array: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   38,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "v: r._value, t: \" \", i: 2",
																		Start: ast.Position{
																			Column: 44,
																			Line:   38,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   38,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 44,
																				Line:   38,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 45,
																					Line:   38,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 44,
																					Line:   38,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   38,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 47,
																					Line:   38,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 48,
																						Line:   38,
																					},
																					File:   "partition_strings_splitN_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 47,
																						Line:   38,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 55,
																						Line:   38,
																					},
																					File:   "partition_strings_splitN_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 49,
																						Line:   38,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 63,
																				Line:   38,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "t: \" \"",
																			Start: ast.Position{
																				Column: 57,
																				Line:   38,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   38,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "t",
																				Start: ast.Position{
																					Column: 57,
																					Line:   38,
																				},
																			},
																		},
																		Name: "t",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 63,
																					Line:   38,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "\" \"",
																				Start: ast.Position{
																					Column: 60,
																					Line:   38,
																				},
																			},
																		},
																		Value: " ",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   38,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "i: 2",
																			Start: ast.Position{
																				Column: 65,
																				Line:   38,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   38,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "i",
																				Start: ast.Position{
																					Column: 65,
																					Line:   38,
																				},
																			},
																		},
																		Name: "i",
																	},
																	Value: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 69,
																					Line:   38,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "2",
																				Start: ast.Position{
																					Column: 68,
																					Line:   38,
																				},
																			},
																		},
																		Value: int64(2),
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 70,
																		Line:   38,
																	},
																	File:   "partition_strings_splitN_test.flux",
																	Source: "strings.splitN(v: r._value, t: \" \", i: 2)",
																	Start: ast.Position{
																		Column: 29,
																		Line:   38,
																	},
																},
															},
															Callee: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   38,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "strings.splitN",
																		Start: ast.Position{
																			Column: 29,
																			Line:   38,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   38,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "strings",
																			Start: ast.Position{
																				Column: 29,
																				Line:   38,
																			},
																		},
																	},
																	Name: "strings",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 43,
																				Line:   38,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "splitN",
																			Start: ast.Position{
																				Column: 37,
																				Line:   38,
																			},
																		},
																	},
																	Name: "splitN",
																},
															},
														},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   38,
																},
																File:   "partition_strings_splitN_test.flux",
																Source: "strings.splitN(v: r._value, t: \" \", i: 2)[0]",
																Start: ast.Position{
																	Column: 29,
																	Line:   38,
																},
															},
														},
														Index: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   38,
																	},
																	File:   "partition_strings_splitN_test.flux",
																	Source: "0",
																	Start: ast.Position{
																		Column: 71,
																		Line:   38,
																	},
																},
															},
															Value: int64(0),
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   38,
															},
															File:   "partition_strings_splitN_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   38,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   38,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   34,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   34,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   34,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   34,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   34,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 106,
							Line:   41,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "_string_partition = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   40,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "_string_partition",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_string_partition",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 106,
								Line:   41,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
							Start: ast.Position{
								Column: 26,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   41,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
								Start: ast.Position{
									Column: 2,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   41,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition}",
									Start: ast.Position{
										Column: 3,
										Line:   41,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   41,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   41,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   41,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   41,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   41,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   41,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   41,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   41,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   41,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   41,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   41,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   41,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   41,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   41,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   41,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   41,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   41,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   41,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   41,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   41,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "fn: t_string_partition",
										Start: ast.Position{
											Column: 82,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   41,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   41,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "t_string_partition",
											Start: ast.Position{
												Column: 86,
												Line:   41,
											},
										},
									},
									Name: "t_string_partition",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 106,
						Line:   41,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "test _string_partition = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "partition_strings_splitN_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 106,
					Line:   41,
				},
				File:   "repeat_strings_repeat_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_partition = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})))\n\ntest _string_partition = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   38,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "t_string_partition = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   34,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "t_string_partition",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_string_partition",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   38,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})))",
						Start: ast.Position{
							Column: 22,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   38,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   38,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   38,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   38,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   38,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   38,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "({r with _value: strings.repeat(v: r._value, i: 2)})",
													Start: ast.Position{
														Column: 12,
														Line:   38,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   38,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "{r with _value: strings.repeat(v: r._value, i: 2)}",
														Start: ast.Position{
															Column: 13,
															Line:   38,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   38,
															},
															File:   "repeat_strings_repeat_test.flux",
															Source: "_value: strings.repeat(v: r._value, i: 2)",
															Start: ast.Position{
																Column: 21,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   38,
																},
																File:   "repeat_strings_repeat_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   38,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   38,
																	},
																	File:   "repeat_strings_repeat_test.flux",
																	Source: "v: r._value, i: 2",
																	Start: ast.Position{
																		Column: 44,
																		Line:   38,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   38,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 44,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   38,
																			},
																			File:   "repeat_strings_repeat_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 44,
																				Line:   38,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   38,
																			},
																			File:   "repeat_strings_repeat_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 47,
																				Line:   38,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 48,
																					Line:   38,
																				},
																				File:   "repeat_strings_repeat_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 47,
																					Line:   38,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   38,
																				},
																				File:   "repeat_strings_repeat_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 49,
																					Line:   38,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   38,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "i: 2",
																		Start: ast.Position{
																			Column: 57,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   38,
																			},
																			File:   "repeat_strings_repeat_test.flux",
																			Source: "i",
																			Start: ast.Position{
																				Column: 57,
																				Line:   38,
																			},
																		},
																	},
																	Name: "i",
																},
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   38,
																			},
																			File:   "repeat_strings_repeat_test.flux",
																			Source: "2",
																			Start: ast.Position{
																				Column: 60,
																				Line:   38,
																			},
																		},
																	},
																	Value: int64(2),
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   38,
																},
																File:   "repeat_strings_repeat_test.flux",
																Source: "strings.repeat(v: r._value, i: 2)",
																Start: ast.Position{
																	Column: 29,
																	Line:   38,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   38,
																	},
																	File:   "repeat_strings_repeat_test.flux",
																	Source: "strings.repeat",
																	Start: ast.Position{
																		Column: 29,
																		Line:   38,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   38,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   38,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   38,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "repeat",
																		Start: ast.Position{
																			Column: 37,
																			Line:   38,
																		},
																	},
																},
																Name: "repeat",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   38,
															},
															File:   "repeat_strings_repeat_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   38,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   38,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.repeat(v: r._value, i: 2)}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   34,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   34,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   34,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   34,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   34,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 106,
							Line:   41,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "_string_partition = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   40,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "_string_partition",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_string_partition",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 106,
								Line:   41,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
							Start: ast.Position{
								Column: 26,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   41,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
								Start: ast.Position{
									Column: 2,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   41,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition}",
									Start: ast.Position{
										Column: 3,
										Line:   41,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   41,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   41,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   41,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   41,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   41,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   41,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   41,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   41,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   41,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   41,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   41,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   41,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   41,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   41,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   41,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   41,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   41,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   41,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   41,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   41,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "fn: t_string_partition",
										Start: ast.Position{
											Column: 82,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   41,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   41,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "t_string_partition",
											Start: ast.Position{
												Column: 86,
												Line:   41,
											},
										},
									},
									Name: "t_string_partition",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 106,
						Line:   41,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "test _string_partition = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "repeat_strings_repeat_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   40,
				},
				File:   "replace_strings_replace_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_replace = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})))\n\ntest _string_replace = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 86,
						Line:   37,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "t_string_replace = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "t_string_replace",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_replace",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 86,
							Line:   37,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   37,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   37,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   37,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   37,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 83,
															Line:   37,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "{r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   37,
															},
															File:   "replace_strings_replace_test.flux",
															Source: "_value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "replace_strings_replace_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   37,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "v: r._value, t: \"LnSk\", u: \" \", i: 1",
																	Start: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   37,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   37,
																				},
																				File:   "replace_strings_replace_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 48,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   37,
																				},
																				File:   "replace_strings_replace_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 50,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   37,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "t: \"LnSk\"",
																		Start: ast.Position{
																			Column: 58,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 58,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "\"LnSk\"",
																			Start: ast.Position{
																				Column: 61,
																				Line:   37,
																			},
																		},
																	},
																	Value: "LnSk",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   37,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "u: \" \"",
																		Start: ast.Position{
																			Column: 69,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "u",
																			Start: ast.Position{
																				Column: 69,
																				Line:   37,
																			},
																		},
																	},
																	Name: "u",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 72,
																				Line:   37,
																			},
																		},
																	},
																	Value: " ",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   37,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "i: 1",
																		Start: ast.Position{
																			Column: 77,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "i",
																			Start: ast.Position{
																				Column: 77,
																				Line:   37,
																			},
																		},
																	},
																	Name: "i",
																},
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 81,
																				Line:   37,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "1",
																			Start: ast.Position{
																				Column: 80,
																				Line:   37,
																			},
																		},
																	},
																	Value: int64(1),
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 82,
																	Line:   37,
																},
																File:   "replace_strings_replace_test.flux",
																Source: "strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   37,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "strings.replace",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   37,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "replace",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "replace",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "replace_strings_replace_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   37,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   40,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "_string_replace = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "_string_replace",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_replace",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   40,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   40,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   40,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   40,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "fn: t_string_replace",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   40,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "t_string_replace",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_replace",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   40,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "test _string_replace = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "replace_strings_replace_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 106,
					Line:   40,
				},
				File:   "rstrip_string_trimRight_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_trimRight = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})))\n\ntest _string_trimRight = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 76,
						Line:   37,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "t_string_trimRight = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "t_string_trimRight",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_trimRight",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 76,
							Line:   37,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})))",
						Start: ast.Position{
							Column: 22,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 76,
								Line:   37,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   37,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   37,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   37,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   37,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "{r with _value: strings.trimRight(v: r._value, cutset: \" \")}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   37,
															},
															File:   "rstrip_string_trimRight_test.flux",
															Source: "_value: strings.trimRight(v: r._value, cutset: \" \")",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "rstrip_string_trimRight_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 71,
																		Line:   37,
																	},
																	File:   "rstrip_string_trimRight_test.flux",
																	Source: "v: r._value, cutset: \" \"",
																	Start: ast.Position{
																		Column: 47,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   37,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 47,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																			File:   "rstrip_string_trimRight_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 47,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   37,
																			},
																			File:   "rstrip_string_trimRight_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   37,
																				},
																				File:   "rstrip_string_trimRight_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 50,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   37,
																				},
																				File:   "rstrip_string_trimRight_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 52,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 71,
																			Line:   37,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "cutset: \" \"",
																		Start: ast.Position{
																			Column: 60,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   37,
																			},
																			File:   "rstrip_string_trimRight_test.flux",
																			Source: "cutset",
																			Start: ast.Position{
																				Column: 60,
																				Line:   37,
																			},
																		},
																	},
																	Name: "cutset",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 71,
																				Line:   37,
																			},
																			File:   "rstrip_string_trimRight_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 68,
																				Line:   37,
																			},
																		},
																	},
																	Value: " ",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   37,
																},
																File:   "rstrip_string_trimRight_test.flux",
																Source: "strings.trimRight(v: r._value, cutset: \" \")",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   37,
																	},
																	File:   "rstrip_string_trimRight_test.flux",
																	Source: "strings.trimRight",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   37,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "trimRight",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "trimRight",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "rstrip_string_trimRight_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   37,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   33,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 106,
							Line:   40,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "_string_trimRight = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   39,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "_string_trimRight",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_trimRight",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 106,
								Line:   40,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
							Start: ast.Position{
								Column: 26,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   40,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   40,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   40,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "fn: t_string_trimRight",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   40,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "t_string_trimRight",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_string_trimRight",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 106,
						Line:   40,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "test _string_trimRight = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "rstrip_string_trimRight_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 121,
					Line:   41,
				},
				File:   "startswith_strings_regexp_hasPrefix_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nre = regexp.compile(v: \"[[:alpha:]]{1}\")\n\nt_string_regexp_hasPrefix = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])))\n\ntest _string_regexp_hasPrefix = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   7,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   7,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   7,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   7,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   7,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   7,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   33,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "re = regexp.compile(v: \"[[:alpha:]]{1}\")",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   33,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   33,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "v: \"[[:alpha:]]{1}\"",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   33,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "v: \"[[:alpha:]]{1}\"",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   33,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   33,
									},
								},
							},
							Name: "v",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   33,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "\"[[:alpha:]]{1}\"",
									Start: ast.Position{
										Column: 24,
										Line:   33,
									},
								},
							},
							Value: "[[:alpha:]]{1}",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   33,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "regexp.compile(v: \"[[:alpha:]]{1}\")",
						Start: ast.Position{
							Column: 6,
							Line:   33,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   33,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   33,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   33,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   33,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   33,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   33,
								},
							},
						},
						Name: "compile",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 98,
						Line:   38,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "t_string_regexp_hasPrefix = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])))",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   35,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "t_string_regexp_hasPrefix",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "t_string_regexp_hasPrefix",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 98,
							Line:   38,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])))",
						Start: ast.Position{
							Column: 29,
							Line:   35,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   38,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])))",
							Start: ast.Position{
								Column: 2,
								Line:   36,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   36,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   36,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   37,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   36,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   37,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   37,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   37,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   37,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   37,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   37,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   38,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))",
								Start: ast.Position{
									Column: 3,
									Line:   36,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   38,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
										Start: ast.Position{
											Column: 13,
											Line:   38,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   38,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
											Start: ast.Position{
												Column: 13,
												Line:   38,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   38,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 13,
													Line:   38,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   38,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "(r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
												Start: ast.Position{
													Column: 17,
													Line:   38,
												},
											},
										},
										Body: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   38,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "r: re, v: strings.split(v: r._value, t: \"\")[0]",
														Start: ast.Position{
															Column: 49,
															Line:   38,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   38,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "r: re",
															Start: ast.Position{
																Column: 49,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   38,
																},
																File:   "startswith_strings_regexp_hasPrefix_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 49,
																	Line:   38,
																},
															},
														},
														Name: "r",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   38,
																},
																File:   "startswith_strings_regexp_hasPrefix_test.flux",
																Source: "re",
																Start: ast.Position{
																	Column: 52,
																	Line:   38,
																},
															},
														},
														Name: "re",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 95,
																Line:   38,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "v: strings.split(v: r._value, t: \"\")[0]",
															Start: ast.Position{
																Column: 56,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   38,
																},
																File:   "startswith_strings_regexp_hasPrefix_test.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 56,
																	Line:   38,
																},
															},
														},
														Name: "v",
													},
													Value: &ast.IndexExpression{
														Array: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 91,
																			Line:   38,
																		},
																		File:   "startswith_strings_regexp_hasPrefix_test.flux",
																		Source: "v: r._value, t: \"\"",
																		Start: ast.Position{
																			Column: 73,
																			Line:   38,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   38,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 73,
																				Line:   38,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 74,
																					Line:   38,
																				},
																				File:   "startswith_strings_regexp_hasPrefix_test.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 73,
																					Line:   38,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 84,
																					Line:   38,
																				},
																				File:   "startswith_strings_regexp_hasPrefix_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 76,
																					Line:   38,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 77,
																						Line:   38,
																					},
																					File:   "startswith_strings_regexp_hasPrefix_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 76,
																						Line:   38,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 84,
																						Line:   38,
																					},
																					File:   "startswith_strings_regexp_hasPrefix_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 78,
																						Line:   38,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 91,
																				Line:   38,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "t: \"\"",
																			Start: ast.Position{
																				Column: 86,
																				Line:   38,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 87,
																					Line:   38,
																				},
																				File:   "startswith_strings_regexp_hasPrefix_test.flux",
																				Source: "t",
																				Start: ast.Position{
																					Column: 86,
																					Line:   38,
																				},
																			},
																		},
																		Name: "t",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   38,
																				},
																				File:   "startswith_strings_regexp_hasPrefix_test.flux",
																				Source: "\"\"",
																				Start: ast.Position{
																					Column: 89,
																					Line:   38,
																				},
																			},
																		},
																		Value: "",
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 92,
																		Line:   38,
																	},
																	File:   "startswith_strings_regexp_hasPrefix_test.flux",
																	Source: "strings.split(v: r._value, t: \"\")",
																	Start: ast.Position{
																		Column: 59,
																		Line:   38,
																	},
																},
															},
															Callee: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   38,
																		},
																		File:   "startswith_strings_regexp_hasPrefix_test.flux",
																		Source: "strings.split",
																		Start: ast.Position{
																			Column: 59,
																			Line:   38,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   38,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "strings",
																			Start: ast.Position{
																				Column: 59,
																				Line:   38,
																			},
																		},
																	},
																	Name: "strings",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 72,
																				Line:   38,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "split",
																			Start: ast.Position{
																				Column: 67,
																				Line:   38,
																			},
																		},
																	},
																	Name: "split",
																},
															},
														},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 95,
																	Line:   38,
																},
																File:   "startswith_strings_regexp_hasPrefix_test.flux",
																Source: "strings.split(v: r._value, t: \"\")[0]",
																Start: ast.Position{
																	Column: 59,
																	Line:   38,
																},
															},
														},
														Index: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 94,
																		Line:   38,
																	},
																	File:   "startswith_strings_regexp_hasPrefix_test.flux",
																	Source: "0",
																	Start: ast.Position{
																		Column: 93,
																		Line:   38,
																	},
																},
															},
															Value: int64(0),
														},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   38,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
													Start: ast.Position{
														Column: 24,
														Line:   38,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   38,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "regexp.matchRegexpString",
														Start: ast.Position{
															Column: 24,
															Line:   38,
														},
													},
												},
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   38,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "regexp",
															Start: ast.Position{
																Column: 24,
																Line:   38,
															},
														},
													},
													Name: "regexp",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   38,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "matchRegexpString",
															Start: ast.Position{
																Column: 31,
																Line:   38,
															},
														},
													},
													Name: "matchRegexpString",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   38,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 18,
														Line:   38,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   38,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 18,
															Line:   38,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 97,
										Line:   38,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))",
									Start: ast.Position{
										Column: 6,
										Line:   38,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   38,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 6,
											Line:   38,
										},
									},
								},
								Name: "filter",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   35,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 30,
								Line:   35,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   35,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 30,
									Line:   35,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   35,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 36,
								Line:   35,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 121,
							Line:   41,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "_string_regexp_hasPrefix = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   40,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "_string_regexp_hasPrefix",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_string_regexp_hasPrefix",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 121,
								Line:   41,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "() =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
							Start: ast.Position{
								Column: 33,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   41,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
								Start: ast.Position{
									Column: 10,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 120,
										Line:   41,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix}",
									Start: ast.Position{
										Column: 11,
										Line:   41,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   41,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   41,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   41,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 39,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   41,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 39,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 39,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   41,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 44,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   41,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 19,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   41,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 19,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   41,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   41,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 27,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   41,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 53,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   41,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 53,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   41,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 75,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   41,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 75,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   41,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 75,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   41,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 80,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   41,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 59,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   41,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 59,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   41,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   41,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 67,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 119,
											Line:   41,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "fn: t_string_regexp_hasPrefix",
										Start: ast.Position{
											Column: 90,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   41,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 90,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 119,
												Line:   41,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "t_string_regexp_hasPrefix",
											Start: ast.Position{
												Column: 94,
												Line:   41,
											},
										},
									},
									Name: "t_string_regexp_hasPrefix",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 121,
						Line:   41,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "test _string_regexp_hasPrefix = () =>\n         ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   5,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   5,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "startswith_strings_regexp_hasPrefix_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 103,
					Line:   41,
				},
				File:   "strip_strings_trimLeftRight_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_lstrip = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})))\n\ntest _string_lstrip = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   38,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "t_string_lstrip = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   34,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "t_string_lstrip",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_string_lstrip",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   38,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})))",
						Start: ast.Position{
							Column: 19,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   38,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   38,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   38,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   38,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   38,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   38,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
													Start: ast.Position{
														Column: 12,
														Line:   38,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   38,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "{r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}",
														Start: ast.Position{
															Column: 13,
															Line:   38,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 106,
																Line:   38,
															},
															File:   "strip_strings_trimLeftRight_test.flux",
															Source: "_value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")",
															Start: ast.Position{
																Column: 21,
																Line:   38,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   38,
																},
																File:   "strip_strings_trimLeftRight_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   38,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 105,
																		Line:   38,
																	},
																	File:   "strip_strings_trimLeftRight_test.flux",
																	Source: "v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \"",
																	Start: ast.Position{
																		Column: 47,
																		Line:   38,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 92,
																			Line:   38,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "v: strings.trimLeft(v: r._value, cutset: \" \")",
																		Start: ast.Position{
																			Column: 47,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   38,
																			},
																			File:   "strip_strings_trimLeftRight_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 47,
																				Line:   38,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   38,
																				},
																				File:   "strip_strings_trimLeftRight_test.flux",
																				Source: "v: r._value, cutset: \" \"",
																				Start: ast.Position{
																					Column: 67,
																					Line:   38,
																				},
																			},
																		},
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   38,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "v: r._value",
																					Start: ast.Position{
																						Column: 67,
																						Line:   38,
																					},
																				},
																			},
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 68,
																							Line:   38,
																						},
																						File:   "strip_strings_trimLeftRight_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 67,
																							Line:   38,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 78,
																							Line:   38,
																						},
																						File:   "strip_strings_trimLeftRight_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 70,
																							Line:   38,
																						},
																					},
																				},
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 71,
																								Line:   38,
																							},
																							File:   "strip_strings_trimLeftRight_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 70,
																								Line:   38,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 78,
																								Line:   38,
																							},
																							File:   "strip_strings_trimLeftRight_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 72,
																								Line:   38,
																							},
																						},
																					},
																					Name: "_value",
																				},
																			},
																		}, &ast.Property{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 91,
																						Line:   38,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "cutset: \" \"",
																					Start: ast.Position{
																						Column: 80,
																						Line:   38,
																					},
																				},
																			},
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 86,
																							Line:   38,
																						},
																						File:   "strip_strings_trimLeftRight_test.flux",
																						Source: "cutset",
																						Start: ast.Position{
																							Column: 80,
																							Line:   38,
																						},
																					},
																				},
																				Name: "cutset",
																			},
																			Value: &ast.StringLiteral{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 91,
																							Line:   38,
																						},
																						File:   "strip_strings_trimLeftRight_test.flux",
																						Source: "\" \"",
																						Start: ast.Position{
																							Column: 88,
																							Line:   38,
																						},
																					},
																				},
																				Value: " ",
																			},
																		}},
																		With: nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 92,
																				Line:   38,
																			},
																			File:   "strip_strings_trimLeftRight_test.flux",
																			Source: "strings.trimLeft(v: r._value, cutset: \" \")",
																			Start: ast.Position{
																				Column: 50,
																				Line:   38,
																			},
																		},
																	},
																	Callee: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   38,
																				},
																				File:   "strip_strings_trimLeftRight_test.flux",
																				Source: "strings.trimLeft",
																				Start: ast.Position{
																					Column: 50,
																					Line:   38,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   38,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "strings",
																					Start: ast.Position{
																						Column: 50,
																						Line:   38,
																					},
																				},
																			},
																			Name: "strings",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 66,
																						Line:   38,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "trimLeft",
																					Start: ast.Position{
																						Column: 58,
																						Line:   38,
																					},
																				},
																			},
																			Name: "trimLeft",
																		},
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 105,
																			Line:   38,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "cutset: \" \"",
																		Start: ast.Position{
																			Column: 94,
																			Line:   38,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 100,
																				Line:   38,
																			},
																			File:   "strip_strings_trimLeftRight_test.flux",
																			Source: "cutset",
																			Start: ast.Position{
																				Column: 94,
																				Line:   38,
																			},
																		},
																	},
																	Name: "cutset",
																},
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 105,
																				Line:   38,
																			},
																			File:   "strip_strings_trimLeftRight_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 102,
																				Line:   38,
																			},
																		},
																	},
																	Value: " ",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 106,
																	Line:   38,
																},
																File:   "strip_strings_trimLeftRight_test.flux",
																Source: "strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")",
																Start: ast.Position{
																	Column: 29,
																	Line:   38,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   38,
																	},
																	File:   "strip_strings_trimLeftRight_test.flux",
																	Source: "strings.trimRight",
																	Start: ast.Position{
																		Column: 29,
																		Line:   38,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   38,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   38,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   38,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "trimRight",
																		Start: ast.Position{
																			Column: 37,
																			Line:   38,
																		},
																	},
																},
																Name: "trimRight",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   38,
															},
															File:   "strip_strings_trimLeftRight_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   38,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   38,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   34,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   34,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   34,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   34,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   34,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 103,
							Line:   41,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "_string_lstrip = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   40,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "_string_lstrip",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_string_lstrip",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 103,
								Line:   41,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
							Start: ast.Position{
								Column: 23,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   41,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
								Start: ast.Position{
									Column: 2,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 102,
										Line:   41,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip}",
									Start: ast.Position{
										Column: 3,
										Line:   41,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   41,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   41,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   41,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   41,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   41,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   41,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   41,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   41,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   41,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   41,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   41,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   41,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   41,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   41,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   41,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   41,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   41,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   41,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   41,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   41,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   41,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   41,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "fn: t_string_lstrip",
										Start: ast.Position{
											Column: 82,
											Line:   41,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   41,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 101,
												Line:   41,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "t_string_lstrip",
											Start: ast.Position{
												Column: 86,
												Line:   41,
											},
										},
									},
									Name: "t_string_lstrip",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 103,
						Line:   41,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "test _string_lstrip = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "strip_strings_trimLeftRight_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 102,
					Line:   40,
				},
				File:   "title_strings_title_test.flux",
				Source: "package pandas_test\n\nimport \"testing\"\nimport \"strings\"\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9n  Gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\n\nt_string_title = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})))\n\ntest _string_title = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_title})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "title_strings_title_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "title_strings_title_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "title_strings_title_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "title_strings_title_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "title_strings_title_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "title_strings_title_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "title_strings_title_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "title_strings_title_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "title_strings_title_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "title_strings_title_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9n  Gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "title_strings_title_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "title_strings_title_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9n  Gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9n  Gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   37,
					},
					File:   "title_strings_title_test.flux",
					Source: "t_string_title = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   33,
						},
						File:   "title_strings_title_test.flux",
						Source: "t_string_title",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_title",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   37,
						},
						File:   "title_strings_title_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})))",
						Start: ast.Position{
							Column: 18,
							Line:   33,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   37,
							},
							File:   "title_strings_title_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})))",
							Start: ast.Position{
								Column: 2,
								Line:   34,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   34,
										},
										File:   "title_strings_title_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "title_strings_title_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   35,
											},
											File:   "title_strings_title_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   35,
												},
												File:   "title_strings_title_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   35,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "title_strings_title_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   35,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   35,
													},
													File:   "title_strings_title_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   35,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   35,
										},
										File:   "title_strings_title_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "title_strings_title_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   35,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   37,
								},
								File:   "title_strings_title_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> map(fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)}))",
								Start: ast.Position{
									Column: 3,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   37,
										},
										File:   "title_strings_title_test.flux",
										Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})",
										Start: ast.Position{
											Column: 10,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   37,
											},
											File:   "title_strings_title_test.flux",
											Source: "fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   36,
												},
												File:   "title_strings_title_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   37,
												},
												File:   "title_strings_title_test.flux",
												Source: "(r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)})",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   37,
													},
													File:   "title_strings_title_test.flux",
													Source: "({r with _value: strings.title(v: r._value)})",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   37,
														},
														File:   "title_strings_title_test.flux",
														Source: "{r with _value: strings.title(v: r._value)}",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   37,
															},
															File:   "title_strings_title_test.flux",
															Source: "_value: strings.title(v: r._value)",
															Start: ast.Position{
																Column: 21,
																Line:   37,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "title_strings_title_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 21,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   37,
																	},
																	File:   "title_strings_title_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 43,
																		Line:   37,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   37,
																		},
																		File:   "title_strings_title_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   37,
																			},
																			File:   "title_strings_title_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 43,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   37,
																			},
																			File:   "title_strings_title_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 46,
																				Line:   37,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 47,
																					Line:   37,
																				},
																				File:   "title_strings_title_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 46,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   37,
																				},
																				File:   "title_strings_title_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 48,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   37,
																},
																File:   "title_strings_title_test.flux",
																Source: "strings.title(v: r._value)",
																Start: ast.Position{
																	Column: 29,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   37,
																	},
																	File:   "title_strings_title_test.flux",
																	Source: "strings.title",
																	Start: ast.Position{
																		Column: 29,
																		Line:   37,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "title_strings_title_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "title_strings_title_test.flux",
																		Source: "title",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Name: "title",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "title_strings_title_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "title_strings_title_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   36,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   36,
														},
														File:   "title_strings_title_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   37,
									},
									File:   "title_strings_title_test.flux",
									Source: "map(fn: (r) =>\n        \t\t\t({r with _value: strings.title(v: r._value)}))",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   36,
										},
										File:   "title_strings_title_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Name: "map",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   33,
							},
							File:   "title_strings_title_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   33,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   33,
								},
								File:   "title_strings_title_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   33,
							},
							File:   "title_strings_title_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   33,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 102,
							Line:   40,
						},
						File:   "title_strings_title_test.flux",
						Source: "_string_title = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_title})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   39,
							},
							File:   "title_strings_title_test.flux",
							Source: "_string_title",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_title",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   40,
							},
							File:   "title_strings_title_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_title})",
							Start: ast.Position{
								Column: 22,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   40,
								},
								File:   "title_strings_title_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_title})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   40,
									},
									File:   "title_strings_title_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_title}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "title_strings_title_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "title_strings_title_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											