xk6-dashboard `v0.7.9` is here 🎉!

This release is a prerequisite for the feature request in `grafana/k6` to enable the web dashboard by default.

## Changes

* Gracefully Handle Default Port Binding Errors [#216](https://github.com/grafana/xk6-dashboard/pull/216)
* Downgraded spf13/cobra to 1.4.0 [#218](https://github.com/grafana/xk6-dashboard/pull/218)


### Gracefully Handle Default Port Binding Errors

When multiple k6 instances are run in parallel (e.g., in a CI environment), each instance tries to launch the web dashboard and bind to the default port, `5665`. The first instance succeeds, but all subsequent instances fail with a "port in use" error. This fatal error terminates the test run, preventing parallel execution when the dashboard is active.

**The solution**

The dashboard's error handling for port binding now more flexible. Specifically, if a port binding error occurs on the **default port (`5665`)**, the behavior is:

1.  A warning message is **logged** to the console, informing the user that the dashboard couldn't start on the default port.
2.  The error is treated as **non-fatal**.
3.  The k6 test proceeds to run normally, as if the dashboard were disabled for that specific instance.

This change makes the dashboard's behavior consistent with other k6 services (like the REST API) and would allow for the dashboard to be enabled by default in `k6` without breaking parallel test execution workflows.

### Downgraded spf13/cobra to 1.4.0

To maintain compatibility and continue the integration of `xk6-dashboard` with the main Grafana k6 repository, the `spf13/cobra` dependency downgraded from its current version (`v1.9.1`) to `v1.4.0`. This is to align with the version of `spf13/cobra` currently in use by Grafana k6.

**Problem**

The upstream Grafana k6 project uses an older version of the `spf13/cobra` library (`v1.4.0`). The current version in this repository (`v1.9.1`) creates a dependency conflict, which blocks the seamless integration of newer `xk6-dashboard` versions into Grafana k6.

**Impact**

As a direct consequence of this downgrade, the `szkiba/docsme` build-time tool, which is used for automatically generating the `cmd/k6-web-dashboard/README.md` file, will no longer be compatible.

Therefore, any future updates to the `cmd/k6-web-dashboard/README.md` file will need to be performed manually. This manual process will remain in effect until the `spf13/cobra` library is updated in the Grafana k6 repository.
