// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ScheduleDTO schedule DTO
//
// swagger:model ScheduleDTO
type ScheduleDTO struct {

	// day
	Day string `json:"day,omitempty"`

	// day of month
	DayOfMonth string `json:"dayOfMonth,omitempty"`

	// end date
	// Format: date-time
	EndDate *strfmt.DateTime `json:"endDate,omitempty"`

	// frequency
	Frequency string `json:"frequency,omitempty"`

	// hour
	Hour int64 `json:"hour,omitempty"`

	// interval amount
	IntervalAmount int64 `json:"intervalAmount,omitempty"`

	// interval frequency
	IntervalFrequency string `json:"intervalFrequency,omitempty"`

	// minute
	Minute int64 `json:"minute,omitempty"`

	// start date
	// Format: date-time
	StartDate *strfmt.DateTime `json:"startDate,omitempty"`

	// time zone
	TimeZone string `json:"timeZone,omitempty"`

	// workdays only
	WorkdaysOnly bool `json:"workdaysOnly,omitempty"`
}

// Validate validates this schedule DTO
func (m *ScheduleDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEndDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleDTO) validateEndDate(formats strfmt.Registry) error {
	if swag.IsZero(m.EndDate) { // not required
		return nil
	}

	if err := validate.FormatOf("endDate", "body", "date-time", m.EndDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ScheduleDTO) validateStartDate(formats strfmt.Registry) error {
	if swag.IsZero(m.StartDate) { // not required
		return nil
	}

	if err := validate.FormatOf("startDate", "body", "date-time", m.StartDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this schedule DTO based on context it is used
func (m *ScheduleDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ScheduleDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScheduleDTO) UnmarshalBinary(b []byte) error {
	var res ScheduleDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
