// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// CreateDashboardSnapshotCommand create dashboard snapshot command
//
// swagger:model CreateDashboardSnapshotCommand
type CreateDashboardSnapshotCommand struct {

	// dashboard
	// Required: true
	Dashboard JSON `json:"dashboard"`

	// Unique key used to delete the snapshot. It is different from the `key` so that only the creator can delete the snapshot. Required if `external` is `true`.
	DeleteKey string `json:"deleteKey,omitempty"`

	// When the snapshot should expire in seconds in seconds. Default is never to expire.
	Expires int64 `json:"expires,omitempty"`

	// these are passed when storing an external snapshot ref
	// Save the snapshot on an external server rather than locally.
	External *bool `json:"external,omitempty"`

	// Define the unique key. Required if `external` is `true`.
	Key string `json:"key,omitempty"`

	// Snapshot name
	Name string `json:"name,omitempty"`
}

// Validate validates this create dashboard snapshot command
func (m *CreateDashboardSnapshotCommand) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDashboard(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateDashboardSnapshotCommand) validateDashboard(formats strfmt.Registry) error {

	if m.Dashboard == nil {
		return errors.Required("dashboard", "body", nil)
	}

	return nil
}

// ContextValidate validates this create dashboard snapshot command based on context it is used
func (m *CreateDashboardSnapshotCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CreateDashboardSnapshotCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CreateDashboardSnapshotCommand) UnmarshalBinary(b []byte) error {
	var res CreateDashboardSnapshotCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
