// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRenderReportPDFParams creates a new RenderReportPDFParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRenderReportPDFParams() *RenderReportPDFParams {
	return &RenderReportPDFParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRenderReportPDFParamsWithTimeout creates a new RenderReportPDFParams object
// with the ability to set a timeout on a request.
func NewRenderReportPDFParamsWithTimeout(timeout time.Duration) *RenderReportPDFParams {
	return &RenderReportPDFParams{
		timeout: timeout,
	}
}

// NewRenderReportPDFParamsWithContext creates a new RenderReportPDFParams object
// with the ability to set a context for a request.
func NewRenderReportPDFParamsWithContext(ctx context.Context) *RenderReportPDFParams {
	return &RenderReportPDFParams{
		Context: ctx,
	}
}

// NewRenderReportPDFParamsWithHTTPClient creates a new RenderReportPDFParams object
// with the ability to set a custom HTTPClient for a request.
func NewRenderReportPDFParamsWithHTTPClient(client *http.Client) *RenderReportPDFParams {
	return &RenderReportPDFParams{
		HTTPClient: client,
	}
}

/*
RenderReportPDFParams contains all the parameters to send to the API endpoint

	for the render report PDF operation.

	Typically these are written to a http.Request.
*/
type RenderReportPDFParams struct {

	// DashboardID.
	//
	// Format: int64
	DashboardID int64

	// From.
	From *string

	// Layout.
	Layout *string

	// Orientation.
	Orientation *string

	// Title.
	Title *string

	// To.
	To *string

	// Variables.
	Variables *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the render report PDF params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RenderReportPDFParams) WithDefaults() *RenderReportPDFParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the render report PDF params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RenderReportPDFParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the render report PDF params
func (o *RenderReportPDFParams) WithTimeout(timeout time.Duration) *RenderReportPDFParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the render report PDF params
func (o *RenderReportPDFParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the render report PDF params
func (o *RenderReportPDFParams) WithContext(ctx context.Context) *RenderReportPDFParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the render report PDF params
func (o *RenderReportPDFParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the render report PDF params
func (o *RenderReportPDFParams) WithHTTPClient(client *http.Client) *RenderReportPDFParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the render report PDF params
func (o *RenderReportPDFParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDashboardID adds the dashboardID to the render report PDF params
func (o *RenderReportPDFParams) WithDashboardID(dashboardID int64) *RenderReportPDFParams {
	o.SetDashboardID(dashboardID)
	return o
}

// SetDashboardID adds the dashboardId to the render report PDF params
func (o *RenderReportPDFParams) SetDashboardID(dashboardID int64) {
	o.DashboardID = dashboardID
}

// WithFrom adds the from to the render report PDF params
func (o *RenderReportPDFParams) WithFrom(from *string) *RenderReportPDFParams {
	o.SetFrom(from)
	return o
}

// SetFrom adds the from to the render report PDF params
func (o *RenderReportPDFParams) SetFrom(from *string) {
	o.From = from
}

// WithLayout adds the layout to the render report PDF params
func (o *RenderReportPDFParams) WithLayout(layout *string) *RenderReportPDFParams {
	o.SetLayout(layout)
	return o
}

// SetLayout adds the layout to the render report PDF params
func (o *RenderReportPDFParams) SetLayout(layout *string) {
	o.Layout = layout
}

// WithOrientation adds the orientation to the render report PDF params
func (o *RenderReportPDFParams) WithOrientation(orientation *string) *RenderReportPDFParams {
	o.SetOrientation(orientation)
	return o
}

// SetOrientation adds the orientation to the render report PDF params
func (o *RenderReportPDFParams) SetOrientation(orientation *string) {
	o.Orientation = orientation
}

// WithTitle adds the title to the render report PDF params
func (o *RenderReportPDFParams) WithTitle(title *string) *RenderReportPDFParams {
	o.SetTitle(title)
	return o
}

// SetTitle adds the title to the render report PDF params
func (o *RenderReportPDFParams) SetTitle(title *string) {
	o.Title = title
}

// WithTo adds the to to the render report PDF params
func (o *RenderReportPDFParams) WithTo(to *string) *RenderReportPDFParams {
	o.SetTo(to)
	return o
}

// SetTo adds the to to the render report PDF params
func (o *RenderReportPDFParams) SetTo(to *string) {
	o.To = to
}

// WithVariables adds the variables to the render report PDF params
func (o *RenderReportPDFParams) WithVariables(variables *string) *RenderReportPDFParams {
	o.SetVariables(variables)
	return o
}

// SetVariables adds the variables to the render report PDF params
func (o *RenderReportPDFParams) SetVariables(variables *string) {
	o.Variables = variables
}

// WriteToRequest writes these params to a swagger request
func (o *RenderReportPDFParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param dashboardID
	if err := r.SetPathParam("dashboardID", swag.FormatInt64(o.DashboardID)); err != nil {
		return err
	}

	if o.From != nil {

		// query param from
		var qrFrom string

		if o.From != nil {
			qrFrom = *o.From
		}
		qFrom := qrFrom
		if qFrom != "" {

			if err := r.SetQueryParam("from", qFrom); err != nil {
				return err
			}
		}
	}

	if o.Layout != nil {

		// query param layout
		var qrLayout string

		if o.Layout != nil {
			qrLayout = *o.Layout
		}
		qLayout := qrLayout
		if qLayout != "" {

			if err := r.SetQueryParam("layout", qLayout); err != nil {
				return err
			}
		}
	}

	if o.Orientation != nil {

		// query param orientation
		var qrOrientation string

		if o.Orientation != nil {
			qrOrientation = *o.Orientation
		}
		qOrientation := qrOrientation
		if qOrientation != "" {

			if err := r.SetQueryParam("orientation", qOrientation); err != nil {
				return err
			}
		}
	}

	if o.Title != nil {

		// query param title
		var qrTitle string

		if o.Title != nil {
			qrTitle = *o.Title
		}
		qTitle := qrTitle
		if qTitle != "" {

			if err := r.SetQueryParam("title", qTitle); err != nil {
				return err
			}
		}
	}

	if o.To != nil {

		// query param to
		var qrTo string

		if o.To != nil {
			qrTo = *o.To
		}
		qTo := qrTo
		if qTo != "" {

			if err := r.SetQueryParam("to", qTo); err != nil {
				return err
			}
		}
	}

	if o.Variables != nil {

		// query param variables
		var qrVariables string

		if o.Variables != nil {
			qrVariables = *o.Variables
		}
		qVariables := qrVariables
		if qVariables != "" {

			if err := r.SetQueryParam("variables", qVariables); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
