// Code generated by go-swagger; DO NOT EDIT.

package folders

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateFolderReader is a Reader for the CreateFolder structure.
type CreateFolderReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateFolderReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateFolderOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateFolderBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateFolderUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateFolderForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateFolderConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateFolderInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /folders] createFolder", response, response.Code())
	}
}

// NewCreateFolderOK creates a CreateFolderOK with default headers values
func NewCreateFolderOK() *CreateFolderOK {
	return &CreateFolderOK{}
}

/*
CreateFolderOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateFolderOK struct {
	Payload *models.Folder
}

// IsSuccess returns true when this create folder Ok response has a 2xx status code
func (o *CreateFolderOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create folder Ok response has a 3xx status code
func (o *CreateFolderOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create folder Ok response has a 4xx status code
func (o *CreateFolderOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create folder Ok response has a 5xx status code
func (o *CreateFolderOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create folder Ok response a status code equal to that given
func (o *CreateFolderOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create folder Ok response
func (o *CreateFolderOK) Code() int {
	return 200
}

func (o *CreateFolderOK) Error() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderOk  %+v", 200, o.Payload)
}

func (o *CreateFolderOK) String() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderOk  %+v", 200, o.Payload)
}

func (o *CreateFolderOK) GetPayload() *models.Folder {
	return o.Payload
}

func (o *CreateFolderOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Folder)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFolderBadRequest creates a CreateFolderBadRequest with default headers values
func NewCreateFolderBadRequest() *CreateFolderBadRequest {
	return &CreateFolderBadRequest{}
}

/*
CreateFolderBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateFolderBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create folder bad request response has a 2xx status code
func (o *CreateFolderBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create folder bad request response has a 3xx status code
func (o *CreateFolderBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create folder bad request response has a 4xx status code
func (o *CreateFolderBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create folder bad request response has a 5xx status code
func (o *CreateFolderBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create folder bad request response a status code equal to that given
func (o *CreateFolderBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create folder bad request response
func (o *CreateFolderBadRequest) Code() int {
	return 400
}

func (o *CreateFolderBadRequest) Error() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderBadRequest  %+v", 400, o.Payload)
}

func (o *CreateFolderBadRequest) String() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderBadRequest  %+v", 400, o.Payload)
}

func (o *CreateFolderBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateFolderBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFolderUnauthorized creates a CreateFolderUnauthorized with default headers values
func NewCreateFolderUnauthorized() *CreateFolderUnauthorized {
	return &CreateFolderUnauthorized{}
}

/*
CreateFolderUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateFolderUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create folder unauthorized response has a 2xx status code
func (o *CreateFolderUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create folder unauthorized response has a 3xx status code
func (o *CreateFolderUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create folder unauthorized response has a 4xx status code
func (o *CreateFolderUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create folder unauthorized response has a 5xx status code
func (o *CreateFolderUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create folder unauthorized response a status code equal to that given
func (o *CreateFolderUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create folder unauthorized response
func (o *CreateFolderUnauthorized) Code() int {
	return 401
}

func (o *CreateFolderUnauthorized) Error() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderUnauthorized  %+v", 401, o.Payload)
}

func (o *CreateFolderUnauthorized) String() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderUnauthorized  %+v", 401, o.Payload)
}

func (o *CreateFolderUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateFolderUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFolderForbidden creates a CreateFolderForbidden with default headers values
func NewCreateFolderForbidden() *CreateFolderForbidden {
	return &CreateFolderForbidden{}
}

/*
CreateFolderForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateFolderForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create folder forbidden response has a 2xx status code
func (o *CreateFolderForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create folder forbidden response has a 3xx status code
func (o *CreateFolderForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create folder forbidden response has a 4xx status code
func (o *CreateFolderForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create folder forbidden response has a 5xx status code
func (o *CreateFolderForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create folder forbidden response a status code equal to that given
func (o *CreateFolderForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create folder forbidden response
func (o *CreateFolderForbidden) Code() int {
	return 403
}

func (o *CreateFolderForbidden) Error() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderForbidden  %+v", 403, o.Payload)
}

func (o *CreateFolderForbidden) String() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderForbidden  %+v", 403, o.Payload)
}

func (o *CreateFolderForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateFolderForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFolderConflict creates a CreateFolderConflict with default headers values
func NewCreateFolderConflict() *CreateFolderConflict {
	return &CreateFolderConflict{}
}

/*
CreateFolderConflict describes a response with status code 409, with default header values.

ConflictError
*/
type CreateFolderConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create folder conflict response has a 2xx status code
func (o *CreateFolderConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create folder conflict response has a 3xx status code
func (o *CreateFolderConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create folder conflict response has a 4xx status code
func (o *CreateFolderConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this create folder conflict response has a 5xx status code
func (o *CreateFolderConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this create folder conflict response a status code equal to that given
func (o *CreateFolderConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the create folder conflict response
func (o *CreateFolderConflict) Code() int {
	return 409
}

func (o *CreateFolderConflict) Error() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderConflict  %+v", 409, o.Payload)
}

func (o *CreateFolderConflict) String() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderConflict  %+v", 409, o.Payload)
}

func (o *CreateFolderConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateFolderConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFolderInternalServerError creates a CreateFolderInternalServerError with default headers values
func NewCreateFolderInternalServerError() *CreateFolderInternalServerError {
	return &CreateFolderInternalServerError{}
}

/*
CreateFolderInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateFolderInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create folder internal server error response has a 2xx status code
func (o *CreateFolderInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create folder internal server error response has a 3xx status code
func (o *CreateFolderInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create folder internal server error response has a 4xx status code
func (o *CreateFolderInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create folder internal server error response has a 5xx status code
func (o *CreateFolderInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create folder internal server error response a status code equal to that given
func (o *CreateFolderInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create folder internal server error response
func (o *CreateFolderInternalServerError) Code() int {
	return 500
}

func (o *CreateFolderInternalServerError) Error() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateFolderInternalServerError) String() string {
	return fmt.Sprintf("[POST /folders][%d] createFolderInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateFolderInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateFolderInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
