// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteDataSourceByIDReader is a Reader for the DeleteDataSourceByID structure.
type DeleteDataSourceByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteDataSourceByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteDataSourceByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeleteDataSourceByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteDataSourceByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteDataSourceByIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteDataSourceByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /datasources/{id}] deleteDataSourceByID", response, response.Code())
	}
}

// NewDeleteDataSourceByIDOK creates a DeleteDataSourceByIDOK with default headers values
func NewDeleteDataSourceByIDOK() *DeleteDataSourceByIDOK {
	return &DeleteDataSourceByIDOK{}
}

/*
DeleteDataSourceByIDOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteDataSourceByIDOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete data source by Id Ok response has a 2xx status code
func (o *DeleteDataSourceByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete data source by Id Ok response has a 3xx status code
func (o *DeleteDataSourceByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Id Ok response has a 4xx status code
func (o *DeleteDataSourceByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete data source by Id Ok response has a 5xx status code
func (o *DeleteDataSourceByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Id Ok response a status code equal to that given
func (o *DeleteDataSourceByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete data source by Id Ok response
func (o *DeleteDataSourceByIDOK) Code() int {
	return 200
}

func (o *DeleteDataSourceByIDOK) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdOk  %+v", 200, o.Payload)
}

func (o *DeleteDataSourceByIDOK) String() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdOk  %+v", 200, o.Payload)
}

func (o *DeleteDataSourceByIDOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByIDUnauthorized creates a DeleteDataSourceByIDUnauthorized with default headers values
func NewDeleteDataSourceByIDUnauthorized() *DeleteDataSourceByIDUnauthorized {
	return &DeleteDataSourceByIDUnauthorized{}
}

/*
DeleteDataSourceByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteDataSourceByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Id unauthorized response has a 2xx status code
func (o *DeleteDataSourceByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Id unauthorized response has a 3xx status code
func (o *DeleteDataSourceByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Id unauthorized response has a 4xx status code
func (o *DeleteDataSourceByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by Id unauthorized response has a 5xx status code
func (o *DeleteDataSourceByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Id unauthorized response a status code equal to that given
func (o *DeleteDataSourceByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete data source by Id unauthorized response
func (o *DeleteDataSourceByIDUnauthorized) Code() int {
	return 401
}

func (o *DeleteDataSourceByIDUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *DeleteDataSourceByIDUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *DeleteDataSourceByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByIDForbidden creates a DeleteDataSourceByIDForbidden with default headers values
func NewDeleteDataSourceByIDForbidden() *DeleteDataSourceByIDForbidden {
	return &DeleteDataSourceByIDForbidden{}
}

/*
DeleteDataSourceByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteDataSourceByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Id forbidden response has a 2xx status code
func (o *DeleteDataSourceByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Id forbidden response has a 3xx status code
func (o *DeleteDataSourceByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Id forbidden response has a 4xx status code
func (o *DeleteDataSourceByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by Id forbidden response has a 5xx status code
func (o *DeleteDataSourceByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Id forbidden response a status code equal to that given
func (o *DeleteDataSourceByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete data source by Id forbidden response
func (o *DeleteDataSourceByIDForbidden) Code() int {
	return 403
}

func (o *DeleteDataSourceByIDForbidden) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdForbidden  %+v", 403, o.Payload)
}

func (o *DeleteDataSourceByIDForbidden) String() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdForbidden  %+v", 403, o.Payload)
}

func (o *DeleteDataSourceByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByIDNotFound creates a DeleteDataSourceByIDNotFound with default headers values
func NewDeleteDataSourceByIDNotFound() *DeleteDataSourceByIDNotFound {
	return &DeleteDataSourceByIDNotFound{}
}

/*
DeleteDataSourceByIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteDataSourceByIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Id not found response has a 2xx status code
func (o *DeleteDataSourceByIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Id not found response has a 3xx status code
func (o *DeleteDataSourceByIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Id not found response has a 4xx status code
func (o *DeleteDataSourceByIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by Id not found response has a 5xx status code
func (o *DeleteDataSourceByIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Id not found response a status code equal to that given
func (o *DeleteDataSourceByIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete data source by Id not found response
func (o *DeleteDataSourceByIDNotFound) Code() int {
	return 404
}

func (o *DeleteDataSourceByIDNotFound) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdNotFound  %+v", 404, o.Payload)
}

func (o *DeleteDataSourceByIDNotFound) String() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdNotFound  %+v", 404, o.Payload)
}

func (o *DeleteDataSourceByIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByIDInternalServerError creates a DeleteDataSourceByIDInternalServerError with default headers values
func NewDeleteDataSourceByIDInternalServerError() *DeleteDataSourceByIDInternalServerError {
	return &DeleteDataSourceByIDInternalServerError{}
}

/*
DeleteDataSourceByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteDataSourceByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Id internal server error response has a 2xx status code
func (o *DeleteDataSourceByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Id internal server error response has a 3xx status code
func (o *DeleteDataSourceByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Id internal server error response has a 4xx status code
func (o *DeleteDataSourceByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete data source by Id internal server error response has a 5xx status code
func (o *DeleteDataSourceByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete data source by Id internal server error response a status code equal to that given
func (o *DeleteDataSourceByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete data source by Id internal server error response
func (o *DeleteDataSourceByIDInternalServerError) Code() int {
	return 500
}

func (o *DeleteDataSourceByIDInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteDataSourceByIDInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /datasources/{id}][%d] deleteDataSourceByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteDataSourceByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
