// Code generated by go-swagger; DO NOT EDIT.

package tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteTaskParams creates a new DeleteTaskParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteTaskParams() *DeleteTaskParams {
	return &DeleteTaskParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteTaskParamsWithTimeout creates a new DeleteTaskParams object
// with the ability to set a timeout on a request.
func NewDeleteTaskParamsWithTimeout(timeout time.Duration) *DeleteTaskParams {
	return &DeleteTaskParams{
		timeout: timeout,
	}
}

// NewDeleteTaskParamsWithContext creates a new DeleteTaskParams object
// with the ability to set a context for a request.
func NewDeleteTaskParamsWithContext(ctx context.Context) *DeleteTaskParams {
	return &DeleteTaskParams{
		Context: ctx,
	}
}

// NewDeleteTaskParamsWithHTTPClient creates a new DeleteTaskParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteTaskParamsWithHTTPClient(client *http.Client) *DeleteTaskParams {
	return &DeleteTaskParams{
		HTTPClient: client,
	}
}

/*
DeleteTaskParams contains all the parameters to send to the API endpoint

	for the delete task operation.

	Typically these are written to a http.Request.
*/
type DeleteTaskParams struct {

	/* ID.

	   The id of the item

	   Format: int64
	*/
	ID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteTaskParams) WithDefaults() *DeleteTaskParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteTaskParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete task params
func (o *DeleteTaskParams) WithTimeout(timeout time.Duration) *DeleteTaskParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete task params
func (o *DeleteTaskParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete task params
func (o *DeleteTaskParams) WithContext(ctx context.Context) *DeleteTaskParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete task params
func (o *DeleteTaskParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete task params
func (o *DeleteTaskParams) WithHTTPClient(client *http.Client) *DeleteTaskParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete task params
func (o *DeleteTaskParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the delete task params
func (o *DeleteTaskParams) WithID(id int64) *DeleteTaskParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the delete task params
func (o *DeleteTaskParams) SetID(id int64) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteTaskParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", swag.FormatInt64(o.ID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
