// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// ChunkedReader is a Reader for the Chunked structure.
type ChunkedReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *ChunkedReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewChunkedOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		return nil, runtime.NewAPIError("[GET /HTTP/ChunkedScript] chunked", response, response.Code())
	}
}

// NewChunkedOK creates a ChunkedOK with default headers values
func NewChunkedOK(writer io.Writer) *ChunkedOK {
	return &ChunkedOK{

		Payload: writer,
	}
}

/*
ChunkedOK describes a response with status code 200, with default header values.

chunked data delivered
*/
type ChunkedOK struct {
	Payload io.Writer
}

// IsSuccess returns true when this chunked o k response has a 2xx status code
func (o *ChunkedOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this chunked o k response has a 3xx status code
func (o *ChunkedOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this chunked o k response has a 4xx status code
func (o *ChunkedOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this chunked o k response has a 5xx status code
func (o *ChunkedOK) IsServerError() bool {
	return false
}

// IsCode returns true when this chunked o k response a status code equal to that given
func (o *ChunkedOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the chunked o k response
func (o *ChunkedOK) Code() int {
	return 200
}

func (o *ChunkedOK) Error() string {
	return fmt.Sprintf("[GET /HTTP/ChunkedScript][%d] chunkedOK", 200)
}

func (o *ChunkedOK) String() string {
	return fmt.Sprintf("[GET /HTTP/ChunkedScript][%d] chunkedOK", 200)
}

func (o *ChunkedOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *ChunkedOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
