// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new operations API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new operations API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new operations API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for operations API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// This client is generated with a few options you might find useful for your swagger spec.
//
// Feel free to add you own set of options.

// WithContentType allows the client to force the Content-Type header
// to negotiate a specific Consumer from the server.
//
// You may use this option to set arbitrary extensions to your MIME media type.
func WithContentType(mime string) ClientOption {
	return func(r *runtime.ClientOperation) {
		r.ConsumesMediaTypes = []string{mime}
	}
}

// WithContentTypeApplicationIoGoswaggerExamplesTodoListV1JSON sets the Content-Type header to "application/io.goswagger.examples.todo-list.v1+json".
func WithContentTypeApplicationIoGoswaggerExamplesTodoListV1JSON(r *runtime.ClientOperation) {
	r.ConsumesMediaTypes = []string{"application/io.goswagger.examples.todo-list.v1+json"}
}

// WithContentTypeApplicationJSON sets the Content-Type header to "application/json".
func WithContentTypeApplicationJSON(r *runtime.ClientOperation) {
	r.ConsumesMediaTypes = []string{"application/json"}
}

// WithAccept allows the client to force the Accept header
// to negotiate a specific Producer from the server.
//
// You may use this option to set arbitrary extensions to your MIME media type.
func WithAccept(mime string) ClientOption {
	return func(r *runtime.ClientOperation) {
		r.ProducesMediaTypes = []string{mime}
	}
}

// WithAcceptApplicationIoGoswaggerExamplesTodoListV1JSON sets the Accept header to "application/io.goswagger.examples.todo-list.v1+json".
func WithAcceptApplicationIoGoswaggerExamplesTodoListV1JSON(r *runtime.ClientOperation) {
	r.ProducesMediaTypes = []string{"application/io.goswagger.examples.todo-list.v1+json"}
}

// WithAcceptApplicationJSON sets the Accept header to "application/json".
func WithAcceptApplicationJSON(r *runtime.ClientOperation) {
	r.ProducesMediaTypes = []string{"application/json"}
}

// ClientService is the interface for Client methods
type ClientService interface {
	PutTest2766(params *PutTest2766Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PutTest2766OK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
PutTest2766 put test2766 API
*/
func (a *Client) PutTest2766(params *PutTest2766Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PutTest2766OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPutTest2766Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutTest2766",
		Method:             "PUT",
		PathPattern:        "/test2766",
		ProducesMediaTypes: []string{"application/io.goswagger.examples.todo-list.v1+json"},
		ConsumesMediaTypes: []string{"application/io.goswagger.examples.todo-list.v1+json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PutTest2766Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutTest2766OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutTest2766: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
