// Code generated by go-swagger; DO NOT EDIT.

package cli

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-swagger/go-swagger/examples/cli/models"
	"github.com/spf13/cobra"
)

// Schema cli for Item

// register flags to command
func registerModelItemFlags(depth int, cmdPrefix string, cmd *cobra.Command) error {

	if err := registerItemPropCompleted(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	if err := registerItemPropDescription(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	if err := registerItemPropID(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	return nil
}

func registerItemPropCompleted(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	flagCompletedDescription := ``

	var flagCompletedName string
	if cmdPrefix == "" {
		flagCompletedName = "completed"
	} else {
		flagCompletedName = fmt.Sprintf("%v.completed", cmdPrefix)
	}

	var flagCompletedDefault bool

	_ = cmd.PersistentFlags().Bool(flagCompletedName, flagCompletedDefault, flagCompletedDescription)

	return nil
}

func registerItemPropDescription(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	flagDescriptionDescription := `Required. `

	var flagDescriptionName string
	if cmdPrefix == "" {
		flagDescriptionName = "description"
	} else {
		flagDescriptionName = fmt.Sprintf("%v.description", cmdPrefix)
	}

	var flagDescriptionDefault string

	_ = cmd.PersistentFlags().String(flagDescriptionName, flagDescriptionDefault, flagDescriptionDescription)

	return nil
}

func registerItemPropID(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	flagIDDescription := ``

	var flagIDName string
	if cmdPrefix == "" {
		flagIDName = "id"
	} else {
		flagIDName = fmt.Sprintf("%v.id", cmdPrefix)
	}

	var flagIDDefault int64

	_ = cmd.PersistentFlags().Int64(flagIDName, flagIDDefault, flagIDDescription)

	return nil
}

// retrieve flags from commands, and set value in model. Return true if any flag is passed by user to fill model field.
func retrieveModelItemFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	retAdded := false

	err, CompletedAdded := retrieveItemPropCompletedFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || CompletedAdded

	err, DescriptionAdded := retrieveItemPropDescriptionFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || DescriptionAdded

	err, IDAdded := retrieveItemPropIDFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || IDAdded

	return nil, retAdded
}

func retrieveItemPropCompletedFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	flagCompletedName := fmt.Sprintf("%v.completed", cmdPrefix)
	if cmd.Flags().Changed(flagCompletedName) {

		var flagCompletedName string
		if cmdPrefix == "" {
			flagCompletedName = "completed"
		} else {
			flagCompletedName = fmt.Sprintf("%v.completed", cmdPrefix)
		}

		flagCompletedValue, err := cmd.Flags().GetBool(flagCompletedName)
		if err != nil {
			return err, false
		}
		m.Completed = flagCompletedValue

		retAdded = true
	}

	return nil, retAdded
}

func retrieveItemPropDescriptionFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	flagDescriptionName := fmt.Sprintf("%v.description", cmdPrefix)
	if cmd.Flags().Changed(flagDescriptionName) {

		var flagDescriptionName string
		if cmdPrefix == "" {
			flagDescriptionName = "description"
		} else {
			flagDescriptionName = fmt.Sprintf("%v.description", cmdPrefix)
		}

		flagDescriptionValue, err := cmd.Flags().GetString(flagDescriptionName)
		if err != nil {
			return err, false
		}
		m.Description = &flagDescriptionValue

		retAdded = true
	}

	return nil, retAdded
}

func retrieveItemPropIDFlags(depth int, m *models.Item, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	flagIDName := fmt.Sprintf("%v.id", cmdPrefix)
	if cmd.Flags().Changed(flagIDName) {

		var flagIDName string
		if cmdPrefix == "" {
			flagIDName = "id"
		} else {
			flagIDName = fmt.Sprintf("%v.id", cmdPrefix)
		}

		flagIDValue, err := cmd.Flags().GetInt64(flagIDName)
		if err != nil {
			return err, false
		}
		m.ID = flagIDValue

		retAdded = true
	}

	return nil, retAdded
}
