// Code generated by go-swagger; DO NOT EDIT.

package store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery --name API --keeptree --with-expecter --case underscore

// API is the interface of the store client
type API interface {
	/*
	   InventoryGet returns pet inventories by status*/
	InventoryGet(ctx context.Context, params *InventoryGetParams) (*InventoryGetOK, error)
	/*
	   OrderCreate places an order for a pet*/
	OrderCreate(ctx context.Context, params *OrderCreateParams) (*OrderCreateOK, error)
	/*
	   OrderDelete deletes purchase order by ID

	   For valid response try integer IDs with positive integer value. Negative or non-integer values will generate API errors*/
	OrderDelete(ctx context.Context, params *OrderDeleteParams) (*OrderDeleteNoContent, error)
	/*
	   OrderGet finds purchase order by ID

	   For valid response try integer IDs with value >= 1 and <= 10. Other values will generated exceptions*/
	OrderGet(ctx context.Context, params *OrderGetParams) (*OrderGetOK, error)
}

// New creates a new store API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for store API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
InventoryGet returns pet inventories by status
*/
func (a *Client) InventoryGet(ctx context.Context, params *InventoryGetParams) (*InventoryGetOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InventoryGet",
		Method:             "GET",
		PathPattern:        "/store/inventory",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &InventoryGetReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	switch value := result.(type) {
	case *InventoryGetOK:
		return value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for InventoryGet: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
OrderCreate places an order for a pet
*/
func (a *Client) OrderCreate(ctx context.Context, params *OrderCreateParams) (*OrderCreateOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "OrderCreate",
		Method:             "POST",
		PathPattern:        "/store/order",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrderCreateReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	switch value := result.(type) {
	case *OrderCreateOK:
		return value, nil
	case *OrderCreateBadRequest:
		return nil, runtime.NewAPIError("unsuccessful response", value, value.Code())
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for OrderCreate: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
OrderDelete deletes purchase order by ID

For valid response try integer IDs with positive integer value. Negative or non-integer values will generate API errors
*/
func (a *Client) OrderDelete(ctx context.Context, params *OrderDeleteParams) (*OrderDeleteNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "OrderDelete",
		Method:             "DELETE",
		PathPattern:        "/store/order/{orderId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrderDeleteReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	switch value := result.(type) {
	case *OrderDeleteNoContent:
		return value, nil
	case *OrderDeleteBadRequest:
		return nil, runtime.NewAPIError("unsuccessful response", value, value.Code())
	case *OrderDeleteNotFound:
		return nil, runtime.NewAPIError("unsuccessful response", value, value.Code())
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for OrderDelete: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
OrderGet finds purchase order by ID

For valid response try integer IDs with value >= 1 and <= 10. Other values will generated exceptions
*/
func (a *Client) OrderGet(ctx context.Context, params *OrderGetParams) (*OrderGetOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "OrderGet",
		Method:             "GET",
		PathPattern:        "/store/order/{orderId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrderGetReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	switch value := result.(type) {
	case *OrderGetOK:
		return value, nil
	case *OrderGetBadRequest:
		return nil, runtime.NewAPIError("unsuccessful response", value, value.Code())
	case *OrderGetNotFound:
		return nil, runtime.NewAPIError("unsuccessful response", value, value.Code())
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for OrderGet: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}
