// This file is generated by "./lib/proto/generate"

package proto

/*

PWA

This domain allows interacting with the browser to control PWAs.

*/

// PWAFileHandlerAccept The following types are the replica of
// https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67
type PWAFileHandlerAccept struct {
	// MediaType New name of the mimetype according to
	// https://www.iana.org/assignments/media-types/media-types.xhtml
	MediaType string `json:"mediaType"`

	// FileExtensions ...
	FileExtensions []string `json:"fileExtensions"`
}

// PWAFileHandler ...
type PWAFileHandler struct {
	// Action ...
	Action string `json:"action"`

	// Accepts ...
	Accepts []*PWAFileHandlerAccept `json:"accepts"`

	// DisplayName ...
	DisplayName string `json:"displayName"`
}

// PWAGetOsAppState Returns the following OS state for the given manifest id.
type PWAGetOsAppState struct {
	// ManifestID The id from the webapp's manifest file, commonly it's the url of the
	// site installing the webapp. See
	// https://web.dev/learn/pwa/web-app-manifest.
	ManifestID string `json:"manifestId"`
}

// ProtoReq name.
func (m PWAGetOsAppState) ProtoReq() string { return "PWA.getOsAppState" }

// Call the request.
func (m PWAGetOsAppState) Call(c Client) (*PWAGetOsAppStateResult, error) {
	var res PWAGetOsAppStateResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PWAGetOsAppStateResult ...
type PWAGetOsAppStateResult struct {
	// BadgeCount ...
	BadgeCount int `json:"badgeCount"`

	// FileHandlers ...
	FileHandlers []*PWAFileHandler `json:"fileHandlers"`
}

// PWAInstall Installs the given manifest identity, optionally using the given install_url
// or IWA bundle location.
//
// TODO(crbug.com/337872319) Support IWA to meet the following specific
// requirement.
// IWA-specific install description: If the manifest_id is isolated-app://,
// install_url_or_bundle_url is required, and can be either an http(s) URL or
// file:// URL pointing to a signed web bundle (.swbn). The .swbn file's
// signing key must correspond to manifest_id. If Chrome is not in IWA dev
// mode, the installation will fail, regardless of the state of the allowlist.
type PWAInstall struct {
	// ManifestID ...
	ManifestID string `json:"manifestId"`

	// InstallURLOrBundleURL (optional) The location of the app or bundle overriding the one derived from the
	// manifestId.
	InstallURLOrBundleURL string `json:"installUrlOrBundleUrl,omitempty"`
}

// ProtoReq name.
func (m PWAInstall) ProtoReq() string { return "PWA.install" }

// Call sends the request.
func (m PWAInstall) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PWAUninstall Uninstals the given manifest_id and closes any opened app windows.
type PWAUninstall struct {
	// ManifestID ...
	ManifestID string `json:"manifestId"`
}

// ProtoReq name.
func (m PWAUninstall) ProtoReq() string { return "PWA.uninstall" }

// Call sends the request.
func (m PWAUninstall) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}
