// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.


package v1

import (
	"bytes"
	"context"
	"fmt"
	"io/ioutil"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	mpc_walletspb "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/mpc_wallets/v1"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newMPCWalletClientHook clientHook

// MPCWalletCallOptions contains the retry settings for each method of MPCWalletClient.
type MPCWalletCallOptions struct {
	CreateMPCWallet []gax.CallOption
	GetMPCWallet []gax.CallOption
	ListMPCWallets []gax.CallOption
	GenerateAddress []gax.CallOption
	GetAddress []gax.CallOption
	ListAddresses []gax.CallOption
	ListBalances []gax.CallOption
	ListBalanceDetails []gax.CallOption
}

func defaultMPCWalletGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("api.developer.coinbase.com/waas/mpc_wallets:443"),
		internaloption.WithDefaultMTLSEndpoint("api.developer.coinbase.com/waas/mpc_wallets:443"),
		internaloption.WithDefaultAudience("https://api.developer.coinbase.com/waas/mpc_wallets/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
		grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultMPCWalletCallOptions() *MPCWalletCallOptions {
	return &MPCWalletCallOptions{
		CreateMPCWallet: []gax.CallOption{
		},
		GetMPCWallet: []gax.CallOption{
		},
		ListMPCWallets: []gax.CallOption{
		},
		GenerateAddress: []gax.CallOption{
		},
		GetAddress: []gax.CallOption{
		},
		ListAddresses: []gax.CallOption{
		},
		ListBalances: []gax.CallOption{
		},
		ListBalanceDetails: []gax.CallOption{
		},
	}
}

func defaultMPCWalletRESTCallOptions() *MPCWalletCallOptions {
	return &MPCWalletCallOptions{
		CreateMPCWallet: []gax.CallOption{
		},
		GetMPCWallet: []gax.CallOption{
		},
		ListMPCWallets: []gax.CallOption{
		},
		GenerateAddress: []gax.CallOption{
		},
		GetAddress: []gax.CallOption{
		},
		ListAddresses: []gax.CallOption{
		},
		ListBalances: []gax.CallOption{
		},
		ListBalanceDetails: []gax.CallOption{
		},
	}
}

// internalMPCWalletClient is an interface that defines the methods available from .
type internalMPCWalletClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateMPCWallet(context.Context, *mpc_walletspb.CreateMPCWalletRequest, ...gax.CallOption) (*CreateMPCWalletOperation, error)
	CreateMPCWalletOperation(name string) *CreateMPCWalletOperation
	GetMPCWallet(context.Context, *mpc_walletspb.GetMPCWalletRequest, ...gax.CallOption) (*mpc_walletspb.MPCWallet, error)
	ListMPCWallets(context.Context, *mpc_walletspb.ListMPCWalletsRequest, ...gax.CallOption) *MPCWalletIterator
	GenerateAddress(context.Context, *mpc_walletspb.GenerateAddressRequest, ...gax.CallOption) (*mpc_walletspb.Address, error)
	GetAddress(context.Context, *mpc_walletspb.GetAddressRequest, ...gax.CallOption) (*mpc_walletspb.Address, error)
	ListAddresses(context.Context, *mpc_walletspb.ListAddressesRequest, ...gax.CallOption) *AddressIterator
	ListBalances(context.Context, *mpc_walletspb.ListBalancesRequest, ...gax.CallOption) *BalanceIterator
	ListBalanceDetails(context.Context, *mpc_walletspb.ListBalanceDetailsRequest, ...gax.CallOption) *BalanceDetailIterator
}

// MPCWalletClient is a client for interacting with .
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// A service that manages BIP-32-based Hierarchically Deterministic (HD) collections of on-chain
// Addresses and their associated Asset balances. The Addresses are backed by the MPCKey resources
// of KeyService, and information about the Assets can be queried using BlockchainService. Because
// of the backing by MPC Keys, full functionality of these APIs requires use of the WaaS SDK.
type MPCWalletClient struct {
	// The internal transport-dependent client.
	internalClient internalMPCWalletClient

	// The call options for this service.
	CallOptions *MPCWalletCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient

}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *MPCWalletClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *MPCWalletClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *MPCWalletClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateMPCWallet creates an MPCWallet. The Device in the request must have been registered using MPCKeyService’s
// RegisterDevice before this method is called. Under the hood, this calls MPCKeyService’s
// CreateDeviceGroup with the appropriate parameters. After calling this, use MPCKeyService’s
// ListMPCOperations to poll for the pending CreateDeviceGroup operation, and use the WaaS SDK’s
// computeMPCOperation to complete the operation.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *MPCWalletClient) CreateMPCWallet(ctx context.Context, req *mpc_walletspb.CreateMPCWalletRequest, opts ...gax.CallOption) (*CreateMPCWalletOperation, error) {
	return c.internalClient.CreateMPCWallet(ctx, req, opts...)
}

// CreateMPCWalletOperation returns a new CreateMPCWalletOperation from a given name.
// The name must be that of a previously created CreateMPCWalletOperation, possibly from a different process.
func (c *MPCWalletClient) CreateMPCWalletOperation(name string) *CreateMPCWalletOperation {
	return c.internalClient.CreateMPCWalletOperation(name)
}

// GetMPCWallet retrieves an MPCWallet by resource name.
func (c *MPCWalletClient) GetMPCWallet(ctx context.Context, req *mpc_walletspb.GetMPCWalletRequest, opts ...gax.CallOption) (*mpc_walletspb.MPCWallet, error) {
	return c.internalClient.GetMPCWallet(ctx, req, opts...)
}

// ListMPCWallets returns a list of MPCWallets in a Pool.
func (c *MPCWalletClient) ListMPCWallets(ctx context.Context, req *mpc_walletspb.ListMPCWalletsRequest, opts ...gax.CallOption) *MPCWalletIterator {
	return c.internalClient.ListMPCWallets(ctx, req, opts...)
}

// GenerateAddress generates an Address within an MPCWallet. The Address values generated are identical across
// Networks of the same protocol family (e.g. EVM). So, for example, calling GenerateAddress twice
// for networks/ethereum-mainnet, and then calling it twice more for networks/ethereum-goerli, will
// result in two pairs of identical addresses on Ethereum Mainnet and Goerli.
func (c *MPCWalletClient) GenerateAddress(ctx context.Context, req *mpc_walletspb.GenerateAddressRequest, opts ...gax.CallOption) (*mpc_walletspb.Address, error) {
	return c.internalClient.GenerateAddress(ctx, req, opts...)
}

// GetAddress retrieves an Address by resource name.
func (c *MPCWalletClient) GetAddress(ctx context.Context, req *mpc_walletspb.GetAddressRequest, opts ...gax.CallOption) (*mpc_walletspb.Address, error) {
	return c.internalClient.GetAddress(ctx, req, opts...)
}

// ListAddresses returns a list of Addresses in an MPCWallet.
func (c *MPCWalletClient) ListAddresses(ctx context.Context, req *mpc_walletspb.ListAddressesRequest, opts ...gax.CallOption) *AddressIterator {
	return c.internalClient.ListAddresses(ctx, req, opts...)
}

// ListBalances returns a list of Balances.
func (c *MPCWalletClient) ListBalances(ctx context.Context, req *mpc_walletspb.ListBalancesRequest, opts ...gax.CallOption) *BalanceIterator {
	return c.internalClient.ListBalances(ctx, req, opts...)
}

// ListBalanceDetails returns a list of BalanceDetails.
func (c *MPCWalletClient) ListBalanceDetails(ctx context.Context, req *mpc_walletspb.ListBalanceDetailsRequest, opts ...gax.CallOption) *BalanceDetailIterator {
	return c.internalClient.ListBalanceDetails(ctx, req, opts...)
}

// mPCWalletGRPCClient is a client for interacting with  over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type mPCWalletGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing MPCWalletClient
	CallOptions **MPCWalletCallOptions

	// The gRPC API client.
	mPCWalletClient mpc_walletspb.MPCWalletServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewMPCWalletClient creates a new mpc wallet service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// A service that manages BIP-32-based Hierarchically Deterministic (HD) collections of on-chain
// Addresses and their associated Asset balances. The Addresses are backed by the MPCKey resources
// of KeyService, and information about the Assets can be queried using BlockchainService. Because
// of the backing by MPC Keys, full functionality of these APIs requires use of the WaaS SDK.
func NewMPCWalletClient(ctx context.Context, opts ...option.ClientOption) (*MPCWalletClient, error) {
	clientOpts := defaultMPCWalletGRPCClientOptions()
	if newMPCWalletClientHook != nil {
		hookOpts, err := newMPCWalletClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := MPCWalletClient{CallOptions: defaultMPCWalletCallOptions()}

	c := &mPCWalletGRPCClient{
		connPool:    connPool,
		disableDeadlines: disableDeadlines,
		mPCWalletClient: mpc_walletspb.NewMPCWalletServiceClient(connPool),
		CallOptions: &client.CallOptions,

	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *mPCWalletGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *mPCWalletGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *mPCWalletGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type mPCWalletRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD

	// Points back to the CallOptions field of the containing MPCWalletClient
	CallOptions **MPCWalletCallOptions
}

// NewMPCWalletRESTClient creates a new mpc wallet service rest client.
//
// A service that manages BIP-32-based Hierarchically Deterministic (HD) collections of on-chain
// Addresses and their associated Asset balances. The Addresses are backed by the MPCKey resources
// of KeyService, and information about the Assets can be queried using BlockchainService. Because
// of the backing by MPC Keys, full functionality of these APIs requires use of the WaaS SDK.
func NewMPCWalletRESTClient(ctx context.Context, opts ...option.ClientOption) (*MPCWalletClient, error) {
	clientOpts := append(defaultMPCWalletRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultMPCWalletRESTCallOptions()
	c := &mPCWalletRESTClient{
		endpoint: endpoint,
		httpClient: httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &MPCWalletClient{internalClient: c, LROClient: opClient, CallOptions: callOpts}, nil
}

func defaultMPCWalletRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://api.developer.coinbase.com/waas/mpc_wallets"),
		internaloption.WithDefaultMTLSEndpoint("https://api.developer.coinbase.com/waas/mpc_wallets"),
		internaloption.WithDefaultAudience("https://api.developer.coinbase.com/waas/mpc_wallets/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}
// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *mPCWalletRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *mPCWalletRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *mPCWalletRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *mPCWalletGRPCClient) CreateMPCWallet(ctx context.Context, req *mpc_walletspb.CreateMPCWalletRequest, opts ...gax.CallOption) (*CreateMPCWalletOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateMPCWallet[0:len((*c.CallOptions).CreateMPCWallet):len((*c.CallOptions).CreateMPCWallet)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCWalletClient.CreateMPCWallet(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateMPCWalletOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *mPCWalletGRPCClient) GetMPCWallet(ctx context.Context, req *mpc_walletspb.GetMPCWalletRequest, opts ...gax.CallOption) (*mpc_walletspb.MPCWallet, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetMPCWallet[0:len((*c.CallOptions).GetMPCWallet):len((*c.CallOptions).GetMPCWallet)], opts...)
	var resp *mpc_walletspb.MPCWallet
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCWalletClient.GetMPCWallet(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCWalletGRPCClient) ListMPCWallets(ctx context.Context, req *mpc_walletspb.ListMPCWalletsRequest, opts ...gax.CallOption) *MPCWalletIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListMPCWallets[0:len((*c.CallOptions).ListMPCWallets):len((*c.CallOptions).ListMPCWallets)], opts...)
	it := &MPCWalletIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListMPCWalletsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.MPCWallet, string, error) {
		resp := &mpc_walletspb.ListMPCWalletsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.mPCWalletClient.ListMPCWallets(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMpcWallets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *mPCWalletGRPCClient) GenerateAddress(ctx context.Context, req *mpc_walletspb.GenerateAddressRequest, opts ...gax.CallOption) (*mpc_walletspb.Address, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "mpc_wallet", url.QueryEscape(req.GetMpcWallet())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GenerateAddress[0:len((*c.CallOptions).GenerateAddress):len((*c.CallOptions).GenerateAddress)], opts...)
	var resp *mpc_walletspb.Address
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCWalletClient.GenerateAddress(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCWalletGRPCClient) GetAddress(ctx context.Context, req *mpc_walletspb.GetAddressRequest, opts ...gax.CallOption) (*mpc_walletspb.Address, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAddress[0:len((*c.CallOptions).GetAddress):len((*c.CallOptions).GetAddress)], opts...)
	var resp *mpc_walletspb.Address
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.mPCWalletClient.GetAddress(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *mPCWalletGRPCClient) ListAddresses(ctx context.Context, req *mpc_walletspb.ListAddressesRequest, opts ...gax.CallOption) *AddressIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAddresses[0:len((*c.CallOptions).ListAddresses):len((*c.CallOptions).ListAddresses)], opts...)
	it := &AddressIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListAddressesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.Address, string, error) {
		resp := &mpc_walletspb.ListAddressesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.mPCWalletClient.ListAddresses(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAddresses(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *mPCWalletGRPCClient) ListBalances(ctx context.Context, req *mpc_walletspb.ListBalancesRequest, opts ...gax.CallOption) *BalanceIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListBalances[0:len((*c.CallOptions).ListBalances):len((*c.CallOptions).ListBalances)], opts...)
	it := &BalanceIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListBalancesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.Balance, string, error) {
		resp := &mpc_walletspb.ListBalancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.mPCWalletClient.ListBalances(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBalances(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *mPCWalletGRPCClient) ListBalanceDetails(ctx context.Context, req *mpc_walletspb.ListBalanceDetailsRequest, opts ...gax.CallOption) *BalanceDetailIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListBalanceDetails[0:len((*c.CallOptions).ListBalanceDetails):len((*c.CallOptions).ListBalanceDetails)], opts...)
	it := &BalanceDetailIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListBalanceDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.BalanceDetail, string, error) {
		resp := &mpc_walletspb.ListBalanceDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.mPCWalletClient.ListBalanceDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBalanceDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateMPCWallet creates an MPCWallet. The Device in the request must have been registered using MPCKeyService’s
// RegisterDevice before this method is called. Under the hood, this calls MPCKeyService’s
// CreateDeviceGroup with the appropriate parameters. After calling this, use MPCKeyService’s
// ListMPCOperations to poll for the pending CreateDeviceGroup operation, and use the WaaS SDK’s
// computeMPCOperation to complete the operation.
// Note: because the creation of MPC operations is asynchronous, ListMPCOperations may return a
// NOT_FOUND error immediately after calling this. To complete the operation, continue polling
// ListMPCOperations even after it returns a NOT_FOUND error.
func (c *mPCWalletRESTClient) CreateMPCWallet(ctx context.Context, req *mpc_walletspb.CreateMPCWalletRequest, opts ...gax.CallOption) (*CreateMPCWalletOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMpcWallet()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/mpcWallets", req.GetParent())

	params := url.Values{}
	params.Add("device", fmt.Sprintf("%v", req.GetDevice()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateMPCWalletOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetMPCWallet retrieves an MPCWallet by resource name.
func (c *mPCWalletRESTClient) GetMPCWallet(ctx context.Context, req *mpc_walletspb.GetMPCWalletRequest, opts ...gax.CallOption) (*mpc_walletspb.MPCWallet, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetMPCWallet[0:len((*c.CallOptions).GetMPCWallet):len((*c.CallOptions).GetMPCWallet)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_walletspb.MPCWallet{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// ListMPCWallets returns a list of MPCWallets in a Pool.
func (c *mPCWalletRESTClient) ListMPCWallets(ctx context.Context, req *mpc_walletspb.ListMPCWalletsRequest, opts ...gax.CallOption) *MPCWalletIterator {
	it := &MPCWalletIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListMPCWalletsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.MPCWallet, string, error) {
		resp := &mpc_walletspb.ListMPCWalletsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/mpcWallets", req.GetParent())

		params := url.Values{}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil{
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := ioutil.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return maybeUnknownEnum(err)
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetMpcWallets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
// GenerateAddress generates an Address within an MPCWallet. The Address values generated are identical across
// Networks of the same protocol family (e.g. EVM). So, for example, calling GenerateAddress twice
// for networks/ethereum-mainnet, and then calling it twice more for networks/ethereum-goerli, will
// result in two pairs of identical addresses on Ethereum Mainnet and Goerli.
func (c *mPCWalletRESTClient) GenerateAddress(ctx context.Context, req *mpc_walletspb.GenerateAddressRequest, opts ...gax.CallOption) (*mpc_walletspb.Address, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:generateAddress", req.GetMpcWallet())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "mpc_wallet", url.QueryEscape(req.GetMpcWallet())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GenerateAddress[0:len((*c.CallOptions).GenerateAddress):len((*c.CallOptions).GenerateAddress)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_walletspb.Address{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// GetAddress retrieves an Address by resource name.
func (c *mPCWalletRESTClient) GetAddress(ctx context.Context, req *mpc_walletspb.GetAddressRequest, opts ...gax.CallOption) (*mpc_walletspb.Address, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetAddress[0:len((*c.CallOptions).GetAddress):len((*c.CallOptions).GetAddress)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &mpc_walletspb.Address{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// ListAddresses returns a list of Addresses in an MPCWallet.
func (c *mPCWalletRESTClient) ListAddresses(ctx context.Context, req *mpc_walletspb.ListAddressesRequest, opts ...gax.CallOption) *AddressIterator {
	it := &AddressIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListAddressesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.Address, string, error) {
		resp := &mpc_walletspb.ListAddressesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/addresses", req.GetParent())

		params := url.Values{}
		if req.GetMpcWallet() != "" {
			params.Add("mpcWallet", fmt.Sprintf("%v", req.GetMpcWallet()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil{
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := ioutil.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return maybeUnknownEnum(err)
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAddresses(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
// ListBalances returns a list of Balances.
func (c *mPCWalletRESTClient) ListBalances(ctx context.Context, req *mpc_walletspb.ListBalancesRequest, opts ...gax.CallOption) *BalanceIterator {
	it := &BalanceIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListBalancesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.Balance, string, error) {
		resp := &mpc_walletspb.ListBalancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/balances", req.GetParent())

		params := url.Values{}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil{
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := ioutil.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return maybeUnknownEnum(err)
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBalances(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
// ListBalanceDetails returns a list of BalanceDetails.
func (c *mPCWalletRESTClient) ListBalanceDetails(ctx context.Context, req *mpc_walletspb.ListBalanceDetailsRequest, opts ...gax.CallOption) *BalanceDetailIterator {
	it := &BalanceDetailIterator{}
	req = proto.Clone(req).(*mpc_walletspb.ListBalanceDetailsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*mpc_walletspb.BalanceDetail, string, error) {
		resp := &mpc_walletspb.ListBalanceDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/balanceDetails", req.GetParent())

		params := url.Values{}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil{
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := ioutil.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return maybeUnknownEnum(err)
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBalanceDetails(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
// CreateMPCWalletOperation manages a long-running operation from CreateMPCWallet.
type CreateMPCWalletOperation struct {
	lro *longrunning.Operation
	pollPath string
}

// CreateMPCWalletOperation returns a new CreateMPCWalletOperation from a given name.
// The name must be that of a previously created CreateMPCWalletOperation, possibly from a different process.
func (c *mPCWalletGRPCClient) CreateMPCWalletOperation(name string) *CreateMPCWalletOperation {
	return &CreateMPCWalletOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateMPCWalletOperation returns a new CreateMPCWalletOperation from a given name.
// The name must be that of a previously created CreateMPCWalletOperation, possibly from a different process.
func (c *mPCWalletRESTClient) CreateMPCWalletOperation(name string) *CreateMPCWalletOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateMPCWalletOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateMPCWalletOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*mpc_walletspb.MPCWallet, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_walletspb.MPCWallet
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateMPCWalletOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*mpc_walletspb.MPCWallet, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp mpc_walletspb.MPCWallet
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateMPCWalletOperation) Metadata() (*mpc_walletspb.CreateMPCWalletMetadata, error) {
	var meta mpc_walletspb.CreateMPCWalletMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateMPCWalletOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateMPCWalletOperation) Name() string {
	return op.lro.Name()
}

// AddressIterator manages a stream of *mpc_walletspb.Address.
type AddressIterator struct {
	items    []*mpc_walletspb.Address
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*mpc_walletspb.Address, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AddressIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AddressIterator) Next() (*mpc_walletspb.Address, error) {
	var item *mpc_walletspb.Address
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AddressIterator) bufLen() int {
	return len(it.items)
}

func (it *AddressIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// BalanceDetailIterator manages a stream of *mpc_walletspb.BalanceDetail.
type BalanceDetailIterator struct {
	items    []*mpc_walletspb.BalanceDetail
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*mpc_walletspb.BalanceDetail, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *BalanceDetailIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *BalanceDetailIterator) Next() (*mpc_walletspb.BalanceDetail, error) {
	var item *mpc_walletspb.BalanceDetail
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *BalanceDetailIterator) bufLen() int {
	return len(it.items)
}

func (it *BalanceDetailIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// BalanceIterator manages a stream of *mpc_walletspb.Balance.
type BalanceIterator struct {
	items    []*mpc_walletspb.Balance
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*mpc_walletspb.Balance, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *BalanceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *BalanceIterator) Next() (*mpc_walletspb.Balance, error) {
	var item *mpc_walletspb.Balance
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *BalanceIterator) bufLen() int {
	return len(it.items)
}

func (it *BalanceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// MPCWalletIterator manages a stream of *mpc_walletspb.MPCWallet.
type MPCWalletIterator struct {
	items    []*mpc_walletspb.MPCWallet
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*mpc_walletspb.MPCWallet, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *MPCWalletIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *MPCWalletIterator) Next() (*mpc_walletspb.MPCWallet, error) {
	var item *mpc_walletspb.MPCWallet
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *MPCWalletIterator) bufLen() int {
	return len(it.items)
}

func (it *MPCWalletIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
