// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

// VersionSelected - Certificate version v1(0), v2(1), v3(2).
type VersionSelected string

const (
	VersionSelectedUnknown VersionSelected = ""
	VersionSelectedSsLv2   VersionSelected = "ss_lv_2"
	VersionSelectedSsLv3   VersionSelected = "ss_lv_3"
	VersionSelectedTlsv10  VersionSelected = "tlsv1_0"
	VersionSelectedTlsv11  VersionSelected = "tlsv1_1"
	VersionSelectedTlsv12  VersionSelected = "tlsv1_2"
	VersionSelectedTlsv13  VersionSelected = "tlsv1_3"
	VersionSelectedDtlsv10 VersionSelected = "dtlsv1_0"
	VersionSelectedDtlsv12 VersionSelected = "dtlsv1_2"
	VersionSelectedDtlsv13 VersionSelected = "dtlsv1_3"
)

func (e VersionSelected) ToPointer() *VersionSelected {
	return &e
}
func (e *VersionSelected) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "ss_lv_2":
		fallthrough
	case "ss_lv_3":
		fallthrough
	case "tlsv1_0":
		fallthrough
	case "tlsv1_1":
		fallthrough
	case "tlsv1_2":
		fallthrough
	case "tlsv1_3":
		fallthrough
	case "dtlsv1_0":
		fallthrough
	case "dtlsv1_2":
		fallthrough
	case "dtlsv1_3":
		*e = VersionSelected(v)
		return nil
	default:
		return fmt.Errorf("invalid value for VersionSelected: %v", v)
	}
}

type TLS struct {
	// Cipher suite chosen for the exchange.
	CipherSelected *string `json:"cipher_selected,omitempty"`
	// The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records.
	FingerprintSha256 *string `json:"fingerprint_sha256,omitempty"`
	// The JA3S fingerprint for this service.
	Ja3s *string `json:"ja3s,omitempty"`
	Ja4s *string `json:"ja4s,omitempty"`
	// Certificate chain information.
	PresentedChain []TLSChain `json:"presented_chain,omitempty"`
	// Certificate version v1(0), v2(1), v3(2).
	VersionSelected *VersionSelected `json:"version_selected,omitempty"`
	Versions        []TLSVersionData `json:"versions,omitempty"`
}

func (o *TLS) GetCipherSelected() *string {
	if o == nil {
		return nil
	}
	return o.CipherSelected
}

func (o *TLS) GetFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.FingerprintSha256
}

func (o *TLS) GetJa3s() *string {
	if o == nil {
		return nil
	}
	return o.Ja3s
}

func (o *TLS) GetJa4s() *string {
	if o == nil {
		return nil
	}
	return o.Ja4s
}

func (o *TLS) GetPresentedChain() []TLSChain {
	if o == nil {
		return nil
	}
	return o.PresentedChain
}

func (o *TLS) GetVersionSelected() *VersionSelected {
	if o == nil {
		return nil
	}
	return o.VersionSelected
}

func (o *TLS) GetVersions() []TLSVersionData {
	if o == nil {
		return nil
	}
	return o.Versions
}
