// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

// KEVSource - The source checked to determine whether the CVE is in the KEV catalog.
type KEVSource string

const (
	KEVSourceUnknown    KEVSource = ""
	KEVSourceCisa       KEVSource = "cisa"
	KEVSourceThirdParty KEVSource = "third_party"
)

func (e KEVSource) ToPointer() *KEVSource {
	return &e
}
func (e *KEVSource) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "cisa":
		fallthrough
	case "third_party":
		*e = KEVSource(v)
		return nil
	default:
		return fmt.Errorf("invalid value for KEVSource: %v", v)
	}
}

type Kev struct {
	// The date the vulnerability was added to the KEV catalog.
	DateAdded *string `json:"date_added,omitempty"`
	// Per CISA’s Binding Operation Directive 22-01, the date all federal civilian executive branch (FCEB) agencies are required to remediate vulnerabilities in the KEV catalog.
	DateDue *string `json:"date_due,omitempty"`
	// The source checked to determine whether the CVE is in the KEV catalog.
	Source *KEVSource `json:"source,omitempty"`
}

func (o *Kev) GetDateAdded() *string {
	if o == nil {
		return nil
	}
	return o.DateAdded
}

func (o *Kev) GetDateDue() *string {
	if o == nil {
		return nil
	}
	return o.DateDue
}

func (o *Kev) GetSource() *KEVSource {
	if o == nil {
		return nil
	}
	return o.Source
}
