// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type TransportProtocol string

const (
	TransportProtocolUnknown TransportProtocol = ""
	TransportProtocolTCP     TransportProtocol = "tcp"
	TransportProtocolUDP     TransportProtocol = "udp"
	TransportProtocolIcmp    TransportProtocol = "icmp"
	TransportProtocolQuic    TransportProtocol = "quic"
)

func (e TransportProtocol) ToPointer() *TransportProtocol {
	return &e
}
func (e *TransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = TransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for TransportProtocol: %v", v)
	}
}

type EndpointScanState struct {
	Banner            *string            `json:"banner,omitempty"`
	BannerHashSha256  *string            `json:"banner_hash_sha256,omitempty"`
	ChromeDevtools    *ChromeDevtools    `json:"chrome_devtools,omitempty"`
	CobaltStrike      *CobaltStrike      `json:"cobalt_strike,omitempty"`
	Elasticsearch     *ElasticSearch     `json:"elasticsearch,omitempty"`
	EndpointType      *string            `json:"endpoint_type,omitempty"`
	Fortigate         *Fortigate         `json:"fortigate,omitempty"`
	Graphql           *Graphql           `json:"graphql,omitempty"`
	Hostname          *string            `json:"hostname,omitempty"`
	HTTP              *HTTP              `json:"http,omitempty"`
	IP                *string            `json:"ip,omitempty"`
	IvantiAvalanche   *IvantiAvalanche   `json:"ivanti_avalanche,omitempty"`
	Kubernetes        *Kubernetes        `json:"kubernetes,omitempty"`
	Ollama            *Ollama            `json:"ollama,omitempty"`
	OpenDirectory     *OpenDirectory     `json:"open_directory,omitempty"`
	Path              *string            `json:"path,omitempty"`
	PlexMediaServer   *PlexMediaServer   `json:"plex_media_server,omitempty"`
	Port              *int               `json:"port,omitempty"`
	Pprof             *Pprof             `json:"pprof,omitempty"`
	Prometheus        *Prometheus        `json:"prometheus,omitempty"`
	PrometheusTarget  *PrometheusTarget  `json:"prometheus_target,omitempty"`
	RedlionWeb        *RedlionWeb        `json:"redlion_web,omitempty"`
	ScadaView         *ScadaView         `json:"scada_view,omitempty"`
	ScanTime          *string            `json:"scan_time,omitempty"`
	Screenshots       []Screenshot       `json:"screenshots,omitempty"`
	TransportProtocol *TransportProtocol `json:"transport_protocol,omitempty"`
}

func (o *EndpointScanState) GetBanner() *string {
	if o == nil {
		return nil
	}
	return o.Banner
}

func (o *EndpointScanState) GetBannerHashSha256() *string {
	if o == nil {
		return nil
	}
	return o.BannerHashSha256
}

func (o *EndpointScanState) GetChromeDevtools() *ChromeDevtools {
	if o == nil {
		return nil
	}
	return o.ChromeDevtools
}

func (o *EndpointScanState) GetCobaltStrike() *CobaltStrike {
	if o == nil {
		return nil
	}
	return o.CobaltStrike
}

func (o *EndpointScanState) GetElasticsearch() *ElasticSearch {
	if o == nil {
		return nil
	}
	return o.Elasticsearch
}

func (o *EndpointScanState) GetEndpointType() *string {
	if o == nil {
		return nil
	}
	return o.EndpointType
}

func (o *EndpointScanState) GetFortigate() *Fortigate {
	if o == nil {
		return nil
	}
	return o.Fortigate
}

func (o *EndpointScanState) GetGraphql() *Graphql {
	if o == nil {
		return nil
	}
	return o.Graphql
}

func (o *EndpointScanState) GetHostname() *string {
	if o == nil {
		return nil
	}
	return o.Hostname
}

func (o *EndpointScanState) GetHTTP() *HTTP {
	if o == nil {
		return nil
	}
	return o.HTTP
}

func (o *EndpointScanState) GetIP() *string {
	if o == nil {
		return nil
	}
	return o.IP
}

func (o *EndpointScanState) GetIvantiAvalanche() *IvantiAvalanche {
	if o == nil {
		return nil
	}
	return o.IvantiAvalanche
}

func (o *EndpointScanState) GetKubernetes() *Kubernetes {
	if o == nil {
		return nil
	}
	return o.Kubernetes
}

func (o *EndpointScanState) GetOllama() *Ollama {
	if o == nil {
		return nil
	}
	return o.Ollama
}

func (o *EndpointScanState) GetOpenDirectory() *OpenDirectory {
	if o == nil {
		return nil
	}
	return o.OpenDirectory
}

func (o *EndpointScanState) GetPath() *string {
	if o == nil {
		return nil
	}
	return o.Path
}

func (o *EndpointScanState) GetPlexMediaServer() *PlexMediaServer {
	if o == nil {
		return nil
	}
	return o.PlexMediaServer
}

func (o *EndpointScanState) GetPort() *int {
	if o == nil {
		return nil
	}
	return o.Port
}

func (o *EndpointScanState) GetPprof() *Pprof {
	if o == nil {
		return nil
	}
	return o.Pprof
}

func (o *EndpointScanState) GetPrometheus() *Prometheus {
	if o == nil {
		return nil
	}
	return o.Prometheus
}

func (o *EndpointScanState) GetPrometheusTarget() *PrometheusTarget {
	if o == nil {
		return nil
	}
	return o.PrometheusTarget
}

func (o *EndpointScanState) GetRedlionWeb() *RedlionWeb {
	if o == nil {
		return nil
	}
	return o.RedlionWeb
}

func (o *EndpointScanState) GetScadaView() *ScadaView {
	if o == nil {
		return nil
	}
	return o.ScadaView
}

func (o *EndpointScanState) GetScanTime() *string {
	if o == nil {
		return nil
	}
	return o.ScanTime
}

func (o *EndpointScanState) GetScreenshots() []Screenshot {
	if o == nil {
		return nil
	}
	return o.Screenshots
}

func (o *EndpointScanState) GetTransportProtocol() *TransportProtocol {
	if o == nil {
		return nil
	}
	return o.TransportProtocol
}
