// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

// CVSSv4ComponentsAttackComplexity - Indicates conditions beyond the attacker’s control that must exist in order to exploit the vulnerability. The Attack Complexity metric is scored as either Low or High. There are two possible values: Low (L) – There are no specific pre-conditions required for exploitation, High (H) – The attacker must complete some number of preparatory steps in order to get access.
type CVSSv4ComponentsAttackComplexity string

const (
	CVSSv4ComponentsAttackComplexityUnknown CVSSv4ComponentsAttackComplexity = ""
	CVSSv4ComponentsAttackComplexityLow     CVSSv4ComponentsAttackComplexity = "low"
	CVSSv4ComponentsAttackComplexityHigh    CVSSv4ComponentsAttackComplexity = "high"
)

func (e CVSSv4ComponentsAttackComplexity) ToPointer() *CVSSv4ComponentsAttackComplexity {
	return &e
}
func (e *CVSSv4ComponentsAttackComplexity) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "low":
		fallthrough
	case "high":
		*e = CVSSv4ComponentsAttackComplexity(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsAttackComplexity: %v", v)
	}
}

type AttackRequirements string

const (
	AttackRequirementsUnknown AttackRequirements = ""
	AttackRequirementsNone    AttackRequirements = "none"
	AttackRequirementsPresent AttackRequirements = "present"
)

func (e AttackRequirements) ToPointer() *AttackRequirements {
	return &e
}
func (e *AttackRequirements) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "none":
		fallthrough
	case "present":
		*e = AttackRequirements(v)
		return nil
	default:
		return fmt.Errorf("invalid value for AttackRequirements: %v", v)
	}
}

// CVSSv4ComponentsAttackVector - Indicates the level of access required for an attacker to exploit the vulnerability. The Attack Vector metric is scored in one of four levels: Network (N) – Vulnerabilities with this rating are remotely exploitable, from one or more hops away, up to, and including, remote exploitation over the Internet, Adjacent (A) – A vulnerability with this rating requires network adjacency for exploitation. The attack must be launched from the same physical or logical network, Local (L) – Vulnerabilities with this rating are not exploitable over a network, Physical (P) – An attacker must physically interact with the target system.
type CVSSv4ComponentsAttackVector string

const (
	CVSSv4ComponentsAttackVectorUnknown  CVSSv4ComponentsAttackVector = ""
	CVSSv4ComponentsAttackVectorNetwork  CVSSv4ComponentsAttackVector = "network"
	CVSSv4ComponentsAttackVectorAdjacent CVSSv4ComponentsAttackVector = "adjacent"
	CVSSv4ComponentsAttackVectorLocal    CVSSv4ComponentsAttackVector = "local"
	CVSSv4ComponentsAttackVectorPhysical CVSSv4ComponentsAttackVector = "physical"
)

func (e CVSSv4ComponentsAttackVector) ToPointer() *CVSSv4ComponentsAttackVector {
	return &e
}
func (e *CVSSv4ComponentsAttackVector) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "network":
		fallthrough
	case "adjacent":
		fallthrough
	case "local":
		fallthrough
	case "physical":
		*e = CVSSv4ComponentsAttackVector(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsAttackVector: %v", v)
	}
}

type Automatable string

const (
	AutomatableUnknown Automatable = ""
	AutomatableNo      Automatable = "no"
	AutomatableYes     Automatable = "yes"
)

func (e Automatable) ToPointer() *Automatable {
	return &e
}
func (e *Automatable) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "no":
		fallthrough
	case "yes":
		*e = Automatable(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Automatable: %v", v)
	}
}

// CVSSv4ComponentsAvailability - If an attack renders information unavailable, such as when a system crashes or through a DDoS attack, availability is negatively impacted. Availability has three possible values: None (N) – There is no loss of availability, Low (L) – Availability might be intermittently limited, or performance might be negatively impacted, as a result of a successful attack, High (H) – There is a complete loss of availability of the impacted system or information.
type CVSSv4ComponentsAvailability string

const (
	CVSSv4ComponentsAvailabilityUnknown CVSSv4ComponentsAvailability = ""
	CVSSv4ComponentsAvailabilityNone    CVSSv4ComponentsAvailability = "none"
	CVSSv4ComponentsAvailabilityLow     CVSSv4ComponentsAvailability = "low"
	CVSSv4ComponentsAvailabilityHigh    CVSSv4ComponentsAvailability = "high"
)

func (e CVSSv4ComponentsAvailability) ToPointer() *CVSSv4ComponentsAvailability {
	return &e
}
func (e *CVSSv4ComponentsAvailability) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "none":
		fallthrough
	case "low":
		fallthrough
	case "high":
		*e = CVSSv4ComponentsAvailability(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsAvailability: %v", v)
	}
}

// CVSSv4ComponentsConfidentiality - Refers to the disclosure of sensitive information to authorized and unauthorized users, with the goal being that only authorized users are able to access the target data. Confidentiality has three potential values: High (H) – The attacker has full access to all resources in the impacted system, including highly sensitive information such as encryption keys, Low (L) – The attacker has partial access to information, with no control over what, specifically, they are able to access, None (N) – No data is accessible to unauthorized users as a result of the exploit.
type CVSSv4ComponentsConfidentiality string

const (
	CVSSv4ComponentsConfidentialityUnknown CVSSv4ComponentsConfidentiality = ""
	CVSSv4ComponentsConfidentialityNone    CVSSv4ComponentsConfidentiality = "none"
	CVSSv4ComponentsConfidentialityLow     CVSSv4ComponentsConfidentiality = "low"
	CVSSv4ComponentsConfidentialityHigh    CVSSv4ComponentsConfidentiality = "high"
)

func (e CVSSv4ComponentsConfidentiality) ToPointer() *CVSSv4ComponentsConfidentiality {
	return &e
}
func (e *CVSSv4ComponentsConfidentiality) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "none":
		fallthrough
	case "low":
		fallthrough
	case "high":
		*e = CVSSv4ComponentsConfidentiality(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsConfidentiality: %v", v)
	}
}

// CVSSv4ComponentsIntegrity - Refers to whether the protected information has been tampered with or changed in any way. If there is no way for an attacker to alter the accuracy or completeness of the information, integrity has been maintained. Integrity has three values: None (N) – There is no loss of the integrity of any information, Low (L) – A limited amount of information might be tampered with or modified, but there is no serious impact on the protected system, High (H) – The attacker can modify any/all information on the target system, resulting in a complete loss of integrity.
type CVSSv4ComponentsIntegrity string

const (
	CVSSv4ComponentsIntegrityUnknown CVSSv4ComponentsIntegrity = ""
	CVSSv4ComponentsIntegrityNone    CVSSv4ComponentsIntegrity = "none"
	CVSSv4ComponentsIntegrityLow     CVSSv4ComponentsIntegrity = "low"
	CVSSv4ComponentsIntegrityHigh    CVSSv4ComponentsIntegrity = "high"
)

func (e CVSSv4ComponentsIntegrity) ToPointer() *CVSSv4ComponentsIntegrity {
	return &e
}
func (e *CVSSv4ComponentsIntegrity) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "none":
		fallthrough
	case "low":
		fallthrough
	case "high":
		*e = CVSSv4ComponentsIntegrity(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsIntegrity: %v", v)
	}
}

// CVSSv4ComponentsPrivilegesRequired - Describes the level of privileges or access an attacker must have before successful exploitation. There are three possible values: None (N) – There is no privilege or special access required to conduct the attack, Low (L) – The attacker requires basic, “user” level privileges to leverage the exploit, High (H) – Administrative or similar access privileges are required for successful attack.
type CVSSv4ComponentsPrivilegesRequired string

const (
	CVSSv4ComponentsPrivilegesRequiredUnknown CVSSv4ComponentsPrivilegesRequired = ""
	CVSSv4ComponentsPrivilegesRequiredNone    CVSSv4ComponentsPrivilegesRequired = "none"
	CVSSv4ComponentsPrivilegesRequiredLow     CVSSv4ComponentsPrivilegesRequired = "low"
	CVSSv4ComponentsPrivilegesRequiredHigh    CVSSv4ComponentsPrivilegesRequired = "high"
)

func (e CVSSv4ComponentsPrivilegesRequired) ToPointer() *CVSSv4ComponentsPrivilegesRequired {
	return &e
}
func (e *CVSSv4ComponentsPrivilegesRequired) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "none":
		fallthrough
	case "low":
		fallthrough
	case "high":
		*e = CVSSv4ComponentsPrivilegesRequired(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsPrivilegesRequired: %v", v)
	}
}

type ProviderUrgency string

const (
	ProviderUrgencyUnknown ProviderUrgency = ""
	ProviderUrgencyClear   ProviderUrgency = "clear"
	ProviderUrgencyGreen   ProviderUrgency = "green"
	ProviderUrgencyAmber   ProviderUrgency = "amber"
	ProviderUrgencyRed     ProviderUrgency = "red"
)

func (e ProviderUrgency) ToPointer() *ProviderUrgency {
	return &e
}
func (e *ProviderUrgency) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "clear":
		fallthrough
	case "green":
		fallthrough
	case "amber":
		fallthrough
	case "red":
		*e = ProviderUrgency(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ProviderUrgency: %v", v)
	}
}

type Recovery string

const (
	RecoveryUnknown       Recovery = ""
	RecoveryAutomatic     Recovery = "automatic"
	RecoveryUser          Recovery = "user"
	RecoveryIrrecoverable Recovery = "irrecoverable"
)

func (e Recovery) ToPointer() *Recovery {
	return &e
}
func (e *Recovery) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "automatic":
		fallthrough
	case "user":
		fallthrough
	case "irrecoverable":
		*e = Recovery(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Recovery: %v", v)
	}
}

type Safety string

const (
	SafetyUnknown    Safety = ""
	SafetyNegligible Safety = "negligible"
	SafetyPresent    Safety = "present"
)

func (e Safety) ToPointer() *Safety {
	return &e
}
func (e *Safety) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "negligible":
		fallthrough
	case "present":
		*e = Safety(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Safety: %v", v)
	}
}

// CVSSv4ComponentsUserInteraction - Describes whether a user, other than the attacker, is required to do anything or participate in exploitation of the vulnerability. User interaction has two possible values: None (N) – No user interaction is required, Required (R) – A user must complete some steps for the exploit to succeed. For example, a user might be required to install some software.
type CVSSv4ComponentsUserInteraction string

const (
	CVSSv4ComponentsUserInteractionUnknown  CVSSv4ComponentsUserInteraction = ""
	CVSSv4ComponentsUserInteractionNone     CVSSv4ComponentsUserInteraction = "none"
	CVSSv4ComponentsUserInteractionRequired CVSSv4ComponentsUserInteraction = "required"
)

func (e CVSSv4ComponentsUserInteraction) ToPointer() *CVSSv4ComponentsUserInteraction {
	return &e
}
func (e *CVSSv4ComponentsUserInteraction) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "none":
		fallthrough
	case "required":
		*e = CVSSv4ComponentsUserInteraction(v)
		return nil
	default:
		return fmt.Errorf("invalid value for CVSSv4ComponentsUserInteraction: %v", v)
	}
}

type ValueDensity string

const (
	ValueDensityUnknown      ValueDensity = ""
	ValueDensityDiffuse      ValueDensity = "diffuse"
	ValueDensityConcentrated ValueDensity = "concentrated"
)

func (e ValueDensity) ToPointer() *ValueDensity {
	return &e
}
func (e *ValueDensity) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "diffuse":
		fallthrough
	case "concentrated":
		*e = ValueDensity(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ValueDensity: %v", v)
	}
}

type VulnerabilityResponseEffort string

const (
	VulnerabilityResponseEffortUnknown  VulnerabilityResponseEffort = ""
	VulnerabilityResponseEffortLow      VulnerabilityResponseEffort = "low"
	VulnerabilityResponseEffortModerate VulnerabilityResponseEffort = "moderate"
	VulnerabilityResponseEffortHigh     VulnerabilityResponseEffort = "high"
)

func (e VulnerabilityResponseEffort) ToPointer() *VulnerabilityResponseEffort {
	return &e
}
func (e *VulnerabilityResponseEffort) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "low":
		fallthrough
	case "moderate":
		fallthrough
	case "high":
		*e = VulnerabilityResponseEffort(v)
		return nil
	default:
		return fmt.Errorf("invalid value for VulnerabilityResponseEffort: %v", v)
	}
}

type CVSSv4Components struct {
	// Indicates conditions beyond the attacker’s control that must exist in order to exploit the vulnerability. The Attack Complexity metric is scored as either Low or High. There are two possible values: Low (L) – There are no specific pre-conditions required for exploitation, High (H) – The attacker must complete some number of preparatory steps in order to get access.
	AttackComplexity   *CVSSv4ComponentsAttackComplexity `json:"attack_complexity,omitempty"`
	AttackRequirements *AttackRequirements               `json:"attack_requirements,omitempty"`
	// Indicates the level of access required for an attacker to exploit the vulnerability. The Attack Vector metric is scored in one of four levels: Network (N) – Vulnerabilities with this rating are remotely exploitable, from one or more hops away, up to, and including, remote exploitation over the Internet, Adjacent (A) – A vulnerability with this rating requires network adjacency for exploitation. The attack must be launched from the same physical or logical network, Local (L) – Vulnerabilities with this rating are not exploitable over a network, Physical (P) – An attacker must physically interact with the target system.
	AttackVector *CVSSv4ComponentsAttackVector `json:"attack_vector,omitempty"`
	Automatable  *Automatable                  `json:"automatable,omitempty"`
	// If an attack renders information unavailable, such as when a system crashes or through a DDoS attack, availability is negatively impacted. Availability has three possible values: None (N) – There is no loss of availability, Low (L) – Availability might be intermittently limited, or performance might be negatively impacted, as a result of a successful attack, High (H) – There is a complete loss of availability of the impacted system or information.
	Availability *CVSSv4ComponentsAvailability `json:"availability,omitempty"`
	// Refers to the disclosure of sensitive information to authorized and unauthorized users, with the goal being that only authorized users are able to access the target data. Confidentiality has three potential values: High (H) – The attacker has full access to all resources in the impacted system, including highly sensitive information such as encryption keys, Low (L) – The attacker has partial access to information, with no control over what, specifically, they are able to access, None (N) – No data is accessible to unauthorized users as a result of the exploit.
	Confidentiality *CVSSv4ComponentsConfidentiality `json:"confidentiality,omitempty"`
	// Refers to whether the protected information has been tampered with or changed in any way. If there is no way for an attacker to alter the accuracy or completeness of the information, integrity has been maintained. Integrity has three values: None (N) – There is no loss of the integrity of any information, Low (L) – A limited amount of information might be tampered with or modified, but there is no serious impact on the protected system, High (H) – The attacker can modify any/all information on the target system, resulting in a complete loss of integrity.
	Integrity *CVSSv4ComponentsIntegrity `json:"integrity,omitempty"`
	// Describes the level of privileges or access an attacker must have before successful exploitation. There are three possible values: None (N) – There is no privilege or special access required to conduct the attack, Low (L) – The attacker requires basic, “user” level privileges to leverage the exploit, High (H) – Administrative or similar access privileges are required for successful attack.
	PrivilegesRequired *CVSSv4ComponentsPrivilegesRequired `json:"privileges_required,omitempty"`
	ProviderUrgency    *ProviderUrgency                    `json:"provider_urgency,omitempty"`
	Recovery           *Recovery                           `json:"recovery,omitempty"`
	Safety             *Safety                             `json:"safety,omitempty"`
	// Describes whether a user, other than the attacker, is required to do anything or participate in exploitation of the vulnerability. User interaction has two possible values: None (N) – No user interaction is required, Required (R) – A user must complete some steps for the exploit to succeed. For example, a user might be required to install some software.
	UserInteraction             *CVSSv4ComponentsUserInteraction `json:"user_interaction,omitempty"`
	ValueDensity                *ValueDensity                    `json:"value_density,omitempty"`
	VulnerabilityResponseEffort *VulnerabilityResponseEffort     `json:"vulnerability_response_effort,omitempty"`
}

func (o *CVSSv4Components) GetAttackComplexity() *CVSSv4ComponentsAttackComplexity {
	if o == nil {
		return nil
	}
	return o.AttackComplexity
}

func (o *CVSSv4Components) GetAttackRequirements() *AttackRequirements {
	if o == nil {
		return nil
	}
	return o.AttackRequirements
}

func (o *CVSSv4Components) GetAttackVector() *CVSSv4ComponentsAttackVector {
	if o == nil {
		return nil
	}
	return o.AttackVector
}

func (o *CVSSv4Components) GetAutomatable() *Automatable {
	if o == nil {
		return nil
	}
	return o.Automatable
}

func (o *CVSSv4Components) GetAvailability() *CVSSv4ComponentsAvailability {
	if o == nil {
		return nil
	}
	return o.Availability
}

func (o *CVSSv4Components) GetConfidentiality() *CVSSv4ComponentsConfidentiality {
	if o == nil {
		return nil
	}
	return o.Confidentiality
}

func (o *CVSSv4Components) GetIntegrity() *CVSSv4ComponentsIntegrity {
	if o == nil {
		return nil
	}
	return o.Integrity
}

func (o *CVSSv4Components) GetPrivilegesRequired() *CVSSv4ComponentsPrivilegesRequired {
	if o == nil {
		return nil
	}
	return o.PrivilegesRequired
}

func (o *CVSSv4Components) GetProviderUrgency() *ProviderUrgency {
	if o == nil {
		return nil
	}
	return o.ProviderUrgency
}

func (o *CVSSv4Components) GetRecovery() *Recovery {
	if o == nil {
		return nil
	}
	return o.Recovery
}

func (o *CVSSv4Components) GetSafety() *Safety {
	if o == nil {
		return nil
	}
	return o.Safety
}

func (o *CVSSv4Components) GetUserInteraction() *CVSSv4ComponentsUserInteraction {
	if o == nil {
		return nil
	}
	return o.UserInteraction
}

func (o *CVSSv4Components) GetValueDensity() *ValueDensity {
	if o == nil {
		return nil
	}
	return o.ValueDensity
}

func (o *CVSSv4Components) GetVulnerabilityResponseEffort() *VulnerabilityResponseEffort {
	if o == nil {
		return nil
	}
	return o.VulnerabilityResponseEffort
}
