// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type Source string

const (
	SourceUnknown    Source = ""
	SourceCensys     Source = "censys"
	SourceRecog      Source = "recog"
	SourceWappalyzer Source = "wappalyzer"
	SourceThirdParty Source = "third_party"
)

func (e Source) ToPointer() *Source {
	return &e
}
func (e *Source) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "censys":
		fallthrough
	case "recog":
		fallthrough
	case "wappalyzer":
		fallthrough
	case "third_party":
		*e = Source(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Source: %v", v)
	}
}

type Attribute struct {
	Components []Cpe         `json:"components,omitempty"`
	Confidence *float64      `json:"confidence,omitempty"`
	Cpe        *string       `json:"cpe,omitempty"`
	Edition    *string       `json:"edition,omitempty"`
	Evidence   []Evidence    `json:"evidence,omitempty"`
	LifeCycle  *CPELifeCycle `json:"life_cycle,omitempty"`
	Part       *string       `json:"part,omitempty"`
	Product    *string       `json:"product,omitempty"`
	Source     *Source       `json:"source,omitempty"`
	Type       []string      `json:"type,omitempty"`
	Update     *string       `json:"update,omitempty"`
	Vendor     *string       `json:"vendor,omitempty"`
	Version    *string       `json:"version,omitempty"`
}

func (o *Attribute) GetComponents() []Cpe {
	if o == nil {
		return nil
	}
	return o.Components
}

func (o *Attribute) GetConfidence() *float64 {
	if o == nil {
		return nil
	}
	return o.Confidence
}

func (o *Attribute) GetCpe() *string {
	if o == nil {
		return nil
	}
	return o.Cpe
}

func (o *Attribute) GetEdition() *string {
	if o == nil {
		return nil
	}
	return o.Edition
}

func (o *Attribute) GetEvidence() []Evidence {
	if o == nil {
		return nil
	}
	return o.Evidence
}

func (o *Attribute) GetLifeCycle() *CPELifeCycle {
	if o == nil {
		return nil
	}
	return o.LifeCycle
}

func (o *Attribute) GetPart() *string {
	if o == nil {
		return nil
	}
	return o.Part
}

func (o *Attribute) GetProduct() *string {
	if o == nil {
		return nil
	}
	return o.Product
}

func (o *Attribute) GetSource() *Source {
	if o == nil {
		return nil
	}
	return o.Source
}

func (o *Attribute) GetType() []string {
	if o == nil {
		return nil
	}
	return o.Type
}

func (o *Attribute) GetUpdate() *string {
	if o == nil {
		return nil
	}
	return o.Update
}

func (o *Attribute) GetVendor() *string {
	if o == nil {
		return nil
	}
	return o.Vendor
}

func (o *Attribute) GetVersion() *string {
	if o == nil {
		return nil
	}
	return o.Version
}
