package plot

import (
	"runtime/metrics"
	"time"
)

var _ = register(description{
	metrics: []string{
		"/gc/cycles/automatic:gc-cycles",
		"/gc/cycles/forced:gc-cycles",
		"/gc/cycles/total:gc-cycles",
	},
	getvalues: func() getvalues {
		deltaauto := delta[uint64]()
		deltaforced := delta[uint64]()
		deltatotal := delta[uint64]()

		return func(_ time.Time, samples []metrics.Sample) any {
			auto := samples[idx_gc_cycles_automatic_gc_cycles].Value.Uint64()
			forced := samples[idx_gc_cycles_forced_gc_cycles].Value.Uint64()
			total := samples[idx_gc_cycles_total_gc_cycles].Value.Uint64()

			return []uint64{deltaauto(auto), deltaforced(forced), deltatotal(total)}
		}
	},
	layout: Scatter{
		Name:  "gc-cycles",
		Tags:  []tag{tagGC},
		Title: "Completed GC Cycles",
		Type:  "bar",
		Layout: ScatterLayout{
			BarMode: "stack",
			Yaxis: ScatterYAxis{
				Title: "cycles",
			},
		},
		Subplots: []Subplot{
			{Unitfmt: "%{y}", Type: "bar", Name: "automatic"},
			{Unitfmt: "%{y}", Type: "bar", Name: "forced"},
			{Unitfmt: "%{y}", Type: "scatter", Name: "total"},
		},
		InfoText: `Number of completed GC cycles, either forced of generated by the Go runtime.`,
	},
})
