package locksapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2016-09-01/locks"
	"github.com/Azure/go-autorest/autorest"
)

// AuthorizationOperationsClientAPI contains the set of methods on the AuthorizationOperationsClient type.
type AuthorizationOperationsClientAPI interface {
	List(ctx context.Context) (result locks.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result locks.OperationListResultIterator, err error)
}

var _ AuthorizationOperationsClientAPI = (*locks.AuthorizationOperationsClient)(nil)

// ManagementLocksClientAPI contains the set of methods on the ManagementLocksClient type.
type ManagementLocksClientAPI interface {
	CreateOrUpdateAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	CreateOrUpdateAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	CreateOrUpdateAtSubscriptionLevel(ctx context.Context, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	CreateOrUpdateByScope(ctx context.Context, scope string, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	DeleteAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string) (result autorest.Response, err error)
	DeleteAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (result autorest.Response, err error)
	DeleteAtSubscriptionLevel(ctx context.Context, lockName string) (result autorest.Response, err error)
	DeleteByScope(ctx context.Context, scope string, lockName string) (result autorest.Response, err error)
	GetAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string) (result locks.ManagementLockObject, err error)
	GetAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (result locks.ManagementLockObject, err error)
	GetAtSubscriptionLevel(ctx context.Context, lockName string) (result locks.ManagementLockObject, err error)
	GetByScope(ctx context.Context, scope string, lockName string) (result locks.ManagementLockObject, err error)
	ListAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string) (result locks.ManagementLockListResultPage, err error)
	ListAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string) (result locks.ManagementLockListResultIterator, err error)
	ListAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (result locks.ManagementLockListResultPage, err error)
	ListAtResourceLevelComplete(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (result locks.ManagementLockListResultIterator, err error)
	ListAtSubscriptionLevel(ctx context.Context, filter string) (result locks.ManagementLockListResultPage, err error)
	ListAtSubscriptionLevelComplete(ctx context.Context, filter string) (result locks.ManagementLockListResultIterator, err error)
	ListByScope(ctx context.Context, scope string, filter string) (result locks.ManagementLockListResultPage, err error)
	ListByScopeComplete(ctx context.Context, scope string, filter string) (result locks.ManagementLockListResultIterator, err error)
}

var _ ManagementLocksClientAPI = (*locks.ManagementLocksClient)(nil)
