/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by David Miles

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <windows.h>
#include "runtime.h"


static LPTOP_LEVEL_EXCEPTION_FILTER handle_fpe(EXCEPTION_POINTERS *ep) {
char *message, buffer[200];

    switch(ep->ExceptionRecord->ExceptionCode) { 
    case EXCEPTION_INT_DIVIDE_BY_ZERO:
	message = "Integer division by zero";  break;    

    case EXCEPTION_INT_OVERFLOW:
	message = "Integer overflow";          break;    

    case EXCEPTION_FLT_DIVIDE_BY_ZERO:
	message = "Division by zero";          break;
  
    case EXCEPTION_FLT_OVERFLOW:
	message = "Overflow";                  break;  
         
    case EXCEPTION_FLT_UNDERFLOW:
	message = "Underflow";                 break;         
 
    case EXCEPTION_FLT_INEXACT_RESULT:
	message = "Inexact result";            break;  

    case EXCEPTION_FLT_INVALID_OPERATION:
    message = "Invalid operation";         break;      
        
    case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
	message = "Subscript out of range";    break;

    case EXCEPTION_ACCESS_VIOLATION:
	message = "Access Violation";          break;

    case EXCEPTION_BREAKPOINT :
	message = "Breakpoint";                break;

    case EXCEPTION_DATATYPE_MISALIGNMENT :
	message = "Data alignment";            break;

    case EXCEPTION_FLT_DENORMAL_OPERAND:
	message = "Denormal operand";          break;

    case EXCEPTION_FLT_STACK_CHECK:
	message = "FP stack overflow";         break;

    case EXCEPTION_ILLEGAL_INSTRUCTION :
	message = "Illegal instruction";       break;

    case EXCEPTION_IN_PAGE_ERROR:
	message = "Page error";                break;

    case EXCEPTION_INVALID_DISPOSITION:
	message = "Invalid disposition";       break;

    case EXCEPTION_NONCONTINUABLE_EXCEPTION:
	message = "Noncontinuable exception";  break;

    case EXCEPTION_PRIV_INSTRUCTION:
	message = "Privileged instruction";    break;

    case EXCEPTION_SINGLE_STEP:
	message = "Single Step";               break;

    case EXCEPTION_STACK_OVERFLOW:
	message = "Stack overflow";            break;

    default:   
	st_sprintf(buffer, "Unknown exception 0x%x",
		   (G95_DINT) ep->ExceptionRecord->ExceptionCode);
	message = buffer;         
	break; 
    }

    st_printf("Exception: %s\n", message);

    /* Some operating systems clear the floating point unit during an
     * exception, so don't do the usual display even if originally
     * requested. */        

    options.view_exceptions = 0;
    show_locus();
    g95_runtime_stop();
    sys_exit(1, 95);

    return 0;
}


/* init_fpu_trap()-- Initialize the floating point signal handler. */        

void init_fpu_trap(void) {

    (void) SetUnhandledExceptionFilter(handle_fpe);
}
