
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <signal.h>
#include "runtime.h"


/* sys_signal()-- Access to the signal() system call */

#define sys_signal prefix(signal_s)

void sys_signal(G95_DINT *sig, void *handler, G95_DINT *status) {
G95_DINT m;

    m = (G95_DINT) signal(*sig, handler);

    if (status != NULL)
	*status = m;
}


#define sys_signal_f prefix(signal_f)

G95_DINT sys_signal_f(G95_DINT *sig, void *handler, G95_DINT *flag) {
G95_DINT rc;

    if (*flag > 0)
	rc = (G95_DINT) signal(*sig, SIG_IGN);

    else if (*flag == 0)
	rc = (G95_DINT) signal(*sig, SIG_DFL);

    else
	rc = (G95_DINT) signal(*sig, handler);

    return rc;
}
