/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <math.h>
#include "runtime.h"


/* Subroutines that round floating point numbers in various ways */


#define anint4_4 prefix(anint4_4)
float anint4_4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return x;
}



#define anint8_4 prefix(anint8_4)
double anint8_4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return (double) x;
}



#define anint8_8 prefix(anint8_8)
double anint8_8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return x;
}



#define anint4_8 prefix(anint4_8)
float anint4_8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return (float) x;
}



#define dnint prefix(dnint)
double dnint(double *a) {
double x;

    x = *a;
    round_8(&x);

    return x;
}



#define ceiling_1_r4 prefix(ceiling_1_r4)
G95_INT1 ceiling_1_r4(float *a) {

    return (G95_INT1) ceil(*a);
}


#define ceiling_2_r4 prefix(ceiling_2_r4)
G95_INT2 ceiling_2_r4(float *a) {

    return (G95_INT2) ceil(*a);
}


#define ceiling_4_r4 prefix(ceiling_4_r4)
G95_INT4 ceiling_4_r4(float *a) {

    return (G95_INT4) ceil(*a);
}


#ifdef G95_INT8
#define ceiling_8_r4 prefix(ceiling_8_r4)
G95_INT8 ceiling_8_r4(float *a) {

    return (G95_INT8) ceil(*a);
}
#endif


#ifdef G95_INT16
#define ceiling_16_r4 prefix(ceiling_16_r4)
G95_INT16 ceiling_16_r4(float *a) {

    return (G95_INT16) ceil(*a);
}
#endif



#define ceiling_1_r8 prefix(ceiling_1_r8)
G95_INT1 ceiling_1_r8(double *a) {

    return (G95_INT1) ceil(*a);
}


#define ceiling_2_r8 prefix(ceiling_2_r8)
G95_INT2 ceiling_2_r8(double *a) {

    return (G95_INT2) ceil(*a);
}


#define ceiling_4_r8 prefix(ceiling_4_r8)
G95_INT4 ceiling_4_r8(double *a) {

    return (G95_INT4) ceil(*a);
}


#ifdef G95_INT8
#define ceiling_8_r8 prefix(ceiling_8_r8)
G95_INT8 ceiling_8_r8(double *a) {

    return (G95_INT8) ceil(*a);
}
#endif


#ifdef G95_INT16
#define ceiling_16_r8 prefix(ceiling_16_r8)
G95_INT16 ceiling_16_r8(double *a) {

    return (G95_INT16) ceil(*a);
}
#endif



#define floor_1_r4 prefix(floor_1_r4)
G95_INT1 floor_1_r4(float *a) {

    return (G95_INT1) floor(*a);
}


#define floor_2_r4 prefix(floor_2_r4)
G95_INT2 floor_2_r4(float *a) {

    return (G95_INT2) floor(*a);
}


#define floor_4_r4 prefix(floor_4_r4)
G95_INT4 floor_4_r4(float *a) {

    return (G95_INT4) floor(*a);
}


#ifdef G95_INT8
#define floor_8_r4 prefix(floor_8_r4)
G95_INT8 floor_8_r4(float *a) {

    return (G95_INT8) floor(*a);
}
#endif


#ifdef G95_INT16
#define floor_16_r4 prefix(floor_16_r4)
G95_INT16 floor_16_r4(float *a) {

    return (G95_INT16) floor(*a);
}
#endif



#define floor_1_r8 prefix(floor_1_r8)
G95_INT1 floor_1_r8(double *a) {

    return (G95_INT1) floor(*a);
}


#define floor_2_r8 prefix(floor_2_r8)
G95_INT2 floor_2_r8(double *a) {

    return (G95_INT2) floor(*a);
}


#define floor_4_r8 prefix(floor_4_r8)
G95_INT4 floor_4_r8(double *a) {

    return (G95_INT4) floor(*a);
}


#ifdef G95_INT8
#define floor_8_r8 prefix(floor_8_r8)
G95_INT8 floor_8_r8(double *a) {

    return (G95_INT8) floor(*a);
}
#endif


#ifdef G95_INT16
#define floor_16_r8 prefix(floor_16_r8)
G95_INT16 floor_16_r8(double *a) {

    return (G95_INT16) floor(*a);
}
#endif




#define nint_1_r4 prefix(nint_1_r4)
G95_INT1 nint_1_r4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return (G95_INT1) x;
}



#define nint_2_r4 prefix(nint_2_r4)
G95_INT2 nint_2_r4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return (G95_INT2) x;
}



#define nint_4_r4 prefix(nint_4_r4)
G95_INT4 nint_4_r4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return (G95_INT4) x;
}



#ifdef G95_INT8
#define nint_8_r4 prefix(nint_8_r4)
G95_INT8 nint_8_r4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return (G95_INT8) x;
}
#endif



#ifdef G95_INT16
#define nint_16_r4 prefix(nint_16_r4)
G95_INT16 nint_16_r4(float *a) {
float x;

    x = *a;
    round_4(&x);

    return (G95_INT16) x;
}
#endif




#define nint_1_r8 prefix(nint_1_r8)
G95_INT1 nint_1_r8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return (G95_INT1) x;
}



#define nint_2_r8 prefix(nint_2_r8)
G95_INT2 nint_2_r8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return (G95_INT2) x;
}



#define nint_4_r8 prefix(nint_4_r8)
G95_INT4 nint_4_r8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return (G95_INT4) x;
}



#ifdef G95_INT8
#define nint_8_r8 prefix(nint_8_r8)
G95_INT8 nint_8_r8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return (G95_INT8) x;
}
#endif



#ifdef G95_INT16
#define nint_16_r8 prefix(nint_16_r8)
G95_INT16 nint_16_r8(double *a) {
double x;

    x = *a;
    round_8(&x);

    return (G95_INT16) x;
}
#endif



#define aint4_4 prefix(aint4_4)

float aint4_4(float *f) {
float x;

    x = *f;
    trunc_4(&x);

    return x;
}


#define aint4_8 prefix(aint4_8)

float aint4_8(double *d) {
double x;

    x = *d;
    trunc_8(&x);

    return (float) x;
}


#define aint8_4 prefix(aint8_4)

double aint8_4(float *f) {
float x;

    x = *f;
    trunc_4(&x);

    return (double) x;
}


#define aint8_8 prefix(aint8_8)

double aint8_8(double *d) {
double x;

    x = *d;
    trunc_8(&x);

    return x;
}


#define dint prefix(dint)

double dint(double *d) {
double x;

    x = *d;
    trunc_8(&x);

    return x;
}

