/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <math.h>
#include "runtime.h"

double floor(double);

/* mod() and modulo() intrinsics for real types */

#define mod_r4 prefix(mod_r4)
float mod_r4(float *a, float *p) {
float x;

    x = *a / *p;
    trunc_4(&x);

    return *a - x*(*p);
}


#define mod_r8 prefix(mod_r8)
double mod_r8(double *a, double *p) {
double x;

    x = *a / *p;
    trunc_8(&x);

    return *a - x*(*p);
}


#define modulo_r4 prefix(modulo_r4)
float modulo_r4(float *a, float *p) {

    return *a - floor(*a/(*p))*(*p);
}


#define modulo_r8 prefix(modulo_r8)
double modulo_r8(double *a, double *p) {

    return *a - floor((*a)/(*p))*(*p);
}



/* Integer versions of mod() for dummy functions */

#define mod_i4 prefix(mod_i4)

G95_INT4 mod_i4(G95_INT4 *a, G95_INT4 *p) {

    return *a - (*a / *p) * (*p);
}


#define mod_i8 prefix(mod_i8)

G95_INT8 mod_i8(G95_INT8 *a, G95_INT8 *p) {

    return *a - (*a / *p) * (*p);
}

