
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the sum() intrinsic. */


#ifdef SUBROUTINE

#ifndef COMPLEX

TYPE SUBROUTINE(g95_array_descriptor *array, void *dummy,
		g95_array_descriptor *mask) {
G95_AINT array_index[G95_MAX_DIMENSIONS], mask_index[G95_MAX_DIMENSIONS];
int i, rank;
TYPE sum;
char *p;

    sum = 0;
    rank = array->rank;
    dummy = NULL;

    for(i=0; i<rank; i++) {
	if (array->info[i].ubound < array->info[i].lbound)
	    goto done;

	array_index[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask == NULL)
	    i = 1;

	else {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask_index[i] * mask->info[i].mult;

	    i = extract_logical(p, mask->element_size);
	}

	if (i) {
	    p = array->offset;
	    for(i=0; i<rank; i++)
		p += array_index[i] * array->info[i].mult;

	    sum += *((TYPE *) p);
	}

	if (bump_element(array, array_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_index);
    }

done:
    return sum;
}


TYPE SUBROUTINE_1(g95_array_descriptor *array, void *dummy, G95_DINT *mask) {

    return (*mask)
	? SUBROUTINE(array, dummy, NULL)
	: (TYPE) 0;
}



g95_array_descriptor *SUBROUTINE_D(g95_array_descriptor *array,
				   G95_DINT *dim_p,
				   g95_array_descriptor *mask) {
G95_AINT a, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
int i, m, rank, zero_size, dim;
g95_array_descriptor *result;
char *q1, *q2, *m1, *m2;
TYPE *p, sum;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	sum = 0;

	for(a=array->info[dim].lbound; a<=array->info[dim].ubound; a++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (a - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    q2 = q1 + array->info[dim].mult * a;
	    sum = sum + *((TYPE *) q2);
	}

	*p++ = sum;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *SUBROUTINE_1D(g95_array_descriptor *array,
				    G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT a, extent, array_x[G95_MAX_DIMENSIONS];
int i, m, rank, zero_size, dim;
g95_array_descriptor *result;
char *q1, *q2, *m1;
TYPE *p, sum;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	sum = 0;

	if (*mask)
	    for(a=array->info[dim].lbound; a<=array->info[dim].ubound; a++) {
		q2 = q1 + array->info[dim].mult * a;
		sum = sum + *((TYPE *) q2);
	    }

	*p++ = sum;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



#else /* COMPLEX */

void SUBROUTINE(TYPE *sum, g95_array_descriptor *array, void *dummy,
		g95_array_descriptor *mask) {
G95_AINT array_index[G95_MAX_DIMENSIONS], mask_index[G95_MAX_DIMENSIONS];
int i, rank;
char *p;

    sum->r = 0;
    sum->c = 0;

    rank = array->rank;
    dummy = NULL;

    for(i=0; i<rank; i++) {
	if (array->info[i].ubound < array->info[i].lbound)
	    return;

	array_index[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask == NULL)
	    i = 1;

	else {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask_index[i] * mask->info[i].mult;

	    i = extract_logical(p, mask->element_size);
	}

	if (i) {
	    p = array->offset;
	    for(i=0; i<rank; i++)
		p += array_index[i] * array->info[i].mult;

	    sum->r += ((TYPE *) p)->r;
	    sum->c += ((TYPE *) p)->c;
	}

	if (bump_element(array, array_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_index);
    }
}



void SUBROUTINE_1(TYPE *sum, g95_array_descriptor *array, void *dummy,
		 G95_DINT *mask) {

    if (*mask)
	SUBROUTINE(sum, array, dummy, NULL);

    else
	sum->r = sum->c = 0;
}



g95_array_descriptor *SUBROUTINE_D(g95_array_descriptor *array,
				   G95_DINT *dim_p,
				   g95_array_descriptor *mask) {
G95_AINT a, extent, array_x[G95_MAX_DIMENSIONS],
    mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int dim, i, m, rank, zero_size;
char *q1, *q2, *m1, *m2;
TYPE *p, sum;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0)
	    zero_size = 1;

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	sum.r = 0;
	sum.c = 0;

	for(a=array->info[dim].lbound; a<=array->info[dim].ubound; a++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (a - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    q2 = q1 + array->info[dim].mult * a;

	    sum.r += ((TYPE *) q2)->r;
	    sum.c += ((TYPE *) q2)->c;
	}

	*p++ = sum;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *SUBROUTINE_1D(g95_array_descriptor *array,
				    G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT a, extent, array_x[G95_MAX_DIMENSIONS];
int i, m, rank, zero_size, dim;
g95_array_descriptor *result;
char *q1, *q2, *m1;
TYPE *p, sum;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0)
	    zero_size = 1;

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	sum.r = 0;
	sum.c = 0;

	if (*mask)
	    for(a=array->info[dim].lbound; a<=array->info[dim].ubound; a++) {
		q2 = q1 + array->info[dim].mult * a;

		sum.r += ((TYPE *) q2)->r;
		sum.c += ((TYPE *) q2)->c;
	    }

	*p++ = sum;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}


#endif /* COMPLEX */

#undef SUBROUTINE
#undef SUBROUTINE_1
#undef SUBROUTINE_D
#undef SUBROUTINE_1D

#undef TYPE

#else  /* SUBROUTINE */

#include "runtime.h"

#define SUBROUTINE     prefix(sum_i1)
#define SUBROUTINE_D   prefix(sumd_i1)
#define SUBROUTINE_1   prefix(sum1_i1)
#define SUBROUTINE_1D  prefix(sum1d_i1)
#define TYPE G95_INT1
#include "sum.c"

#define SUBROUTINE     prefix(sum_i2)
#define SUBROUTINE_D   prefix(sumd_i2)
#define SUBROUTINE_1   prefix(sum1_i2)
#define SUBROUTINE_1D  prefix(sum1d_i2)
#define TYPE G95_INT2
#include "sum.c"

#define SUBROUTINE     prefix(sum_i4)
#define SUBROUTINE_D   prefix(sumd_i4)
#define SUBROUTINE_1   prefix(sum1_i4)
#define SUBROUTINE_1D  prefix(sum1d_i4)
#define TYPE G95_INT4
#include "sum.c"

#ifdef G95_INT8
#define SUBROUTINE     prefix(sum_i8)
#define SUBROUTINE_D   prefix(sumd_i8)
#define SUBROUTINE_1   prefix(sum1_i8)
#define SUBROUTINE_1D  prefix(sum1d_i8)
#define TYPE G95_INT8
#include "sum.c"
#endif

#ifdef G95_INT16
#define SUBROUTINE     prefix(sum_i16)
#define SUBROUTINE_D   prefix(sumd_i16)
#define SUBROUTINE_1   prefix(sum1_i16)
#define SUBROUTINE_1D  prefix(sum1d_i16)
#define TYPE G95_INT16
#include "sum.c"
#endif

#define SUBROUTINE     prefix(sum_r4)
#define SUBROUTINE_D   prefix(sumd_r4)
#define SUBROUTINE_1   prefix(sum1_r4)
#define SUBROUTINE_1D  prefix(sum1d_r4)
#define TYPE float
#include "sum.c"

#define SUBROUTINE     prefix(sum_r8)
#define SUBROUTINE_D   prefix(sumd_r8)
#define SUBROUTINE_1   prefix(sum1_r8)
#define SUBROUTINE_1D  prefix(sum1d_r8)
#define TYPE double
#include "sum.c"

#define COMPLEX 1

#define SUBROUTINE     prefix(sum_z4)
#define SUBROUTINE_D   prefix(sumd_z4)
#define SUBROUTINE_1   prefix(sum1_z4)
#define SUBROUTINE_1D  prefix(sum1d_z4)
#define TYPE z4
#include "sum.c"

#define SUBROUTINE     prefix(sum_z8)
#define SUBROUTINE_D   prefix(sumd_z8)
#define SUBROUTINE_1   prefix(sum1_z8)
#define SUBROUTINE_1D  prefix(sum1d_z8)
#define TYPE z8
#include "sum.c"

#endif
