

#include "runtime.h"

#if HAVE_REAL_10

/* SUM ****************************/

#define sum_r10     prefix(sum_r10)
#define sum1_r10    prefix(sum1_r10)
#define sumd_r10    prefix(sumd_r10)
#define sum1d_r10   prefix(sum1d_r10)

#define sum_z10     prefix(sum_z10)
#define sum1_z10    prefix(sum1_z10)
#define sumd_z10    prefix(sumd_z10)
#define sum1d_z10   prefix(sum1d_z10)


void sum_r10(g95_array_descriptor *array, void *dummy,
	     g95_array_descriptor *mask) {
G95_AINT array_index[G95_MAX_DIMENSIONS], mask_index[G95_MAX_DIMENSIONS];
int i, rank;
char *p;

    rank = array->rank;
    dummy = NULL;
    asm("fldz\n");

    for(i=0; i<rank; i++) {
	if (array->info[i].ubound < array->info[i].lbound)
	    goto done;

	array_index[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask == NULL)
	    i = 1;

	else {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask_index[i] * mask->info[i].mult;

	    i = extract_logical(p, mask->element_size);
	}

	if (i) {
	    p = array->offset;
	    for(i=0; i<rank; i++)
		p += array_index[i] * array->info[i].mult;

	    asm("mov %0, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"faddp\n" : : "m" (p) : EAX);
	}

	if (bump_element(array, array_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_index);
    }

done:
    return;
}


void sum1_r10(g95_array_descriptor *array, void *dummy, G95_DINT *mask) {

    if (*mask)
	sum_r10(array, dummy, NULL);

    else
	asm("fldz\n");
}



g95_array_descriptor *sumd_r10(g95_array_descriptor *array,
			       G95_DINT *dim_p,
			       g95_array_descriptor *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *m2, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	asm("fldz\n");

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    q2 = q1 + array->info[dim].mult * i;

	    asm("mov %0, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"faddp %%st(1)\n" : : "m" (q2) : EAX);
	}

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += array->element_size;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *sum1d_r10(g95_array_descriptor *array,
				G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	asm("fldz\n");

	if (*mask)
	    for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
		q2 = q1 + array->info[dim].mult * i;

		asm("mov %0, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "faddp %%st(1)\n" : : "m" (q2) : EAX);
	    }

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += array->element_size;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}




void sum_z10(char *sum, g95_array_descriptor *array, void *dummy,
	     g95_array_descriptor *mask) {
G95_AINT array_index[G95_MAX_DIMENSIONS], mask_index[G95_MAX_DIMENSIONS];
int i, rank;
char *p;

    rank = array->rank;
    dummy = NULL;

    for(i=0; i<rank; i++) {
	if (array->info[i].ubound < array->info[i].lbound)
	    return;

	array_index[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_index[i] = mask->info[i].lbound;
    }

    asm("fldz\n"
	"fldz\n");

    for(;;) {
	if (mask == NULL)
	    i = 1;

	else {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask_index[i] * mask->info[i].mult;

	    i = extract_logical(p, mask->element_size);
	}

	if (i) {
	    p = array->offset;
	    for(i=0; i<rank; i++)
		p += array_index[i] * array->info[i].mult;

	    asm("mov %0, %" EAX "\n"
		"fxch %%st(1)\n"
		"fldt (%" EAX ")\n"
		"faddp\n"
		"fxch %%st(1)\n"
		"fldt " stringize(REAL10_SIZE) " (%" EAX ")\n"
		"faddp\n" : : "m" (p) : EAX);
	}

	if (bump_element(array, array_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_index);
    }

    asm("mov %0, %" EAX "\n"
	"fxch %%st(1)\n"
	"fstpt (%" EAX ")\n"
	"fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (sum) : EAX);

}



void sum1_z10(char *sum, g95_array_descriptor *array, void *dummy,
	      G95_DINT *mask) {

    if (*mask)
	sum_z10(sum, array, dummy, NULL);

    else
	asm("mov %0, %" EAX "\n"
	    "fldz\n"
	    "fstpt (%" EAX ")\n"
	    "fldz\n"
	    "fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (sum):EAX);
}



g95_array_descriptor *sumd_z10(g95_array_descriptor *array,
			       G95_DINT *dim_p,
			       g95_array_descriptor *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
G95_AINT n;
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *m2, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0)
	    zero_size = 1;

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	asm("fldz\n"
	    "fldz\n");

	for(n=array->info[dim].lbound; n<=array->info[dim].ubound; n++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (n - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    q2 = q1 + array->info[dim].mult * n;

	    asm("mov %0, %" EAX "\n"
		"fxch %%st(1)\n"
		"fldt (%" EAX ")\n"
		"faddp\n"
		"fxch %%st(1)\n"
		"fldt " stringize(REAL10_SIZE) " (%" EAX ")\n"
		"faddp\n" : : "m" (q2) : EAX);
	}

	asm("mov %0, %" EAX "\n"
	    "fxch %%st(1)\n"
	    "fstpt (%" EAX ")\n"
	    "fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (p) : EAX);

	p += result->element_size;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *sum1d_z10(g95_array_descriptor *array,
				G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS];
G95_AINT n;
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0)
	    zero_size = 1;

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	asm("fldz\n"
	    "fldz\n");

	if (*mask)
	    for(n=array->info[dim].lbound; n<=array->info[dim].ubound; n++) {
		q2 = q1 + array->info[dim].mult * n;

		asm("mov %0, %" EAX "\n"
		    "fxch %%st(1)\n"
		    "fldt (%" EAX ")\n"
		    "faddp\n"
		    "fxch %%st(1)\n"
		    "fldt " stringize(REAL10_SIZE) " (%" EAX ")\n"
		    "faddp\n" : : "m" (q2) : EAX);
	    }

	asm("mov %0, %" EAX "\n"
	    "fxch %%st(1)\n"
	    "fstpt (%" EAX ")\n"
	    "fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (p) : EAX);

	p += result->element_size;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



/* PRODUCT ****************************/

#define product_r10     prefix(product_r10)
#define product1_r10    prefix(product1_r10)
#define productd_r10    prefix(productd_r10)
#define product1d_r10   prefix(product1d_r10)

#define product_z10     prefix(product_z10)
#define product1_z10    prefix(product1_z10)
#define productd_z10    prefix(productd_z10)
#define product1d_z10   prefix(product1d_z10)


void product_r10(g95_array_descriptor *array, void *dummy,
		 g95_array_descriptor *mask) {
G95_AINT array_index[G95_MAX_DIMENSIONS], mask_index[G95_MAX_DIMENSIONS];
int i, rank;
char *p;

    rank = array->rank;
    dummy = NULL;
    asm("fld1\n");

    for(i=0; i<rank; i++) {
	if (array->info[i].ubound < array->info[i].lbound)
	    goto done;

	array_index[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask == NULL)
	    i = 1;

	else {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask_index[i] * mask->info[i].mult;

	    i = extract_logical(p, mask->element_size);
	}

	if (i) {
	    p = array->offset;
	    for(i=0; i<rank; i++)
		p += array_index[i] * array->info[i].mult;

	    asm("mov %0, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fmulp\n" : : "m" (p) : EAX);
	}

	if (bump_element(array, array_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_index);
    }

done:
    return;
}



void product1_r10(g95_array_descriptor *array, void *dummy, G95_DINT *mask) {

    if (*mask)
	product_r10(array, dummy, NULL);

    else
	asm("fld1\n");
}



g95_array_descriptor *productd_r10(g95_array_descriptor *array,
				   G95_DINT *dim_p,
				   g95_array_descriptor *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *m2, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	asm("fld1\n");

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    q2 = q1 + array->info[dim].mult * i;

	    asm("mov %0, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fmulp %%st(1)\n" : : "m" (q2) : EAX);
	}

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += array->element_size;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *product1d_r10(g95_array_descriptor *array,
				    G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	asm("fld1\n");

	if (*mask)
	    for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
		q2 = q1 + array->info[dim].mult * i;

		asm("mov %0, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "fmulp %%st(1)\n" : : "m" (q2) : EAX);
	    }

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += array->element_size;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



void product_z10(char *product, g95_array_descriptor *array, void *dummy,
		 g95_array_descriptor *mask) {
G95_AINT array_index[G95_MAX_DIMENSIONS], mask_index[G95_MAX_DIMENSIONS];
int i, rank;
char *p;

    rank = array->rank;
    dummy = NULL;

    for(i=0; i<rank; i++) {
	if (array->info[i].ubound < array->info[i].lbound)
	    return;

	array_index[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_index[i] = mask->info[i].lbound;
    }

    asm("fld1\n"
	"fldz\n");

    for(;;) {
	if (mask == NULL)
	    i = 1;

	else {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask_index[i] * mask->info[i].mult;

	    i = extract_logical(p, mask->element_size);
	}

	if (i) {
	    p = array->offset;
	    for(i=0; i<rank; i++)
		p += array_index[i] * array->info[i].mult;

	    asm("mov %0, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fld %%st\n"
		"fmul %%st(3)\n"
		"fxch %%st(1)\n"
		"fmul %%st(2)\n"
		"fxch %%st(3)\n"
		"fldt " stringize(REAL10_SIZE) " (%" EAX ")\n"
		"fld %%st\n"
		"fxch %%st(2)\n"
		"fmulp %%st(1)\n"
		"fxch %%st(3)\n"
		"fmulp %%st(1)\n"
		"fsubrp %%st(1)\n"
		"fxch %%st(2)\n"
		"faddp %%st(1)\n" : : "m" (p) : EAX);
	}

	if (bump_element(array, array_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_index);
    }

    asm("mov %0, %" EAX "\n"
	"fxch %%st(1)\n"
	"fstpt (%" EAX ")\n"
	"fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (product):EAX);
}



void product1_z10(char *product, g95_array_descriptor *array, void *dummy,
		  G95_DINT *mask) {

    if (*mask)
	product_z10(product, array, dummy, NULL);

    else
	asm("mov %0, %" EAX "\n"
	    "fld1\n"
	    "fstpt (%" EAX ")\n"
	    "fldz\n"
	    "fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n"
	    : : "m" (product) : EAX);
}



g95_array_descriptor *productd_z10(g95_array_descriptor *array,
				   G95_DINT *dim_p,
				   g95_array_descriptor *mask) {
G95_AINT extent, dim, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *m2, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	asm("fld1\n"
	    "fldz\n");

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    q2 = q1 + array->info[dim].mult * i;

	    asm("mov %0, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fld %%st\n"
		"fmul %%st(3)\n"
		"fxch %%st(1)\n"
		"fmul %%st(2)\n"
		"fxch %%st(3)\n"
		"fldt " stringize(REAL10_SIZE) " (%" EAX ")\n"
		"fld %%st\n"
		"fxch %%st(2)\n"
		"fmulp %%st(1)\n"
		"fxch %%st(3)\n"
		"fmulp %%st(1)\n"
		"fsubrp %%st(1)\n"
		"fxch %%st(2)\n"
		"faddp %%st(1)\n" : : "m" (q2) : EAX);
	}

	asm("mov %0, %" EAX "\n"
	    "fxch %%st(1)\n"
	    "fstpt (%" EAX ")\n"
	    "fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (p) : EAX);
    
	p += result->element_size;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *product1d_z10(g95_array_descriptor *array,
				    G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT extent, dim, array_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *q1, *q2, *m1, *p;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q1 = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q1 += array->info[i].mult * array_x[i];
	}

	asm("fld1\n"
	    "fldz\n");

	if (*mask)
	    for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
		q2 = q1 + array->info[dim].mult * i;

		asm("mov %0, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "fld %%st\n"
		    "fmul %%st(3)\n"
		    "fxch %%st(1)\n"
		    "fmul %%st(2)\n"
		    "fxch %%st(3)\n"
		    "fldt " stringize(REAL10_SIZE) " (%" EAX ")\n"
		    "fld %%st\n"
		    "fxch %%st(2)\n"
		    "fmulp %%st(1)\n"
		    "fxch %%st(3)\n"
		    "fmulp %%st(1)\n"
		    "fsubrp %%st(1)\n"
		    "fxch %%st(2)\n"
		    "faddp %%st(1)\n" : : "m" (q2) : EAX);
	    }

	asm("mov %0, %" EAX "\n"
	    "fxch %%st(1)\n"
	    "fstpt (%" EAX ")\n"
	    "fstpt " stringize(REAL10_SIZE) " (%" EAX ")\n" : : "m" (p) : EAX);
    
	p += result->element_size;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}


/* MINVAL **************************************/

#define minval_r10      prefix(minval_r10)
#define minval1_r10     prefix(minval1_r10)
#define minvald_r10     prefix(minvald_r10)
#define minval1d_r10    prefix(minval1d_r10)


void minval_r10(g95_array_descriptor *array, G95_DINT *dim,
		g95_array_descriptor *mask) {
G95_AINT rank, array_count[G95_MAX_DIMENSIONS], mask_count[G95_MAX_DIMENSIONS];
char *p;
int i;

    huge_10();

    rank = array->rank;

    for(i=0; i<rank; i++) {
	array_count[i] = array->info[i].lbound;
	if (array->info[i].lbound > array->info[i].ubound)
	    return;

	if (mask != NULL)
	    mask_count[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask != NULL) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * mask_count[i];

	    if (*(int *) p == 0)
		goto next;
	}

	p = array->offset;
	for(i=0; i<rank; i++)
	    p += array->info[i].mult * array_count[i];

	asm("mov %0, %" EAX "\n"
	    "fldt ( %" EAX ")\n"
	    "fcom %%st(1)\n"
	    "fstsw %%ax\n"
	    "andb $0x41, %%ah\n"
	    "cmpb $0, %%ah\n"
	    "je 0f\n"
	    "fxch %%st(1)\n"
	    "0: fstp %%st\n" : : "m" (p) : EAX);

    next:
	if (bump_element(array, array_count))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_count);
    }
}



void minval1_r10(g95_array_descriptor *array, G95_DINT *dim,
		 G95_DINT *mask) {

    if (*mask)
	minval_r10(array, dim, NULL);

    else
	huge_10();
}



g95_array_descriptor *minvald_r10(g95_array_descriptor *array,
				  G95_DINT *dim_p,
				  g95_array_descriptor *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *p, *q, *r, *m1, *m2;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	huge_10();

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    r = q + array->info[dim].mult * i;

	    asm("mov %0, %" EAX "\n"
		"fldt ( %" EAX ")\n"
		"fcom %%st(1)\n"
		"fstsw %%ax\n"
		"andb $0x41, %%ah\n"
		"cmpb $0, %%ah\n"
		"je 0f\n"
		"fxch %%st(1)\n"
		"0: fstp %%st\n" : : "m" (r) : EAX);
	}

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += result->element_size;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *minval1d_r10(g95_array_descriptor *array,
				   G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS];
int i, m, rank, zero_size, mask_val;
g95_array_descriptor *result;
char *p, *r, *q, *m1;

    rank = array->rank;
    mask_val = (mask == NULL) ? 1 : *mask;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	huge_10();

	if (mask_val)
	    for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
		r = q + array->info[dim].mult * i;

		asm("mov %0, %" EAX "\n"
		    "fldt ( %" EAX ")\n"
		    "fcom %%st(1)\n"
		    "fstsw %%ax\n"
		    "andb $0x41, %%ah\n"
		    "cmpb $0, %%ah\n"
		    "je 0f\n"
		    "fxch %%st(1)\n"
		    "0: fstp %%st\n" : : "m" (r) : EAX);
	    }

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += result->element_size;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



/* MAXVAL **************************************/

#define maxval_r10      prefix(maxval_r10)
#define maxval1_r10     prefix(maxval1_r10)
#define maxvald_r10     prefix(maxvald_r10)
#define maxval1d_r10    prefix(maxval1d_r10)


void maxval_r10(g95_array_descriptor *array, G95_DINT *dim,
		g95_array_descriptor *mask) {
G95_AINT rank, array_count[G95_MAX_DIMENSIONS], mask_count[G95_MAX_DIMENSIONS];
char *p;
int i;

    huge_10();
    asm("fchs");

    rank = array->rank;

    for(i=0; i<rank; i++) {
	array_count[i] = array->info[i].lbound;
	if (array->info[i].lbound > array->info[i].ubound)
	    return;

	if (mask != NULL)
	    mask_count[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask != NULL) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * mask_count[i];

	    if (*(int *) p == 0)
		goto next;
	}

	p = array->offset;
	for(i=0; i<rank; i++)
	    p += array->info[i].mult * array_count[i];

	asm("mov %0, %" EAX "\n"
	    "fldt ( %" EAX ")\n"
	    "fcom %%st(1)\n"
	    "fstsw %%ax\n"
	    "andb $0x41, %%ah\n"
	    "cmpb $1, %%ah\n"
	    "je 0f\n"
	    "fxch %%st(1)\n"
	    "0: fstp %%st\n" : : "m" (p) : EAX);

    next:
	if (bump_element(array, array_count))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_count);
    }
}



void maxval1_r10(g95_array_descriptor *array, G95_DINT *dim,
		 G95_DINT *mask) {

    if (*mask)
	maxval_r10(array, dim, NULL);

    else {
	huge_10();
	asm("fchs");
    }
}



g95_array_descriptor *maxvald_r10(g95_array_descriptor *array,
				  G95_DINT *dim_p,
				  g95_array_descriptor *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *p, *q, *r, *m1, *m2;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	huge_10();
	asm("fchs");

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    r = q + array->info[dim].mult * i;

	    asm("mov %0, %" EAX "\n"
		"fldt ( %" EAX ")\n"
		"fcom %%st(1)\n"
		"fstsw %%ax\n"
		"andb $0x41, %%ah\n"
		"cmpb $1, %%ah\n"
		"je 0f\n"
		"fxch %%st(1)\n"
		"0: fstp %%st\n" : : "m" (r) : EAX);
	}

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += result->element_size;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *maxval1d_r10(g95_array_descriptor *array,
				   G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS];
int i, m, rank, zero_size, mask_val;
g95_array_descriptor *result;
char *p, *r, *q, *m1;

    rank = array->rank;
    mask_val = (mask == NULL) ? 1 : *mask;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	huge_10();
	asm("fchs");

	if (mask_val)
	    for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
		r = q + array->info[dim].mult * i;

		asm("mov %0, %" EAX "\n"
		    "fldt ( %" EAX ")\n"
		    "fcom %%st(1)\n"
		    "fstsw %%ax\n"
		    "andb $0x41, %%ah\n"
		    "cmpb $1, %%ah\n"
		    "je 0f\n"
		    "fxch %%st(1)\n"
		    "0: fstp %%st\n" : : "m" (r) : EAX);
	    }

	asm("mov %0, %" EAX "\n"
	    "fstpt (%" EAX ")\n" : : "m" (p) : EAX);

	p += result->element_size;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



/* MINLOC ************************************/

#define minloc_r10     prefix(minloc_r10)
#define minloc1_r10    prefix(minloc1_r10)
#define minlocd_r10    prefix(minlocd_r10)


g95_array_descriptor *minloc_r10(g95_array_descriptor *array,
				 void *dummy,
				 g95_array_descriptor *mask,
				 G95_DINT *mask_s) {
  
G95_AINT a_index[G95_MAX_DIMENSIONS], m_index[G95_MAX_DIMENSIONS],
         x_index[G95_MAX_DIMENSIONS], rank, *ip;
int flag, i;
g95_array_descriptor *r;
char *extremum, *p;

    extremum = NULL;
    rank = array->rank;

    if (mask_s != NULL && !(*mask_s))
	goto done;

    for(i=0; i<rank; i++) {
	a_index[i] = array->info[i].lbound;
	if (array->info[i].lbound > array->info[i].ubound)
	    goto done;

	if (mask != NULL)
	    m_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask != NULL) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * m_index[i];

	    if (!extract_logical(p, mask->element_size))
		goto next;
	}

	p = array->offset;
	for(i=0; i<rank; i++)
	    p += array->info[i].mult * a_index[i];

	if (extremum == NULL)
	    flag = 1;

	else
	    asm("mov %1, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"mov %2, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fcompp\n"
		"fstsw %%ax\n"
		"movb %%ah, %%al\n"
		"xorb $0x01, %%al\n"
		"shrb $6, %%ah\n"
		"xorb $0x01, %%ah\n"
		"andb %%ah, %%al\n"
		"and $1, %%eax\n"
		"mov %%eax, %0\n" : "=m" (flag) : "m" (p), "m" (extremum):EAX);

	if (flag) {
	    extremum = p;
	    for(i=0; i<rank; i++)
		x_index[i] = a_index[i];
	}

    next:
	if (bump_element(array, a_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, m_index);
    }

done:
    /* Without an extremum, we return a zero vector */

    if (extremum == NULL)
	for(i=0; i<rank; i++)
	    x_index[i] = array->info[i].lbound - 1;

    r = temp_array(1, sizeof(G95_DINT), rank);
    ip = (G95_AINT *) r->base;

    for(i=0; i<rank; i++)
	*ip++ = x_index[i] - array->info[i].lbound + 1;

    return r;
}



g95_array_descriptor *minlocd_r10(g95_array_descriptor *array,
				  G95_DINT *dim_p,
				  g95_array_descriptor *mask,
				  G95_DINT *mask_s) {
G95_AINT n, dim, extent, *p, array_x[G95_MAX_DIMENSIONS],
         mask_x[G95_MAX_DIMENSIONS];
char *q, *m1, *m2, *p1, *extremum;
int flag, m, i, rank, zero_size;
g95_array_descriptor *result;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = sizeof(int);

    zero_size = 0;
    m = 2;
    m1 = NULL;
    n = 0;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size || (mask_s != NULL && !(*mask_s)))
	return result;

    p = (G95_AINT *) result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	extremum = NULL;

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    p1 = q + array->info[dim].mult * i;

	    if (extremum == NULL)
		flag = 1;

	    else
		asm("mov %1, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "mov %2, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "fcompp\n"
		    "fstsw %%ax\n"
		    "movb %%ah, %%al\n"
		    "xorb $0x01, %%al\n"
		    "shrb $6, %%ah\n"
		    "xorb $0x01, %%ah\n"
		    "andb %%ah, %%al\n"
		    "and $1, %%eax\n"
		    "mov %%eax, %0\n" : "=m" (flag)
				      : "m" (p1), "m" (extremum) : EAX);

	    if (flag) {
		extremum = p1;
		n = i;
	    }
	}

	*p++ = n - array->info[dim].lbound + 1;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



G95_AINT minloc1_r10(g95_array_descriptor *array, void *dummy,
		     g95_array_descriptor *mask, G95_DINT *mask_s) {
G95_AINT x_index, m, a, i;
char *extremum, *p;
int flag;

    if (mask_s != NULL && !(*mask_s))
	return 0;

    x_index = -1;
    i = 0;
    m = 0;

    extremum = NULL;
    if (mask != NULL)
	m = mask->info[0].lbound;

    for(a=array->info[0].lbound; a<=array->info[0].ubound; a++) {
	if (mask != NULL) {
	    p = mask->offset + mask->info[0].mult*m++;

	    if (!extract_logical(p, mask->element_size))
		continue;
	}

	p = array->offset + array->info[0].mult*a;

	if (extremum == NULL)
	    flag = 1;

	else
	    asm("mov %1, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"mov %2, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fcompp\n"
		"fstsw %%ax\n"
		"movb %%ah, %%al\n"
		"xorb $0x01, %%al\n"
		"shrb $6, %%ah\n"
		"xorb $0x01, %%ah\n"
		"andb %%ah, %%al\n"
		"and $1, %%eax\n"
		"mov %%eax, %0\n" : "=m" (flag) : "m" (p), "m" (extremum):EAX);

	if (flag) {
	    extremum = p;
	    x_index = a;
	}
    }

    return (extremum == NULL) ? 0 : x_index - array->info[0].lbound + 1;
}


/* MAXLOC ************************************************/

#define maxloc_r10     prefix(maxloc_r10)
#define maxloc1_r10    prefix(maxloc1_r10)
#define maxlocd_r10    prefix(maxlocd_r10)


g95_array_descriptor *maxloc_r10(g95_array_descriptor *array,
				 void *dummy,
				 g95_array_descriptor *mask,
				 G95_DINT *mask_s) {
  
G95_AINT a_index[G95_MAX_DIMENSIONS], m_index[G95_MAX_DIMENSIONS],
         x_index[G95_MAX_DIMENSIONS], rank, *ip;
int flag, i;
g95_array_descriptor *r;
char *extremum, *p;

    extremum = NULL;
    rank = array->rank;

    if (mask_s != NULL && !(*mask_s))
	goto done;

    for(i=0; i<rank; i++) {
	a_index[i] = array->info[i].lbound;
	if (array->info[i].lbound > array->info[i].ubound)
	    goto done;

	if (mask != NULL)
	    m_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask != NULL) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * m_index[i];

	    if (!extract_logical(p, mask->element_size))
		goto next;
	}

	p = array->offset;
	for(i=0; i<rank; i++)
	    p += array->info[i].mult * a_index[i];

	if (extremum == NULL)
	    flag = 1;

	else
	    asm("mov %1, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"mov %2, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fcompp\n"
		"fstsw %%ax\n"
		"movb %%ah, %%al\n"
		"shrb $6, %%ah\n"
		"xorb $0x01, %%ah\n"
		"andb %%ah, %%al\n"
		"and $1, %%eax\n"
		"mov %%eax, %0\n" : "=m" (flag) : "m" (p), "m" (extremum):EAX);

	if (flag) {
	    extremum = p;
	    for(i=0; i<rank; i++)
		x_index[i] = a_index[i];
	}

    next:
	if (bump_element(array, a_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, m_index);
    }

done:
    /* Without an extremum, we return a zero vector */

    if (extremum == NULL)
	for(i=0; i<rank; i++)
	    x_index[i] = array->info[i].lbound - 1;

    r = temp_array(1, sizeof(G95_DINT), rank);
    ip = (G95_AINT *) r->base;

    for(i=0; i<rank; i++)
	*ip++ = x_index[i] - array->info[i].lbound + 1;

    return r;
}



g95_array_descriptor *maxlocd_r10(g95_array_descriptor *array,
				  G95_DINT *dim_p,
				  g95_array_descriptor *mask,
				  G95_DINT *mask_s) {
G95_AINT n, dim, extent, *p, array_x[G95_MAX_DIMENSIONS],
         mask_x[G95_MAX_DIMENSIONS];
char *q, *m1, *m2, *p1, *extremum;
int flag, m, i, rank, zero_size;
g95_array_descriptor *result;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = sizeof(int);

    zero_size = 0;
    m = 2;
    m1 = NULL;
    n = 0;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size || (mask_s != NULL && !(*mask_s)))
	return result;

    p = (G95_AINT *) result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	extremum = NULL;

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    p1 = q + array->info[dim].mult * i;
	    
	    if (extremum == NULL)
		flag = 1;

	    else
		asm("mov %1, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "mov %2, %" EAX "\n"
		    "fldt (%" EAX ")\n"
		    "fcompp\n"
		    "fstsw %%ax\n"
		    "movb %%ah, %%al\n"
		    "shrb $6, %%ah\n"
		    "xorb $0x01, %%ah\n"
		    "andb %%ah, %%al\n"
		    "and $1, %%eax\n"
		    "mov %%eax, %0\n" : "=m" (flag)
                       : "m" (p1), "m" (extremum) : EAX);

	    if (flag) {
		extremum = p1;
		n = i;
	    }
	}

	*p++ = n - array->info[dim].lbound + 1;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



G95_AINT maxloc1_r10(g95_array_descriptor *array, void *dummy,
		     g95_array_descriptor *mask, G95_DINT *mask_s) {
G95_AINT x_index, m, a, i;
char *extremum, *p;
int flag;

    if (mask_s != NULL && !(*mask_s))
	return 0;

    x_index = -1;
    i = 0;
    m = 0;

    extremum = NULL;
    if (mask != NULL)
	m = mask->info[0].lbound;

    for(a=array->info[0].lbound; a<=array->info[0].ubound; a++) {
	if (mask != NULL) {
	    p = mask->offset + mask->info[0].mult*m++;

	    if (!extract_logical(p, mask->element_size))
		continue;
	}

	p = array->offset + array->info[0].mult*a;

	if (extremum == NULL)
	    flag = 1;

	else
	    asm("mov %1, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"mov %2, %" EAX "\n"
		"fldt (%" EAX ")\n"
		"fcompp\n"
		"fstsw %%ax\n"
		"movb %%ah, %%al\n"
		"shrb $6, %%ah\n"
		"xorb $0x01, %%ah\n"
		"andb %%ah, %%al\n"
		"and $1, %%eax\n"
		"mov %%eax, %0\n" : "=m" (flag) : "m" (p), "m" (extremum):EAX);

	if (flag) {
	    extremum = p;
	    x_index = a;
	}
    }

    return (extremum == NULL) ? 0 : x_index - array->info[0].lbound + 1;
}

#endif
